/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.InitializationUtils;
import com.siyeh.ig.psiutils.SerializationUtils;
import org.jetbrains.annotations.NotNull;

public class TransientFieldNotInitializedInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("transient.field.not.initialized.display.name", new Object[0]);
        if (string == null) {
            TransientFieldNotInitializedInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("transient.field.not.initialized.problem.descriptor", new Object[0]);
        if (string == null) {
            TransientFieldNotInitializedInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ReadObjectInitializationVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/serialization/TransientFieldNotInitializedInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ReadObjectInitializationVisitor
    extends BaseInspectionVisitor {
        private ReadObjectInitializationVisitor() {
        }

        @Override
        public void visitField(PsiField field) {
            super.visitField(field);
            if (!field.hasModifierProperty("transient")) {
                return;
            }
            PsiClass containingClass = field.getContainingClass();
            if (!SerializationUtils.isSerializable(containingClass)) {
                return;
            }
            PsiExpression initializer = field.getInitializer();
            if (initializer == null && !ReadObjectInitializationVisitor.isInitializedInInitializer(field, containingClass) && !ReadObjectInitializationVisitor.isInitializedInConstructors(field, containingClass)) {
                return;
            }
            if (SerializationUtils.hasReadObject(containingClass)) {
                return;
            }
            this.registerFieldError(field, new Object[0]);
        }

        private static boolean isInitializedInConstructors(@NotNull PsiField field, @NotNull PsiClass aClass) {
            PsiMethod[] constructors;
            if (field == null) {
                ReadObjectInitializationVisitor.$$$reportNull$$$0(0);
            }
            if (aClass == null) {
                ReadObjectInitializationVisitor.$$$reportNull$$$0(1);
            }
            if ((constructors = aClass.getConstructors()).length == 0) {
                return false;
            }
            for (PsiMethod constructor : constructors) {
                if (InitializationUtils.methodAssignsVariableOrFails(constructor, field)) continue;
                return false;
            }
            return true;
        }

        private static boolean isInitializedInInitializer(@NotNull PsiField field, @NotNull PsiClass aClass) {
            PsiClassInitializer[] initializers;
            if (field == null) {
                ReadObjectInitializationVisitor.$$$reportNull$$$0(2);
            }
            if (aClass == null) {
                ReadObjectInitializationVisitor.$$$reportNull$$$0(3);
            }
            for (PsiClassInitializer initializer : initializers = aClass.getInitializers()) {
                PsiCodeBlock body;
                if (initializer.hasModifierProperty("static") || !InitializationUtils.blockAssignsVariableOrFails(body = initializer.getBody(), field)) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/serialization/TransientFieldNotInitializedInspection$ReadObjectInitializationVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isInitializedInConstructors";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isInitializedInInitializer";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

