/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.tree.IElementType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class MissortedModifiersInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    public boolean m_requireAnnotationsFirst = true;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("missorted.modifiers.display.name", new Object[0]);
        if (string == null) {
            MissortedModifiersInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("missorted.modifiers.problem.descriptor", new Object[0]);
        if (string == null) {
            MissortedModifiersInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MissortedModifiersVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new SortModifiersFix();
    }

    @Override
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("missorted.modifiers.require.option", new Object[0]), this, "m_requireAnnotationsFirst");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/style/MissortedModifiersInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ModifierComparator
    implements Comparator<String> {
        @NonNls
        private static final Map<String, Integer> s_modifierOrder = new HashMap<String, Integer>(11);

        private ModifierComparator() {
        }

        @Override
        public int compare(String modifier1, String modifier2) {
            Integer ordinal1 = s_modifierOrder.get(modifier1);
            if (ordinal1 == null) {
                return 0;
            }
            Integer ordinal2 = s_modifierOrder.get(modifier2);
            if (ordinal2 == null) {
                return 0;
            }
            return ordinal1 - ordinal2;
        }

        static {
            s_modifierOrder.put("public", 0);
            s_modifierOrder.put("protected", 1);
            s_modifierOrder.put("private", 2);
            s_modifierOrder.put("abstract", 3);
            s_modifierOrder.put("default", 4);
            s_modifierOrder.put("static", 5);
            s_modifierOrder.put("final", 6);
            s_modifierOrder.put("transient", 7);
            s_modifierOrder.put("volatile", 8);
            s_modifierOrder.put("synchronized", 9);
            s_modifierOrder.put("native", 10);
            s_modifierOrder.put("strictfp", 11);
        }
    }

    private class MissortedModifiersVisitor
    extends BaseInspectionVisitor {
        private final Comparator<String> modifierComparator = new ModifierComparator();

        private MissortedModifiersVisitor() {
        }

        @Override
        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                MissortedModifiersVisitor.$$$reportNull$$$0(0);
            }
            super.visitClass(aClass);
            this.checkForMissortedModifiers(aClass);
        }

        @Override
        public void visitClassInitializer(@NotNull PsiClassInitializer initializer) {
            if (initializer == null) {
                MissortedModifiersVisitor.$$$reportNull$$$0(1);
            }
            super.visitClassInitializer(initializer);
            this.checkForMissortedModifiers(initializer);
        }

        @Override
        public void visitLocalVariable(@NotNull PsiLocalVariable variable) {
            if (variable == null) {
                MissortedModifiersVisitor.$$$reportNull$$$0(2);
            }
            super.visitLocalVariable(variable);
            this.checkForMissortedModifiers(variable);
        }

        @Override
        public void visitParameter(@NotNull PsiParameter parameter) {
            if (parameter == null) {
                MissortedModifiersVisitor.$$$reportNull$$$0(3);
            }
            super.visitParameter(parameter);
            this.checkForMissortedModifiers(parameter);
        }

        @Override
        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                MissortedModifiersVisitor.$$$reportNull$$$0(4);
            }
            super.visitMethod(method);
            this.checkForMissortedModifiers(method);
        }

        @Override
        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                MissortedModifiersVisitor.$$$reportNull$$$0(5);
            }
            super.visitField(field);
            this.checkForMissortedModifiers(field);
        }

        private void checkForMissortedModifiers(PsiModifierListOwner listOwner) {
            PsiModifierList modifierList = listOwner.getModifierList();
            if (modifierList == null) {
                return;
            }
            if (!this.isModifierListMissorted(modifierList)) {
                return;
            }
            this.registerError((PsiElement)modifierList, new Object[0]);
        }

        private boolean isModifierListMissorted(PsiModifierList modifierList) {
            if (modifierList == null) {
                return false;
            }
            PsiElement[] children = modifierList.getChildren();
            String currentModifier = null;
            boolean typeAnnotationSeen = false;
            for (PsiElement child : children) {
                if (child instanceof PsiJavaToken) {
                    if (MissortedModifiersInspection.this.m_requireAnnotationsFirst && typeAnnotationSeen) {
                        return true;
                    }
                    String text2 = child.getText();
                    if (this.modifierComparator.compare(text2, currentModifier) < 0) {
                        return true;
                    }
                    currentModifier = text2;
                }
                if (!(child instanceof PsiAnnotation)) continue;
                if (PsiImplUtil.isTypeAnnotation(child)) {
                    typeAnnotationSeen = true;
                    continue;
                }
                if (!MissortedModifiersInspection.this.m_requireAnnotationsFirst || currentModifier == null) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "initializer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/style/MissortedModifiersInspection$MissortedModifiersVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitClass";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitClassInitializer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitLocalVariable";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitParameter";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethod";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitField";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class SortModifiersFix
    extends InspectionGadgetsFix {
        private SortModifiersFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("missorted.modifiers.sort.quickfix", new Object[0]);
            if (string == null) {
                SortModifiersFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement[] children;
            PsiModifierList modifierList = (PsiModifierList)descriptor.getPsiElement();
            ArrayList<String> modifiers = new ArrayList<String>();
            ArrayList<String> typeAnnotations = new ArrayList<String>();
            for (PsiElement child : children = modifierList.getChildren()) {
                if (child instanceof PsiComment) {
                    PsiComment comment = (PsiComment)child;
                    IElementType tokenType = comment.getTokenType();
                    if (JavaTokenType.END_OF_LINE_COMMENT.equals(tokenType)) {
                        String text2 = child.getText() + '\n';
                        modifiers.add(text2);
                        continue;
                    }
                    modifiers.add(child.getText());
                    continue;
                }
                if (child instanceof PsiJavaToken) {
                    modifiers.add(child.getText());
                    continue;
                }
                if (!(child instanceof PsiAnnotation)) continue;
                if (PsiImplUtil.isTypeAnnotation(child)) {
                    typeAnnotations.add(child.getText());
                    continue;
                }
                modifiers.add(0, child.getText());
            }
            Collections.sort(modifiers, new ModifierComparator());
            StringBuilder buffer = new StringBuilder();
            for (String modifier : modifiers) {
                buffer.append(modifier).append(' ');
            }
            for (String annotation : typeAnnotations) {
                buffer.append(annotation).append(' ');
            }
            PsiManager manager = modifierList.getManager();
            PsiElementFactory factory = JavaPsiFacade.getInstance(manager.getProject()).getElementFactory();
            buffer.append("void x() {}");
            String text3 = buffer.toString();
            PsiMethod method = factory.createMethodFromText(text3, modifierList);
            PsiModifierList newModifierList = method.getModifierList();
            modifierList.replace(newModifierList);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/MissortedModifiersInspection$SortModifiersFix", "getFamilyName"));
        }
    }
}

