/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.ex;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.util.ExceptionUtil;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

public class ApplicationUtil {
    public static <T> T tryRunReadAction(@NotNull Computable<T> computable) throws CannotRunReadActionException {
        if (computable == null) {
            ApplicationUtil.$$$reportNull$$$0(0);
        }
        Ref result = new Ref();
        ApplicationUtil.tryRunReadAction(() -> {
            if (computable == null) {
                ApplicationUtil.$$$reportNull$$$0(8);
            }
            result.set(computable.compute());
        });
        return result.get();
    }

    public static void tryRunReadAction(@NotNull Runnable computable) throws CannotRunReadActionException {
        if (computable == null) {
            ApplicationUtil.$$$reportNull$$$0(1);
        }
        if (!((ApplicationEx)ApplicationManager.getApplication()).tryRunReadAction(computable)) {
            throw new CannotRunReadActionException();
        }
    }

    public static <T> T runWithCheckCanceled(@NotNull Callable<T> callable, @NotNull ProgressIndicator indicator) throws Exception {
        if (callable == null) {
            ApplicationUtil.$$$reportNull$$$0(2);
        }
        if (indicator == null) {
            ApplicationUtil.$$$reportNull$$$0(3);
        }
        Ref result = Ref.create();
        Ref error = Ref.create();
        Future<?> future = PooledThreadExecutor.INSTANCE.submit(() -> {
            if (callable == null) {
                ApplicationUtil.$$$reportNull$$$0(5);
            }
            if (indicator == null) {
                ApplicationUtil.$$$reportNull$$$0(6);
            }
            ProgressManager.getInstance().executeProcessUnderProgress(() -> {
                if (callable == null) {
                    ApplicationUtil.$$$reportNull$$$0(7);
                }
                try {
                    result.set(callable.call());
                }
                catch (Throwable t) {
                    error.set(t);
                }
            }, indicator);
        });
        while (true) {
            try {
                indicator.checkCanceled();
            }
            catch (ProcessCanceledException e) {
                future.cancel(true);
                throw e;
            }
            try {
                future.get(200L, TimeUnit.MILLISECONDS);
                ExceptionUtil.rethrowAll((Throwable)error.get());
                return result.get();
            }
            catch (TimeoutException timeoutException) {
                continue;
            }
            break;
        }
    }

    public static void showDialogAfterWriteAction(@NotNull Runnable runnable) {
        Application application;
        if (runnable == null) {
            ApplicationUtil.$$$reportNull$$$0(4);
        }
        if ((application = ApplicationManager.getApplication()).isWriteAccessAllowed()) {
            application.invokeLater(runnable);
        } else {
            runnable.run();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callable";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/application/ex/ApplicationUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "tryRunReadAction";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "runWithCheckCanceled";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "showDialogAfterWriteAction";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$runWithCheckCanceled$2";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$1";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$tryRunReadAction$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class CannotRunReadActionException
    extends ProcessCanceledException {
        public CannotRunReadActionException() {
        }

        public CannotRunReadActionException(@Nullable Throwable cause) {
            throw this;
        }
    }
}

