/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.command.undo.UndoConstants;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.file.PsiBinaryFileImpl;
import com.intellij.psi.impl.file.PsiLargeBinaryFileImpl;
import com.intellij.psi.impl.file.PsiLargeTextFileImpl;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.PsiPlainTextFileImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.reference.SoftReference;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractFileViewProvider
extends UserDataHolderBase
implements FileViewProvider {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.AbstractFileViewProvider");
    public static final Key<Object> FREE_THREADED = Key.create("FREE_THREADED");
    private static final Key<Set<AbstractFileViewProvider>> KNOWN_COPIES = Key.create("KNOWN_COPIES");
    @NotNull
    private final PsiManagerEx myManager;
    @NotNull
    private final VirtualFile myVirtualFile;
    private final boolean myEventSystemEnabled;
    private final boolean myPhysical;
    private boolean myInvalidated;
    private volatile Content myContent;
    private volatile Reference<Document> myDocument;
    @NotNull
    private final FileType myFileType;

    protected AbstractFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile virtualFile, boolean eventSystemEnabled, @NotNull FileType type) {
        if (manager == null) {
            AbstractFileViewProvider.$$$reportNull$$$0(0);
        }
        if (virtualFile == null) {
            AbstractFileViewProvider.$$$reportNull$$$0(1);
        }
        if (type == null) {
            AbstractFileViewProvider.$$$reportNull$$$0(2);
        }
        this.myManager = (PsiManagerEx)manager;
        this.myVirtualFile = virtualFile;
        this.myEventSystemEnabled = eventSystemEnabled;
        this.setContent(new VirtualFileContent());
        this.myPhysical = this.isEventSystemEnabled() && !(virtualFile instanceof LightVirtualFile) && !(virtualFile.getFileSystem() instanceof NonPhysicalFileSystem);
        virtualFile.putUserData(FREE_THREADED, AbstractFileViewProvider.isFreeThreaded(this));
        this.myFileType = type;
    }

    public static boolean isFreeThreaded(@NotNull FileViewProvider provider) {
        if (provider == null) {
            AbstractFileViewProvider.$$$reportNull$$$0(3);
        }
        return provider.getVirtualFile() instanceof LightVirtualFile && !provider.isEventSystemEnabled();
    }

    protected final boolean isIgnored() {
        VirtualFile file = this.getVirtualFile();
        return !(file instanceof LightVirtualFile) && FileTypeRegistry.getInstance().isFileIgnored(file);
    }

    @Nullable
    protected PsiFile createFile(@NotNull Project project, @NotNull VirtualFile file, @NotNull FileType fileType) {
        PsiFile psiFile;
        if (project == null) {
            AbstractFileViewProvider.$$$reportNull$$$0(4);
        }
        if (file == null) {
            AbstractFileViewProvider.$$$reportNull$$$0(5);
        }
        if (fileType == null) {
            AbstractFileViewProvider.$$$reportNull$$$0(6);
        }
        if (fileType.isBinary() || file.is(VFileProperty.SPECIAL)) {
            return SingleRootFileViewProvider.isTooLargeForContentLoading(file) ? new PsiLargeBinaryFileImpl((PsiManagerImpl)this.getManager(), this) : new PsiBinaryFileImpl((PsiManagerImpl)this.getManager(), this);
        }
        if (!SingleRootFileViewProvider.isTooLargeForIntelligence(file) && (psiFile = this.createFile(this.getBaseLanguage())) != null) {
            return psiFile;
        }
        if (SingleRootFileViewProvider.isTooLargeForContentLoading(file)) {
            return new PsiLargeTextFileImpl(this);
        }
        return new PsiPlainTextFileImpl(this);
    }

    @Nullable
    protected PsiFile createFile(@NotNull Language lang) {
        if (lang == null) {
            AbstractFileViewProvider.$$$reportNull$$$0(7);
        }
        if (lang != this.getBaseLanguage()) {
            return null;
        }
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
        if (parserDefinition != null) {
            return parserDefinition.createFile(this);
        }
        return null;
    }

    @Override
    @NotNull
    public final PsiManagerEx getManager() {
        PsiManagerEx psiManagerEx = this.myManager;
        if (psiManagerEx == null) {
            AbstractFileViewProvider.$$$reportNull$$$0(8);
        }
        return psiManagerEx;
    }

    @Override
    @NotNull
    public CharSequence getContents() {
        CharSequence charSequence = this.getContent().getText();
        if (charSequence == null) {
            AbstractFileViewProvider.$$$reportNull$$$0(9);
        }
        return charSequence;
    }

    @Override
    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.myVirtualFile;
        if (virtualFile == null) {
            AbstractFileViewProvider.$$$reportNull$$$0(10);
        }
        return virtualFile;
    }

    @Nullable
    private Document getCachedDocument() {
        Document document = SoftReference.dereference(this.myDocument);
        if (document != null) {
            return document;
        }
        return FileDocumentManager.getInstance().getCachedDocument(this.getVirtualFile());
    }

    @Override
    public Document getDocument() {
        Document document = SoftReference.dereference(this.myDocument);
        if (document == null) {
            document = FileDocumentManager.getInstance().getDocument(this.getVirtualFile());
            this.myDocument = document == null ? null : new java.lang.ref.SoftReference<Document>(document);
        }
        return document;
    }

    @Override
    @Nullable
    public final PsiFile getPsi(@NotNull Language target) {
        VirtualFile virtualFile;
        FileManager fileManager;
        if (target == null) {
            AbstractFileViewProvider.$$$reportNull$$$0(11);
        }
        if (!this.isPhysical() && (fileManager = this.getManager().getFileManager()).findCachedViewProvider(virtualFile = this.getVirtualFile()) == null && this.getCachedPsiFiles().isEmpty()) {
            fileManager.setViewProvider(virtualFile, this);
        }
        return this.getPsiInner(target);
    }

    @Nullable
    protected abstract PsiFile getPsiInner(Language var1);

    @Override
    public FileViewProvider clone() {
        VirtualFile origFile = this.getVirtualFile();
        LightVirtualFile copy = new LightVirtualFile(origFile.getName(), this.myFileType, this.getContents(), origFile.getCharset(), this.getModificationStamp());
        copy.setOriginalFile(origFile);
        copy.putUserData(UndoConstants.DONT_RECORD_UNDO, Boolean.TRUE);
        copy.setCharset(origFile.getCharset());
        return this.createCopy(copy);
    }

    @Override
    public PsiElement findElementAt(int offset, @NotNull Language language) {
        PsiFile psiFile;
        if (language == null) {
            AbstractFileViewProvider.$$$reportNull$$$0(12);
        }
        return (psiFile = this.getPsi(language)) != null ? AbstractFileViewProvider.findElementAt(psiFile, offset) : null;
    }

    @Override
    @Nullable
    public PsiReference findReferenceAt(int offset, @NotNull Language language) {
        PsiFile psiFile;
        if (language == null) {
            AbstractFileViewProvider.$$$reportNull$$$0(13);
        }
        return (psiFile = this.getPsi(language)) != null ? AbstractFileViewProvider.findReferenceAt(psiFile, offset) : null;
    }

    @Nullable
    protected static PsiReference findReferenceAt(@Nullable PsiFile psiFile, int offset) {
        if (psiFile == null) {
            return null;
        }
        int offsetInElement = offset;
        for (PsiElement child = psiFile.getFirstChild(); child != null; child = child.getNextSibling()) {
            int length = child.getTextLength();
            if (length <= offsetInElement) {
                offsetInElement -= length;
                continue;
            }
            return child.findReferenceAt(offsetInElement);
        }
        return null;
    }

    @Nullable
    public static PsiElement findElementAt(@Nullable PsiElement psiFile, int offset) {
        ASTNode node = psiFile == null ? null : psiFile.getNode();
        return node == null ? null : SourceTreeToPsiMap.treeElementToPsi(node.findLeafElementAt(offset));
    }

    @Override
    public void beforeContentsSynchronized() {
    }

    @Override
    public void contentsSynchronized() {
        if (this.myContent instanceof PsiFileContent) {
            this.setContent(new VirtualFileContent());
        }
        this.checkLengthConsistency();
    }

    public final void beforeDocumentChanged(@Nullable PsiFile psiCause) {
        PsiFile psiFile;
        PsiFile psiFile2 = psiFile = psiCause != null ? psiCause : this.getPsi(this.getBaseLanguage());
        if (psiFile instanceof PsiFileImpl && this.myContent instanceof VirtualFileContent) {
            this.setContent(new PsiFileContent((PsiFileImpl)psiFile, psiCause == null ? this.getModificationStamp() : LocalTimeCounter.currentTime()));
            this.checkLengthConsistency();
        }
    }

    public final void onContentReload() {
        List<PsiFile> files = this.getCachedPsiFiles();
        ArrayList<PsiTreeChangeEventImpl> events = ContainerUtil.newArrayList();
        ArrayList<PsiTreeChangeEventImpl> genericEvents = ContainerUtil.newArrayList();
        for (PsiFile file : files) {
            genericEvents.add(this.createChildrenChangeEvent(file, true));
            events.add(this.createChildrenChangeEvent(file, false));
        }
        this.beforeContentsSynchronized();
        for (PsiTreeChangeEventImpl event : genericEvents) {
            ((PsiManagerImpl)this.getManager()).beforeChildrenChange(event);
        }
        for (PsiTreeChangeEventImpl event : events) {
            ((PsiManagerImpl)this.getManager()).beforeChildrenChange(event);
        }
        for (PsiFile psiFile : files) {
            if (!(psiFile instanceof PsiFileEx)) continue;
            ((PsiFileEx)psiFile).onContentReload();
        }
        for (PsiTreeChangeEventImpl event : events) {
            ((PsiManagerImpl)this.getManager()).childrenChanged(event);
        }
        for (PsiTreeChangeEventImpl event : genericEvents) {
            ((PsiManagerImpl)this.getManager()).childrenChanged(event);
        }
        this.contentsSynchronized();
    }

    private PsiTreeChangeEventImpl createChildrenChangeEvent(PsiFile file, boolean generic) {
        PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(this.myManager);
        event.setParent(file);
        event.setFile(file);
        event.setGenericChange(generic);
        if (file instanceof PsiFileImpl && ((PsiFileImpl)file).isContentsLoaded()) {
            event.setOffset(0);
            event.setOldLength(file.getTextLength());
        }
        return event;
    }

    @Override
    public void rootChanged(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            AbstractFileViewProvider.$$$reportNull$$$0(14);
        }
        if (psiFile instanceof PsiFileImpl && ((PsiFileImpl)psiFile).isContentsLoaded()) {
            this.setContent(new PsiFileContent((PsiFileImpl)psiFile, LocalTimeCounter.currentTime()));
        }
    }

    @Override
    public boolean isEventSystemEnabled() {
        return this.myEventSystemEnabled;
    }

    @Override
    public boolean isPhysical() {
        return this.myPhysical;
    }

    @Override
    public long getModificationStamp() {
        return this.getContent().getModificationStamp();
    }

    @Override
    public boolean supportsIncrementalReparse(@NotNull Language rootLanguage) {
        if (rootLanguage == null) {
            AbstractFileViewProvider.$$$reportNull$$$0(15);
        }
        return true;
    }

    @NotNull
    private Content getContent() {
        Content content = this.myContent;
        if (content == null) {
            AbstractFileViewProvider.$$$reportNull$$$0(16);
        }
        return content;
    }

    private void setContent(@NotNull Content content) {
        if (content == null) {
            AbstractFileViewProvider.$$$reportNull$$$0(17);
        }
        this.myContent = content;
    }

    private void checkLengthConsistency() {
        Document document = this.getCachedDocument();
        if (document instanceof DocumentWindow) {
            return;
        }
        if (document != null && ((PsiDocumentManagerBase)PsiDocumentManager.getInstance(this.myManager.getProject())).getSynchronizer().isInSynchronization(document)) {
            return;
        }
        List<FileElement> knownTreeRoots = this.getKnownTreeRoots();
        if (knownTreeRoots.isEmpty()) {
            return;
        }
        int fileLength = this.myContent.getTextLength();
        for (FileElement fileElement : knownTreeRoots) {
            int nodeLength;
            if (this.isDocumentConsistentWithPsi(fileLength, fileElement, nodeLength = fileElement.getTextLength())) continue;
            PsiUtilCore.ensureValid(fileElement.getPsi());
            ArrayList<Attachment> attachments = ContainerUtil.newArrayList(new Attachment[]{new Attachment(this.myVirtualFile.getName(), this.myContent.getText().toString()), new Attachment(this.myVirtualFile.getNameWithoutExtension() + ".tree.txt", fileElement.getText())});
            if (document != null) {
                attachments.add(new Attachment(this.myVirtualFile.getNameWithoutExtension() + ".document.txt", document.getText()));
            }
            LOG.error("Inconsistent " + fileElement.getElementType() + " tree in " + this + "; nodeLength=" + nodeLength + "; fileLength=" + fileLength, attachments.toArray(Attachment.EMPTY_ARRAY));
        }
    }

    private boolean isDocumentConsistentWithPsi(int fileLength, FileElement fileElement, int nodeLength) {
        if (nodeLength != fileLength) {
            return false;
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && !ApplicationInfoImpl.isInStressTest()) {
            return fileElement.textMatches(this.myContent.getText());
        }
        return true;
    }

    @NonNls
    public String toString() {
        return this.getClass().getSimpleName() + "{myVirtualFile=" + this.myVirtualFile + ", content=" + this.getContent() + '}';
    }

    public abstract PsiFile getCachedPsi(@NotNull Language var1);

    public abstract List<PsiFile> getCachedPsiFiles();

    @NotNull
    public abstract List<FileElement> getKnownTreeRoots();

    public void markInvalidated() {
        if (this.myInvalidated) {
            return;
        }
        this.myInvalidated = true;
        this.invalidateCopies();
    }

    private void invalidateCopies() {
        Set<AbstractFileViewProvider> knownCopies = this.getUserData(KNOWN_COPIES);
        if (knownCopies != null) {
            for (AbstractFileViewProvider copy : knownCopies) {
                if (!copy.getCachedPsiFiles().stream().anyMatch(f -> f.getOriginalFile().getViewProvider() == this)) continue;
                this.myManager.getFileManager().setViewProvider(copy.getVirtualFile(), null);
            }
        }
    }

    public final void registerAsCopy(@NotNull AbstractFileViewProvider copy) {
        Set<AbstractFileViewProvider> copies;
        if (copy == null) {
            AbstractFileViewProvider.$$$reportNull$$$0(18);
        }
        if ((copies = this.getUserData(KNOWN_COPIES)) == null) {
            copies = this.putUserDataIfAbsent(KNOWN_COPIES, Collections.newSetFromMap(ContainerUtil.createConcurrentWeakMap()));
        }
        copies.add(copy);
    }

    private CharSequence getLastCommittedText(Document document) {
        return PsiDocumentManager.getInstance(this.myManager.getProject()).getLastCommittedText(document);
    }

    private long getLastCommittedStamp(Document document) {
        return PsiDocumentManager.getInstance(this.myManager.getProject()).getLastCommittedStamp(document);
    }

    @Override
    @NotNull
    public PsiFile getStubBindingRoot() {
        PsiFile psi = this.getPsi(this.getBaseLanguage());
        assert (psi != null);
        PsiFile psiFile = psi;
        if (psiFile == null) {
            AbstractFileViewProvider.$$$reportNull$$$0(19);
        }
        return psiFile;
    }

    @Override
    @NotNull
    public final FileType getFileType() {
        FileType fileType = this.myFileType;
        if (fileType == null) {
            AbstractFileViewProvider.$$$reportNull$$$0(20);
        }
        return fileType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lang";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/AbstractFileViewProvider";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootLanguage";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/AbstractFileViewProvider";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getManager";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getContents";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFile";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubBindingRoot";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isFreeThreaded";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 19: 
            case 20: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getPsi";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findElementAt";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findReferenceAt";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "rootChanged";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "supportsIncrementalReparse";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setContent";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "registerAsCopy";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class PsiFileContent
    implements Content {
        private final PsiFileImpl myFile;
        private volatile String myContent;
        private final long myModificationStamp;
        private final List<FileElement> myFileElementHardRefs = new SmartList<FileElement>();

        private PsiFileContent(PsiFileImpl file, long modificationStamp) {
            this.myFile = file;
            this.myModificationStamp = modificationStamp;
            for (PsiFile aFile : AbstractFileViewProvider.this.getAllFiles()) {
                if (!(aFile instanceof PsiFileImpl)) continue;
                this.myFileElementHardRefs.add(((PsiFileImpl)aFile).calcTreeElement());
            }
        }

        @Override
        public CharSequence getText() {
            String content = this.myContent;
            if (content == null) {
                this.myContent = content = ReadAction.compute(() -> this.myFile.calcTreeElement().getText());
            }
            return content;
        }

        @Override
        public int getTextLength() {
            String content = this.myContent;
            if (content != null) {
                return content.length();
            }
            return this.myFile.calcTreeElement().getTextLength();
        }

        @Override
        public long getModificationStamp() {
            return this.myModificationStamp;
        }
    }

    private class VirtualFileContent
    implements Content {
        private VirtualFileContent() {
        }

        @Override
        public CharSequence getText() {
            VirtualFile virtualFile = AbstractFileViewProvider.this.getVirtualFile();
            if (virtualFile instanceof LightVirtualFile) {
                Document doc = AbstractFileViewProvider.this.getCachedDocument();
                if (doc != null) {
                    return AbstractFileViewProvider.this.getLastCommittedText(doc);
                }
                return ((LightVirtualFile)virtualFile).getContent();
            }
            Document document = AbstractFileViewProvider.this.getDocument();
            if (document == null) {
                return LoadTextUtil.loadText(virtualFile);
            }
            return AbstractFileViewProvider.this.getLastCommittedText(document);
        }

        @Override
        public int getTextLength() {
            return this.getText().length();
        }

        @Override
        public long getModificationStamp() {
            Document document = AbstractFileViewProvider.this.getCachedDocument();
            if (document == null) {
                return AbstractFileViewProvider.this.getVirtualFile().getModificationStamp();
            }
            return AbstractFileViewProvider.this.getLastCommittedStamp(document);
        }

        @NonNls
        public String toString() {
            return "VirtualFileContent{size=" + AbstractFileViewProvider.this.getVirtualFile().getLength() + "}";
        }
    }

    private static interface Content {
        public CharSequence getText();

        public int getTextLength();

        public long getModificationStamp();
    }
}

