/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.ActiveComponent;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CaptionPanel
extends JPanel {
    private static final Color CNT_COLOR = new JBColor(Gray._240, Gray._90);
    private static final Color BND_COLOR = new JBColor(Gray._240, Gray._90);
    public static final Color CNT_ACTIVE_COLOR = new JBColor(Gray._202, Gray._55);
    public static final Color CNT_ACTIVE_BORDER_COLOR = UIUtil.isUnderDarcula() ? UIUtil.getBorderColor() : CNT_ACTIVE_COLOR;
    public static final Color BND_ACTIVE_COLOR = new JBColor(Gray._239, Gray._90);
    private static final JBColor TOP_FLICK_ACTIVE = new JBColor(Color.white, Gray._110);
    private static final JBColor TOP_FLICK_PASSIVE = new JBColor(Color.white, BND_COLOR);
    private static final JBColor BOTTOM_FLICK_ACTIVE = new JBColor(Color.gray, Gray._35);
    private static final JBColor BOTTOM_FLICK_PASSIVE = new JBColor(Color.lightGray, Gray._75);
    private boolean myActive = false;
    private ActiveComponent myButtonComponent;
    private JComponent mySettingComponent;

    public CaptionPanel() {
        this.setLayout(new BorderLayout());
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        if (this.myActive) {
            g.setColor(TOP_FLICK_ACTIVE);
            g.drawLine(0, 0, this.getWidth(), 0);
            g.setColor(BOTTOM_FLICK_ACTIVE);
            g.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
            g2d.setPaint(UIUtil.getGradientPaint(0.0f, 0.0f, BND_ACTIVE_COLOR, 0.0f, this.getHeight(), CNT_ACTIVE_COLOR));
        } else {
            g.setColor(TOP_FLICK_PASSIVE);
            g.drawLine(0, 0, this.getWidth(), 0);
            g.setColor(BOTTOM_FLICK_PASSIVE);
            g.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
            g2d.setPaint(UIUtil.getGradientPaint(0.0f, 0.0f, BND_COLOR, 0.0f, this.getHeight(), CNT_COLOR));
        }
        g2d.fillRect(0, 1, this.getWidth(), this.getHeight() - 2);
    }

    private void paintUnderDarcula(Graphics2D g) {
        if (this.myActive) {
            g.setColor(Gray._100);
            g.drawLine(0, 0, this.getWidth(), 0);
            g.setColor(Gray._50);
            g.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
            g.setPaint(UIUtil.getGradientPaint(0.0f, 0.0f, Gray._100, 0.0f, this.getHeight(), Gray._85));
        } else {
            g.setColor(Gray._100);
            g.drawLine(0, 0, this.getWidth(), 0);
            g.setColor(Gray._50);
            g.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
            g.setPaint(UIUtil.getGradientPaint(0.0f, 0.0f, Gray._120, 0.0f, this.getHeight(), Gray._105));
        }
        g.fillRect(0, 1, this.getWidth(), this.getHeight() - 2);
    }

    public void setActive(boolean active) {
        this.myActive = active;
        if (this.myButtonComponent != null) {
            this.myButtonComponent.setActive(active);
        }
        this.repaint();
    }

    public void setButtonComponent(@NotNull ActiveComponent component, @Nullable Border border) {
        if (component == null) {
            CaptionPanel.$$$reportNull$$$0(0);
        }
        if (this.myButtonComponent != null) {
            this.remove(this.myButtonComponent.getComponent());
        }
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(border);
        panel.add((Component)new JLabel(" "), "West");
        panel.add((Component)component.getComponent(), "Center");
        panel.setOpaque(false);
        this.add((Component)panel, "East");
        this.myButtonComponent = component;
    }

    public void addSettingsComponent(Component component) {
        if (this.mySettingComponent == null) {
            this.mySettingComponent = new JPanel();
            this.mySettingComponent.setOpaque(false);
            this.mySettingComponent.setLayout(new BoxLayout(this.mySettingComponent, 0));
            this.add((Component)this.mySettingComponent, "West");
        }
        this.mySettingComponent.add(component);
    }

    public boolean isWithinPanel(MouseEvent e) {
        Point p = SwingUtilities.convertPoint(e.getComponent(), e.getX(), e.getY(), this);
        Component c = this.findComponentAt(p);
        return c != null && c != this.myButtonComponent;
    }

    public static Color getBorderColor(boolean isActive) {
        return isActive ? Color.gray : Color.lightGray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/ui/CaptionPanel", "setButtonComponent"));
    }
}

