/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.BufferExposingByteArrayInputStream;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.io.FileTooBigException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.openapi.vfs.impl.ZipEntryMap;
import com.intellij.util.io.FileAccessorCache;
import com.intellij.util.io.ResourceHandle;
import com.intellij.util.text.ByteArrayCharSequence;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ZipHandler
extends ArchiveHandler {
    private volatile String myCanonicalPathToZip;
    private volatile long myFileStamp;
    private volatile long myFileLength;
    private static final FileAccessorCache<ZipHandler, ZipFile> ourZipFileFileAccessorCache = new FileAccessorCache<ZipHandler, ZipFile>(20, 10){

        @Override
        protected ZipFile createAccessor(ZipHandler key) throws IOException {
            String canonicalPathToZip = key.getCanonicalPathToZip();
            ZipHandler.setFileStampAndLength(key, canonicalPathToZip);
            return new ZipFile(canonicalPathToZip);
        }

        @Override
        protected void disposeAccessor(ZipFile fileAccessor) throws IOException {
            fileAccessor.close();
        }

        @Override
        public boolean isEqual(ZipHandler val1, ZipHandler val2) {
            return val1 == val2;
        }
    };

    public ZipHandler(@NotNull String path) {
        if (path == null) {
            ZipHandler.$$$reportNull$$$0(0);
        }
        super(path);
    }

    protected static synchronized void setFileStampAndLength(ZipHandler zipHandler, String pathToZip) {
        FileAttributes attributes = FileSystemUtil.getAttributes(pathToZip);
        zipHandler.myFileStamp = attributes != null ? attributes.lastModified : -1L;
        zipHandler.myFileLength = attributes != null ? attributes.length : 0L;
    }

    @NotNull
    private String getCanonicalPathToZip() throws IOException {
        String value = this.myCanonicalPathToZip;
        if (value == null) {
            this.myCanonicalPathToZip = value = this.getFileToUse().getCanonicalPath();
        }
        String string = value;
        if (string == null) {
            ZipHandler.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    protected Map<String, ArchiveHandler.EntryInfo> createEntriesMap() throws IOException {
        Map<String, ArchiveHandler.EntryInfo> map;
        try (ResourceHandle<ZipFile> existingZipRef = this.acquireZipHandle();){
            Map<String, ArchiveHandler.EntryInfo> map2 = this.buildEntryMapForZipFile(existingZipRef.get());
            map = map2;
        }
        if (map == null) {
            ZipHandler.$$$reportNull$$$0(2);
        }
        return map;
    }

    @NotNull
    protected Map<String, ArchiveHandler.EntryInfo> buildEntryMapForZipFile(ZipFile zip) {
        ZipEntryMap map = new ZipEntryMap(zip.size());
        map.put("", this.createRootEntry());
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            this.getOrCreate(entries.nextElement(), (Map<String, ArchiveHandler.EntryInfo>)map, zip);
        }
        ZipEntryMap zipEntryMap = map;
        if (zipEntryMap == null) {
            ZipHandler.$$$reportNull$$$0(3);
        }
        return zipEntryMap;
    }

    @Contract(value="true -> !null")
    protected FileAccessorCache.Handle<ZipFile> getCachedZipFileHandle(boolean createIfNeeded) throws IOException {
        try {
            FileAccessorCache.Handle<ZipFile> handle;
            FileAccessorCache.Handle<ZipFile> handle2 = handle = createIfNeeded ? ourZipFileFileAccessorCache.get(this) : ourZipFileFileAccessorCache.getIfCached(this);
            if (handle != null && this.getFile() == this.getFileToUse()) {
                FileAttributes attributes = FileSystemUtil.getAttributes(this.getCanonicalPathToZip());
                if (attributes == null) {
                    throw new FileNotFoundException(this.getCanonicalPathToZip());
                }
                if (attributes.lastModified == this.myFileStamp && attributes.length == this.myFileLength) {
                    return handle;
                }
                this.removeZipHandlerFromCache();
                handle.release();
                handle = ourZipFileFileAccessorCache.get(this);
            }
            return handle;
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw e;
        }
    }

    private void removeZipHandlerFromCache() {
        ourZipFileFileAccessorCache.remove(this);
        this.clearCaches();
    }

    @NotNull
    protected File getFileToUse() {
        File file = this.getFile();
        if (file == null) {
            ZipHandler.$$$reportNull$$$0(4);
        }
        return file;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.removeZipHandlerFromCache();
    }

    @NotNull
    private ArchiveHandler.EntryInfo getOrCreate(@NotNull ZipEntry entry, @NotNull Map<String, ArchiveHandler.EntryInfo> map, @NotNull ZipFile zip) {
        ArchiveHandler.EntryInfo info;
        if (entry == null) {
            ZipHandler.$$$reportNull$$$0(5);
        }
        if (map == null) {
            ZipHandler.$$$reportNull$$$0(6);
        }
        if (zip == null) {
            ZipHandler.$$$reportNull$$$0(7);
        }
        boolean isDirectory = entry.isDirectory();
        String entryName = entry.getName();
        if (StringUtil.endsWithChar(entryName, '/')) {
            entryName = entryName.substring(0, entryName.length() - 1);
            isDirectory = true;
        }
        if ((info = map.get(entryName)) != null) {
            ArchiveHandler.EntryInfo entryInfo = info;
            if (entryInfo == null) {
                ZipHandler.$$$reportNull$$$0(8);
            }
            return entryInfo;
        }
        Pair<String, String> path = this.splitPath(entryName);
        ArchiveHandler.EntryInfo parentInfo = this.getOrCreate((String)path.first, map, zip);
        if (".".equals(path.second)) {
            ArchiveHandler.EntryInfo entryInfo = parentInfo;
            if (entryInfo == null) {
                ZipHandler.$$$reportNull$$$0(9);
            }
            return entryInfo;
        }
        ArchiveHandler.EntryInfo entryInfo = info = ZipHandler.store(map, parentInfo, (CharSequence)path.second, isDirectory, entry.getSize(), this.myFileStamp, entryName);
        if (entryInfo == null) {
            ZipHandler.$$$reportNull$$$0(10);
        }
        return entryInfo;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private static ArchiveHandler.EntryInfo store(@NotNull Map<String, ArchiveHandler.EntryInfo> map, @Nullable ArchiveHandler.EntryInfo parentInfo, @NotNull CharSequence shortName, boolean isDirectory, long size, long time, @NotNull String string) {
        void entryName;
        if (map == null) {
            ZipHandler.$$$reportNull$$$0(11);
        }
        if (shortName == null) {
            ZipHandler.$$$reportNull$$$0(12);
        }
        if (string == null) {
            ZipHandler.$$$reportNull$$$0(13);
        }
        CharSequence sequence = shortName instanceof ByteArrayCharSequence ? shortName : ByteArrayCharSequence.convertToBytesIfAsciiString(shortName);
        ArchiveHandler.EntryInfo info = new ArchiveHandler.EntryInfo(sequence, isDirectory, size, time, parentInfo);
        map.put((String)entryName, info);
        ArchiveHandler.EntryInfo entryInfo = info;
        if (entryInfo == null) {
            ZipHandler.$$$reportNull$$$0(14);
        }
        return entryInfo;
    }

    @NotNull
    private ArchiveHandler.EntryInfo getOrCreate(@NotNull String entryName, Map<String, ArchiveHandler.EntryInfo> map, @NotNull ZipFile zip) {
        ArchiveHandler.EntryInfo info;
        if (entryName == null) {
            ZipHandler.$$$reportNull$$$0(15);
        }
        if (zip == null) {
            ZipHandler.$$$reportNull$$$0(16);
        }
        if ((info = map.get(entryName)) == null) {
            ZipEntry entry = zip.getEntry(entryName + "/");
            if (entry != null) {
                ArchiveHandler.EntryInfo entryInfo = this.getOrCreate(entry, map, zip);
                if (entryInfo == null) {
                    ZipHandler.$$$reportNull$$$0(17);
                }
                return entryInfo;
            }
            Pair<String, String> path = this.splitPath(entryName);
            ArchiveHandler.EntryInfo parentInfo = this.getOrCreate((String)path.first, map, zip);
            info = ZipHandler.store(map, parentInfo, (CharSequence)path.second, true, 0L, -1L, entryName);
        }
        if (!info.isDirectory) {
            Logger.getInstance(this.getClass()).info(zip.getName() + ": " + entryName + " should be a directory");
            info = ZipHandler.store(map, info.parent, info.shortName, true, info.length, info.timestamp, entryName);
        }
        ArchiveHandler.EntryInfo entryInfo = info;
        if (entryInfo == null) {
            ZipHandler.$$$reportNull$$$0(18);
        }
        return entryInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public byte[] contentsToByteArray(@NotNull String relativePath) throws IOException {
        block31: {
            byte[] byArray;
            Throwable throwable;
            ResourceHandle<ZipFile> zipRef;
            block32: {
                if (relativePath == null) {
                    ZipHandler.$$$reportNull$$$0(19);
                }
                zipRef = this.acquireZipHandle();
                throwable = null;
                try {
                    ZipFile zip = zipRef.get();
                    ZipEntry entry = zip.getEntry(relativePath);
                    if (entry == null) break block31;
                    long length = entry.getSize();
                    if (FileUtilRt.isTooLarge(length)) {
                        throw new FileTooBigException(this.getFile() + "!/" + relativePath);
                    }
                    try (InputStream stream = zip.getInputStream(entry);){
                        if (stream == null) break block31;
                        byArray = FileUtil.loadBytes(stream, (int)length);
                        if (byArray != null) break block32;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                ZipHandler.$$$reportNull$$$0(20);
            }
            return byArray;
            finally {
                if (zipRef != null) {
                    if (throwable != null) {
                        try {
                            zipRef.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        zipRef.close();
                    }
                }
            }
        }
        throw new FileNotFoundException(this.getFile() + "!/" + relativePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public InputStream getInputStream(@NotNull String relativePath) throws IOException {
        block12: {
            InputStream stream;
            if (relativePath == null) {
                ZipHandler.$$$reportNull$$$0(21);
            }
            boolean release = true;
            ResourceHandle<ZipFile> zipRef = this.acquireZipHandle();
            ZipFile zip = zipRef.get();
            ZipEntry entry = zip.getEntry(relativePath);
            if (entry == null || (stream = zip.getInputStream(entry)) == null) break block12;
            long length = entry.getSize();
            if (!FileUtilRt.isTooLarge(length)) {
                BufferExposingByteArrayInputStream bufferExposingByteArrayInputStream = new BufferExposingByteArrayInputStream(FileUtil.loadBytes(stream, (int)length));
                BufferExposingByteArrayInputStream bufferExposingByteArrayInputStream2 = bufferExposingByteArrayInputStream;
                if (bufferExposingByteArrayInputStream2 == null) {
                    ZipHandler.$$$reportNull$$$0(22);
                }
                return bufferExposingByteArrayInputStream2;
                finally {
                    stream.close();
                }
            }
            release = false;
            InputStreamWrapper inputStreamWrapper = new InputStreamWrapper(stream, zipRef);
            InputStreamWrapper inputStreamWrapper2 = inputStreamWrapper;
            if (inputStreamWrapper2 == null) {
                ZipHandler.$$$reportNull$$$0(23);
            }
            return inputStreamWrapper2;
            finally {
                if (release) {
                    zipRef.release();
                }
            }
        }
        throw new FileNotFoundException(this.getFile() + "!/" + relativePath);
    }

    @NotNull
    protected ResourceHandle<ZipFile> acquireZipHandle() throws IOException {
        FileAccessorCache.Handle<ZipFile> handle = this.getCachedZipFileHandle(true);
        if (handle == null) {
            ZipHandler.$$$reportNull$$$0(24);
        }
        return handle;
    }

    public static void clearFileAccessorCache() {
        ourZipFileFileAccessorCache.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/ZipHandler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 7: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zip";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortName";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryName";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/ZipHandler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalPathToZip";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEntriesMap";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildEntryMapForZipFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileToUse";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreate";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "store";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputStream";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "acquireZipHandle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreate";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "store";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "contentsToByteArray";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getInputStream";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class InputStreamWrapper
    extends InputStream {
        private final InputStream myStream;
        private final ResourceHandle<ZipFile> myZipRef;
        private final AtomicBoolean closed = new AtomicBoolean(false);

        public InputStreamWrapper(InputStream stream, ResourceHandle<ZipFile> zipRef) {
            this.myStream = stream;
            this.myZipRef = zipRef;
        }

        @Override
        public int read() throws IOException {
            return this.myStream.read();
        }

        @Override
        public int read(@NotNull byte[] b, int off, int len) throws IOException {
            if (b == null) {
                InputStreamWrapper.$$$reportNull$$$0(0);
            }
            return this.myStream.read(b, off, len);
        }

        @Override
        public int available() throws IOException {
            return this.myStream.available();
        }

        @Override
        public void close() throws IOException {
            if (!this.closed.getAndSet(true)) {
                try {
                    this.myStream.close();
                }
                finally {
                    this.myZipRef.release();
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/intellij/openapi/vfs/impl/ZipHandler$InputStreamWrapper", "read"));
        }
    }
}

