/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.google.common.base.MoreObjects;
import com.intellij.lang.Language;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.smartPointers.SmartPointerAnchorProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.WeakInterner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Identikit {
    private static final WeakInterner<ByType> ourPlainInterner = new WeakInterner();
    private static final WeakInterner<ByAnchor> ourAnchorInterner = new WeakInterner();

    @Nullable
    public abstract PsiElement findPsiElement(@NotNull PsiFile var1, int var2, int var3);

    @NotNull
    public abstract Language getFileLanguage();

    public abstract boolean isForPsiFile();

    public static ByType fromPsi(@NotNull PsiElement element, @NotNull Language fileLanguage) {
        if (element == null) {
            Identikit.$$$reportNull$$$0(0);
        }
        if (fileLanguage == null) {
            Identikit.$$$reportNull$$$0(1);
        }
        return Identikit.fromTypes(element.getClass(), PsiUtilCore.getElementType(element), fileLanguage);
    }

    @Nullable
    static Pair<ByAnchor, PsiElement> withAnchor(@NotNull PsiElement element, @NotNull Language fileLanguage) {
        if (element == null) {
            Identikit.$$$reportNull$$$0(2);
        }
        if (fileLanguage == null) {
            Identikit.$$$reportNull$$$0(3);
        }
        PsiUtilCore.ensureValid(element);
        if (element.isPhysical()) {
            for (SmartPointerAnchorProvider provider : SmartPointerAnchorProvider.EP_NAME.getExtensions()) {
                PsiElement anchor = provider.getAnchor(element);
                if (anchor == null || !anchor.isPhysical() || provider.restoreElement(anchor) != element) continue;
                ByAnchor anchorKit = new ByAnchor(Identikit.fromPsi(element, fileLanguage), Identikit.fromPsi(anchor, fileLanguage), provider);
                return Pair.create(ourAnchorInterner.intern(anchorKit), anchor);
            }
        }
        return null;
    }

    @NotNull
    static ByType fromTypes(@NotNull Class elementClass, @Nullable IElementType elementType, @NotNull Language fileLanguage) {
        if (elementClass == null) {
            Identikit.$$$reportNull$$$0(4);
        }
        if (fileLanguage == null) {
            Identikit.$$$reportNull$$$0(5);
        }
        ByType byType = ourPlainInterner.intern(new ByType(elementClass, elementType, fileLanguage));
        if (byType == null) {
            Identikit.$$$reportNull$$$0(6);
        }
        return byType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileLanguage";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementClass";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/smartPointers/Identikit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/smartPointers/Identikit";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "fromTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fromPsi";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "withAnchor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fromTypes";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class ByAnchor
    extends Identikit {
        private final ByType myElementInfo;
        private final ByType myAnchorInfo;
        private final SmartPointerAnchorProvider myAnchorProvider;

        ByAnchor(ByType elementInfo, ByType anchorInfo, SmartPointerAnchorProvider anchorProvider) {
            this.myElementInfo = elementInfo;
            this.myAnchorInfo = anchorInfo;
            this.myAnchorProvider = anchorProvider;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ByAnchor)) {
                return false;
            }
            ByAnchor anchor = (ByAnchor)o;
            if (!this.myElementInfo.equals(anchor.myElementInfo)) {
                return false;
            }
            if (!this.myAnchorInfo.equals(anchor.myAnchorInfo)) {
                return false;
            }
            return this.myAnchorProvider.equals(anchor.myAnchorProvider);
        }

        public int hashCode() {
            return this.myElementInfo.hashCode();
        }

        @Override
        @Nullable
        public PsiElement findPsiElement(@NotNull PsiFile file, int startOffset, int endOffset) {
            PsiElement anchor;
            if (file == null) {
                ByAnchor.$$$reportNull$$$0(0);
            }
            PsiElement element = (anchor = this.myAnchorInfo.findPsiElement(file, startOffset, endOffset)) == null ? null : this.myAnchorProvider.restoreElement(anchor);
            return element != null && this.myElementInfo.isAcceptable(element) ? element : null;
        }

        @Override
        @NotNull
        public Language getFileLanguage() {
            Language language = this.myAnchorInfo.getFileLanguage();
            if (language == null) {
                ByAnchor.$$$reportNull$$$0(1);
            }
            return language;
        }

        @Override
        public boolean isForPsiFile() {
            return this.myAnchorInfo.isForPsiFile();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/smartPointers/Identikit$ByAnchor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/smartPointers/Identikit$ByAnchor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileLanguage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "findPsiElement";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ByType
    extends Identikit {
        private final Class myElementClass;
        private final IElementType myElementType;
        private final Language myFileLanguage;

        private ByType(@NotNull Class elementClass, @Nullable IElementType elementType, Language fileLanguage) {
            if (elementClass == null) {
                ByType.$$$reportNull$$$0(0);
            }
            this.myElementClass = elementClass;
            this.myElementType = elementType;
            this.myFileLanguage = fileLanguage;
        }

        @Override
        @Nullable
        public PsiElement findPsiElement(@NotNull PsiFile file, int startOffset, int endOffset) {
            PsiElement lastChild;
            if (file == null) {
                ByType.$$$reportNull$$$0(1);
            }
            Language actualLanguage = this.myFileLanguage != Language.ANY ? this.myFileLanguage : file.getViewProvider().getBaseLanguage();
            PsiElement anchor = file.getViewProvider().findElementAt(startOffset, actualLanguage);
            if (anchor == null && startOffset == file.getTextLength() && (lastChild = file.getViewProvider().getPsi(actualLanguage).getLastChild()) != null) {
                anchor = PsiTreeUtil.getDeepestLast(lastChild);
            }
            if (anchor == null) {
                return null;
            }
            PsiElement result = this.findParent(startOffset, endOffset, anchor);
            if (endOffset == startOffset) {
                while (result == null && anchor.getTextRange().getStartOffset() == endOffset && (anchor = PsiTreeUtil.prevLeaf(anchor, false)) != null) {
                    result = this.findParent(startOffset, endOffset, anchor);
                }
            }
            return result;
        }

        @Nullable
        private PsiElement findParent(int startOffset, int endOffset, PsiElement anchor) {
            TextRange range = anchor.getTextRange();
            if (range.getStartOffset() != startOffset) {
                return null;
            }
            while (range.getEndOffset() < endOffset) {
                if ((anchor = anchor.getParent()) == null || anchor.getTextRange() == null) {
                    return null;
                }
                range = anchor.getTextRange();
            }
            while (range.getEndOffset() == endOffset) {
                if (this.isAcceptable(anchor)) {
                    return anchor;
                }
                if ((anchor = anchor.getParent()) == null || anchor.getTextRange() == null) break;
                range = anchor.getTextRange();
            }
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ByType)) {
                return false;
            }
            ByType info = (ByType)o;
            return this.myElementType == info.myElementType && this.myElementClass == info.myElementClass && this.myFileLanguage == info.myFileLanguage;
        }

        public int hashCode() {
            return (this.myElementType == null ? 0 : this.myElementType.hashCode() * 31 * 31) + 31 * this.myElementClass.getName().hashCode() + this.myFileLanguage.hashCode();
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("class", (Object)this.myElementClass).add("elementType", (Object)this.myElementType).add("fileLanguage", (Object)this.myFileLanguage).toString();
        }

        @Override
        @NotNull
        public Language getFileLanguage() {
            Language language = this.myFileLanguage;
            if (language == null) {
                ByType.$$$reportNull$$$0(2);
            }
            return language;
        }

        @Override
        public boolean isForPsiFile() {
            return this.myElementType instanceof IFileElementType;
        }

        private boolean isAcceptable(@NotNull PsiElement element) {
            if (element == null) {
                ByType.$$$reportNull$$$0(3);
            }
            return this.myElementClass == element.getClass() && this.myElementType == PsiUtilCore.getElementType(element);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/smartPointers/Identikit$ByType";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/smartPointers/Identikit$ByType";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileLanguage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "findPsiElement";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isAcceptable";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

