/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class NonClasspathDirectoriesScope
extends GlobalSearchScope {
    private final Set<VirtualFile> myRoots;

    public NonClasspathDirectoriesScope(@NotNull Collection<VirtualFile> roots) {
        if (roots == null) {
            NonClasspathDirectoriesScope.$$$reportNull$$$0(0);
        }
        this.myRoots = ContainerUtil.newHashSet(roots);
    }

    @Override
    public boolean isSearchOutsideRootModel() {
        return true;
    }

    @NotNull
    public static GlobalSearchScope compose(@NotNull List<VirtualFile> roots) {
        if (roots == null) {
            NonClasspathDirectoriesScope.$$$reportNull$$$0(1);
        }
        if (roots.isEmpty()) {
            GlobalSearchScope globalSearchScope = EMPTY_SCOPE;
            if (globalSearchScope == null) {
                NonClasspathDirectoriesScope.$$$reportNull$$$0(2);
            }
            return globalSearchScope;
        }
        NonClasspathDirectoriesScope nonClasspathDirectoriesScope = new NonClasspathDirectoriesScope(roots);
        if (nonClasspathDirectoriesScope == null) {
            NonClasspathDirectoriesScope.$$$reportNull$$$0(3);
        }
        return nonClasspathDirectoriesScope;
    }

    @Override
    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            NonClasspathDirectoriesScope.$$$reportNull$$$0(4);
        }
        return VfsUtilCore.isUnder(file, this.myRoots);
    }

    @Override
    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        if (file1 == null) {
            NonClasspathDirectoriesScope.$$$reportNull$$$0(5);
        }
        if (file2 == null) {
            NonClasspathDirectoriesScope.$$$reportNull$$$0(6);
        }
        return 0;
    }

    @Override
    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        if (aModule == null) {
            NonClasspathDirectoriesScope.$$$reportNull$$$0(7);
        }
        return false;
    }

    @Override
    public boolean isSearchInLibraries() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NonClasspathDirectoriesScope)) {
            return false;
        }
        NonClasspathDirectoriesScope that = (NonClasspathDirectoriesScope)o;
        return this.myRoots.equals(that.myRoots);
    }

    @Override
    public int hashCode() {
        return this.myRoots.hashCode();
    }

    @Override
    @NotNull
    public String getDisplayName() {
        if (this.myRoots.size() == 1) {
            VirtualFile root = this.myRoots.iterator().next();
            String string = "Directory '" + root.getName() + "'";
            if (string == null) {
                NonClasspathDirectoriesScope.$$$reportNull$$$0(8);
            }
            return string;
        }
        String string = "Directories " + StringUtil.join(this.myRoots, file -> "'" + file.getName() + "'", ", ");
        if (string == null) {
            NonClasspathDirectoriesScope.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/NonClasspathDirectoriesScope";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file1";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file2";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/NonClasspathDirectoriesScope";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "compose";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "compose";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "compare";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isSearchInModuleContent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

