/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.StubBuilder;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.BooleanStack;
import com.intellij.util.containers.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultStubBuilder
implements StubBuilder {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.stubs.DefaultStubBuilder");

    @Override
    public StubElement buildStubTree(@NotNull PsiFile file) {
        if (file == null) {
            DefaultStubBuilder.$$$reportNull$$$0(0);
        }
        return this.buildStubTreeFor(file.getNode(), this.createStubForFile(file));
    }

    @NotNull
    protected StubElement createStubForFile(@NotNull PsiFile file) {
        PsiFileStubImpl<PsiFile> stub;
        if (file == null) {
            DefaultStubBuilder.$$$reportNull$$$0(1);
        }
        PsiFileStubImpl<PsiFile> psiFileStubImpl = stub = new PsiFileStubImpl<PsiFile>(file);
        if (psiFileStubImpl == null) {
            DefaultStubBuilder.$$$reportNull$$$0(2);
        }
        return psiFileStubImpl;
    }

    protected boolean skipChildProcessingWhenBuildingStubs(@NotNull PsiElement parent, @NotNull PsiElement element) {
        if (parent == null) {
            DefaultStubBuilder.$$$reportNull$$$0(3);
        }
        if (element == null) {
            DefaultStubBuilder.$$$reportNull$$$0(4);
        }
        return false;
    }

    @NotNull
    protected final StubElement buildStubTreeFor(@NotNull ASTNode root, @NotNull StubElement parentStub) {
        if (root == null) {
            DefaultStubBuilder.$$$reportNull$$$0(5);
        }
        if (parentStub == null) {
            DefaultStubBuilder.$$$reportNull$$$0(6);
        }
        new StubBuildingWalkingVisitor(root, parentStub).buildStubTree();
        StubElement stubElement = parentStub;
        if (stubElement == null) {
            DefaultStubBuilder.$$$reportNull$$$0(7);
        }
        return stubElement;
    }

    @Override
    public boolean skipChildProcessingWhenBuildingStubs(@NotNull ASTNode parent, @NotNull ASTNode node) {
        if (parent == null) {
            DefaultStubBuilder.$$$reportNull$$$0(8);
        }
        if (node == null) {
            DefaultStubBuilder.$$$reportNull$$$0(9);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/DefaultStubBuilder";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentStub";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/DefaultStubBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createStubForFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "buildStubTreeFor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildStubTree";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createStubForFile";
                break;
            }
            case 2: 
            case 7: {
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "skipChildProcessingWhenBuildingStubs";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "buildStubTreeFor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class StubBuildingWalkingVisitor {
        private final Stack<StubElement> parentStubs = new Stack();
        private final Stack<ASTNode> parentNodes = new Stack();
        private final BooleanStack parentNodesStubbed = new BooleanStack();

        protected StubBuildingWalkingVisitor(ASTNode root, StubElement parentStub) {
            this.parentNodes.push(root);
            this.parentStubs.push(parentStub);
            this.parentNodesStubbed.push(true);
        }

        public final void buildStubTree() {
            while (!this.parentStubs.isEmpty()) {
                this.visitNode(this.parentStubs.pop(), this.parentNodes.pop(), this.parentNodesStubbed.pop());
            }
        }

        protected void visitNode(StubElement parentStub, ASTNode node, boolean immediateParentStubbed) {
            StubElement stub = this.createStub(parentStub, node);
            if (stub != null && !immediateParentStubbed) {
                ((ObjectStubBase)((Object)stub)).markDangling();
            }
            this.pushChildren(node, node instanceof FileElement || stub != null, stub != null ? stub : parentStub);
        }

        @Nullable
        protected final ASTNode peekNextElement() {
            return this.parentNodes.isEmpty() ? null : this.parentNodes.peek();
        }

        @Nullable
        private StubElement createStub(StubElement parentStub, ASTNode node) {
            IStubElementType type;
            IElementType nodeType = node.getElementType();
            if (nodeType instanceof IStubElementType && (type = (IStubElementType)nodeType).shouldCreateStub(node)) {
                PsiElement element = node.getPsi();
                if (!(element instanceof StubBasedPsiElement)) {
                    LOG.error("Non-StubBasedPsiElement requests stub creation. Stub type: " + type + ", PSI: " + element);
                }
                Object stub = type.createStub(element, parentStub);
                LOG.assertTrue(stub != null, element);
                return stub;
            }
            return null;
        }

        private void pushChildren(ASTNode node, boolean hasStub, StubElement stub) {
            for (ASTNode childNode = node.getLastChildNode(); childNode != null; childNode = childNode.getTreePrev()) {
                if (DefaultStubBuilder.this.skipChildProcessingWhenBuildingStubs(node, childNode)) continue;
                this.parentNodes.push(childNode);
                this.parentStubs.push(stub);
                this.parentNodesStubbed.push(hasStub);
            }
        }
    }
}

