/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.AnnotationHolderImpl;
import com.intellij.codeInsight.daemon.impl.CachedAnnotators;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.codeInsight.daemon.impl.analysis.ErrorQuickFixProvider;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.highlighting.HighlightErrorFilter;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class DefaultHighlightVisitor
implements HighlightVisitor,
DumbAware {
    private AnnotationHolderImpl myAnnotationHolder;
    private final HighlightErrorFilter[] myErrorFilters;
    private final Project myProject;
    private final boolean myHighlightErrorElements;
    private final boolean myRunAnnotators;
    private final DumbService myDumbService;
    private HighlightInfoHolder myHolder;
    private final boolean myBatchMode;
    private final CachedAnnotators myCachedAnnotators;

    DefaultHighlightVisitor(@NotNull Project project, @NotNull CachedAnnotators cachedAnnotators) {
        if (project == null) {
            DefaultHighlightVisitor.$$$reportNull$$$0(0);
        }
        if (cachedAnnotators == null) {
            DefaultHighlightVisitor.$$$reportNull$$$0(1);
        }
        this(project, true, true, false, cachedAnnotators);
    }

    DefaultHighlightVisitor(@NotNull Project project, boolean highlightErrorElements, boolean runAnnotators, boolean batchMode, @NotNull CachedAnnotators cachedAnnotators) {
        if (project == null) {
            DefaultHighlightVisitor.$$$reportNull$$$0(2);
        }
        if (cachedAnnotators == null) {
            DefaultHighlightVisitor.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.myHighlightErrorElements = highlightErrorElements;
        this.myRunAnnotators = runAnnotators;
        this.myCachedAnnotators = cachedAnnotators;
        this.myErrorFilters = Extensions.getExtensions(HighlightErrorFilter.EP_NAME, (AreaInstance)project);
        this.myDumbService = DumbService.getInstance(project);
        this.myBatchMode = batchMode;
    }

    @Override
    public boolean suitableForFile(@NotNull PsiFile file) {
        if (file == null) {
            DefaultHighlightVisitor.$$$reportNull$$$0(4);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean analyze(@NotNull PsiFile file, boolean updateWholeFile, @NotNull HighlightInfoHolder holder, @NotNull Runnable action) {
        if (file == null) {
            DefaultHighlightVisitor.$$$reportNull$$$0(5);
        }
        if (holder == null) {
            DefaultHighlightVisitor.$$$reportNull$$$0(6);
        }
        if (action == null) {
            DefaultHighlightVisitor.$$$reportNull$$$0(7);
        }
        this.myHolder = holder;
        this.myAnnotationHolder = new AnnotationHolderImpl(holder.getAnnotationSession(), this.myBatchMode);
        try {
            action.run();
        }
        finally {
            this.myAnnotationHolder.clear();
            this.myAnnotationHolder = null;
            this.myHolder = null;
        }
        return true;
    }

    @Override
    public void visit(@NotNull PsiElement element) {
        if (element == null) {
            DefaultHighlightVisitor.$$$reportNull$$$0(8);
        }
        if (element instanceof PsiErrorElement) {
            if (this.myHighlightErrorElements) {
                this.visitErrorElement((PsiErrorElement)element);
            }
        } else if (this.myRunAnnotators) {
            this.runAnnotators(element);
        }
        if (this.myAnnotationHolder.hasAnnotations()) {
            for (Annotation annotation : this.myAnnotationHolder) {
                this.myHolder.add(HighlightInfo.fromAnnotation(annotation, null, this.myBatchMode));
            }
            this.myAnnotationHolder.clear();
        }
    }

    @Override
    @NotNull
    public HighlightVisitor clone() {
        DefaultHighlightVisitor defaultHighlightVisitor = new DefaultHighlightVisitor(this.myProject, this.myHighlightErrorElements, this.myRunAnnotators, this.myBatchMode, this.myCachedAnnotators);
        if (defaultHighlightVisitor == null) {
            DefaultHighlightVisitor.$$$reportNull$$$0(9);
        }
        return defaultHighlightVisitor;
    }

    @Override
    public int order() {
        return 2;
    }

    private void runAnnotators(PsiElement element) {
        List<Annotator> annotators = this.myCachedAnnotators.get(element.getLanguage().getID());
        if (annotators.isEmpty()) {
            return;
        }
        boolean dumb = this.myDumbService.isDumb();
        for (int i2 = 0; i2 < annotators.size(); ++i2) {
            Annotator annotator = annotators.get(i2);
            if (dumb && !DumbService.isDumbAware(annotator)) continue;
            ProgressManager.checkCanceled();
            annotator.annotate(element, this.myAnnotationHolder);
        }
    }

    private void visitErrorElement(PsiErrorElement element) {
        for (HighlightErrorFilter errorFilter : this.myErrorFilters) {
            if (errorFilter.shouldHighlightErrorElement(element)) continue;
            return;
        }
        HighlightInfo info = DefaultHighlightVisitor.createErrorElementInfo(element);
        this.myHolder.add(info);
    }

    private static HighlightInfo createErrorElementInfo(@NotNull PsiErrorElement element) {
        HighlightInfo info;
        String text2;
        if (element == null) {
            DefaultHighlightVisitor.$$$reportNull$$$0(10);
        }
        TextRange range = element.getTextRange();
        String errorDescription = element.getErrorDescription();
        if (!range.isEmpty()) {
            HighlightInfo info2;
            HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(range);
            if (errorDescription != null) {
                builder.descriptionAndTooltip(errorDescription);
            }
            if ((info2 = builder.create()) != null) {
                for (ErrorQuickFixProvider provider : Extensions.getExtensions(ErrorQuickFixProvider.EP_NAME)) {
                    provider.registerErrorQuickFix(element, info2);
                }
            }
            return info2;
        }
        int offset = range.getStartOffset();
        PsiFile containingFile = element.getContainingFile();
        int fileLength = containingFile.getTextLength();
        FileViewProvider viewProvider = containingFile.getViewProvider();
        PsiElement elementAtOffset = viewProvider.findElementAt(offset, LanguageUtil.getRootLanguage(element));
        String string = text2 = elementAtOffset == null ? null : elementAtOffset.getText();
        if (offset < fileLength && text2 != null && !StringUtil.startsWithChar(text2, '\n') && !StringUtil.startsWithChar(text2, '\r')) {
            HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(offset, offset + 1);
            if (errorDescription != null) {
                builder.descriptionAndTooltip(errorDescription);
            }
            info = builder.create();
        } else {
            int end;
            int start;
            if (offset > 0) {
                start = offset;
                end = offset;
            } else {
                start = offset;
                end = offset < fileLength ? offset + 1 : offset;
            }
            HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(element, start, end);
            if (errorDescription != null) {
                builder.descriptionAndTooltip(errorDescription);
            }
            builder.endOfLine();
            info = builder.create();
        }
        return info;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cachedAnnotators";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/DefaultHighlightVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/DefaultHighlightVisitor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "clone";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "suitableForFile";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "analyze";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "visit";
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createErrorElementInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

