/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LambdaHighlightingUtil {
    private static final Logger LOG = Logger.getInstance(LambdaHighlightingUtil.class);

    @Nullable
    public static String checkInterfaceFunctional(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            LambdaHighlightingUtil.$$$reportNull$$$0(0);
        }
        return LambdaHighlightingUtil.checkInterfaceFunctional(psiClass, "Target type of a lambda conversion must be an interface");
    }

    @Nullable
    static String checkInterfaceFunctional(@NotNull PsiClass psiClass, String interfaceNonFunctionalMessage) {
        if (psiClass == null) {
            LambdaHighlightingUtil.$$$reportNull$$$0(1);
        }
        if (psiClass instanceof PsiTypeParameter) {
            return null;
        }
        List<HierarchicalMethodSignature> signatures = LambdaUtil.findFunctionCandidates(psiClass);
        if (signatures == null) {
            return interfaceNonFunctionalMessage;
        }
        if (signatures.isEmpty()) {
            return "No target method found";
        }
        if (signatures.size() == 1) {
            return null;
        }
        return "Multiple non-overriding abstract methods found in interface " + HighlightUtil.formatClass(psiClass);
    }

    @Nullable
    static HighlightInfo checkParametersCompatible(PsiLambdaExpression expression, PsiParameter[] methodParameters, PsiSubstitutor substitutor) {
        PsiParameter[] lambdaParameters = expression.getParameterList().getParameters();
        String incompatibleTypesMessage = "Incompatible parameter types in lambda expression: ";
        if (lambdaParameters.length != methodParameters.length) {
            incompatibleTypesMessage = incompatibleTypesMessage + "wrong number of parameters: expected " + methodParameters.length + " but found " + lambdaParameters.length;
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression.getParameterList()).descriptionAndTooltip(incompatibleTypesMessage).create();
        }
        boolean hasFormalParameterTypes = expression.hasFormalParameterTypes();
        for (int i2 = 0; i2 < lambdaParameters.length; ++i2) {
            PsiParameter lambdaParameter = lambdaParameters[i2];
            PsiType lambdaParameterType = lambdaParameter.getType();
            PsiType substitutedParamType = substitutor.substitute(methodParameters[i2].getType());
            if ((!hasFormalParameterTypes || PsiTypesUtil.compareTypes(lambdaParameterType, substitutedParamType, true)) && TypeConversionUtil.isAssignable(substitutedParamType, lambdaParameterType)) continue;
            String expectedType = substitutedParamType != null ? substitutedParamType.getPresentableText() : null;
            String actualType = lambdaParameterType.getPresentableText();
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression.getParameterList()).descriptionAndTooltip(incompatibleTypesMessage + "expected " + expectedType + " but found " + actualType).create();
        }
        return null;
    }

    public static boolean insertSemicolonAfter(PsiLambdaExpression lambdaExpression) {
        return lambdaExpression.getBody() instanceof PsiCodeBlock || !LambdaHighlightingUtil.insertSemicolon(lambdaExpression.getParent());
    }

    public static boolean insertSemicolon(PsiElement parent) {
        return parent instanceof PsiExpressionList || parent instanceof PsiExpression;
    }

    @Nullable
    public static String checkInterfaceFunctional(PsiType functionalInterfaceType) {
        if (functionalInterfaceType instanceof PsiIntersectionType) {
            HashSet<MethodSignature> signatures = new HashSet<MethodSignature>();
            for (PsiType type : ((PsiIntersectionType)functionalInterfaceType).getConjuncts()) {
                if (LambdaHighlightingUtil.checkInterfaceFunctional(type) != null) continue;
                MethodSignature signature = LambdaUtil.getFunction(PsiUtil.resolveClassInType(type));
                LOG.assertTrue(signature != null, type.getCanonicalText());
                signatures.add(signature);
            }
            if (signatures.size() > 1) {
                return "Multiple non-overriding abstract methods found in " + functionalInterfaceType.getPresentableText();
            }
            return null;
        }
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(functionalInterfaceType);
        PsiClass aClass = resolveResult.getElement();
        if (aClass != null) {
            if (aClass instanceof PsiTypeParameter) {
                return null;
            }
            MethodSignature functionalMethod = LambdaUtil.getFunction(aClass);
            if (functionalMethod != null && functionalMethod.getTypeParameters().length > 0) {
                return "Target method is generic";
            }
            return LambdaHighlightingUtil.checkInterfaceFunctional(aClass);
        }
        return functionalInterfaceType.getPresentableText() + " is not a functional interface";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/codeInsight/daemon/impl/analysis/LambdaHighlightingUtil", "checkInterfaceFunctional"));
    }
}

