/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InvalidComparatorMethodReferenceInspection
extends BaseJavaBatchLocalInspectionTool {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            InvalidComparatorMethodReferenceInspection.$$$reportNull$$$0(0);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            @Override
            public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression) {
                PsiElement referenceNameElement = expression.getReferenceNameElement();
                if (referenceNameElement == null) {
                    return;
                }
                String name = referenceNameElement.getText();
                if (!name.equals("min") && !name.equals("max")) {
                    return;
                }
                String className = InvalidComparatorMethodReferenceInspection.getMethodReferenceClassName(expression);
                if (!"java.lang.Integer".equals(className) && !"java.lang.Math".equals(className)) {
                    return;
                }
                String functionalInterface = InvalidComparatorMethodReferenceInspection.getFunctionalInterfaceClassName(expression);
                if (!"java.util.Comparator".equals(functionalInterface)) {
                    return;
                }
                holder.registerProblem((PsiElement)expression, "Method reference mapped to Comparator interface does not fulfill the Comparator contract", new ReplaceWithComparatorQuickFix(name.equals("min")));
            }
        };
        if (javaElementVisitor == null) {
            InvalidComparatorMethodReferenceInspection.$$$reportNull$$$0(1);
        }
        return javaElementVisitor;
    }

    @Nullable
    static String getFunctionalInterfaceClassName(PsiMethodReferenceExpression expression) {
        PsiType functionalInterfaceType = expression.getFunctionalInterfaceType();
        if (!(functionalInterfaceType instanceof PsiClassType)) {
            return null;
        }
        PsiClass targetType = ((PsiClassType)functionalInterfaceType).resolve();
        if (targetType == null) {
            return null;
        }
        return targetType.getQualifiedName();
    }

    @Nullable
    static String getMethodReferenceClassName(PsiMethodReferenceExpression expression) {
        PsiExpression qualifierExpression = expression.getQualifierExpression();
        if (!(qualifierExpression instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiElement refType = ((PsiReference)((Object)qualifierExpression)).resolve();
        if (!(refType instanceof PsiClass)) {
            return null;
        }
        return ((PsiClass)refType).getQualifiedName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/InvalidComparatorMethodReferenceInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/InvalidComparatorMethodReferenceInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ReplaceWithComparatorQuickFix
    implements LocalQuickFix {
        private final boolean reverse;

        public ReplaceWithComparatorQuickFix(boolean reverse) {
            this.reverse = reverse;
        }

        @Override
        @Nls
        @NotNull
        public String getName() {
            String string = "Replace with " + (this.reverse ? "Comparator.reverseOrder()" : "Comparator.naturalOrder()");
            if (string == null) {
                ReplaceWithComparatorQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Replace with comparator" == null) {
                ReplaceWithComparatorQuickFix.$$$reportNull$$$0(1);
            }
            return "Replace with comparator";
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            PsiElement parent;
            if (project == null) {
                ReplaceWithComparatorQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                ReplaceWithComparatorQuickFix.$$$reportNull$$$0(3);
            }
            if ((parent = (element = descriptor.getPsiElement()).getParent()) != null) {
                PsiExpression newMethodExpression = JavaPsiFacade.getElementFactory(project).createExpressionFromText("java.util.Comparator." + (this.reverse ? "reverseOrder()" : "naturalOrder()"), parent);
                element.replace(newMethodExpression);
                JavaCodeStyleManager.getInstance(project).shortenClassReferences(parent);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/InvalidComparatorMethodReferenceInspection$ReplaceWithComparatorQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/InvalidComparatorMethodReferenceInspection$ReplaceWithComparatorQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

