/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.Value;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class Direction {
    public static final Direction Out = Direction.explicitDirection("Out");
    public static final Direction NullableOut = Direction.explicitDirection("NullableOut");
    public static final Direction Pure = Direction.explicitDirection("Pure");
    public static final Direction Throw = Direction.explicitDirection("Throw");
    private static final List<Direction> ourConcreteDirections = Arrays.asList(Out, NullableOut, Pure, Throw);
    private static final int CONCRETE_DIRECTIONS_OFFSET = ourConcreteDirections.size();
    private static final int IN_OUT_OFFSET = 2;
    private static final int IN_THROW_OFFSET = 2 + Value.values().length;
    private static final int DIRECTIONS_PER_PARAM_ID = IN_THROW_OFFSET + Value.values().length;

    @NotNull
    static Direction fromInt(int directionKey) {
        if (directionKey < CONCRETE_DIRECTIONS_OFFSET) {
            Direction direction = ourConcreteDirections.get(directionKey);
            if (direction == null) {
                Direction.$$$reportNull$$$0(0);
            }
            return direction;
        }
        int paramKey = directionKey - CONCRETE_DIRECTIONS_OFFSET;
        int paramId = paramKey / DIRECTIONS_PER_PARAM_ID;
        int subDirectionId = paramKey % DIRECTIONS_PER_PARAM_ID;
        if (subDirectionId < 2) {
            In in = new In(paramId, subDirectionId == 1);
            if (in == null) {
                Direction.$$$reportNull$$$0(1);
            }
            return in;
        }
        if (subDirectionId < IN_THROW_OFFSET) {
            int valueId = subDirectionId - 2;
            InOut inOut = new InOut(paramId, Value.values()[valueId]);
            if (inOut == null) {
                Direction.$$$reportNull$$$0(2);
            }
            return inOut;
        }
        int valueId = subDirectionId - IN_THROW_OFFSET;
        InThrow inThrow = new InThrow(paramId, Value.values()[valueId]);
        if (inThrow == null) {
            Direction.$$$reportNull$$$0(3);
        }
        return inThrow;
    }

    abstract int asInt();

    public int hashCode() {
        return this.asInt();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        return this.asInt() == ((Direction)obj).asInt();
    }

    @NotNull
    private static Direction explicitDirection(final String name) {
        Direction direction = new Direction(){

            @Override
            int asInt() {
                for (int i2 = 0; i2 < ourConcreteDirections.size(); ++i2) {
                    if (ourConcreteDirections.get(i2) != this) continue;
                    return i2;
                }
                throw new InternalError("Explicit direction absent in ourConcreteDirections: " + name);
            }

            public String toString() {
                return name;
            }
        };
        if (direction == null) {
            Direction.$$$reportNull$$$0(4);
        }
        return direction;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/codeInspection/bytecodeAnalysis/Direction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "fromInt";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "explicitDirection";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    static final class InThrow
    extends ParamValueBasedDirection {
        InThrow(int paramIndex, Value inValue) {
            super(paramIndex, inValue);
        }

        @Override
        InThrow withIndex(int paramIndex) {
            return new InThrow(paramIndex, this.inValue);
        }

        @Override
        int asInt() {
            return super.asInt() + IN_THROW_OFFSET + this.inValue.ordinal();
        }

        public String toString() {
            return "InThrow " + this.paramIndex + " " + this.inValue.toString();
        }
    }

    static final class InOut
    extends ParamValueBasedDirection {
        InOut(int paramIndex, Value inValue) {
            super(paramIndex, inValue);
        }

        @Override
        InOut withIndex(int paramIndex) {
            return new InOut(paramIndex, this.inValue);
        }

        @Override
        int asInt() {
            return super.asInt() + 2 + this.inValue.ordinal();
        }

        public String toString() {
            return "InOut " + this.paramIndex + " " + this.inValue.toString();
        }
    }

    static abstract class ParamValueBasedDirection
    extends ParamIdBasedDirection {
        final Value inValue;

        ParamValueBasedDirection(int paramIndex, Value inValue) {
            super(paramIndex);
            this.inValue = inValue;
        }

        abstract ParamValueBasedDirection withIndex(int var1);
    }

    static final class In
    extends ParamIdBasedDirection {
        final boolean nullable;

        In(int paramIndex, boolean nullable) {
            super(paramIndex);
            this.nullable = nullable;
        }

        @Override
        int asInt() {
            return super.asInt() + (this.nullable ? 1 : 0);
        }

        public String toString() {
            return "In " + this.paramIndex + "(" + (this.nullable ? "nullable" : "not null") + ")";
        }
    }

    static abstract class ParamIdBasedDirection
    extends Direction {
        final int paramIndex;

        protected ParamIdBasedDirection(int index) {
            this.paramIndex = index;
        }

        public int paramId() {
            return this.paramIndex;
        }

        @Override
        int asInt() {
            return CONCRETE_DIRECTIONS_OFFSET + DIRECTIONS_PER_PARAM_ID * this.paramId();
        }
    }
}

