/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DfaControlTransferValue;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.DfaVariableState;
import com.intellij.codeInspection.dataFlow.EqClass;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.NullnessUtil;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.value.DfaBoxedValue;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaOptionalValue;
import com.intellij.codeInspection.dataFlow.value.DfaRelationValue;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnboxedValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UnorderedPair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import com.siyeh.ig.psiutils.MethodUtils;
import gnu.trove.THashSet;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import gnu.trove.TLongArrayList;
import gnu.trove.TLongHashSet;
import gnu.trove.TLongIterator;
import java.lang.constant.Constable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaMemoryStateImpl
implements DfaMemoryState {
    private final DfaValueFactory myFactory;
    private final List<EqClass> myEqClasses;
    private final TIntObjectHashMap<int[]> myIdToEqClassesIndices;
    private final Stack<DfaValue> myStack;
    private final TLongHashSet myDistinctClasses;
    private final LinkedHashMap<DfaVariableValue, DfaVariableState> myVariableStates;
    private final Map<DfaVariableValue, DfaVariableState> myDefaultVariableStates;
    private final LinkedHashSet<DfaVariableValue> myUnknownVariables;
    private boolean myEphemeral;
    private LinkedHashSet<UnorderedPair<EqClass>> myCachedDistinctClassPairs;
    private LinkedHashSet<EqClass> myCachedNonTrivialEqClasses;
    private Integer myCachedHash;

    protected DfaMemoryStateImpl(DfaValueFactory factory) {
        this.myFactory = factory;
        this.myDefaultVariableStates = ContainerUtil.newTroveMap();
        this.myEqClasses = ContainerUtil.newArrayList();
        this.myUnknownVariables = ContainerUtil.newLinkedHashSet();
        this.myVariableStates = ContainerUtil.newLinkedHashMap();
        this.myDistinctClasses = new TLongHashSet();
        this.myStack = new Stack();
        this.myIdToEqClassesIndices = new MyIdMap(20);
    }

    protected DfaMemoryStateImpl(DfaMemoryStateImpl toCopy) {
        this.myFactory = toCopy.myFactory;
        this.myEphemeral = toCopy.myEphemeral;
        this.myDefaultVariableStates = toCopy.myDefaultVariableStates;
        this.myStack = new Stack<DfaValue>((Collection<DfaValue>)toCopy.myStack);
        this.myDistinctClasses = new TLongHashSet(toCopy.myDistinctClasses.size());
        toCopy.myDistinctClasses.forEach(arg_0 -> ((TLongHashSet)this.myDistinctClasses).add(arg_0));
        this.myUnknownVariables = ContainerUtil.newLinkedHashSet(toCopy.myUnknownVariables);
        this.myEqClasses = ContainerUtil.newArrayList(toCopy.myEqClasses);
        this.myIdToEqClassesIndices = new MyIdMap(toCopy.myIdToEqClassesIndices.size());
        toCopy.myIdToEqClassesIndices.forEachEntry((id, set) -> {
            this.myIdToEqClassesIndices.put(id, set);
            return true;
        });
        this.myVariableStates = ContainerUtil.newLinkedHashMap(toCopy.myVariableStates);
        this.myCachedDistinctClassPairs = toCopy.myCachedDistinctClassPairs;
        this.myCachedNonTrivialEqClasses = toCopy.myCachedNonTrivialEqClasses;
        this.myCachedHash = toCopy.myCachedHash;
    }

    @NotNull
    public DfaValueFactory getFactory() {
        DfaValueFactory dfaValueFactory = this.myFactory;
        if (dfaValueFactory == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(0);
        }
        return dfaValueFactory;
    }

    @Override
    @NotNull
    public DfaMemoryStateImpl createCopy() {
        DfaMemoryStateImpl dfaMemoryStateImpl = new DfaMemoryStateImpl(this);
        if (dfaMemoryStateImpl == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(1);
        }
        return dfaMemoryStateImpl;
    }

    @Override
    @NotNull
    public DfaMemoryStateImpl createClosureState() {
        DfaMemoryStateImpl copy = this.createCopy();
        copy.flushFields();
        HashSet<DfaVariableValue> vars = new HashSet<DfaVariableValue>(copy.getVariableStates().keySet());
        for (DfaVariableValue value : vars) {
            copy.flushDependencies(value);
        }
        copy.emptyStack();
        DfaMemoryStateImpl dfaMemoryStateImpl = copy;
        if (dfaMemoryStateImpl == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(2);
        }
        return dfaMemoryStateImpl;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DfaMemoryStateImpl)) {
            return false;
        }
        DfaMemoryStateImpl that = (DfaMemoryStateImpl)obj;
        if (this.myCachedHash != null && that.myCachedHash != null && !this.myCachedHash.equals(that.myCachedHash)) {
            return false;
        }
        return this.equalsSuperficially(that) && this.equalsByUnknownVariables(that) && this.equalsByRelations(that) && this.equalsByVariableStates(that);
    }

    private boolean equalsByUnknownVariables(DfaMemoryStateImpl that) {
        return this.myUnknownVariables.equals(that.myUnknownVariables);
    }

    Object getSuperficialKey() {
        return Pair.create(this.myEphemeral, this.myStack);
    }

    private boolean equalsSuperficially(DfaMemoryStateImpl other) {
        return this.myEphemeral == other.myEphemeral && this.myStack.equals(other.myStack);
    }

    boolean equalsByRelations(DfaMemoryStateImpl that) {
        return this.getNonTrivialEqClasses().equals(that.getNonTrivialEqClasses()) && this.getDistinctClassPairs().equals(that.getDistinctClassPairs());
    }

    boolean equalsByVariableStates(DfaMemoryStateImpl that) {
        return this.myVariableStates.equals(that.myVariableStates);
    }

    LinkedHashSet<UnorderedPair<EqClass>> getDistinctClassPairs() {
        if (this.myCachedDistinctClassPairs != null) {
            return this.myCachedDistinctClassPairs;
        }
        LinkedHashSet<UnorderedPair<EqClass>> result = ContainerUtil.newLinkedHashSet();
        for (long encodedPair : this.myDistinctClasses.toArray()) {
            result.add(new UnorderedPair<EqClass>(this.myEqClasses.get(DfaMemoryStateImpl.low(encodedPair)), this.myEqClasses.get(DfaMemoryStateImpl.high(encodedPair))));
        }
        this.myCachedDistinctClassPairs = result;
        return this.myCachedDistinctClassPairs;
    }

    LinkedHashSet<EqClass> getNonTrivialEqClasses() {
        if (this.myCachedNonTrivialEqClasses != null) {
            return this.myCachedNonTrivialEqClasses;
        }
        LinkedHashSet<EqClass> result = ContainerUtil.newLinkedHashSet();
        for (EqClass eqClass : this.myEqClasses) {
            if (eqClass == null || eqClass.size() <= 1) continue;
            result.add(eqClass);
        }
        this.myCachedNonTrivialEqClasses = result;
        return this.myCachedNonTrivialEqClasses;
    }

    public int hashCode() {
        if (this.myCachedHash != null) {
            return this.myCachedHash;
        }
        int hash = this.getPartialHashCode(true, true);
        this.myCachedHash = hash;
        return hash;
    }

    int getPartialHashCode(boolean unknowns, boolean varStates) {
        int hash = (this.getNonTrivialEqClasses().hashCode() * 31 + this.getDistinctClassPairs().hashCode()) * 31 + this.myStack.hashCode();
        if (varStates) {
            hash = hash * 31 + this.myVariableStates.hashCode();
        }
        if (unknowns && !this.myUnknownVariables.isEmpty()) {
            hash = hash * 31 + this.myUnknownVariables.hashCode();
        }
        return hash;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append('<');
        if (this.myEphemeral) {
            result.append("ephemeral, ");
        }
        for (EqClass set : this.getNonTrivialEqClasses()) {
            result.append(set);
        }
        if (!this.myDistinctClasses.isEmpty()) {
            result.append("\n  distincts: ");
            String distincts = ((StreamEx)StreamEx.of(this.getDistinctClassPairs()).map(pair -> "{" + pair.first + ", " + pair.second + "}").sorted()).joining((CharSequence)" ");
            result.append(distincts);
        }
        if (!this.myStack.isEmpty()) {
            result.append("\n  stack: ").append(StringUtil.join(this.myStack, ","));
        }
        if (!this.myVariableStates.isEmpty()) {
            result.append("\n  vars: ");
            this.myVariableStates.forEach((key, value) -> result.append("[").append(key).append("->").append(value).append("] "));
        }
        if (!this.myUnknownVariables.isEmpty()) {
            result.append("\n  unknowns: ").append(new HashSet<DfaVariableValue>(this.myUnknownVariables));
        }
        result.append('>');
        return result.toString();
    }

    @Override
    public DfaValue pop() {
        this.myCachedHash = null;
        return this.myStack.pop();
    }

    @Override
    public DfaValue peek() {
        return this.myStack.peek();
    }

    @Override
    public void push(@NotNull DfaValue value) {
        if (value == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(3);
        }
        this.myCachedHash = null;
        this.myStack.push(value);
    }

    @Override
    public void emptyStack() {
        this.myCachedHash = null;
        while (!this.myStack.isEmpty() && !(this.myStack.peek() instanceof DfaControlTransferValue)) {
            this.myStack.pop();
        }
    }

    @Override
    public void setVarValue(DfaVariableValue var, DfaValue value) {
        if (var == value) {
            return;
        }
        value = this.handleFlush(var, value);
        this.flushVariable(var);
        if (value instanceof DfaUnknownValue) {
            this.setVariableState(var, this.getVariableState(var).withNotNull());
            return;
        }
        this.setVariableState(var, this.withValueNullability(value, this.getVariableState(var).withValue(value)));
        if (value instanceof DfaTypeValue) {
            DfaRelationValue dfaInstanceof = this.myFactory.getRelationFactory().createRelation(var, DfaRelationValue.RelationType.IS, value);
            if (((DfaTypeValue)value).isNotNull()) {
                this.applyCondition(dfaInstanceof);
            } else {
                this.applyInstanceofOrNull(dfaInstanceof);
            }
        } else {
            DfaRelationValue dfaEqual = this.myFactory.getRelationFactory().createRelation(var, DfaRelationValue.RelationType.EQ, value);
            if (dfaEqual == null) {
                return;
            }
            this.applyCondition(dfaEqual);
            if (value instanceof DfaVariableValue) {
                this.setVariableState(var, this.getVariableState((DfaVariableValue)value));
            }
        }
        if (this.getVariableState(var).isNotNull()) {
            DfaConstValue dfaNull = this.myFactory.getConstFactory().getNull();
            this.applyCondition(this.myFactory.getRelationFactory().createRelation(var, DfaRelationValue.RelationType.NE, dfaNull));
        }
    }

    private DfaVariableState withValueNullability(DfaValue value, DfaVariableState state) {
        if (value instanceof DfaTypeValue) {
            return state.withFact(DfaFactType.CAN_BE_NULL, NullnessUtil.toBoolean(((DfaTypeValue)value).getNullness()));
        }
        if (this.isNull(value)) {
            return state.withFact(DfaFactType.CAN_BE_NULL, true);
        }
        return state;
    }

    private DfaValue handleFlush(DfaVariableValue flushed, DfaValue value) {
        if (value instanceof DfaVariableValue && (value == flushed || this.myFactory.getVarFactory().getAllQualifiedBy(flushed).contains(value))) {
            Nullness nullability = this.isNotNull(value) ? Nullness.NOT_NULL : ((DfaVariableValue)value).getInherentNullability();
            return this.myFactory.createTypeValue(((DfaVariableValue)value).getVariableType(), nullability);
        }
        return value;
    }

    @Nullable(value="for boxed values which can't be compared by ==")
    private Integer getOrCreateEqClassIndex(@NotNull DfaValue dfaValue) {
        int i2;
        if (dfaValue == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(4);
        }
        if ((i2 = this.getEqClassIndex(dfaValue)) != -1) {
            return i2;
        }
        if (!DfaMemoryStateImpl.canBeInRelation(dfaValue) || !this.canBeReused(dfaValue) && !(((DfaBoxedValue)dfaValue).getWrappedValue() instanceof DfaConstValue)) {
            return null;
        }
        int freeIndex = this.myEqClasses.indexOf(null);
        int resultIndex = freeIndex >= 0 ? freeIndex : this.myEqClasses.size();
        EqClass aClass = new EqClass(this.myFactory);
        aClass.add(dfaValue.getID());
        if (freeIndex >= 0) {
            this.myEqClasses.set(freeIndex, aClass);
        } else {
            this.myEqClasses.add(aClass);
        }
        this.addToMap(dfaValue.getID(), resultIndex);
        return this.tryMergeClassByQualifier(resultIndex);
    }

    private int tryMergeClassByQualifier(int classIndex) {
        List<DfaValue> values = this.myEqClasses.get(classIndex).getMemberValues();
        if (values.size() != 1) {
            return classIndex;
        }
        DfaValue dfaValue = values.get(0);
        if (!(dfaValue instanceof DfaVariableValue)) {
            return classIndex;
        }
        DfaVariableValue variableValue = (DfaVariableValue)dfaValue;
        DfaVariableValue qualifier = variableValue.getQualifier();
        PsiModifierListOwner variable = variableValue.getPsiVariable();
        if (qualifier == null) {
            return classIndex;
        }
        Integer index = this.getOrCreateEqClassIndex(qualifier);
        if (index == null) {
            return classIndex;
        }
        for (DfaValue eqQualifier : this.myEqClasses.get(index).getMemberValues()) {
            DfaVariableValue eqValue;
            int i2;
            if (eqQualifier == qualifier || !(eqQualifier instanceof DfaVariableValue) || (i2 = this.getEqClassIndex(eqValue = this.getFactory().getVarFactory().createVariableValue(variable, variableValue.getVariableType(), variableValue.isNegated(), (DfaVariableValue)eqQualifier))) == -1) continue;
            this.uniteClasses(i2, classIndex);
            return i2;
        }
        return classIndex;
    }

    private void addToMap(int id, int index) {
        int[] classes = (int[])this.myIdToEqClassesIndices.get(id = DfaMemoryStateImpl.unwrap(this.myFactory.getValue(id)).getID());
        if (classes == null) {
            classes = new int[]{index};
            this.myIdToEqClassesIndices.put(id, (Object)classes);
        } else {
            classes = ArrayUtil.append(classes, index);
            this.myIdToEqClassesIndices.put(id, (Object)classes);
        }
    }

    private void removeFromMap(int id, int index) {
        int i2;
        int[] classes = (int[])this.myIdToEqClassesIndices.get(id = DfaMemoryStateImpl.unwrap(this.myFactory.getValue(id)).getID());
        if (classes != null && (i2 = ArrayUtil.indexOf(classes, index)) != -1) {
            classes = ArrayUtil.remove(classes, i2);
            this.myIdToEqClassesIndices.put(id, (Object)classes);
        }
    }

    private void removeAllFromMap(int id) {
        if (id < 0) {
            return;
        }
        id = DfaMemoryStateImpl.unwrap(this.myFactory.getValue(id)).getID();
        this.myIdToEqClassesIndices.remove(id);
    }

    public boolean isSuperStateOf(DfaMemoryStateImpl that) {
        if (!(this.equalsSuperficially(that) && this.equalsByUnknownVariables(that) && this.getNonTrivialEqClasses().equals(that.getNonTrivialEqClasses()) && that.getDistinctClassPairs().containsAll(this.getDistinctClassPairs()))) {
            return false;
        }
        if (this.myVariableStates.size() != that.myVariableStates.size()) {
            return false;
        }
        for (Map.Entry<DfaVariableValue, DfaVariableState> entry : this.myVariableStates.entrySet()) {
            DfaVariableState thatState;
            DfaVariableState thisState = entry.getValue();
            if (Objects.equals(thisState, thatState = that.myVariableStates.get(entry.getKey())) || thatState != null && thisState != null && thisState.isSuperStateOf(thatState)) continue;
            return false;
        }
        return true;
    }

    private static boolean canBeInRelation(@NotNull DfaValue dfaValue) {
        DfaValue unwrapped;
        if (dfaValue == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(5);
        }
        return (unwrapped = DfaMemoryStateImpl.unwrap(dfaValue)) instanceof DfaVariableValue || unwrapped instanceof DfaConstValue;
    }

    @NotNull
    List<DfaValue> getEquivalentValues(@NotNull DfaValue dfaValue) {
        int index;
        EqClass set;
        if (dfaValue == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(6);
        }
        EqClass eqClass = set = (index = this.getEqClassIndex(dfaValue)) == -1 ? null : this.myEqClasses.get(index);
        if (set == null) {
            List<DfaValue> list = Collections.emptyList();
            if (list == null) {
                DfaMemoryStateImpl.$$$reportNull$$$0(7);
            }
            return list;
        }
        List<DfaValue> list = set.getMemberValues();
        if (list == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(8);
        }
        return list;
    }

    private boolean canBeNaN(@NotNull DfaValue dfaValue) {
        if (dfaValue == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(9);
        }
        for (DfaValue eq : this.getEquivalentValues(dfaValue)) {
            if (eq instanceof DfaBoxedValue) {
                eq = ((DfaBoxedValue)eq).getWrappedValue();
            }
            if (!(eq instanceof DfaConstValue) || DfaMemoryStateImpl.isNaN(eq)) continue;
            return false;
        }
        return dfaValue instanceof DfaVariableValue && TypeConversionUtil.isFloatOrDoubleType(((DfaVariableValue)dfaValue).getVariableType());
    }

    private boolean isEffectivelyNaN(@NotNull DfaValue dfaValue) {
        if (dfaValue == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(10);
        }
        for (DfaValue eqClass : this.getEquivalentValues(dfaValue)) {
            if (!DfaMemoryStateImpl.isNaN(eqClass)) continue;
            return true;
        }
        return false;
    }

    private int getEqClassIndex(@NotNull DfaValue dfaValue) {
        if (dfaValue == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(11);
        }
        int id = DfaMemoryStateImpl.unwrap(dfaValue).getID();
        int[] classes = (int[])this.myIdToEqClassesIndices.get(id);
        int result = -1;
        if (classes != null) {
            for (int index : classes) {
                EqClass aClass = this.myEqClasses.get(index);
                if (!aClass.contains(dfaValue.getID())) continue;
                if (!this.canBeReused(dfaValue) && aClass.size() > 1) break;
                result = index;
                break;
            }
        }
        return result;
    }

    private boolean canBeReused(@NotNull DfaValue dfaValue) {
        if (dfaValue == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(12);
        }
        if (dfaValue instanceof DfaBoxedValue) {
            DfaValue valueToWrap = ((DfaBoxedValue)dfaValue).getWrappedValue();
            if (valueToWrap instanceof DfaConstValue) {
                return DfaMemoryStateImpl.cacheable((DfaConstValue)valueToWrap);
            }
            if (valueToWrap instanceof DfaVariableValue) {
                if (PsiType.BOOLEAN.equals(((DfaVariableValue)valueToWrap).getVariableType())) {
                    return true;
                }
                for (DfaValue value : this.getEquivalentValues(valueToWrap)) {
                    if (!(value instanceof DfaConstValue) || !DfaMemoryStateImpl.cacheable((DfaConstValue)value)) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private static boolean cacheable(@NotNull DfaConstValue dfaConstValue) {
        Object value;
        if (dfaConstValue == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(13);
        }
        return DfaMemoryStateImpl.box(value = dfaConstValue.getValue()) == DfaMemoryStateImpl.box(value);
    }

    private static Object box(Object value) {
        Constable newBoxedValue;
        if (value instanceof Integer) {
            newBoxedValue = (int)((Integer)value);
        } else if (value instanceof Byte) {
            newBoxedValue = (byte)((Byte)value);
        } else if (value instanceof Short) {
            newBoxedValue = (short)((Short)value);
        } else if (value instanceof Long) {
            newBoxedValue = (long)((Long)value);
        } else if (value instanceof Boolean) {
            newBoxedValue = (Boolean)value;
        } else if (value instanceof Character) {
            newBoxedValue = Character.valueOf(((Character)value).charValue());
        } else {
            return new Object();
        }
        return newBoxedValue;
    }

    private boolean uniteClasses(int c1Index, int c2Index) {
        int i2;
        long[] distincts;
        EqClass c1 = this.myEqClasses.get(c1Index);
        EqClass c2 = this.myEqClasses.get(c2Index);
        THashSet vars = ContainerUtil.newTroveSet();
        THashSet negatedVars = ContainerUtil.newTroveSet();
        int[] cs = new int[c1.size() + c2.size()];
        c1.set(0, cs, 0, c1.size());
        c2.set(0, cs, c1.size(), c2.size());
        int nConst = 0;
        for (int c : cs) {
            DfaValue dfaValue = DfaMemoryStateImpl.unwrap(this.myFactory.getValue(c));
            if (dfaValue instanceof DfaConstValue) {
                ++nConst;
            }
            if (dfaValue instanceof DfaVariableValue) {
                DfaVariableValue variableValue = (DfaVariableValue)dfaValue;
                if (variableValue.isNegated()) {
                    negatedVars.add((DfaVariableValue)variableValue.createNegated());
                } else {
                    vars.add((DfaVariableValue)variableValue);
                }
            }
            if (nConst <= 1) continue;
            return false;
        }
        if (ContainerUtil.intersects(vars, negatedVars)) {
            return false;
        }
        TLongArrayList c2Pairs = new TLongArrayList();
        for (long distinct : distincts = this.myDistinctClasses.toArray()) {
            int pc1 = DfaMemoryStateImpl.low(distinct);
            int pc2 = DfaMemoryStateImpl.high(distinct);
            boolean addedToC1 = false;
            if (pc1 == c1Index || pc2 == c1Index) {
                addedToC1 = true;
            }
            if (pc1 != c2Index && pc2 != c2Index) continue;
            if (addedToC1) {
                return false;
            }
            c2Pairs.add(distinct);
        }
        EqClass newClass = new EqClass(c1);
        this.myEqClasses.set(c1Index, newClass);
        for (i2 = 0; i2 < c2.size(); ++i2) {
            int c = c2.get(i2);
            newClass.add(c);
            this.removeFromMap(c, c2Index);
            this.addToMap(c, c1Index);
        }
        for (i2 = 0; i2 < c2Pairs.size(); ++i2) {
            long c = c2Pairs.get(i2);
            this.myDistinctClasses.remove(c);
            this.myDistinctClasses.add(DfaMemoryStateImpl.createPair(c1Index, DfaMemoryStateImpl.low(c) == c2Index ? DfaMemoryStateImpl.high(c) : DfaMemoryStateImpl.low(c)));
        }
        this.myEqClasses.set(c2Index, null);
        return true;
    }

    private static int low(long l) {
        return (int)l;
    }

    private static int high(long l) {
        return (int)((l & 0xFFFFFFFF00000000L) >> 32);
    }

    private static long createPair(int i1, int i2) {
        if (i1 < i2) {
            long l = i1;
            l <<= 32;
            return l += (long)i2;
        }
        long l = i2;
        l <<= 32;
        return l += (long)i1;
    }

    private void makeClassesDistinct(int c1Index, int c2Index) {
        this.myDistinctClasses.add(DfaMemoryStateImpl.createPair(c1Index, c2Index));
    }

    @Override
    public boolean isNull(DfaValue dfaValue) {
        if (dfaValue instanceof DfaConstValue) {
            return ((DfaConstValue)dfaValue).getValue() == null;
        }
        if (dfaValue instanceof DfaVariableValue) {
            int c1Index = this.getEqClassIndex(dfaValue);
            return c1Index >= 0 && c1Index == this.getEqClassIndex(this.myFactory.getConstFactory().getNull());
        }
        return false;
    }

    @Override
    public boolean isNotNull(DfaValue dfaVar) {
        long[] pairs;
        if (dfaVar instanceof DfaConstValue) {
            return ((DfaConstValue)dfaVar).getValue() != null;
        }
        if (dfaVar instanceof DfaBoxedValue) {
            return true;
        }
        if (dfaVar instanceof DfaTypeValue) {
            return ((DfaTypeValue)dfaVar).isNotNull();
        }
        if (dfaVar instanceof DfaVariableValue) {
            if (this.getVariableState((DfaVariableValue)dfaVar).isNotNull()) {
                return true;
            }
            DfaConstValue constantValue = this.getConstantValue((DfaVariableValue)dfaVar);
            if (constantValue != null && constantValue.getValue() != null) {
                return true;
            }
        }
        DfaConstValue dfaNull = this.myFactory.getConstFactory().getNull();
        Integer c1Index = this.getOrCreateEqClassIndex(dfaVar);
        int c2Index = this.getEqClassIndex(dfaNull);
        if (c1Index == null || c2Index < 0) {
            return false;
        }
        for (long pair : pairs = this.myDistinctClasses.toArray()) {
            if ((c1Index != DfaMemoryStateImpl.low(pair) || c2Index != DfaMemoryStateImpl.high(pair)) && (c1Index != DfaMemoryStateImpl.high(pair) || c2Index != DfaMemoryStateImpl.low(pair))) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public DfaConstValue getConstantValue(@NotNull DfaVariableValue value) {
        int index;
        if (value == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(14);
        }
        EqClass ec = (index = this.getEqClassIndex(value)) == -1 ? null : this.myEqClasses.get(index);
        return ec == null ? null : (DfaConstValue)DfaMemoryStateImpl.unwrap(ec.findConstant(true));
    }

    @Override
    public void markEphemeral() {
        this.myEphemeral = true;
    }

    @Override
    public boolean isEphemeral() {
        return this.myEphemeral;
    }

    @Override
    public boolean applyInstanceofOrNull(@NotNull DfaRelationValue dfaCond) {
        DfaValue left;
        if (dfaCond == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(15);
        }
        if (!((left = DfaMemoryStateImpl.unwrap(dfaCond.getLeftOperand())) instanceof DfaVariableValue)) {
            return true;
        }
        DfaVariableValue dfaVar = (DfaVariableValue)left;
        DfaTypeValue dfaType = (DfaTypeValue)dfaCond.getRightOperand();
        if (this.isUnknownState(dfaVar) || this.isNull(dfaVar)) {
            return true;
        }
        DfaVariableState newState = this.getVariableState(dfaVar).withInstanceofValue(dfaType);
        if (newState != null) {
            this.setVariableState(dfaVar, newState);
            return true;
        }
        return false;
    }

    <T> void setFact(DfaValue target, DfaFactType<T> factType, T fact) {
        if (target instanceof DfaVariableValue && !this.isUnknownState(target)) {
            this.setVariableState((DfaVariableValue)target, this.getVariableState((DfaVariableValue)target).withFact(factType, fact));
        }
    }

    <T> boolean applyFact(DfaVariableValue target, DfaFactType<T> factType, T range) {
        if (!this.isUnknownState(target) && range != null) {
            DfaVariableState state = this.getVariableState(target);
            DfaVariableState newState = state.intersectFact(factType, range);
            if (newState == null) {
                return false;
            }
            this.setVariableState(target, newState);
        }
        return true;
    }

    static DfaValue unwrap(DfaValue value) {
        if (value instanceof DfaBoxedValue) {
            return ((DfaBoxedValue)value).getWrappedValue();
        }
        if (value instanceof DfaUnboxedValue) {
            return ((DfaUnboxedValue)value).getVariable();
        }
        return value;
    }

    @Override
    public boolean applyContractCondition(DfaValue condition) {
        DfaRelationValue relation;
        if (condition instanceof DfaRelationValue && (relation = (DfaRelationValue)condition).isEquality() && relation.getRightOperand() == this.myFactory.getConstFactory().getNull() && (relation.getLeftOperand() instanceof DfaUnknownValue || relation.getLeftOperand() instanceof DfaVariableValue && this.getVariableState((DfaVariableValue)relation.getLeftOperand()).getNullability() == Nullness.UNKNOWN)) {
            this.markEphemeral();
        }
        return this.applyCondition(condition);
    }

    @Override
    public boolean applyCondition(DfaValue dfaCond) {
        if (dfaCond instanceof DfaUnknownValue) {
            return true;
        }
        if (dfaCond instanceof DfaUnboxedValue) {
            DfaVariableValue dfaVar = ((DfaUnboxedValue)dfaCond).getVariable();
            boolean isNegated = dfaVar.isNegated();
            DfaVariableValue dfaNormalVar = isNegated ? dfaVar.createNegated() : dfaVar;
            DfaValue boxedTrue = this.myFactory.getBoxedFactory().createBoxed(this.myFactory.getConstFactory().getTrue());
            return this.applyRelationCondition(this.myFactory.getRelationFactory().createRelation(dfaNormalVar, DfaRelationValue.RelationType.equivalence(!isNegated), boxedTrue));
        }
        if (dfaCond instanceof DfaVariableValue) {
            DfaVariableValue dfaVar = (DfaVariableValue)dfaCond;
            boolean isNegated = dfaVar.isNegated();
            DfaVariableValue dfaNormalVar = isNegated ? dfaVar.createNegated() : dfaVar;
            DfaConstValue dfaTrue = this.myFactory.getConstFactory().getTrue();
            return this.applyRelationCondition(this.myFactory.getRelationFactory().createRelation(dfaNormalVar, DfaRelationValue.RelationType.equivalence(!isNegated), dfaTrue));
        }
        if (dfaCond instanceof DfaConstValue) {
            return dfaCond == this.myFactory.getConstFactory().getTrue() || dfaCond != this.myFactory.getConstFactory().getFalse();
        }
        if (!(dfaCond instanceof DfaRelationValue)) {
            return true;
        }
        return this.applyRelationCondition((DfaRelationValue)dfaCond);
    }

    private boolean applyRelationCondition(@NotNull DfaRelationValue dfaRelation) {
        if (dfaRelation == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(16);
        }
        DfaValue dfaLeft = dfaRelation.getLeftOperand();
        DfaValue dfaRight = dfaRelation.getRightOperand();
        if (dfaLeft instanceof DfaUnknownValue || dfaRight instanceof DfaUnknownValue) {
            return true;
        }
        DfaRelationValue.RelationType relationType = dfaRelation.getRelation();
        LongRangeSet left = this.getValueFact(DfaFactType.RANGE, dfaLeft);
        LongRangeSet right = this.getValueFact(DfaFactType.RANGE, dfaRight);
        if (left != null && right != null) {
            if (dfaLeft instanceof DfaVariableValue && !this.applyFact((DfaVariableValue)dfaLeft, DfaFactType.RANGE, right.fromRelation(relationType))) {
                return false;
            }
            if (dfaRight instanceof DfaVariableValue && !this.applyFact((DfaVariableValue)dfaRight, DfaFactType.RANGE, left.fromRelation(relationType.getFlipped()))) {
                return false;
            }
        }
        if (dfaLeft instanceof DfaVariableValue && dfaRight instanceof DfaOptionalValue && (relationType == DfaRelationValue.RelationType.IS || relationType == DfaRelationValue.RelationType.IS_NOT)) {
            boolean present = ((DfaOptionalValue)dfaRight).isPresent() == (relationType == DfaRelationValue.RelationType.IS);
            return this.applyFact((DfaVariableValue)dfaLeft, DfaFactType.OPTIONAL_PRESENCE, present);
        }
        if (dfaRight instanceof DfaTypeValue) {
            if (dfaLeft instanceof DfaVariableValue) {
                DfaVariableValue dfaVar = (DfaVariableValue)dfaLeft;
                if (this.isUnknownState(dfaVar)) {
                    return true;
                }
                DfaTypeValue typeValue = (DfaTypeValue)dfaRight;
                switch (relationType) {
                    case EQ: 
                    case NE: {
                        return !dfaRelation.isEquality() || !typeValue.isNotNull() || !this.isNull(dfaVar);
                    }
                    case IS_NOT: {
                        DfaVariableState newState = this.getVariableState(dfaVar).withNotInstanceofValue(typeValue);
                        if (newState != null) {
                            this.setVariableState(dfaVar, newState);
                            return true;
                        }
                        return !this.getVariableState(dfaVar).isNotNull() && this.applyRelation(dfaVar, this.myFactory.getConstFactory().getNull(), false);
                    }
                    case IS: {
                        DfaVariableState newState;
                        if (this.applyRelation(dfaVar, this.myFactory.getConstFactory().getNull(), true) && (newState = this.getVariableState(dfaVar).withInstanceofValue(typeValue)) != null) {
                            this.setVariableState(dfaVar, newState);
                            return true;
                        }
                        return false;
                    }
                }
            }
            return true;
        }
        if (this.isEffectivelyNaN(dfaLeft) || this.isEffectivelyNaN(dfaRight)) {
            this.applyEquivalenceRelation(dfaRelation, dfaLeft, dfaRight);
            return relationType == DfaRelationValue.RelationType.NE;
        }
        if (this.canBeNaN(dfaLeft) && this.canBeNaN(dfaRight)) {
            if (dfaLeft == dfaRight && dfaLeft instanceof DfaVariableValue && !(((DfaVariableValue)dfaLeft).getVariableType() instanceof PsiPrimitiveType)) {
                return !dfaRelation.isNonEquality();
            }
            this.applyEquivalenceRelation(dfaRelation, dfaLeft, dfaRight);
            return true;
        }
        return this.applyEquivalenceRelation(dfaRelation, dfaLeft, dfaRight);
    }

    private void updateVarStateOnComparison(@NotNull DfaVariableValue dfaVar, DfaValue value) {
        if (dfaVar == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(17);
        }
        if (!this.isUnknownState(dfaVar)) {
            if (value instanceof DfaConstValue) {
                DfaVariableState state;
                DfaValue typeValue;
                Object constValue = ((DfaConstValue)value).getValue();
                if (constValue == null) {
                    this.setVariableState(dfaVar, this.getVariableState(dfaVar).withFact(DfaFactType.CAN_BE_NULL, true));
                    return;
                }
                if (constValue instanceof PsiVariable && (typeValue = this.myFactory.createTypeValue(((PsiVariable)constValue).getType(), Nullness.NOT_NULL)) instanceof DfaTypeValue && (state = this.getVariableState(dfaVar).withInstanceofValue((DfaTypeValue)typeValue)) != null) {
                    this.setVariableState(dfaVar, state);
                }
            }
            if (this.isNotNull(value) && !this.isNotNull(dfaVar)) {
                this.setVariableState(dfaVar, this.getVariableState(dfaVar).withoutFact(DfaFactType.CAN_BE_NULL));
                this.applyRelation(dfaVar, this.myFactory.getConstFactory().getNull(), true);
            }
        }
    }

    private boolean applyEquivalenceRelation(@NotNull DfaRelationValue dfaRelation, DfaValue dfaLeft, DfaValue dfaRight) {
        boolean containsCalls;
        boolean isNegated;
        if (dfaRelation == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(18);
        }
        if (!(isNegated = dfaRelation.isNonEquality()) && !dfaRelation.isEquality()) {
            return true;
        }
        boolean bl = containsCalls = dfaLeft instanceof DfaVariableValue && ((DfaVariableValue)dfaLeft).containsCalls();
        if (containsCalls && !this.isNotNull(dfaLeft) && this.isNull(dfaRight) && !isNegated) {
            return true;
        }
        if (dfaLeft == dfaRight) {
            return containsCalls || !isNegated;
        }
        if (this.isNull(dfaLeft) && this.isNotNull(dfaRight) || this.isNull(dfaRight) && this.isNotNull(dfaLeft)) {
            return isNegated;
        }
        if (!isNegated) {
            if (dfaLeft instanceof DfaVariableValue) {
                this.updateVarStateOnComparison((DfaVariableValue)dfaLeft, dfaRight);
            }
            if (dfaRight instanceof DfaVariableValue) {
                this.updateVarStateOnComparison((DfaVariableValue)dfaRight, dfaLeft);
            }
        }
        if (!this.applyRelation(dfaLeft, dfaRight, isNegated)) {
            return false;
        }
        if (!this.checkCompareWithBooleanLiteral(dfaLeft, dfaRight, isNegated)) {
            return false;
        }
        if (dfaLeft instanceof DfaVariableValue) {
            if (!this.applyUnboxedRelation((DfaVariableValue)dfaLeft, dfaRight, isNegated)) {
                return false;
            }
            if (!this.applyBoxedRelation((DfaVariableValue)dfaLeft, dfaRight, isNegated)) {
                return false;
            }
        }
        if (!isNegated && dfaRight instanceof DfaOptionalValue) {
            this.setFact(dfaLeft, DfaFactType.OPTIONAL_PRESENCE, ((DfaOptionalValue)dfaRight).isPresent());
        }
        return true;
    }

    private boolean applyBoxedRelation(@NotNull DfaVariableValue dfaLeft, DfaValue dfaRight, boolean negated) {
        if (dfaLeft == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(19);
        }
        if (!TypeConversionUtil.isPrimitiveAndNotNull(dfaLeft.getVariableType())) {
            return true;
        }
        DfaBoxedValue.Factory boxedFactory = this.myFactory.getBoxedFactory();
        DfaValue boxedLeft = boxedFactory.createBoxed(dfaLeft);
        DfaValue boxedRight = boxedFactory.createBoxed(dfaRight);
        return boxedLeft == null || boxedRight == null || this.applyRelation(boxedLeft, boxedRight, negated);
    }

    private boolean applyUnboxedRelation(@NotNull DfaVariableValue dfaLeft, DfaValue dfaRight, boolean negated) {
        DfaValue unboxedRight;
        if (dfaLeft == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(20);
        }
        if (negated) {
            return true;
        }
        PsiType type = dfaLeft.getVariableType();
        if (!TypeConversionUtil.isPrimitiveWrapper(type)) {
            return true;
        }
        DfaBoxedValue.Factory boxedFactory = this.myFactory.getBoxedFactory();
        DfaValue unboxedLeft = boxedFactory.createUnboxed(dfaLeft);
        return this.applyRelation(unboxedLeft, unboxedRight = boxedFactory.createUnboxed(dfaRight), false) && this.checkCompareWithBooleanLiteral(unboxedLeft, unboxedRight, false);
    }

    private boolean checkCompareWithBooleanLiteral(DfaValue dfaLeft, DfaValue dfaRight, boolean negated) {
        Object constVal;
        if (dfaRight instanceof DfaConstValue && (constVal = ((DfaConstValue)dfaRight).getValue()) instanceof Boolean) {
            DfaConstValue negVal = this.myFactory.getConstFactory().createFromValue((Boolean)constVal == false, PsiType.BOOLEAN, null);
            if (!this.applyRelation(dfaLeft, negVal, !negated)) {
                return false;
            }
            if (!this.applyRelation(dfaLeft.createNegated(), negVal, negated)) {
                return false;
            }
        }
        return true;
    }

    static boolean isNaN(DfaValue dfa) {
        return dfa instanceof DfaConstValue && DfaUtil.isNaN(((DfaConstValue)dfa).getValue());
    }

    private boolean applyRelation(@NotNull DfaValue dfaLeft, @NotNull DfaValue dfaRight, boolean isNegated) {
        if (dfaLeft == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(21);
        }
        if (dfaRight == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(22);
        }
        if (this.isUnknownState(dfaLeft) || this.isUnknownState(dfaRight)) {
            return true;
        }
        Integer c1Index = this.getOrCreateEqClassIndex(dfaLeft);
        Integer c2Index = this.getOrCreateEqClassIndex(dfaRight);
        if (c1Index == null || c2Index == null) {
            return true;
        }
        if (!isNegated) {
            if (c1Index.equals(c2Index) || this.areCompatibleConstants(c1Index, c2Index)) {
                return true;
            }
            if (!this.uniteClasses(c1Index, c2Index)) {
                return false;
            }
            for (long encodedPair : this.myDistinctClasses.toArray()) {
                EqClass c1 = this.myEqClasses.get(DfaMemoryStateImpl.low(encodedPair));
                EqClass c2 = this.myEqClasses.get(DfaMemoryStateImpl.high(encodedPair));
                DfaConstValue const1 = (DfaConstValue)c1.findConstant(false);
                DfaConstValue const2 = (DfaConstValue)c2.findConstant(false);
                if (const1 == null || const2 == null || DfaMemoryStateImpl.preserveConstantDistinction(const1.getValue(), const2.getValue())) continue;
                this.myDistinctClasses.remove(encodedPair);
            }
            this.myCachedDistinctClassPairs = null;
            this.myCachedNonTrivialEqClasses = null;
            this.myCachedHash = null;
        } else {
            if (c1Index.equals(c2Index) || this.areCompatibleConstants(c1Index, c2Index)) {
                return false;
            }
            if (this.isNull(dfaLeft) && DfaMemoryStateImpl.isPrimitive(dfaRight) || this.isNull(dfaRight) && DfaMemoryStateImpl.isPrimitive(dfaLeft)) {
                return true;
            }
            this.makeClassesDistinct(c1Index, c2Index);
            this.myCachedDistinctClassPairs = null;
            this.myCachedHash = null;
        }
        return true;
    }

    private static boolean isPrimitive(DfaValue value) {
        return value instanceof DfaVariableValue && ((DfaVariableValue)value).getVariableType() instanceof PsiPrimitiveType;
    }

    private static boolean preserveConstantDistinction(Object c1, Object c2) {
        return c1 == null && c2 instanceof PsiVariable || c2 == null && c1 instanceof PsiVariable;
    }

    private boolean areCompatibleConstants(int i1, int i2) {
        Double dv1 = this.getDoubleValue(i1);
        return dv1 != null && dv1.equals(this.getDoubleValue(i2));
    }

    @Nullable
    private Double getDoubleValue(int eqClassIndex) {
        EqClass ec = this.myEqClasses.get(eqClassIndex);
        DfaValue dfaConst = ec == null ? null : ec.findConstant(false);
        Object constValue = dfaConst instanceof DfaConstValue ? ((DfaConstValue)dfaConst).getValue() : null;
        return constValue instanceof Number ? Double.valueOf(((Number)constValue).doubleValue()) : null;
    }

    private boolean isUnknownState(DfaValue val) {
        if ((val = DfaMemoryStateImpl.unwrap(val)) instanceof DfaVariableValue) {
            if (this.myUnknownVariables.contains(val)) {
                return true;
            }
            DfaVariableValue negatedValue = ((DfaVariableValue)val).getNegatedValue();
            if (negatedValue != null && this.myUnknownVariables.contains(negatedValue)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean checkNotNullable(DfaValue value) {
        if (value == this.myFactory.getConstFactory().getNull()) {
            return false;
        }
        if (value instanceof DfaTypeValue && ((DfaTypeValue)value).isNullable()) {
            return false;
        }
        if (value instanceof DfaVariableValue) {
            DfaVariableValue varValue = (DfaVariableValue)value;
            if (varValue.getVariableType() instanceof PsiPrimitiveType) {
                return true;
            }
            if (this.isNotNull(varValue)) {
                return true;
            }
            if (this.getVariableState(varValue).getNullability() == Nullness.NULLABLE) {
                return false;
            }
        }
        return true;
    }

    @Override
    @Nullable
    public <T> T getValueFact(@NotNull DfaFactType<T> factType, @NotNull DfaValue value) {
        LongRangeSet range;
        if (factType == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(23);
        }
        if (value == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(24);
        }
        if (factType == DfaFactType.RANGE && (range = this.getRange(value)) != null) {
            return (T)range;
        }
        if (value instanceof DfaVariableValue) {
            T fact;
            DfaVariableState state = this.findVariableState((DfaVariableValue)value);
            if (state != null && (fact = state.getFact(factType)) != null) {
                return fact;
            }
            DfaConstValue constValue = this.getConstantValue((DfaVariableValue)value);
            if (constValue != null) {
                value = constValue;
            }
        }
        return factType.fromDfaValue(value);
    }

    @Nullable
    private LongRangeSet getRange(DfaValue value) {
        DfaConstValue constValue;
        DfaVariableValue qualifier;
        DfaVariableValue var;
        if (value instanceof DfaVariableValue && (var = (DfaVariableValue)value).getPsiVariable() instanceof PsiMethod && MethodUtils.isStringLength((PsiMethod)var.getPsiVariable()) && (qualifier = var.getQualifier()) != null && (constValue = this.getConstantValue(qualifier)) != null && constValue.getValue() instanceof String) {
            return LongRangeSet.point(((String)constValue.getValue()).length());
        }
        return null;
    }

    void setVariableState(DfaVariableValue dfaVar, DfaVariableState state) {
        assert (!this.myUnknownVariables.contains(dfaVar));
        if (state.equals(this.myDefaultVariableStates.get(dfaVar))) {
            this.myVariableStates.remove(dfaVar);
        } else {
            this.myVariableStates.put(dfaVar, state);
        }
        this.myCachedHash = null;
    }

    private DfaVariableState findVariableState(DfaVariableValue var) {
        DfaVariableState state = this.myVariableStates.get(var);
        if (state != null) {
            return state;
        }
        DfaVariableValue qualifier = var.getQualifier();
        if (qualifier == null) {
            return null;
        }
        int qualifierIndex = this.getEqClassIndex(qualifier);
        if (qualifierIndex == -1) {
            return null;
        }
        for (DfaValue eqQualifier : this.myEqClasses.get(qualifierIndex).getMemberValues()) {
            DfaVariableValue eqValue;
            if (eqQualifier == qualifier || !(eqQualifier instanceof DfaVariableValue) || (state = this.myVariableStates.get(eqValue = this.getFactory().getVarFactory().createVariableValue(var.getPsiVariable(), var.getVariableType(), var.isNegated(), (DfaVariableValue)eqQualifier))) == null) continue;
            return state;
        }
        return null;
    }

    DfaVariableState getVariableState(DfaVariableValue dfaVar) {
        DfaVariableState state = this.findVariableState(dfaVar);
        if (state == null) {
            state = this.myDefaultVariableStates.get(dfaVar);
            if (state == null) {
                state = this.createVariableState(dfaVar);
                DfaTypeValue initialType = dfaVar.getTypeValue();
                if (initialType != null) {
                    state = state.withInstanceofValue(initialType);
                    assert (state != null);
                }
                this.myDefaultVariableStates.put(dfaVar, state);
            }
            if (this.isUnknownState(dfaVar)) {
                return state.withNotNull();
            }
        }
        return state;
    }

    @NotNull
    Map<DfaVariableValue, DfaVariableState> getVariableStates() {
        LinkedHashMap<DfaVariableValue, DfaVariableState> linkedHashMap = this.myVariableStates;
        if (linkedHashMap == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(25);
        }
        return linkedHashMap;
    }

    @NotNull
    protected DfaVariableState createVariableState(@NotNull DfaVariableValue var) {
        if (var == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(26);
        }
        DfaVariableState dfaVariableState = new DfaVariableState(var);
        if (dfaVariableState == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(27);
        }
        return dfaVariableState;
    }

    @Override
    public void flushFields() {
        LinkedHashSet<DfaVariableValue> vars = ContainerUtil.newLinkedHashSet(this.getChangedVariables());
        for (EqClass aClass : this.myEqClasses) {
            if (aClass == null) continue;
            vars.addAll(aClass.getVariables(true));
        }
        for (DfaVariableValue value : vars) {
            if (!value.isFlushableByCalls()) continue;
            this.doFlush(value, this.shouldMarkUnknown(value));
        }
    }

    private boolean shouldMarkUnknown(@NotNull DfaVariableValue value) {
        int eqClassIndex;
        if (value == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(28);
        }
        if ((eqClassIndex = this.getEqClassIndex(value)) < 0) {
            return false;
        }
        EqClass eqClass = this.myEqClasses.get(eqClassIndex);
        if (eqClass == null) {
            return false;
        }
        if (eqClass.findConstant(true) != null) {
            return true;
        }
        for (UnorderedPair unorderedPair : this.getDistinctClassPairs()) {
            if ((unorderedPair.first != eqClass || ((EqClass)unorderedPair.second).findConstant(true) == null) && (unorderedPair.second != eqClass || ((EqClass)unorderedPair.first).findConstant(true) == null)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    Set<DfaVariableValue> getChangedVariables() {
        Set<DfaVariableValue> set = this.myVariableStates.keySet();
        if (set == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(29);
        }
        return set;
    }

    @Override
    public void flushVariable(@NotNull DfaVariableValue variable) {
        if (variable == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(30);
        }
        List<DfaValue> updatedStack = ContainerUtil.map(this.myStack, value -> {
            if (variable == null) {
                DfaMemoryStateImpl.$$$reportNull$$$0(34);
            }
            return this.handleFlush(variable, (DfaValue)value);
        });
        this.myStack.clear();
        for (DfaValue value2 : updatedStack) {
            this.myStack.push(value2);
        }
        this.doFlush(variable, false);
        this.flushDependencies(variable);
        this.myUnknownVariables.remove(variable);
        this.myUnknownVariables.removeAll(this.myFactory.getVarFactory().getAllQualifiedBy(variable));
        this.myCachedHash = null;
    }

    void flushDependencies(@NotNull DfaVariableValue variable) {
        if (variable == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(31);
        }
        for (DfaVariableValue dependent : this.myFactory.getVarFactory().getAllQualifiedBy(variable)) {
            this.doFlush(dependent, false);
        }
    }

    @NotNull
    Set<DfaVariableValue> getUnknownVariables() {
        LinkedHashSet<DfaVariableValue> linkedHashSet = this.myUnknownVariables;
        if (linkedHashSet == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(32);
        }
        return linkedHashSet;
    }

    void doFlush(@NotNull DfaVariableValue varPlain, boolean markUnknown) {
        if (varPlain == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(33);
        }
        DfaVariableValue varNegated = varPlain.getNegatedValue();
        int idPlain = varPlain.getID();
        int idNegated = varNegated == null ? -1 : varNegated.getID();
        int[] classes = (int[])this.myIdToEqClassesIndices.get(idPlain);
        int[] negatedClasses = (int[])this.myIdToEqClassesIndices.get(idNegated);
        int[] result = ArrayUtil.mergeArrays(ObjectUtils.notNull(classes, ArrayUtil.EMPTY_INT_ARRAY), ObjectUtils.notNull(negatedClasses, ArrayUtil.EMPTY_INT_ARRAY));
        int interruptCount = 0;
        for (int varClassIndex : result) {
            TLongIterator iterator;
            EqClass varClass = this.myEqClasses.get(varClassIndex);
            if ((++interruptCount & 0xF) == 0) {
                ProgressManager.checkCanceled();
            }
            varClass = new EqClass(varClass);
            this.myEqClasses.set(varClassIndex, varClass);
            for (int id : varClass.toNativeArray()) {
                int idUnwrapped;
                if (id != idPlain && id != idNegated && (idUnwrapped = DfaMemoryStateImpl.unwrap(this.myFactory.getValue(id)).getID()) != idPlain && idUnwrapped != idNegated) continue;
                varClass.removeValue(id);
            }
            if (varClass.isEmpty()) {
                this.myEqClasses.set(varClassIndex, null);
                iterator = this.myDistinctClasses.iterator();
                while (iterator.hasNext()) {
                    long pair = iterator.next();
                    if (DfaMemoryStateImpl.low(pair) != varClassIndex && DfaMemoryStateImpl.high(pair) != varClassIndex) continue;
                    iterator.remove();
                }
                continue;
            }
            if (!varClass.containsConstantsOnly()) continue;
            iterator = this.myDistinctClasses.iterator();
            while (iterator.hasNext()) {
                long pair = iterator.next();
                if ((DfaMemoryStateImpl.low(pair) != varClassIndex || !this.myEqClasses.get(DfaMemoryStateImpl.high(pair)).containsConstantsOnly()) && (DfaMemoryStateImpl.high(pair) != varClassIndex || !this.myEqClasses.get(DfaMemoryStateImpl.low(pair)).containsConstantsOnly())) continue;
                iterator.remove();
            }
        }
        this.removeAllFromMap(idPlain);
        this.removeAllFromMap(idNegated);
        this.myVariableStates.remove(varPlain);
        if (varNegated != null) {
            this.myVariableStates.remove(varNegated);
        }
        if (markUnknown) {
            this.myUnknownVariables.add(varPlain);
        }
        this.myCachedNonTrivialEqClasses = null;
        this.myCachedDistinctClassPairs = null;
        this.myCachedHash = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl";
                break;
            }
            case 3: 
            case 14: 
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfaValue";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfaConstValue";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfaCond";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfaRelation";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfaVar";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfaLeft";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfaRight";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factType";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 30: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varPlain";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createCopy";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createClosureState";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getEquivalentValues";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableStates";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createVariableState";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangedVariables";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnknownVariables";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "push";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateEqClassIndex";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "canBeInRelation";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getEquivalentValues";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "canBeNaN";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isEffectivelyNaN";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getEqClassIndex";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "canBeReused";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "cacheable";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getConstantValue";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "applyInstanceofOrNull";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "applyRelationCondition";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "updateVarStateOnComparison";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "applyEquivalenceRelation";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "applyBoxedRelation";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "applyUnboxedRelation";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "applyRelation";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getValueFact";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createVariableState";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "shouldMarkUnknown";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "flushVariable";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "flushDependencies";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "doFlush";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "lambda$flushVariable$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyIdMap
    extends TIntObjectHashMap<int[]> {
        private MyIdMap(int initialCapacity) {
            super(initialCapacity);
        }

        public String toString() {
            final StringBuilder s = new StringBuilder("{");
            this.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<int[]>(){

                public boolean execute(int id, int[] set) {
                    DfaValue value = DfaMemoryStateImpl.this.myFactory.getValue(id);
                    s.append(value).append(" -> ").append(Arrays.toString(set)).append(", ");
                    return true;
                }
            });
            s.append("}");
            return s.toString();
        }
    }
}

