/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.projectRoots.ex.ProjectRoot;
import com.intellij.openapi.projectRoots.impl.SimpleProjectRoot;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class CompositeProjectRoot
implements ProjectRoot {
    @NonNls
    private static final String SIMPLE_ROOT = "simple";
    @NonNls
    private static final String COMPOSITE_ROOT = "composite";
    @NonNls
    private static final String ATTRIBUTE_TYPE = "type";
    @NonNls
    private static final String ELEMENT_ROOT = "root";
    private final List<ProjectRoot> myRoots = new ArrayList<ProjectRoot>();

    CompositeProjectRoot() {
    }

    @NotNull
    ProjectRoot[] getProjectRoots() {
        ProjectRoot[] projectRootArray = this.myRoots.toArray(new ProjectRoot[this.myRoots.size()]);
        if (projectRootArray == null) {
            CompositeProjectRoot.$$$reportNull$$$0(0);
        }
        return projectRootArray;
    }

    @Override
    @NotNull
    public String getPresentableString() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public VirtualFile[] getVirtualFiles() {
        ArrayList result = new ArrayList();
        for (ProjectRoot root : this.myRoots) {
            ContainerUtil.addAll(result, root.getVirtualFiles());
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(result);
        if (virtualFileArray == null) {
            CompositeProjectRoot.$$$reportNull$$$0(1);
        }
        return virtualFileArray;
    }

    @Override
    @NotNull
    public String[] getUrls() {
        ArrayList<String> result = new ArrayList<String>();
        for (ProjectRoot root : this.myRoots) {
            ContainerUtil.addAll(result, root.getUrls());
        }
        String[] stringArray = ArrayUtil.toStringArray(result);
        if (stringArray == null) {
            CompositeProjectRoot.$$$reportNull$$$0(2);
        }
        return stringArray;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    void remove(@NotNull ProjectRoot root) {
        if (root == null) {
            CompositeProjectRoot.$$$reportNull$$$0(3);
        }
        this.myRoots.remove(root);
    }

    @NotNull
    ProjectRoot add(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            CompositeProjectRoot.$$$reportNull$$$0(4);
        }
        SimpleProjectRoot root = new SimpleProjectRoot(virtualFile);
        this.myRoots.add(root);
        SimpleProjectRoot simpleProjectRoot = root;
        if (simpleProjectRoot == null) {
            CompositeProjectRoot.$$$reportNull$$$0(5);
        }
        return simpleProjectRoot;
    }

    void add(@NotNull ProjectRoot root) {
        if (root == null) {
            CompositeProjectRoot.$$$reportNull$$$0(6);
        }
        this.myRoots.add(root);
    }

    void remove(@NotNull VirtualFile root) {
        if (root == null) {
            CompositeProjectRoot.$$$reportNull$$$0(7);
        }
        Iterator<ProjectRoot> iterator = this.myRoots.iterator();
        while (iterator.hasNext()) {
            SimpleProjectRoot r;
            ProjectRoot projectRoot = iterator.next();
            if (!(projectRoot instanceof SimpleProjectRoot) || !root.equals((r = (SimpleProjectRoot)projectRoot).getFile())) continue;
            iterator.remove();
        }
    }

    void clear() {
        this.myRoots.clear();
    }

    public void readExternal(Element element) {
        for (Element child : element.getChildren()) {
            this.myRoots.add(CompositeProjectRoot.read(child));
        }
    }

    public void writeExternal(Element element) {
        for (ProjectRoot root : this.myRoots) {
            Element e = CompositeProjectRoot.write(root);
            element.addContent(e);
        }
    }

    @Override
    public void update() {
        for (ProjectRoot root : this.myRoots) {
            root.update();
        }
    }

    @NotNull
    static ProjectRoot read(Element element) {
        String type = element.getAttributeValue(ATTRIBUTE_TYPE);
        if (type.equals(SIMPLE_ROOT)) {
            SimpleProjectRoot simpleProjectRoot = new SimpleProjectRoot(element);
            if (simpleProjectRoot == null) {
                CompositeProjectRoot.$$$reportNull$$$0(8);
            }
            return simpleProjectRoot;
        }
        if (type.equals(COMPOSITE_ROOT)) {
            CompositeProjectRoot root = new CompositeProjectRoot();
            root.readExternal(element);
            CompositeProjectRoot compositeProjectRoot = root;
            if (compositeProjectRoot == null) {
                CompositeProjectRoot.$$$reportNull$$$0(9);
            }
            return compositeProjectRoot;
        }
        throw new IllegalArgumentException("Wrong type: " + type);
    }

    @NotNull
    static Element write(ProjectRoot projectRoot) {
        Element element = new Element(ELEMENT_ROOT);
        if (projectRoot instanceof SimpleProjectRoot) {
            element.setAttribute(ATTRIBUTE_TYPE, SIMPLE_ROOT);
            ((SimpleProjectRoot)projectRoot).writeExternal(element);
        } else if (projectRoot instanceof CompositeProjectRoot) {
            element.setAttribute(ATTRIBUTE_TYPE, COMPOSITE_ROOT);
            ((CompositeProjectRoot)projectRoot).writeExternal(element);
        } else {
            throw new IllegalArgumentException("Wrong root: " + projectRoot);
        }
        Element element2 = element;
        if (element2 == null) {
            CompositeProjectRoot.$$$reportNull$$$0(10);
        }
        return element2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/projectRoots/impl/CompositeProjectRoot";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = ELEMENT_ROOT;
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectRoots";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFiles";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrls";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/projectRoots/impl/CompositeProjectRoot";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "add";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "read";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "write";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

