/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl.libraries;

import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.PersistentOrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryImpl;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JarDirectories
implements JDOMExternalizable {
    private final MultiMap<OrderRootType, String> myDirectories = new MultiMap();
    private final MultiMap<OrderRootType, String> myRecursivelyIncluded = new MultiMap();
    @NonNls
    private static final String JAR_DIRECTORY_ELEMENT = "jarDirectory";
    @NonNls
    private static final String URL_ATTR = "url";
    @NonNls
    private static final String RECURSIVE_ATTR = "recursive";
    @NonNls
    private static final String ROOT_TYPE_ATTR = "type";
    public static final OrderRootType DEFAULT_JAR_DIRECTORY_TYPE = OrderRootType.CLASSES;

    public void copyFrom(@NotNull JarDirectories other) {
        if (other == null) {
            JarDirectories.$$$reportNull$$$0(0);
        }
        this.myDirectories.clear();
        this.myDirectories.putAllValues(other.myDirectories);
        this.myRecursivelyIncluded.clear();
        this.myRecursivelyIncluded.putAllValues(other.myRecursivelyIncluded);
    }

    public boolean contains(@NotNull OrderRootType rootType, @NotNull String url) {
        if (rootType == null) {
            JarDirectories.$$$reportNull$$$0(1);
        }
        if (url == null) {
            JarDirectories.$$$reportNull$$$0(2);
        }
        return this.myDirectories.get(rootType).contains(url);
    }

    public boolean isRecursive(@NotNull OrderRootType rootType, @NotNull String url) {
        if (rootType == null) {
            JarDirectories.$$$reportNull$$$0(3);
        }
        if (url == null) {
            JarDirectories.$$$reportNull$$$0(4);
        }
        return this.myRecursivelyIncluded.get(rootType).contains(url);
    }

    public void add(@NotNull OrderRootType rootType, @NotNull String url, boolean recursively) {
        if (rootType == null) {
            JarDirectories.$$$reportNull$$$0(5);
        }
        if (url == null) {
            JarDirectories.$$$reportNull$$$0(6);
        }
        this.myDirectories.putValue(rootType, url);
        if (recursively) {
            this.myRecursivelyIncluded.putValue(rootType, url);
        }
    }

    public void remove(@NotNull OrderRootType rootType, @NotNull String url) {
        if (rootType == null) {
            JarDirectories.$$$reportNull$$$0(7);
        }
        if (url == null) {
            JarDirectories.$$$reportNull$$$0(8);
        }
        this.myDirectories.remove(rootType, url);
        this.myRecursivelyIncluded.remove(rootType, url);
    }

    public void clear() {
        this.myDirectories.clear();
        this.myRecursivelyIncluded.clear();
    }

    @NotNull
    public Collection<OrderRootType> getRootTypes() {
        Set<OrderRootType> set = this.myDirectories.keySet();
        if (set == null) {
            JarDirectories.$$$reportNull$$$0(9);
        }
        return set;
    }

    @NotNull
    public Collection<String> getDirectories(@NotNull OrderRootType rootType) {
        if (rootType == null) {
            JarDirectories.$$$reportNull$$$0(10);
        }
        Collection<String> collection = this.myDirectories.get(rootType);
        if (collection == null) {
            JarDirectories.$$$reportNull$$$0(11);
        }
        return collection;
    }

    @NotNull
    public Collection<? extends String> getAllDirectories() {
        Collection<String> collection = this.myDirectories.values();
        if (collection == null) {
            JarDirectories.$$$reportNull$$$0(12);
        }
        return collection;
    }

    public boolean isEmpty() {
        return this.myDirectories.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JarDirectories)) {
            return false;
        }
        JarDirectories that = (JarDirectories)o;
        return this.myDirectories.equals(that.myDirectories) && this.myRecursivelyIncluded.equals(that.myRecursivelyIncluded);
    }

    public int hashCode() {
        return 31 * this.myDirectories.hashCode() + this.myRecursivelyIncluded.hashCode();
    }

    public String toString() {
        return "JAR dirs: " + this.myDirectories.values();
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        this.clear();
        List jarDirs = element.getChildren(JAR_DIRECTORY_ELEMENT);
        for (Element jarDir : jarDirs) {
            String url = jarDir.getAttributeValue(URL_ATTR);
            String recursive = jarDir.getAttributeValue(RECURSIVE_ATTR);
            OrderRootType rootType = JarDirectories.getJarDirectoryRootType(jarDir.getAttributeValue(ROOT_TYPE_ATTR));
            if (url == null) continue;
            this.add(rootType, url, Boolean.parseBoolean(recursive));
        }
    }

    private static OrderRootType getJarDirectoryRootType(@Nullable String type) {
        for (PersistentOrderRootType rootType : OrderRootType.getAllPersistentTypes()) {
            if (!rootType.name().equals(type)) continue;
            return rootType;
        }
        return DEFAULT_JAR_DIRECTORY_TYPE;
    }

    @Override
    public void writeExternal(Element element) {
        List<OrderRootType> rootTypes = LibraryImpl.sortRootTypes(this.getRootTypes());
        for (OrderRootType rootType : rootTypes) {
            ArrayList<String> urls = new ArrayList<String>(this.getDirectories(rootType));
            Collections.sort(urls, String.CASE_INSENSITIVE_ORDER);
            for (String url : urls) {
                Element jarDirElement = new Element(JAR_DIRECTORY_ELEMENT);
                jarDirElement.setAttribute(URL_ATTR, url);
                jarDirElement.setAttribute(RECURSIVE_ATTR, Boolean.toString(this.isRecursive(rootType, url)));
                if (!rootType.equals(DEFAULT_JAR_DIRECTORY_TYPE)) {
                    jarDirElement.setAttribute(ROOT_TYPE_ATTR, rootType.name());
                }
                element.addContent(jarDirElement);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootType";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = URL_ATTR;
                break;
            }
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/libraries/JarDirectories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/libraries/JarDirectories";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootTypes";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectories";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDirectories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "copyFrom";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isRecursive";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 9: 
            case 11: 
            case 12: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDirectories";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

