/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pom.core.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.pom.PomModel;
import com.intellij.pom.PomModelAspect;
import com.intellij.pom.PomTransaction;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.pom.event.PomModelListener;
import com.intellij.pom.impl.PomTransactionBase;
import com.intellij.pom.tree.TreeAspect;
import com.intellij.pom.tree.TreeAspectEvent;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.DocumentCommitThread;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.PsiToDocumentSynchronizer;
import com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.text.BlockSupportImpl;
import com.intellij.psi.impl.source.text.DiffLog;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.text.BlockSupport;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IReparseableLeafElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import com.intellij.util.lang.CompoundRuntimeException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PomModelImpl
extends UserDataHolderBase
implements PomModel {
    private static final Logger LOG = Logger.getInstance("#com.intellij.pom.core.impl.PomModelImpl");
    private final Project myProject;
    private final Map<Class<? extends PomModelAspect>, PomModelAspect> myAspects = new HashMap<Class<? extends PomModelAspect>, PomModelAspect>();
    private final Map<PomModelAspect, List<PomModelAspect>> myIncidence = new HashMap<PomModelAspect, List<PomModelAspect>>();
    private final Map<PomModelAspect, List<PomModelAspect>> myInvertedIncidence = new HashMap<PomModelAspect, List<PomModelAspect>>();
    private final Collection<PomModelListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final ThreadLocal<Stack<Pair<PomModelAspect, PomTransaction>>> myBlockedAspects = ThreadLocal.withInitial(Stack::new);
    private static volatile boolean allowPsiModification = true;

    public PomModelImpl(Project project) {
        this.myProject = project;
    }

    @Override
    public <T extends PomModelAspect> T getModelAspect(@NotNull Class<T> aClass) {
        if (aClass == null) {
            PomModelImpl.$$$reportNull$$$0(0);
        }
        return (T)this.myAspects.get(aClass);
    }

    @Override
    public void registerAspect(@NotNull Class<? extends PomModelAspect> aClass, @NotNull PomModelAspect aspect, @NotNull Set<PomModelAspect> dependencies) {
        if (aClass == null) {
            PomModelImpl.$$$reportNull$$$0(1);
        }
        if (aspect == null) {
            PomModelImpl.$$$reportNull$$$0(2);
        }
        if (dependencies == null) {
            PomModelImpl.$$$reportNull$$$0(3);
        }
        this.myAspects.put(aClass, aspect);
        Iterator<PomModelAspect> iterator = dependencies.iterator();
        ArrayList<PomModelAspect> deps = new ArrayList<PomModelAspect>();
        while (iterator.hasNext()) {
            PomModelAspect depend = iterator.next();
            deps.addAll(this.getAllDependencies(depend));
        }
        deps.add(aspect);
        for (PomModelAspect pomModelAspect : deps) {
            List<PomModelAspect> pomModelAspects = this.myInvertedIncidence.get(pomModelAspect);
            if (pomModelAspects != null) {
                pomModelAspects.add(aspect);
                continue;
            }
            this.myInvertedIncidence.put(pomModelAspect, new ArrayList<PomModelAspect>(Collections.singletonList(aspect)));
        }
        this.myIncidence.put(aspect, deps);
    }

    private List<PomModelAspect> getAllDependencies(PomModelAspect aspect) {
        List<PomModelAspect> pomModelAspects = this.myIncidence.get(aspect);
        return pomModelAspects != null ? pomModelAspects : Collections.emptyList();
    }

    private List<PomModelAspect> getAllDependants(PomModelAspect aspect) {
        List<PomModelAspect> pomModelAspects = this.myInvertedIncidence.get(aspect);
        return pomModelAspects != null ? pomModelAspects : Collections.emptyList();
    }

    @Override
    public void addModelListener(@NotNull PomModelListener listener) {
        if (listener == null) {
            PomModelImpl.$$$reportNull$$$0(4);
        }
        this.myListeners.add(listener);
    }

    @Override
    public void addModelListener(final @NotNull PomModelListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            PomModelImpl.$$$reportNull$$$0(5);
        }
        if (parentDisposable == null) {
            PomModelImpl.$$$reportNull$$$0(6);
        }
        this.addModelListener(listener);
        Disposer.register(parentDisposable, new Disposable(){

            @Override
            public void dispose() {
                PomModelImpl.this.removeModelListener(listener);
            }
        });
    }

    @Override
    public void removeModelListener(@NotNull PomModelListener listener) {
        if (listener == null) {
            PomModelImpl.$$$reportNull$$$0(7);
        }
        this.myListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void runTransaction(@NotNull PomTransaction transaction) throws IncorrectOperationException {
        ArrayList<Throwable> throwables;
        block53: {
            Pair<PomModelAspect, PomTransaction> block;
            PomModelEvent event;
            block52: {
                if (transaction == null) {
                    PomModelImpl.$$$reportNull$$$0(8);
                }
                if (!PomModelImpl.isAllowPsiModification()) {
                    throw new IncorrectOperationException("Must not modify PSI inside save listener");
                }
                throwables = new ArrayList<Throwable>(0);
                PomModelAspect aspect = transaction.getTransactionAspect();
                this.startTransaction(transaction);
                try {
                    DebugUtil.startPsiModification(null);
                    Stack<Pair<PomModelAspect, PomTransaction>> blockedAspects = this.myBlockedAspects.get();
                    blockedAspects.push(Pair.create(aspect, transaction));
                    try {
                        transaction.run();
                        event = transaction.getAccumulatedEvent();
                    }
                    catch (ProcessCanceledException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throwables.add(e);
                        try {
                            this.commitTransaction(transaction);
                        }
                        catch (ProcessCanceledException e2) {
                            throw e2;
                        }
                        catch (Throwable t) {
                            throwables.add(t);
                        }
                        finally {
                            DebugUtil.finishPsiModification();
                        }
                        if (throwables.isEmpty()) return;
                        CompoundRuntimeException.throwIfNotEmpty(throwables);
                        return;
                    }
                    finally {
                        blockedAspects.pop();
                    }
                    block = this.getBlockingTransaction(aspect, transaction);
                    if (block != null) break block52;
                    Set<PomModelAspect> changedAspects = event.getChangedAspects();
                    LinkedHashSet<PomModelAspect> dependants = new LinkedHashSet<PomModelAspect>();
                    for (PomModelAspect pomModelAspect : changedAspects) {
                        dependants.addAll(this.getAllDependants(pomModelAspect));
                    }
                    for (PomModelAspect modelAspect : dependants) {
                        if (changedAspects.contains(modelAspect)) continue;
                        modelAspect.update(event);
                    }
                    block45: for (PomModelListener listener : this.myListeners) {
                        Set<PomModelAspect> changedAspects2 = event.getChangedAspects();
                        for (PomModelAspect modelAspect : changedAspects2) {
                            if (!listener.isAspectChangeInteresting(modelAspect)) continue;
                            listener.modelChanged(event);
                            continue block45;
                        }
                    }
                    break block53;
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable t) {
                    throwables.add(t);
                    return;
                }
            }
            PomModelEvent currentEvent = block.getSecond().getAccumulatedEvent();
            currentEvent.merge(event);
            try {
                this.commitTransaction(transaction);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable t) {
                throwables.add(t);
            }
            finally {
                DebugUtil.finishPsiModification();
            }
            if (throwables.isEmpty()) return;
            CompoundRuntimeException.throwIfNotEmpty(throwables);
            return;
        }
        try {
            this.commitTransaction(transaction);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable t) {
            throwables.add(t);
        }
        finally {
            DebugUtil.finishPsiModification();
        }
        if (throwables.isEmpty()) return;
        CompoundRuntimeException.throwIfNotEmpty(throwables);
        return;
        finally {
            try {
                this.commitTransaction(transaction);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable t) {
                throwables.add(t);
            }
            finally {
                DebugUtil.finishPsiModification();
            }
            if (!throwables.isEmpty()) {
                CompoundRuntimeException.throwIfNotEmpty(throwables);
            }
        }
    }

    @Nullable
    private Pair<PomModelAspect, PomTransaction> getBlockingTransaction(PomModelAspect aspect, PomTransaction transaction) {
        List<PomModelAspect> allDependants = this.getAllDependants(aspect);
        for (PomModelAspect pomModelAspect : allDependants) {
            Stack<Pair<PomModelAspect, PomTransaction>> blockedAspects = this.myBlockedAspects.get();
            ListIterator blocksIterator = blockedAspects.listIterator(blockedAspects.size());
            while (blocksIterator.hasPrevious()) {
                Pair pair = (Pair)blocksIterator.previous();
                if (pomModelAspect != pair.getFirst() || !PsiTreeUtil.isAncestor(((PomTransaction)pair.getSecond()).getChangeScope(), transaction.getChangeScope(), false) || PomModelImpl.getContainingFileByTree(((PomTransaction)pair.getSecond()).getChangeScope()) == null) continue;
                return pair;
            }
        }
        return null;
    }

    private void commitTransaction(PomTransaction transaction) {
        ProgressIndicator progressIndicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        PsiDocumentManagerBase manager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance(this.myProject);
        PsiToDocumentSynchronizer synchronizer = manager.getSynchronizer();
        PsiFile containingFileByTree = PomModelImpl.getContainingFileByTree(transaction.getChangeScope());
        Document document = containingFileByTree != null ? manager.getCachedDocument(containingFileByTree) : null;
        boolean docSynced = false;
        if (document != null) {
            int oldLength = containingFileByTree.getTextLength();
            docSynced = synchronizer.commitTransaction(document);
            if (docSynced) {
                BlockSupportImpl.sendAfterChildrenChangedEvent((PsiManagerImpl)PsiManager.getInstance(this.myProject), containingFileByTree, oldLength, true);
            }
        }
        if (containingFileByTree != null) {
            boolean isFromCommit;
            boolean bl = isFromCommit = ApplicationManager.getApplication().isDispatchThread() && ((PsiDocumentManagerBase)PsiDocumentManager.getInstance(this.myProject)).isCommitInProgress();
            if (!isFromCommit && !synchronizer.isIgnorePsiEvents()) {
                this.reparseParallelTrees(containingFileByTree, synchronizer);
                if (docSynced) {
                    containingFileByTree.getViewProvider().contentsSynchronized();
                }
            }
        }
        if (progressIndicator != null) {
            progressIndicator.finishNonCancelableSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reparseParallelTrees(PsiFile changedFile, PsiToDocumentSynchronizer synchronizer) {
        List<PsiFile> allFiles = changedFile.getViewProvider().getAllFiles();
        if (allFiles.size() <= 1) {
            return;
        }
        CharSequence newText = changedFile.getNode().getChars();
        for (PsiFile file : allFiles) {
            Runnable changeAction;
            FileElement fileElement = file == changedFile ? null : ((PsiFileImpl)file).getTreeElement();
            Runnable runnable = changeAction = fileElement == null ? null : this.reparseFile(file, fileElement, newText);
            if (changeAction == null) continue;
            synchronizer.setIgnorePsiEvents(true);
            try {
                CodeStyleManager.getInstance(file.getProject()).performActionWithFormatterDisabled(changeAction);
            }
            finally {
                synchronizer.setIgnorePsiEvents(false);
            }
        }
    }

    @Nullable
    private Runnable reparseFile(final @NotNull PsiFile file, @NotNull FileElement treeElement, @NotNull CharSequence newText) {
        TextRange changedPsiRange;
        if (file == null) {
            PomModelImpl.$$$reportNull$$$0(9);
        }
        if (treeElement == null) {
            PomModelImpl.$$$reportNull$$$0(10);
        }
        if (newText == null) {
            PomModelImpl.$$$reportNull$$$0(11);
        }
        if ((changedPsiRange = DocumentCommitThread.getChangedPsiRange(file, treeElement, newText)) == null) {
            return null;
        }
        Runnable reparseLeaf = PomModelImpl.tryReparseOneLeaf(treeElement, newText, changedPsiRange);
        if (reparseLeaf != null) {
            return reparseLeaf;
        }
        final DiffLog log = BlockSupport.getInstance(this.myProject).reparseRange(file, treeElement, changedPsiRange, newText, new EmptyProgressIndicator(), treeElement.getText());
        return () -> {
            if (file == null) {
                PomModelImpl.$$$reportNull$$$0(18);
            }
            this.runTransaction(new PomTransactionBase(file, this.getModelAspect(TreeAspect.class)){

                @Override
                public PomModelEvent runInner() throws IncorrectOperationException {
                    return new TreeAspectEvent(PomModelImpl.this, log.performActualPsiChange(file));
                }
            });
        };
    }

    @Nullable
    private static Runnable tryReparseOneLeaf(@NotNull FileElement treeElement, @NotNull CharSequence newText, @NotNull TextRange changedPsiRange) {
        LeafElement leaf;
        IElementType leafType;
        if (treeElement == null) {
            PomModelImpl.$$$reportNull$$$0(12);
        }
        if (newText == null) {
            PomModelImpl.$$$reportNull$$$0(13);
        }
        if (changedPsiRange == null) {
            PomModelImpl.$$$reportNull$$$0(14);
        }
        IElementType iElementType = leafType = (leaf = treeElement.findLeafElementAt(changedPsiRange.getStartOffset())) == null ? null : leaf.getElementType();
        if (!(leafType instanceof IReparseableLeafElementType)) {
            return null;
        }
        CharSequence newLeafText = PomModelImpl.getLeafChangedText(leaf, treeElement, newText, changedPsiRange);
        LeafElement copy = newLeafText == null ? null : ((IReparseableLeafElementType)((Object)leafType)).reparseLeaf(leaf, newLeafText);
        return copy == null ? null : () -> leaf.getTreeParent().replaceChild(leaf, copy);
    }

    private static CharSequence getLeafChangedText(LeafElement leaf, FileElement treeElement, CharSequence newFileText, TextRange changedPsiRange) {
        if (leaf.getTextRange().getEndOffset() >= changedPsiRange.getEndOffset()) {
            int leafStart = leaf.getTextRange().getStartOffset();
            int newLeafEnd = newFileText.length() - (treeElement.getTextLength() - leaf.getTextRange().getEndOffset());
            if (newLeafEnd > leafStart) {
                return newFileText.subSequence(leafStart, newLeafEnd);
            }
        }
        return null;
    }

    private void startTransaction(@NotNull PomTransaction transaction) {
        Document document;
        ProgressIndicator progressIndicator;
        if (transaction == null) {
            PomModelImpl.$$$reportNull$$$0(15);
        }
        if ((progressIndicator = ProgressIndicatorProvider.getGlobalProgressIndicator()) != null) {
            progressIndicator.startNonCancelableSection();
        }
        PsiDocumentManagerBase manager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance(this.myProject);
        PsiToDocumentSynchronizer synchronizer = manager.getSynchronizer();
        PsiElement changeScope = transaction.getChangeScope();
        PsiFile containingFileByTree = PomModelImpl.getContainingFileByTree(changeScope);
        if (containingFileByTree != null && !(containingFileByTree instanceof DummyHolder) && !manager.isCommitInProgress()) {
            PsiUtilCore.ensureValid(containingFileByTree);
        }
        boolean physical = changeScope.isPhysical();
        if (synchronizer.toProcessPsiEvent()) {
            if (this.isDocumentUncommitted(containingFileByTree)) {
                throw new IllegalStateException("Attempt to modify PSI for non-committed Document!");
            }
            CommandProcessor commandProcessor = CommandProcessor.getInstance();
            if (physical && !commandProcessor.isUndoTransparentActionInProgress() && commandProcessor.getCurrentCommand() == null) {
                throw new IncorrectOperationException("Must not change PSI outside command or undo-transparent action. See com.intellij.openapi.command.WriteCommandAction or com.intellij.openapi.command.CommandProcessor");
            }
        }
        if (containingFileByTree != null) {
            ((SmartPointerManagerImpl)SmartPointerManager.getInstance(this.myProject)).fastenBelts(containingFileByTree.getViewProvider().getVirtualFile());
            if (containingFileByTree instanceof PsiFileImpl) {
                ((PsiFileImpl)containingFileByTree).beforeAstChange();
            }
        }
        BlockSupportImpl.sendBeforeChildrenChangeEvent((PsiManagerImpl)PsiManager.getInstance(this.myProject), changeScope, true);
        Document document2 = containingFileByTree == null ? null : (document = physical ? manager.getDocument(containingFileByTree) : manager.getCachedDocument(containingFileByTree));
        if (document != null) {
            synchronizer.startTransaction(this.myProject, document, changeScope);
        }
    }

    private boolean isDocumentUncommitted(@Nullable PsiFile file) {
        if (file == null) {
            return false;
        }
        PsiDocumentManager manager = PsiDocumentManager.getInstance(this.myProject);
        Document cachedDocument = manager.getCachedDocument(file);
        return cachedDocument != null && manager.isUncommited(cachedDocument);
    }

    @Nullable
    private static PsiFile getContainingFileByTree(@NotNull PsiElement changeScope) {
        PsiFile psiFile;
        ASTNode node;
        if (changeScope == null) {
            PomModelImpl.$$$reportNull$$$0(16);
        }
        if ((node = changeScope.getNode()) == null) {
            psiFile = changeScope.getContainingFile();
        } else {
            FileElement fileElement = TreeUtil.getFileElement((TreeElement)node);
            if (fileElement == null) {
                return null;
            }
            psiFile = (PsiFile)fileElement.getPsi();
        }
        return psiFile.getNode() != null ? psiFile : null;
    }

    public static <T extends Throwable> void guardPsiModificationsIn(@NotNull ThrowableRunnable<T> runnable) throws T {
        if (runnable == null) {
            PomModelImpl.$$$reportNull$$$0(17);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        boolean old = allowPsiModification;
        try {
            allowPsiModification = false;
            runnable.run();
        }
        finally {
            allowPsiModification = old;
        }
    }

    public static boolean isAllowPsiModification() {
        return allowPsiModification;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aspect";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transaction";
                break;
            }
            case 9: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeElement";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newText";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changedPsiRange";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeScope";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/pom/core/impl/PomModelImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getModelAspect";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "registerAspect";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "addModelListener";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "removeModelListener";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "runTransaction";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "reparseFile";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "tryReparseOneLeaf";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "startTransaction";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "getContainingFileByTree";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "guardPsiModificationsIn";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$reparseFile$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

