/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl.todo;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.impl.CustomSyntaxTableFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.cache.impl.id.PlatformIdTableBuilding;
import com.intellij.psi.impl.cache.impl.todo.TodoIndexEntry;
import com.intellij.psi.impl.cache.impl.todo.TodoIndexers;
import com.intellij.psi.impl.cache.impl.todo.VersionedTodoIndexer;
import com.intellij.psi.search.IndexPatternProvider;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.IntInlineKeyDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.messages.MessageBus;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class TodoIndex
extends FileBasedIndexExtension<TodoIndexEntry, Integer> {
    @NonNls
    public static final ID<TodoIndexEntry, Integer> NAME = ID.create("TodoIndex");
    private final FileTypeRegistry myFileTypeManager;
    private final KeyDescriptor<TodoIndexEntry> myKeyDescriptor = new KeyDescriptor<TodoIndexEntry>(){

        @Override
        public int getHashCode(TodoIndexEntry value) {
            return value.hashCode();
        }

        @Override
        public boolean isEqual(TodoIndexEntry val1, TodoIndexEntry val2) {
            return val1.equals(val2);
        }

        @Override
        public void save(@NotNull DataOutput out, TodoIndexEntry value) throws IOException {
            if (out == null) {
                2.$$$reportNull$$$0(0);
            }
            out.writeUTF(value.pattern);
            out.writeBoolean(value.caseSensitive);
        }

        @Override
        public TodoIndexEntry read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                2.$$$reportNull$$$0(1);
            }
            String pattern = in.readUTF();
            boolean caseSensitive = in.readBoolean();
            return new TodoIndexEntry(pattern, caseSensitive);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/impl/cache/impl/todo/TodoIndex$2";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private final DataExternalizer<Integer> myValueExternalizer = new IntInlineKeyDescriptor(){

        @Override
        protected boolean isCompactFormat() {
            return true;
        }
    };
    private final DataIndexer<TodoIndexEntry, Integer, FileContent> myIndexer = new DataIndexer<TodoIndexEntry, Integer, FileContent>(){

        @Override
        @NotNull
        public Map<TodoIndexEntry, Integer> map(@NotNull FileContent inputData) {
            if (inputData == null) {
                4.$$$reportNull$$$0(0);
            }
            VirtualFile file = inputData.getFile();
            DataIndexer<TodoIndexEntry, Integer, FileContent> indexer = PlatformIdTableBuilding.getTodoIndexer(inputData.getFileType(), file);
            if (indexer != null) {
                Map<TodoIndexEntry, Integer> map = indexer.map(inputData);
                if (map == null) {
                    4.$$$reportNull$$$0(1);
                }
                return map;
            }
            Map<TodoIndexEntry, Integer> map = Collections.emptyMap();
            if (map == null) {
                4.$$$reportNull$$$0(2);
            }
            return map;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inputData";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/cache/impl/todo/TodoIndex$4";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/cache/impl/todo/TodoIndex$4";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "map";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "map";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    protected final FileBasedIndex.InputFilter myInputFilter = file -> {
        if (!file.isInLocalFileSystem()) {
            return false;
        }
        if (!TodoIndex.isInContentOfAnyProject(file)) {
            return false;
        }
        FileType fileType = file.getFileType();
        if (fileType instanceof LanguageFileType) {
            Language lang = ((LanguageFileType)fileType).getLanguage();
            ParserDefinition parserDef = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
            TokenSet commentTokens = parserDef != null ? parserDef.getCommentTokens() : null;
            return commentTokens != null;
        }
        return PlatformIdTableBuilding.isTodoIndexerRegistered(fileType) || fileType instanceof CustomSyntaxTableFileType;
    };

    public TodoIndex(MessageBus messageBus, FileTypeRegistry manager) {
        this.myFileTypeManager = manager;
        messageBus.connect().subscribe(IndexPatternProvider.INDEX_PATTERNS_CHANGED, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                FileBasedIndex.getInstance().requestRebuild(NAME);
            }
        });
    }

    private static boolean isInContentOfAnyProject(@NotNull VirtualFile file) {
        if (file == null) {
            TodoIndex.$$$reportNull$$$0(0);
        }
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            if (!ProjectFileIndex.getInstance(project).isInContent(file)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getVersion() {
        int version = 10;
        FileType[] types = this.myFileTypeManager.getRegisteredFileTypes();
        Arrays.sort(types, (o1, o2) -> Comparing.compare(o1.getName(), o2.getName()));
        for (FileType fileType : types) {
            DataIndexer indexer = (DataIndexer)TodoIndexers.INSTANCE.forFileType(fileType);
            if (indexer == null) continue;
            int versionFromIndexer = indexer instanceof VersionedTodoIndexer ? ((VersionedTodoIndexer)indexer).getVersion() : 255;
            version = version * 31 + (versionFromIndexer ^ indexer.getClass().getName().hashCode());
        }
        return version;
    }

    @Override
    public boolean dependsOnFileContent() {
        return true;
    }

    @Override
    @NotNull
    public ID<TodoIndexEntry, Integer> getName() {
        ID<TodoIndexEntry, Integer> iD = NAME;
        if (iD == null) {
            TodoIndex.$$$reportNull$$$0(1);
        }
        return iD;
    }

    @Override
    @NotNull
    public DataIndexer<TodoIndexEntry, Integer, FileContent> getIndexer() {
        DataIndexer<TodoIndexEntry, Integer, FileContent> dataIndexer = this.myIndexer;
        if (dataIndexer == null) {
            TodoIndex.$$$reportNull$$$0(2);
        }
        return dataIndexer;
    }

    @Override
    @NotNull
    public KeyDescriptor<TodoIndexEntry> getKeyDescriptor() {
        KeyDescriptor<TodoIndexEntry> keyDescriptor = this.myKeyDescriptor;
        if (keyDescriptor == null) {
            TodoIndex.$$$reportNull$$$0(3);
        }
        return keyDescriptor;
    }

    @Override
    @NotNull
    public DataExternalizer<Integer> getValueExternalizer() {
        DataExternalizer<Integer> dataExternalizer = this.myValueExternalizer;
        if (dataExternalizer == null) {
            TodoIndex.$$$reportNull$$$0(4);
        }
        return dataExternalizer;
    }

    @Override
    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = this.myInputFilter;
        if (inputFilter == null) {
            TodoIndex.$$$reportNull$$$0(5);
        }
        return inputFilter;
    }

    @Override
    public boolean hasSnapshotMapping() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/cache/impl/todo/TodoIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/cache/impl/todo/TodoIndex";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isInContentOfAnyProject";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

