/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.impl.FrozenDocument;
import com.intellij.openapi.editor.impl.ManualRangeMarker;
import com.intellij.openapi.editor.impl.event.DocumentEventImpl;
import com.intellij.openapi.editor.impl.event.RetargetRangeMarkers;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.psi.impl.smartPointers.SelfElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerTracker;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MarkerCache {
    static final Comparator<SelfElementInfo> INFO_COMPARATOR = (info1, info2) -> {
        int o1 = info1.getPsiStartOffset();
        int o2 = info2.getPsiStartOffset();
        if (o1 < 0 || o2 < 0) {
            return o1 >= 0 ? -1 : (o2 >= 0 ? 1 : 0);
        }
        if (o1 != o2) {
            return o1 > o2 ? 1 : -1;
        }
        o1 = info1.getPsiEndOffset();
        if (o1 != (o2 = info2.getPsiEndOffset())) {
            return o1 > o2 ? 1 : -1;
        }
        return (info1.isGreedy() ? 1 : 0) - (info2.isGreedy() ? 1 : 0);
    };
    private final SmartPointerTracker myPointers;
    private UpdatedRanges myUpdatedRanges;

    MarkerCache(SmartPointerTracker pointers) {
        this.myPointers = pointers;
    }

    private UpdatedRanges getUpdatedMarkers(@NotNull FrozenDocument frozen, @NotNull List<DocumentEvent> events) {
        UpdatedRanges answer;
        if (frozen == null) {
            MarkerCache.$$$reportNull$$$0(0);
        }
        if (events == null) {
            MarkerCache.$$$reportNull$$$0(1);
        }
        int eventCount = events.size();
        assert (eventCount > 0);
        UpdatedRanges cache = this.myUpdatedRanges;
        if (cache != null && cache.myEventCount == eventCount) {
            return cache;
        }
        if (cache != null && cache.myEventCount < eventCount) {
            answer = MarkerCache.applyEvents(events.subList(cache.myEventCount, eventCount), cache);
        } else {
            List<SelfElementInfo> infos = this.myPointers.getSortedInfos();
            ManualRangeMarker[] markers = MarkerCache.createMarkers(infos);
            answer = MarkerCache.applyEvents(events, new UpdatedRanges(0, frozen, infos, markers));
        }
        this.myUpdatedRanges = answer;
        return answer;
    }

    @NotNull
    private static ManualRangeMarker[] createMarkers(List<SelfElementInfo> infos) {
        ManualRangeMarker[] markers = new ManualRangeMarker[infos.size()];
        int i2 = 0;
        while (i2 < markers.length) {
            SelfElementInfo info = infos.get(i2);
            boolean greedy = info.isGreedy();
            int start = info.getPsiStartOffset();
            int end = info.getPsiEndOffset();
            markers[i2] = new ManualRangeMarker(start, end, greedy, greedy, !greedy, null);
            ++i2;
            while (i2 < markers.length && MarkerCache.rangeEquals(infos.get(i2), start, end, greedy)) {
                markers[i2] = markers[i2 - 1];
                ++i2;
            }
        }
        if (markers == null) {
            MarkerCache.$$$reportNull$$$0(2);
        }
        return markers;
    }

    private static boolean rangeEquals(SelfElementInfo info, int start, int end, boolean greedy) {
        return start == info.getPsiStartOffset() && end == info.getPsiEndOffset() && greedy == info.isGreedy();
    }

    private static UpdatedRanges applyEvents(@NotNull List<DocumentEvent> events, UpdatedRanges struct) {
        if (events == null) {
            MarkerCache.$$$reportNull$$$0(3);
        }
        FrozenDocument frozen = struct.myResultDocument;
        ManualRangeMarker[] resultMarkers = (ManualRangeMarker[])struct.myMarkers.clone();
        for (DocumentEvent event : events) {
            DocumentEventImpl corrected;
            FrozenDocument before = frozen;
            if (event instanceof RetargetRangeMarkers) {
                RetargetRangeMarkers retarget = (RetargetRangeMarkers)event;
                corrected = new RetargetRangeMarkers(frozen, retarget.getStartOffset(), retarget.getEndOffset(), retarget.getMoveDestinationOffset());
            } else {
                frozen = frozen.applyEvent(event, 0);
                corrected = new DocumentEventImpl(frozen, event.getOffset(), event.getOldFragment(), event.getNewFragment(), event.getOldTimeStamp(), event.isWholeTextReplaced(), ((DocumentEventImpl)event).getInitialStartOffset(), ((DocumentEventImpl)event).getInitialOldLength());
            }
            int i2 = 0;
            while (i2 < resultMarkers.length) {
                ManualRangeMarker updatedRange;
                int sameMarkersEnd;
                ManualRangeMarker currentRange = resultMarkers[i2];
                for (sameMarkersEnd = i2 + 1; sameMarkersEnd < resultMarkers.length && resultMarkers[sameMarkersEnd] == currentRange; ++sameMarkersEnd) {
                }
                ManualRangeMarker manualRangeMarker = updatedRange = currentRange == null ? null : currentRange.getUpdatedRange(corrected, before);
                while (i2 < sameMarkersEnd) {
                    resultMarkers[i2] = updatedRange;
                    ++i2;
                }
            }
        }
        return new UpdatedRanges(struct.myEventCount + events.size(), frozen, struct.mySortedInfos, resultMarkers);
    }

    boolean updateMarkers(@NotNull FrozenDocument frozen, @NotNull List<DocumentEvent> events) {
        if (frozen == null) {
            MarkerCache.$$$reportNull$$$0(4);
        }
        if (events == null) {
            MarkerCache.$$$reportNull$$$0(5);
        }
        UpdatedRanges updated = this.getUpdatedMarkers(frozen, events);
        boolean sorted = true;
        for (int i2 = 0; i2 < updated.myMarkers.length; ++i2) {
            SelfElementInfo info = (SelfElementInfo)updated.mySortedInfos.get(i2);
            info.setRange(updated.myMarkers[i2]);
            if (!sorted || i2 <= 0 || INFO_COMPARATOR.compare((SelfElementInfo)updated.mySortedInfos.get(i2 - 1), info) <= 0) continue;
            sorted = false;
        }
        this.myUpdatedRanges = null;
        return sorted;
    }

    @Nullable
    TextRange getUpdatedRange(@NotNull SelfElementInfo info, @NotNull FrozenDocument frozen, @NotNull List<DocumentEvent> events) {
        UpdatedRanges struct;
        int i2;
        if (info == null) {
            MarkerCache.$$$reportNull$$$0(6);
        }
        if (frozen == null) {
            MarkerCache.$$$reportNull$$$0(7);
        }
        if (events == null) {
            MarkerCache.$$$reportNull$$$0(8);
        }
        ManualRangeMarker updated = (i2 = Collections.binarySearch((struct = this.getUpdatedMarkers(frozen, events)).mySortedInfos, info, INFO_COMPARATOR)) >= 0 ? struct.myMarkers[i2] : null;
        return updated == null ? null : new UnfairTextRange(updated.getStartOffset(), updated.getEndOffset());
    }

    void rangeChanged() {
        this.myUpdatedRanges = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frozen";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/smartPointers/MarkerCache";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/smartPointers/MarkerCache";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createMarkers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getUpdatedMarkers";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyEvents";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateMarkers";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getUpdatedRange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class UpdatedRanges {
        private final int myEventCount;
        private final FrozenDocument myResultDocument;
        private final List<SelfElementInfo> mySortedInfos;
        private final ManualRangeMarker[] myMarkers;

        public UpdatedRanges(int eventCount, FrozenDocument resultDocument, List<SelfElementInfo> sortedInfos, ManualRangeMarker[] markers) {
            this.myEventCount = eventCount;
            this.myResultDocument = resultDocument;
            this.mySortedInfos = sortedInfos;
            this.myMarkers = markers;
        }
    }
}

