/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.openapi.util.Comparing;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.source.resolve.JavaResolveCache;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.java.ExpressionPsiElement;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiMethodCallExpressionImpl
extends ExpressionPsiElement
implements PsiMethodCallExpression {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.PsiMethodCallExpressionImpl");
    private static final TypeEvaluator ourTypeEvaluator = new TypeEvaluator();

    public PsiMethodCallExpressionImpl() {
        super(JavaElementType.METHOD_CALL_EXPRESSION);
    }

    @Override
    public PsiType getType() {
        return JavaResolveCache.getInstance(this.getProject()).getType(this, ourTypeEvaluator);
    }

    @Override
    public PsiMethod resolveMethod() {
        return (PsiMethod)this.getMethodExpression().resolve();
    }

    @Override
    @NotNull
    public JavaResolveResult resolveMethodGenerics() {
        JavaResolveResult javaResolveResult = this.getMethodExpression().advancedResolve(false);
        if (javaResolveResult == null) {
            PsiMethodCallExpressionImpl.$$$reportNull$$$0(0);
        }
        return javaResolveResult;
    }

    @Override
    public void removeChild(@NotNull ASTNode child) {
        if (child == null) {
            PsiMethodCallExpressionImpl.$$$reportNull$$$0(1);
        }
        if (child == this.getArgumentList()) {
            LOG.error("Cannot delete argument list since it will break contract on argument list notnullity");
        }
        super.removeChild(child);
    }

    @Override
    @NotNull
    public PsiReferenceParameterList getTypeArgumentList() {
        PsiReferenceExpression expression = this.getMethodExpression();
        PsiReferenceParameterList result = expression.getParameterList();
        if (result != null) {
            PsiReferenceParameterList psiReferenceParameterList = result;
            if (psiReferenceParameterList == null) {
                PsiMethodCallExpressionImpl.$$$reportNull$$$0(2);
            }
            return psiReferenceParameterList;
        }
        LOG.error("Invalid method call expression. Children:\n" + DebugUtil.psiTreeToString(expression, false));
        PsiReferenceParameterList psiReferenceParameterList = result;
        if (psiReferenceParameterList == null) {
            PsiMethodCallExpressionImpl.$$$reportNull$$$0(3);
        }
        return psiReferenceParameterList;
    }

    @Override
    @NotNull
    public PsiType[] getTypeArguments() {
        PsiType[] psiTypeArray = this.getMethodExpression().getTypeParameters();
        if (psiTypeArray == null) {
            PsiMethodCallExpressionImpl.$$$reportNull$$$0(4);
        }
        return psiTypeArray;
    }

    @Override
    @NotNull
    public PsiReferenceExpression getMethodExpression() {
        PsiReferenceExpression psiReferenceExpression = (PsiReferenceExpression)this.findChildByRoleAsPsiElement(91);
        if (psiReferenceExpression == null) {
            PsiMethodCallExpressionImpl.$$$reportNull$$$0(5);
        }
        return psiReferenceExpression;
    }

    @Override
    @NotNull
    public PsiExpressionList getArgumentList() {
        PsiExpressionList list = (PsiExpressionList)this.findChildByRoleAsPsiElement(73);
        if (list == null) {
            LOG.error("Invalid PSI for'" + this.getText() + ". Parent:" + DebugUtil.psiToString(this.getParent(), false));
        }
        PsiExpressionList psiExpressionList = list;
        if (psiExpressionList == null) {
            PsiMethodCallExpressionImpl.$$$reportNull$$$0(6);
        }
        return psiExpressionList;
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 91: {
                return this.getFirstChildNode();
            }
            case 73: 
        }
        return this.findChildByType(JavaElementType.EXPRESSION_LIST);
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i2 = child.getElementType();
        if (i2 == JavaElementType.EXPRESSION_LIST) {
            return 73;
        }
        if (ElementType.EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return 91;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            PsiMethodCallExpressionImpl.$$$reportNull$$$0(7);
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitMethodCallExpression(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiMethodCallExpression:" + this.getText();
    }

    public static PsiType captureReturnType(PsiMethodCallExpression call, PsiMethod method, PsiType ret, JavaResolveResult result, LanguageLevel languageLevel) {
        PsiSubstitutor substitutor = result.getSubstitutor();
        PsiType substitutedReturnType = substitutor.substitute(ret);
        if (substitutedReturnType == null) {
            return TypeConversionUtil.erasure(ret);
        }
        if (InferenceSession.wasUncheckedConversionPerformed(call)) {
            return TypeConversionUtil.erasure(substitutedReturnType);
        }
        if (((!languageLevel.isAtLeast(LanguageLevel.JDK_1_8) || call.getTypeArguments().length > 0) && method.hasTypeParameters() || !method.hasTypeParameters() && JavaVersionService.getInstance().isAtLeast(call, JavaSdkVersion.JDK_1_8)) && result instanceof MethodCandidateInfo && ((MethodCandidateInfo)result).isApplicable()) {
            PsiType[] args = call.getArgumentList().getExpressionTypes();
            PsiParameter[] parameters = method.getParameterList().getParameters();
            boolean varargs = ((MethodCandidateInfo)result).getApplicabilityLevel() == 2;
            for (int i2 = 0; i2 < args.length; ++i2) {
                PsiType parameterType = substitutor.substitute(PsiTypesUtil.getParameterType(parameters, i2, varargs));
                PsiType expressionType = args[i2];
                if (expressionType == null || parameterType == null || !JavaGenericsUtil.isRawToGeneric(parameterType, expressionType)) continue;
                return TypeConversionUtil.erasure(substitutedReturnType);
            }
        }
        if (PsiUtil.isRawSubstitutor(method, substitutor)) {
            PsiType returnTypeErasure = TypeConversionUtil.erasure(ret);
            if (Comparing.equal(TypeConversionUtil.erasure(substitutedReturnType), returnTypeErasure)) {
                return returnTypeErasure;
            }
        }
        return PsiUtil.captureToplevelWildcards(substitutedReturnType, call);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/java/PsiMethodCallExpressionImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveMethodGenerics";
                break;
            }
            case 1: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/java/PsiMethodCallExpressionImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeArgumentList";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeArguments";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodExpression";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentList";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "removeChild";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TypeEvaluator
    implements Function<PsiMethodCallExpression, PsiType> {
        private TypeEvaluator() {
        }

        @Override
        @Nullable
        public PsiType fun(PsiMethodCallExpression call) {
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            PsiType theOnly = null;
            JavaResolveResult[] results = methodExpression.multiResolve(false);
            LanguageLevel languageLevel = PsiUtil.getLanguageLevel(call);
            PsiElement callParent = PsiUtil.skipParenthesizedExprUp(call.getParent());
            Object parentArgList = languageLevel.isAtLeast(LanguageLevel.JDK_1_8) ? (callParent instanceof PsiConditionalExpression && !PsiPolyExpressionUtil.isPolyExpression((PsiExpression)callParent) ? null : PsiTreeUtil.getParentOfType((PsiElement)call, PsiExpressionList.class)) : null;
            MethodCandidateInfo.CurrentCandidateProperties properties = MethodCandidateInfo.getCurrentMethod(parentArgList);
            boolean genericMethodCall = properties != null && properties.getInfo().isToInferApplicability();
            for (int i2 = 0; i2 < results.length; ++i2) {
                PsiType type;
                JavaResolveResult candidateInfo = results[i2];
                if (genericMethodCall && PsiPolyExpressionUtil.isMethodCallPolyExpression(call, (PsiMethod)candidateInfo.getElement())) {
                    if (callParent instanceof PsiAssignmentExpression) {
                        return null;
                    }
                    LOG.error("poly expression evaluation during overload resolution");
                }
                if ((type = TypeEvaluator.getResultType(call, methodExpression, candidateInfo, languageLevel)) == null) {
                    return null;
                }
                if (i2 == 0) {
                    theOnly = type;
                    continue;
                }
                if (theOnly.equals(type)) continue;
                return null;
            }
            return PsiClassImplUtil.correctType(theOnly, call.getResolveScope());
        }

        @Nullable
        private static PsiType getResultType(PsiMethodCallExpression call, PsiReferenceExpression methodExpression, JavaResolveResult result, @NotNull LanguageLevel languageLevel) {
            PsiMethod method;
            if (languageLevel == null) {
                TypeEvaluator.$$$reportNull$$$0(0);
            }
            if ((method = (PsiMethod)result.getElement()) == null) {
                return null;
            }
            boolean is15OrHigher = languageLevel.compareTo(LanguageLevel.JDK_1_5) >= 0;
            PsiType getClassReturnType = PsiTypesUtil.patchMethodGetClassReturnType(call, methodExpression, method, type -> type != JavaElementType.CLASS, languageLevel);
            if (getClassReturnType != null) {
                return getClassReturnType;
            }
            PsiType ret = method.getReturnType();
            if (ret == null) {
                return null;
            }
            if (ret instanceof PsiClassType) {
                ret = ((PsiClassType)ret).setLanguageLevel(languageLevel);
            }
            if (is15OrHigher) {
                return PsiMethodCallExpressionImpl.captureReturnType(call, method, ret, result, languageLevel);
            }
            return TypeConversionUtil.erasure(ret);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/psi/impl/source/tree/java/PsiMethodCallExpressionImpl$TypeEvaluator", "getResultType"));
        }
    }
}

