/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.AtomicFieldUpdater;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StubBase<T extends PsiElement>
extends ObjectStubBase<StubElement>
implements StubElement<T> {
    private List<StubElement> myChildren;
    private final IStubElementType myElementType;
    private volatile T myPsi;
    private static final AtomicFieldUpdater<StubBase, PsiElement> ourPsiUpdater = AtomicFieldUpdater.forFieldOfType(StubBase.class, PsiElement.class);

    protected StubBase(StubElement parent, IStubElementType elementType) {
        super(parent);
        this.myElementType = elementType;
        if (parent != null) {
            if (((StubBase)parent).myChildren == null) {
                ((StubBase)parent).myChildren = new SmartList<StubElement>();
            }
            ((StubBase)parent).myChildren.add(this);
        }
    }

    @Override
    public StubElement getParentStub() {
        return (StubElement)this.myParent;
    }

    @Override
    @NotNull
    public List<StubElement> getChildrenStubs() {
        List<StubElement> list = ObjectUtils.chooseNotNull(this.myChildren, Collections.emptyList());
        if (list == null) {
            StubBase.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Override
    @Nullable
    public <P extends PsiElement> StubElement<P> findChildStubByType(@NotNull IStubElementType<?, P> elementType) {
        if (elementType == null) {
            StubBase.$$$reportNull$$$0(1);
        }
        List<StubElement> childrenStubs = this.getChildrenStubs();
        int size = childrenStubs.size();
        for (int i2 = 0; i2 < size; ++i2) {
            StubElement childStub = childrenStubs.get(i2);
            if (childStub.getStubType() != elementType) continue;
            return childStub;
        }
        return null;
    }

    public void setPsi(@NotNull T psi) {
        if (psi == null) {
            StubBase.$$$reportNull$$$0(2);
        }
        this.myPsi = psi;
    }

    @Nullable
    final T getCachedPsi() {
        return this.myPsi;
    }

    @Override
    public T getPsi() {
        Object psi = this.myPsi;
        if (psi != null) {
            return psi;
        }
        psi = this.getStubType().createPsi(this);
        return (T)(ourPsiUpdater.compareAndSet(this, (PsiElement)null, (PsiElement)psi) ? psi : (PsiElement)ObjectUtils.assertNotNull(this.myPsi));
    }

    @Override
    @NotNull
    public <E extends PsiElement> E[] getChildrenByType(@NotNull IElementType elementType, E[] array) {
        if (elementType == null) {
            StubBase.$$$reportNull$$$0(3);
        }
        int count = this.countChildren(elementType);
        array = (PsiElement[])ArrayUtil.ensureExactSize(count, array);
        if (count == 0) {
            if (array == null) {
                StubBase.$$$reportNull$$$0(4);
            }
            return array;
        }
        this.fillFilteredChildren(elementType, (PsiElement[])array);
        if (array == null) {
            StubBase.$$$reportNull$$$0(5);
        }
        return array;
    }

    @Override
    @NotNull
    public <E extends PsiElement> E[] getChildrenByType(@NotNull TokenSet filter, E[] array) {
        if (filter == null) {
            StubBase.$$$reportNull$$$0(6);
        }
        int count = this.countChildren(filter);
        array = (PsiElement[])ArrayUtil.ensureExactSize(count, array);
        if (count == 0) {
            if (array == null) {
                StubBase.$$$reportNull$$$0(7);
            }
            return array;
        }
        this.fillFilteredChildren(filter, (PsiElement[])array);
        if (array == null) {
            StubBase.$$$reportNull$$$0(8);
        }
        return array;
    }

    @Override
    @NotNull
    public <E extends PsiElement> E[] getChildrenByType(@NotNull IElementType elementType, @NotNull ArrayFactory<E> f) {
        if (elementType == null) {
            StubBase.$$$reportNull$$$0(9);
        }
        if (f == null) {
            StubBase.$$$reportNull$$$0(10);
        }
        int count = this.countChildren(elementType);
        PsiElement[] result = (PsiElement[])f.create(count);
        if (count > 0) {
            this.fillFilteredChildren(elementType, result);
        }
        if (result == null) {
            StubBase.$$$reportNull$$$0(11);
        }
        return result;
    }

    private int countChildren(IElementType elementType) {
        int count = 0;
        List<StubElement> childrenStubs = this.getChildrenStubs();
        int childrenStubsSize = childrenStubs.size();
        for (int i2 = 0; i2 < childrenStubsSize; ++i2) {
            StubElement childStub = childrenStubs.get(i2);
            if (childStub.getStubType() != elementType) continue;
            ++count;
        }
        return count;
    }

    private int countChildren(TokenSet types) {
        int count = 0;
        List<StubElement> childrenStubs = this.getChildrenStubs();
        int childrenStubsSize = childrenStubs.size();
        for (int i2 = 0; i2 < childrenStubsSize; ++i2) {
            StubElement childStub = childrenStubs.get(i2);
            if (!types.contains(childStub.getStubType())) continue;
            ++count;
        }
        return count;
    }

    private <E extends PsiElement> void fillFilteredChildren(IElementType type, E[] result) {
        int count = 0;
        for (StubElement childStub : this.getChildrenStubs()) {
            if (childStub.getStubType() != type) continue;
            result[count++] = childStub.getPsi();
        }
        assert (count == result.length);
    }

    private <E extends PsiElement> void fillFilteredChildren(TokenSet set, E[] result) {
        int count = 0;
        for (StubElement childStub : this.getChildrenStubs()) {
            if (!set.contains(childStub.getStubType())) continue;
            result[count++] = childStub.getPsi();
        }
        assert (count == result.length);
    }

    @Override
    @NotNull
    public <E extends PsiElement> E[] getChildrenByType(@NotNull TokenSet filter, @NotNull ArrayFactory<E> f) {
        if (filter == null) {
            StubBase.$$$reportNull$$$0(12);
        }
        if (f == null) {
            StubBase.$$$reportNull$$$0(13);
        }
        int count = this.countChildren(filter);
        PsiElement[] array = (PsiElement[])f.create(count);
        if (count == 0) {
            if (array == null) {
                StubBase.$$$reportNull$$$0(14);
            }
            return array;
        }
        this.fillFilteredChildren(filter, array);
        if (array == null) {
            StubBase.$$$reportNull$$$0(15);
        }
        return array;
    }

    @Override
    @Nullable
    public <E extends PsiElement> E getParentStubOfType(@NotNull Class<E> parentClass) {
        if (parentClass == null) {
            StubBase.$$$reportNull$$$0(16);
        }
        for (StubElement parent = (StubElement)this.myParent; parent != null; parent = parent.getParentStub()) {
            Object psi = parent.getPsi();
            if (!parentClass.isInstance(psi)) continue;
            return (E)psi;
        }
        return null;
    }

    @Override
    public IStubElementType getStubType() {
        return this.myElementType;
    }

    public Project getProject() {
        return this.getPsi().getProject();
    }

    public String printTree() {
        StringBuilder builder = new StringBuilder();
        this.printTree(builder, 0);
        return builder.toString();
    }

    private void printTree(StringBuilder builder, int nestingLevel) {
        for (int i2 = 0; i2 < nestingLevel; ++i2) {
            builder.append("  ");
        }
        builder.append(this.toString()).append('\n');
        for (StubElement child : this.getChildrenStubs()) {
            ((StubBase)child).printTree(builder, nestingLevel + 1);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 16: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 16: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/StubBase";
                break;
            }
            case 1: 
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenStubs";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/StubBase";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenByType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findChildStubByType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setPsi";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenByType";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getParentStubOfType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 16: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

