/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.Queue;
import gnu.trove.Equality;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class TransferToEDTQueue<T> {
    private final String myName;
    private final Processor<T> myProcessor;
    private volatile boolean stopped;
    private final Condition<?> myShutUpCondition;
    private final int myMaxUnitOfWorkThresholdMs;
    private final Queue<T> myQueue;
    private final AtomicBoolean invokeLaterScheduled;
    private final Runnable myUpdateRunnable;

    public TransferToEDTQueue(@NotNull @NonNls String name, @NotNull Processor<T> processor, @NotNull Condition<?> shutUpCondition, int maxUnitOfWorkThresholdMs) {
        if (name == null) {
            TransferToEDTQueue.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            TransferToEDTQueue.$$$reportNull$$$0(1);
        }
        if (shutUpCondition == null) {
            TransferToEDTQueue.$$$reportNull$$$0(2);
        }
        this.myQueue = new Queue(10);
        this.invokeLaterScheduled = new AtomicBoolean();
        this.myUpdateRunnable = new Runnable(){

            @Override
            public void run() {
                boolean b = TransferToEDTQueue.this.invokeLaterScheduled.compareAndSet(true, false);
                assert (b);
                if (TransferToEDTQueue.this.stopped || TransferToEDTQueue.this.myShutUpCondition.value(null)) {
                    TransferToEDTQueue.this.stop();
                    return;
                }
                long start = System.currentTimeMillis();
                while (TransferToEDTQueue.this.processNext()) {
                    long finish = System.currentTimeMillis();
                    if (TransferToEDTQueue.this.myMaxUnitOfWorkThresholdMs == -1 || finish - start <= (long)TransferToEDTQueue.this.myMaxUnitOfWorkThresholdMs) continue;
                    break;
                }
                if (!TransferToEDTQueue.this.isEmpty()) {
                    TransferToEDTQueue.this.scheduleUpdate();
                }
            }

            public String toString() {
                return TransferToEDTQueue.this.getClass().getSimpleName() + "[" + TransferToEDTQueue.this.myName + "]";
            }
        };
        this.myName = name;
        this.myProcessor = processor;
        this.myShutUpCondition = shutUpCondition;
        this.myMaxUnitOfWorkThresholdMs = maxUnitOfWorkThresholdMs;
    }

    public static TransferToEDTQueue<Runnable> createRunnableMerger(@NotNull @NonNls String name, int maxUnitOfWorkThresholdMs) {
        if (name == null) {
            TransferToEDTQueue.$$$reportNull$$$0(3);
        }
        return new TransferToEDTQueue<Runnable>(name, new Processor<Runnable>(){

            @Override
            public boolean process(Runnable runnable) {
                runnable.run();
                return true;
            }
        }, Conditions.alwaysFalse(), maxUnitOfWorkThresholdMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEmpty() {
        Queue<T> queue = this.myQueue;
        synchronized (queue) {
            return this.myQueue.isEmpty();
        }
    }

    private boolean processNext() {
        T thing = this.pullFirst();
        if (thing == null) {
            return false;
        }
        if (!this.myProcessor.process(thing)) {
            this.stop();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T pullFirst() {
        Queue<T> queue = this.myQueue;
        synchronized (queue) {
            return this.myQueue.isEmpty() ? null : (T)this.myQueue.pullFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offer(@NotNull T thing) {
        if (thing == null) {
            TransferToEDTQueue.$$$reportNull$$$0(4);
        }
        Queue<T> queue = this.myQueue;
        synchronized (queue) {
            this.myQueue.addLast(thing);
        }
        this.scheduleUpdate();
        return true;
    }

    /*
     * Exception decompiling
     */
    public boolean offerIfAbsent(@NotNull T thing) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ReturnValueStatement.rewriteExpressions(ReturnValueStatement.java:62)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offerIfAbsent(final @NotNull T thing, final @NotNull Equality<T> equality) {
        if (thing == null) {
            TransferToEDTQueue.$$$reportNull$$$0(6);
        }
        if (equality == null) {
            TransferToEDTQueue.$$$reportNull$$$0(7);
        }
        Queue<T> queue = this.myQueue;
        synchronized (queue) {
            boolean absent = this.myQueue.process(new Processor<T>(){

                @Override
                public boolean process(T t) {
                    return !equality.equals(t, thing);
                }
            });
            if (absent) {
                this.myQueue.addLast(thing);
                this.scheduleUpdate();
            }
            return absent;
        }
    }

    private void scheduleUpdate() {
        if (!this.stopped && this.invokeLaterScheduled.compareAndSet(false, true)) {
            this.schedule(this.myUpdateRunnable);
        }
    }

    protected void schedule(@NotNull Runnable updateRunnable) {
        if (updateRunnable == null) {
            TransferToEDTQueue.$$$reportNull$$$0(8);
        }
        SwingUtilities.invokeLater(updateRunnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.stopped = true;
        Queue<T> queue = this.myQueue;
        synchronized (queue) {
            this.myQueue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Queue<T> queue = this.myQueue;
        synchronized (queue) {
            return this.myQueue.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Collection<T> dump() {
        Queue<T> queue = this.myQueue;
        // MONITORENTER : queue
        List<T> list = this.myQueue.toList();
        // MONITOREXIT : queue
        if (list != null) return list;
        TransferToEDTQueue.$$$reportNull$$$0(9);
        return list;
    }

    public void drain() {
        int processed2 = 0;
        while (this.processNext()) {
            ++processed2;
        }
    }

    public void waitFor() {
        final Semaphore semaphore = new Semaphore();
        semaphore.down();
        this.schedule(new Runnable(){

            @Override
            public void run() {
                semaphore.up();
            }
        });
        semaphore.waitFor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shutUpCondition";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thing";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "equality";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updateRunnable";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/TransferToEDTQueue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/TransferToEDTQueue";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "dump";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createRunnableMerger";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "offer";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "offerIfAbsent";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "schedule";
                break;
            }
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

