/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.internationalization.NonNlsUtils;
import com.siyeh.ig.psiutils.ExceptionUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObjectToStringInspection
extends BaseInspection {
    public boolean IGNORE_NONNLS = false;
    public boolean IGNORE_EXCEPTION = false;
    public boolean IGNORE_ASSERT = false;
    public boolean IGNORE_TOSTRING = false;

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel(this);
        panel.addCheckbox(InspectionGadgetsBundle.message("inspection.option.ignore.nonnls", new Object[0]), "IGNORE_NONNLS");
        panel.addCheckbox(InspectionGadgetsBundle.message("inspection.option.ignore.exceptions", new Object[0]), "IGNORE_EXCEPTION");
        panel.addCheckbox(InspectionGadgetsBundle.message("inspection.option.ignore.assert", new Object[0]), "IGNORE_ASSERT");
        panel.addCheckbox(InspectionGadgetsBundle.message("inspection.option.ignore.in.tostring", new Object[0]), "IGNORE_TOSTRING");
        return panel;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("default.tostring.call.display.name", new Object[0]);
        if (string == null) {
            ObjectToStringInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("default.tostring.call.problem.descriptor", new Object[0]);
        if (string == null) {
            ObjectToStringInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ObjectToStringVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/bugs/ObjectToStringInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class ObjectToStringVisitor
    extends BaseInspectionVisitor {
        private ObjectToStringVisitor() {
        }

        @Override
        public void visitPolyadicExpression(PsiPolyadicExpression expression) {
            PsiExpression[] operands;
            super.visitPolyadicExpression(expression);
            if (!ExpressionUtils.hasStringType(expression)) {
                return;
            }
            for (PsiExpression operand : operands = expression.getOperands()) {
                this.checkExpression(operand);
            }
        }

        @Override
        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression) {
            if (expression == null) {
                ObjectToStringVisitor.$$$reportNull$$$0(0);
            }
            super.visitAssignmentExpression(expression);
            IElementType tokenType = expression.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.PLUSEQ)) {
                return;
            }
            PsiExpression lhs = expression.getLExpression();
            if (!ExpressionUtils.hasStringType(lhs)) {
                return;
            }
            PsiExpression rhs = expression.getRExpression();
            this.checkExpression(rhs);
        }

        @Override
        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String name = methodExpression.getReferenceName();
            if ("toString".equals(name)) {
                PsiExpressionList argumentList = expression.getArgumentList();
                PsiExpression[] arguments = argumentList.getExpressions();
                if (arguments.length != 0) {
                    return;
                }
                PsiExpression qualifier = methodExpression.getQualifierExpression();
                this.checkExpression(qualifier);
            } else if ("append".equals(name)) {
                PsiExpression qualifier = methodExpression.getQualifierExpression();
                if (!TypeUtils.expressionHasTypeOrSubtype(qualifier, "java.lang.AbstractStringBuilder")) {
                    return;
                }
                PsiExpressionList argumentList = expression.getArgumentList();
                PsiExpression[] arguments = argumentList.getExpressions();
                if (arguments.length != 1) {
                    return;
                }
                PsiExpression argument = arguments[0];
                this.checkExpression(argument);
            } else if ("valueOf".equals(name)) {
                PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
                if (!(qualifierExpression instanceof PsiReferenceExpression)) {
                    return;
                }
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifierExpression;
                String canonicalText = referenceExpression.getCanonicalText();
                if (!"java.lang.String".equals(canonicalText)) {
                    return;
                }
                PsiExpressionList argumentList = expression.getArgumentList();
                PsiExpression[] arguments = argumentList.getExpressions();
                if (arguments.length != 1) {
                    return;
                }
                PsiExpression argument = arguments[0];
                this.checkExpression(argument);
            }
        }

        private void checkExpression(PsiExpression expression) {
            if (expression == null) {
                return;
            }
            PsiType type = expression.getType();
            if (!(type instanceof PsiClassType)) {
                return;
            }
            if (ObjectToStringInspection.this.IGNORE_TOSTRING && MethodUtils.isToString(PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMethod.class))) {
                return;
            }
            if (ObjectToStringInspection.this.IGNORE_EXCEPTION && (ExceptionUtils.isExceptionArgument(expression) || PsiTreeUtil.getParentOfType((PsiElement)expression, PsiThrowStatement.class, true, PsiCodeBlock.class, PsiClass.class) != null)) {
                return;
            }
            if (ObjectToStringInspection.this.IGNORE_ASSERT && PsiTreeUtil.getParentOfType((PsiElement)expression, PsiAssertStatement.class, true, PsiCodeBlock.class, PsiClass.class) != null) {
                return;
            }
            if (ObjectToStringInspection.this.IGNORE_NONNLS && NonNlsUtils.isNonNlsAnnotatedUse(expression)) {
                return;
            }
            PsiClassType classType = (PsiClassType)type;
            if (type.equalsToText("java.lang.Object")) {
                return;
            }
            PsiClass referencedClass = classType.resolve();
            if (referencedClass == null || referencedClass instanceof PsiTypeParameter) {
                return;
            }
            if (referencedClass.isEnum() || referencedClass.isInterface()) {
                return;
            }
            if (referencedClass.hasModifierProperty("abstract") && !(expression instanceof PsiSuperExpression)) {
                return;
            }
            if (this.hasGoodToString(referencedClass)) {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }

        private boolean hasGoodToString(PsiClass aClass) {
            PsiMethod[] methods;
            for (PsiMethod method : methods = aClass.findMethodsByName("toString", true)) {
                PsiParameterList parameterList;
                String name;
                PsiClass containingClass = method.getContainingClass();
                if (containingClass == null || "java.lang.Object".equals(name = containingClass.getQualifiedName()) || (parameterList = method.getParameterList()).getParametersCount() != 0) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/bugs/ObjectToStringInspection$ObjectToStringVisitor", "visitAssignmentExpression"));
        }
    }
}

