/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.javadoc;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageInfoWithoutPackageInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("package.info.java.without.package.display.name", new Object[0]);
        if (string == null) {
            PackageInfoWithoutPackageInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("package.info.without.package.problem.descriptor", new Object[0]);
        if (string == null) {
            PackageInfoWithoutPackageInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new PackageInfoWithoutPackageFix((String)infos[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PackageInfoWithoutPackageVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/javadoc/PackageInfoWithoutPackageInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class PackageInfoWithoutPackageVisitor
    extends BaseInspectionVisitor {
        private PackageInfoWithoutPackageVisitor() {
        }

        @Override
        public void visitJavaFile(PsiJavaFile file) {
            String name = file.getName();
            if (!"package-info.java".equals(name)) {
                return;
            }
            PsiPackageStatement packageStatement = file.getPackageStatement();
            if (packageStatement != null) {
                return;
            }
            PsiDirectory directory = file.getContainingDirectory();
            PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(directory);
            if (aPackage == null) {
                return;
            }
            String packageName = aPackage.getQualifiedName();
            if (packageName.isEmpty()) {
                return;
            }
            this.registerError((PsiElement)file, packageName);
        }
    }

    private static class PackageInfoWithoutPackageFix
    extends InspectionGadgetsFix {
        private final String myPackageName;

        public PackageInfoWithoutPackageFix(String packageName) {
            this.myPackageName = packageName;
        }

        @Override
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("package.info.without.package.quickfix", this.myPackageName);
            if (string == null) {
                PackageInfoWithoutPackageFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("package.info.without.package.family.quickfix", new Object[0]);
            if (string == null) {
                PackageInfoWithoutPackageFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiJavaFile)) {
                return;
            }
            PsiJavaFile file = (PsiJavaFile)element;
            file.setPackageName(this.myPackageName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/javadoc/PackageInfoWithoutPackageInspection$PackageInfoWithoutPackageFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

