/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.maturity;

import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.text.StringSearcher;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.LibraryUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObsoleteCollectionInspection
extends BaseInspection {
    private static final int MAX_OCCURRENCES = 20;
    public boolean ignoreRequiredObsoleteCollectionTypes = true;

    @Override
    @NotNull
    public String getID() {
        if ("UseOfObsoleteCollectionType" == null) {
            ObsoleteCollectionInspection.$$$reportNull$$$0(0);
        }
        return "UseOfObsoleteCollectionType";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("use.obsolete.collection.type.display.name", new Object[0]);
        if (string == null) {
            ObsoleteCollectionInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("use.obsolete.collection.type.problem.descriptor", new Object[0]);
        if (string == null) {
            ObsoleteCollectionInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("use.obsolete.collection.type.ignore.library.arguments.option", new Object[0]), this, "ignoreRequiredObsoleteCollectionTypes");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ObsoleteCollectionVisitor();
    }

    private static boolean isCheapToSearchInFile(@NotNull PsiNamedElement element) {
        String name;
        if (element == null) {
            ObsoleteCollectionInspection.$$$reportNull$$$0(3);
        }
        if ((name = element.getName()) == null) {
            return false;
        }
        return (Boolean)CachedValuesManager.getCachedValue(element, () -> {
            PsiFile file;
            int[] occurrences;
            if (element == null) {
                ObsoleteCollectionInspection.$$$reportNull$$$0(4);
            }
            return CachedValueProvider.Result.create(Boolean.valueOf((occurrences = new StringSearcher(name, true, true).findAllOccurrences((file = element.getContainingFile()).getViewProvider().getContents())).length <= 20), file);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/maturity/ObsoleteCollectionInspection";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/maturity/ObsoleteCollectionInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isCheapToSearchInFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isCheapToSearchInFile$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ObsoleteCollectionVisitor
    extends BaseInspectionVisitor {
        private ObsoleteCollectionVisitor() {
        }

        @Override
        public void visitVariable(@NotNull PsiVariable variable) {
            if (variable == null) {
                ObsoleteCollectionVisitor.$$$reportNull$$$0(0);
            }
            super.visitVariable(variable);
            PsiType type = variable.getType();
            if (!this.isObsoleteCollectionType(type)) {
                return;
            }
            if (LibraryUtil.isOverrideOfLibraryMethodParameter(variable)) {
                return;
            }
            PsiTypeElement typeElement = variable.getTypeElement();
            if (typeElement == null) {
                return;
            }
            if (ObsoleteCollectionInspection.this.ignoreRequiredObsoleteCollectionTypes && this.checkReferences(variable)) {
                return;
            }
            this.registerError((PsiElement)typeElement, new Object[0]);
        }

        @Override
        public void visitMethod(PsiMethod method) {
            super.visitMethod(method);
            PsiType returnType = method.getReturnType();
            if (!this.isObsoleteCollectionType(returnType)) {
                return;
            }
            if (LibraryUtil.isOverrideOfLibraryMethod(method)) {
                return;
            }
            PsiTypeElement typeElement = method.getReturnTypeElement();
            if (typeElement == null) {
                return;
            }
            if (ObsoleteCollectionInspection.this.ignoreRequiredObsoleteCollectionTypes && this.checkReferences(method)) {
                return;
            }
            this.registerError((PsiElement)typeElement, new Object[0]);
        }

        @Override
        public void visitNewExpression(@NotNull PsiNewExpression newExpression) {
            if (newExpression == null) {
                ObsoleteCollectionVisitor.$$$reportNull$$$0(1);
            }
            super.visitNewExpression(newExpression);
            PsiType type = newExpression.getType();
            if (!this.isObsoleteCollectionType(type)) {
                return;
            }
            if (ObsoleteCollectionInspection.this.ignoreRequiredObsoleteCollectionTypes && this.isRequiredObsoleteCollectionElement(newExpression)) {
                return;
            }
            this.registerNewExpressionError(newExpression, new Object[0]);
        }

        private boolean isObsoleteCollectionType(@Nullable PsiType type) {
            if (type == null) {
                return false;
            }
            PsiType deepComponentType = type.getDeepComponentType();
            if (!(deepComponentType instanceof PsiClassType)) {
                return false;
            }
            PsiClassType classType = (PsiClassType)deepComponentType;
            String className = classType.getClassName();
            if (!"Vector".equals(className) && !"Hashtable".equals(className)) {
                return false;
            }
            PsiClass aClass = classType.resolve();
            if (aClass == null) {
                return false;
            }
            String name = aClass.getQualifiedName();
            return "java.util.Vector".equals(name) || "java.util.Hashtable".equals(name);
        }

        private boolean checkReferences(PsiNamedElement namedElement) {
            PsiFile containingFile = namedElement.getContainingFile();
            if (!this.isOnTheFly() || ObsoleteCollectionInspection.isCheapToSearchInFile(namedElement)) {
                return !ReferencesSearch.search(namedElement, GlobalSearchScope.fileScope(containingFile)).forEach(ref -> {
                    PsiElement element = ref.getElement();
                    return !this.isRequiredObsoleteCollectionElement(element);
                });
            }
            return true;
        }

        private boolean isRequiredObsoleteCollectionElement(PsiElement element) {
            PsiElement parent = element.getParent();
            if (parent instanceof PsiVariable) {
                PsiVariable variable = (PsiVariable)parent;
                PsiType variableType = variable.getType();
                if (this.isObsoleteCollectionType(variableType)) {
                    return true;
                }
            } else if (parent instanceof PsiReturnStatement) {
                PsiType returnType = PsiTypesUtil.getMethodReturnType(parent);
                if (this.isObsoleteCollectionType(returnType)) {
                    return true;
                }
            } else if (parent instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
                PsiExpression lhs = assignmentExpression.getLExpression();
                PsiType lhsType = lhs.getType();
                if (this.isObsoleteCollectionType(lhsType)) {
                    return true;
                }
            } else if (parent instanceof PsiMethodCallExpression) {
                return this.isRequiredObsoleteCollectionElement(parent);
            }
            if (!(parent instanceof PsiExpressionList)) {
                return false;
            }
            PsiExpressionList argumentList = (PsiExpressionList)parent;
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiCallExpression)) {
                return false;
            }
            PsiCallExpression callExpression = (PsiCallExpression)grandParent;
            int index = this.getIndexOfArgument(argumentList, element);
            PsiMethod method = callExpression.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiParameterList parameterList = method.getParameterList();
            PsiParameter[] parameters = parameterList.getParameters();
            if (index >= parameters.length) {
                PsiParameter lastParameter = parameters[parameters.length - 1];
                if (!lastParameter.isVarArgs()) {
                    return false;
                }
                PsiType type = lastParameter.getType();
                if (!(type instanceof PsiEllipsisType)) {
                    return false;
                }
                PsiEllipsisType ellipsisType = (PsiEllipsisType)type;
                PsiType componentType = ellipsisType.getComponentType();
                return this.isObsoleteCollectionType(componentType);
            }
            PsiParameter parameter = parameters[index];
            PsiType type = parameter.getType();
            return this.isObsoleteCollectionType(type);
        }

        private int getIndexOfArgument(PsiExpressionList argumentList, PsiElement argument) {
            PsiExpression[] expressions = argumentList.getExpressions();
            int index = -1;
            for (PsiExpression expression : expressions) {
                ++index;
                if (expression.equals(argument)) break;
            }
            return index;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newExpression";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/maturity/ObsoleteCollectionInspection$ObsoleteCollectionVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitVariable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitNewExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

