/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.intellij.util.ui.CheckBox;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.naming.ConventionInspection;
import com.siyeh.ig.psiutils.ClassUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class StaticVariableNamingConventionInspectionBase
extends ConventionInspection {
    private static final int DEFAULT_MIN_LENGTH = 5;
    private static final int DEFAULT_MAX_LENGTH = 32;
    public boolean checkMutableFinals = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("static.variable.naming.convention.display.name", new Object[0]);
        if (string == null) {
            StaticVariableNamingConventionInspectionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    protected String getElementDescription() {
        return InspectionGadgetsBundle.message("static.variable.naming.convention.element.description", new Object[0]);
    }

    @Override
    protected String getDefaultRegex() {
        return "s_[a-z][A-Za-z\\d]*";
    }

    @Override
    protected int getDefaultMinLength() {
        return 5;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 32;
    }

    @Override
    @NotNull
    public JComponent[] createExtraOptions() {
        JComponent[] jComponentArray = new JComponent[]{new CheckBox(InspectionGadgetsBundle.message("static.variable.naming.convention.mutable.option", new Object[0]), this, "checkMutableFinals")};
        if (jComponentArray == null) {
            StaticVariableNamingConventionInspectionBase.$$$reportNull$$$0(1);
        }
        return jComponentArray;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NamingConventionsVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/naming/StaticVariableNamingConventionInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createExtraOptions";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class NamingConventionsVisitor
    extends BaseInspectionVisitor {
        private NamingConventionsVisitor() {
        }

        @Override
        public void visitField(@NotNull PsiField field) {
            String name;
            if (field == null) {
                NamingConventionsVisitor.$$$reportNull$$$0(0);
            }
            if (!field.hasModifierProperty("static")) {
                return;
            }
            if (field.hasModifierProperty("final")) {
                if (!StaticVariableNamingConventionInspectionBase.this.checkMutableFinals) {
                    return;
                }
                PsiType type = field.getType();
                if (ClassUtils.isImmutable(type)) {
                    return;
                }
            }
            if ((name = field.getName()) == null) {
                return;
            }
            if (StaticVariableNamingConventionInspectionBase.this.isValid(name)) {
                return;
            }
            this.registerFieldError(field, name);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/siyeh/ig/naming/StaticVariableNamingConventionInspectionBase$NamingConventionsVisitor", "visitField"));
        }
    }
}

