/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.ChangeToAppendUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.controlFlow.DefUseUtil;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.BlockUtils;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringConcatenationInLoopsInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("string.concatenation.in.loops.display.name", new Object[0]);
        if (string == null) {
            StringConcatenationInLoopsInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @org.intellij.lang.annotations.Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        if ("StringConcatenationInLoop" == null) {
            StringConcatenationInLoopsInspection.$$$reportNull$$$0(1);
        }
        return "StringConcatenationInLoop";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("string.concatenation.in.loops.problem.descriptor", new Object[0]);
        if (string == null) {
            StringConcatenationInLoopsInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StringConcatenationInLoopsVisitor();
    }

    static PsiLoopStatement getOutermostCommonLoop(PsiExpression expression, PsiVariable variable) {
        PsiElement stopAt = null;
        PsiCodeBlock block = StringConcatenationInLoopsVisitor.getSurroundingBlock(expression);
        if (block != null) {
            PsiElement ref;
            if (expression instanceof PsiAssignmentExpression) {
                ref = expression;
            } else {
                PsiReference reference = ReferencesSearch.search(variable, new LocalSearchScope(expression)).findFirst();
                PsiElement psiElement = ref = reference != null ? reference.getElement() : null;
            }
            if (ref != null) {
                PsiElement[] elements = (PsiElement[])StreamEx.of((Object[])DefUseUtil.getDefs(block, variable, expression)).prepend((Object)expression).toArray(PsiElement[]::new);
                stopAt = PsiTreeUtil.findCommonParent(elements);
            }
        }
        PsiLoopStatement commonLoop = null;
        for (PsiElement parent = expression.getParent(); !(parent == null || parent == stopAt || parent instanceof PsiMethod || parent instanceof PsiClass || parent instanceof PsiLambdaExpression); parent = parent.getParent()) {
            if (!(parent instanceof PsiLoopStatement)) continue;
            commonLoop = (PsiLoopStatement)parent;
        }
        return commonLoop;
    }

    @Contract(value="null -> null")
    @Nullable
    private static PsiVariable getAppendedVariable(PsiExpression expression) {
        PsiElement parent = expression;
        while (parent instanceof PsiParenthesizedExpression || parent instanceof PsiPolyadicExpression) {
            parent = parent.getParent();
        }
        if (!(parent instanceof PsiAssignmentExpression)) {
            return null;
        }
        PsiExpression lhs = PsiUtil.skipParenthesizedExprDown(((PsiAssignmentExpression)parent).getLExpression());
        if (!(lhs instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiElement element = ((PsiReferenceExpression)lhs).resolve();
        return element instanceof PsiVariable ? (PsiVariable)element : null;
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        PsiExpression expression = ObjectUtils.tryCast(ArrayUtil.getFirstElement(infos), PsiExpression.class);
        PsiVariable var = StringConcatenationInLoopsInspection.getAppendedVariable(expression);
        if (var == null) {
            if (InspectionGadgetsFix.EMPTY_ARRAY == null) {
                StringConcatenationInLoopsInspection.$$$reportNull$$$0(3);
            }
            return InspectionGadgetsFix.EMPTY_ARRAY;
        }
        ArrayList<AbstractStringBuilderFix> fixes = new ArrayList<AbstractStringBuilderFix>();
        if (var instanceof PsiLocalVariable) {
            fixes.add(new ReplaceWithStringBuilderFix(var));
            PsiLoopStatement loop = StringConcatenationInLoopsInspection.getOutermostCommonLoop(expression, var);
            if (ReferencesSearch.search(var).findAll().stream().map(PsiReference::getElement).filter(e -> !PsiTreeUtil.isAncestor(loop, e, true)).limit(2L).count() > 1L) {
                fixes.add(new IntroduceStringBuilderFix(var));
            }
        } else if (var instanceof PsiParameter) {
            fixes.add(new IntroduceStringBuilderFix(var));
        }
        InspectionGadgetsFix[] inspectionGadgetsFixArray = fixes.toArray(InspectionGadgetsFix.EMPTY_ARRAY);
        if (inspectionGadgetsFixArray == null) {
            StringConcatenationInLoopsInspection.$$$reportNull$$$0(4);
        }
        return inspectionGadgetsFixArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/performance/StringConcatenationInLoopsInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixes";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    static class ReplaceWithStringBuilderFix
    extends AbstractStringBuilderFix {
        public ReplaceWithStringBuilderFix(PsiVariable variable) {
            super(variable);
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiStatement commentPlace;
            PsiExpression expression = PsiTreeUtil.getParentOfType(descriptor.getStartElement(), PsiExpression.class);
            if (expression == null) {
                return;
            }
            PsiVariable variable = StringConcatenationInLoopsInspection.getAppendedVariable(expression);
            if (!(variable instanceof PsiLocalVariable)) {
                return;
            }
            variable.normalizeDeclaration();
            PsiTypeElement typeElement = variable.getTypeElement();
            if (typeElement == null) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            this.replaceAll(variable, variable, null, ct);
            ct.replace((PsiElement)typeElement, this.myTargetType);
            PsiExpression initializer = variable.getInitializer();
            if (initializer != null) {
                ct.replace((PsiElement)initializer, this.generateNewStringBuilder(initializer, ct));
            }
            ct.insertCommentsBefore((commentPlace = PsiTreeUtil.getParentOfType((PsiElement)variable, PsiStatement.class)) == null ? variable : commentPlace);
        }

        @Override
        @Nls
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("string.concatenation.replace.fix.name", this.myName, StringUtil.getShortName(this.myTargetType));
            if (string == null) {
                ReplaceWithStringBuilderFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("string.concatenation.replace.fix", new Object[0]);
            if (string == null) {
                ReplaceWithStringBuilderFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/performance/StringConcatenationInLoopsInspection$ReplaceWithStringBuilderFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    static class IntroduceStringBuilderFix
    extends AbstractStringBuilderFix {
        public IntroduceStringBuilderFix(PsiVariable variable) {
            super(variable);
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiExpression expression = PsiTreeUtil.getParentOfType(descriptor.getStartElement(), PsiExpression.class);
            if (expression == null) {
                return;
            }
            PsiVariable variable = StringConcatenationInLoopsInspection.getAppendedVariable(expression);
            if (variable == null) {
                return;
            }
            PsiLoopStatement loop = StringConcatenationInLoopsInspection.getOutermostCommonLoop(expression, variable);
            if (loop == null) {
                return;
            }
            ControlFlowUtils.InitializerUsageStatus status = ControlFlowUtils.getInitializerUsageStatus(variable, loop);
            String newName = JavaCodeStyleManager.getInstance(project).suggestUniqueVariableName(variable.getName() + "Builder", (PsiElement)loop, true);
            String newStringBuilder = this.myTargetType + " " + newName + "=new " + this.myTargetType + "(" + variable.getName() + ");";
            PsiElementFactory factory = JavaPsiFacade.getElementFactory(project);
            Object marker = new Object();
            PsiTreeUtil.mark(loop, marker);
            PsiDeclarationStatement declaration = (PsiDeclarationStatement)BlockUtils.addBefore(loop, factory.createStatementFromText(newStringBuilder, loop));
            if (!loop.isValid() && (loop = (PsiLoopStatement)PsiTreeUtil.releaseMark(declaration.getParent(), marker)) == null) {
                return;
            }
            PsiVariable builderVariable = (PsiVariable)declaration.getDeclaredElements()[0];
            PsiExpression builderInitializer = Objects.requireNonNull(builderVariable.getInitializer());
            CommentTracker ct = new CommentTracker();
            this.replaceAll(variable, builderVariable, loop, ct);
            String toString = variable.getName() + " = " + newName + ".toString();";
            PsiExpression initializer = variable.getInitializer();
            switch (status) {
                case DECLARED_JUST_BEFORE: {
                    PsiTypeElement typeElement = variable.getTypeElement();
                    if (typeElement == null || initializer == null) break;
                    ct.replace((PsiElement)builderInitializer, this.generateNewStringBuilder(initializer, ct));
                    ct.replace((PsiElement)initializer, newName + ".toString()");
                    toString = variable.getText();
                    ct.delete((PsiElement)variable);
                    break;
                }
                case AT_WANTED_PLACE_ONLY: {
                    if (initializer == null) break;
                    ct.replace((PsiElement)builderInitializer, this.generateNewStringBuilder(initializer, ct));
                    initializer.delete();
                    break;
                }
                case AT_WANTED_PLACE: {
                    if (!ExpressionUtils.isSimpleExpression(initializer)) break;
                    ct.replace((PsiElement)builderInitializer, this.generateNewStringBuilder(initializer, ct));
                    break;
                }
                case UNKNOWN: {
                    PsiElement prevStatement = PsiTreeUtil.skipWhitespacesAndCommentsBackward(declaration);
                    PsiExpression prevAssignment = ExpressionUtils.getAssignmentTo(prevStatement, variable);
                    if (prevAssignment == null) break;
                    ct.replace((PsiElement)builderInitializer, this.generateNewStringBuilder(prevAssignment, ct));
                    ct.delete(prevStatement);
                }
            }
            BlockUtils.addAfter(loop, factory.createStatementFromText(toString, loop));
            ct.insertCommentsBefore(loop);
        }

        @Override
        @Nls
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("string.concatenation.introduce.fix.name", this.myName, StringUtil.getShortName(this.myTargetType));
            if (string == null) {
                IntroduceStringBuilderFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("string.concatenation.introduce.fix", new Object[0]);
            if (string == null) {
                IntroduceStringBuilderFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/performance/StringConcatenationInLoopsInspection$IntroduceStringBuilderFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    static abstract class AbstractStringBuilderFix
    extends InspectionGadgetsFix {
        static final Pattern PRINT_OR_PRINTLN = Pattern.compile("print|println");
        String myName;
        String myTargetType;

        public AbstractStringBuilderFix(PsiVariable variable) {
            this.myName = variable.getName();
            this.myTargetType = PsiUtil.isLanguageLevel5OrHigher(variable) ? "java.lang.StringBuilder" : "java.lang.StringBuffer";
        }

        @NotNull
        String generateNewStringBuilder(PsiExpression initializer, CommentTracker ct) {
            if (ExpressionUtils.isNullLiteral(initializer)) {
                String string = ct.text(initializer);
                if (string == null) {
                    AbstractStringBuilderFix.$$$reportNull$$$0(0);
                }
                return string;
            }
            String text2 = initializer == null || ExpressionUtils.isLiteral(initializer, "") ? "" : ct.text(initializer);
            String string = "new " + this.myTargetType + "(" + text2 + ")";
            if (string == null) {
                AbstractStringBuilderFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        void replaceAll(PsiVariable variable, PsiVariable builderVariable, PsiElement scope, CommentTracker ct) {
            this.replaceAll(variable, builderVariable, scope, ct, ref -> false);
        }

        void replaceAll(PsiVariable variable, PsiVariable builderVariable, PsiElement scope, CommentTracker ct, Predicate<PsiReferenceExpression> skip) {
            Query<PsiReference> query = scope == null ? ReferencesSearch.search(variable) : ReferencesSearch.search(variable, new LocalSearchScope(scope));
            Collection<PsiReference> refs = query.findAll();
            for (PsiReference ref : refs) {
                PsiElement target = ref.getElement();
                if (!(target instanceof PsiReferenceExpression) || !target.isValid() || skip.test((PsiReferenceExpression)target)) continue;
                this.replace(variable, builderVariable, (PsiReferenceExpression)target, ct);
            }
        }

        private void replace(PsiVariable variable, PsiVariable builderVariable, PsiReferenceExpression ref, CommentTracker ct) {
            PsiBinaryExpression binOp;
            PsiMethodCallExpression call;
            PsiExpression[] expressions;
            PsiMethodCallExpression methodCallExpression;
            PsiElement parent = PsiUtil.skipParenthesizedExprUp(ref.getParent());
            if (parent instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignment = (PsiAssignmentExpression)parent;
                if (PsiUtil.skipParenthesizedExprDown(assignment.getLExpression()) == ref) {
                    this.replaceInAssignment(variable, builderVariable, assignment, ct);
                    return;
                }
                if (assignment.getOperationTokenType().equals(JavaTokenType.PLUSEQ)) {
                    return;
                }
            }
            if (variable != builderVariable) {
                ExpressionUtils.bindReferenceTo(ref, Objects.requireNonNull(builderVariable.getName()));
            }
            if ((methodCallExpression = ExpressionUtils.getCallForQualifier(ref)) != null) {
                AbstractStringBuilderFix.replaceInCallQualifier(builderVariable, methodCallExpression, ct);
                return;
            }
            if (parent instanceof PsiExpressionList && parent.getParent() instanceof PsiMethodCallExpression && (expressions = ((PsiExpressionList)parent).getExpressions()).length == 1 && expressions[0] == ref && AbstractStringBuilderFix.canAcceptBuilderInsteadOfString(call = (PsiMethodCallExpression)parent.getParent())) {
                return;
            }
            if (parent instanceof PsiBinaryExpression && ExpressionUtils.getValueComparedWithNull(binOp = (PsiBinaryExpression)parent) != null) {
                return;
            }
            if (parent instanceof PsiPolyadicExpression && ((PsiPolyadicExpression)parent).getOperationTokenType().equals(JavaTokenType.PLUS)) {
                PsiExpression[] operands;
                for (PsiExpression operand : operands = ((PsiPolyadicExpression)parent).getOperands()) {
                    if (operand == ref) break;
                    if (!TypeUtils.isJavaLangString(operand.getType())) continue;
                    return;
                }
                if (operands.length > 1 && operands[0] == ref && TypeUtils.isJavaLangString(operands[1].getType())) {
                    return;
                }
            }
            ct.replace((PsiElement)ref, builderVariable.getName() + ".toString()");
        }

        private static boolean canAcceptBuilderInsteadOfString(PsiMethodCallExpression call) {
            return MethodCallUtils.isCallToMethod(call, "java.lang.StringBuilder", null, "append", (PsiType[])null) || MethodCallUtils.isCallToMethod(call, "java.lang.StringBuffer", null, "append", (PsiType[])null) || MethodCallUtils.isCallToMethod(call, "java.io.PrintStream", null, PRINT_OR_PRINTLN, (PsiType[])null) || MethodCallUtils.isCallToMethod(call, "java.io.PrintWriter", null, PRINT_OR_PRINTLN, (PsiType[])null);
        }

        private static void replaceInCallQualifier(PsiVariable variable, PsiMethodCallExpression call, CommentTracker ct) {
            PsiMethod method = call.resolveMethod();
            if (method != null) {
                String name;
                PsiExpression[] args = call.getArgumentList().getExpressions();
                switch (name = method.getName()) {
                    case "length": 
                    case "chars": 
                    case "codePoints": 
                    case "charAt": 
                    case "codePointAt": 
                    case "codePointBefore": 
                    case "codePointAfter": 
                    case "codePointCount": 
                    case "offsetByCodePoints": 
                    case "substring": 
                    case "subSequence": {
                        return;
                    }
                    case "getChars": {
                        if (args.length != 4) break;
                        return;
                    }
                    case "indexOf": 
                    case "lastIndexOf": {
                        if (args.length < 1 || args.length > 2 || !TypeUtils.isJavaLangString(args[0].getType())) break;
                        return;
                    }
                    case "isEmpty": {
                        String sign = "==";
                        PsiExpression negation = BoolUtils.findNegation(call);
                        PsiExpression toReplace = call;
                        if (negation != null) {
                            sign = ">";
                            toReplace = negation;
                        }
                        PsiElementFactory factory = JavaPsiFacade.getElementFactory(variable.getProject());
                        PsiExpression emptyCheck = factory.createExpressionFromText(variable.getName() + ".length()" + sign + "0", call);
                        PsiElement callParent = toReplace.getParent();
                        if (callParent instanceof PsiExpression && ParenthesesUtils.areParenthesesNeeded(emptyCheck, (PsiExpression)callParent, true)) {
                            emptyCheck = factory.createExpressionFromText("(" + emptyCheck.getText() + ")", call);
                        }
                        ct.replace((PsiElement)toReplace, emptyCheck);
                        return;
                    }
                }
            }
            PsiExpression qualifier = Objects.requireNonNull(call.getMethodExpression().getQualifierExpression());
            ct.replace((PsiElement)qualifier, variable.getName() + ".toString()");
        }

        private void replaceInAssignment(PsiVariable variable, PsiVariable builderVariable, PsiAssignmentExpression assignment, CommentTracker ct) {
            PsiPolyadicExpression concat2;
            PsiExpression[] operands;
            PsiExpression rValue = PsiUtil.skipParenthesizedExprDown(assignment.getRExpression());
            String builderName = Objects.requireNonNull(builderVariable.getName());
            if (assignment.getOperationTokenType().equals(JavaTokenType.EQ) && rValue instanceof PsiPolyadicExpression && ((PsiPolyadicExpression)rValue).getOperationTokenType().equals(JavaTokenType.PLUS) && (operands = (concat2 = (PsiPolyadicExpression)rValue).getOperands()).length > 1) {
                if (ExpressionUtils.isReferenceTo(operands[0], variable)) {
                    StreamEx.iterate((Object)operands[1], Objects::nonNull, PsiElement::getNextSibling).forEach(ct::markUnchanged);
                    this.replaceAll(variable, builderVariable, rValue, ct, operands[0]::equals);
                    StringBuilder replacement = ChangeToAppendUtil.buildAppendExpression(rValue, false, new StringBuilder(builderName));
                    if (replacement != null) {
                        PsiMethodCallExpression qualifierCall;
                        PsiMethodCallExpression append = (PsiMethodCallExpression)ct.replace((PsiElement)assignment, replacement.toString());
                        while ((qualifierCall = MethodCallUtils.getQualifierMethodCall(append)) != null) {
                            append = qualifierCall;
                        }
                        PsiExpression qualifier = append.getMethodExpression().getQualifierExpression();
                        if (qualifier != null) {
                            append.replace(qualifier);
                        }
                    }
                    return;
                }
                PsiExpression lastOp = operands[operands.length - 1];
                if (ExpressionUtils.isReferenceTo(lastOp, variable)) {
                    ct.delete(concat2.getTokenBeforeOperand(lastOp), lastOp);
                    this.replaceAll(variable, builderVariable, rValue, ct);
                    ct.replace((PsiElement)assignment, builderName + ".insert(0," + ct.text(rValue) + ")");
                    return;
                }
            }
            if (rValue != null) {
                this.replaceAll(variable, builderVariable, rValue, ct);
                rValue = assignment.getRExpression();
            }
            if (assignment.getOperationTokenType().equals(JavaTokenType.PLUSEQ)) {
                StringBuilder sb;
                String replacement = "";
                if (rValue != null && (sb = ChangeToAppendUtil.buildAppendExpression(ct.markUnchanged(rValue), false, new StringBuilder(builderName))) != null) {
                    replacement = sb.toString();
                }
                ct.replace((PsiElement)assignment, replacement);
            } else if (assignment.getOperationTokenType().equals(JavaTokenType.EQ)) {
                ct.replace((PsiElement)assignment, builderName + "=" + this.generateNewStringBuilder(rValue, ct));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/StringConcatenationInLoopsInspection$AbstractStringBuilderFix", "generateNewStringBuilder"));
        }
    }

    private static class StringConcatenationInLoopsVisitor
    extends BaseInspectionVisitor {
        private StringConcatenationInLoopsVisitor() {
        }

        @Override
        public void visitPolyadicExpression(PsiPolyadicExpression expression) {
            super.visitPolyadicExpression(expression);
            PsiExpression[] operands = expression.getOperands();
            if (operands.length <= 1) {
                return;
            }
            IElementType tokenType = expression.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.PLUS)) {
                return;
            }
            if (!StringConcatenationInLoopsVisitor.checkExpression(expression)) {
                return;
            }
            if (ExpressionUtils.isEvaluatedAtCompileTime(expression)) {
                return;
            }
            if (!StringConcatenationInLoopsVisitor.isAppendedRepeatedly(expression)) {
                return;
            }
            PsiJavaToken sign = expression.getTokenBeforeOperand(operands[1]);
            assert (sign != null);
            this.registerError((PsiElement)sign, expression);
        }

        @Override
        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression) {
            if (expression == null) {
                StringConcatenationInLoopsVisitor.$$$reportNull$$$0(0);
            }
            super.visitAssignmentExpression(expression);
            if (expression.getRExpression() == null) {
                return;
            }
            PsiJavaToken sign = expression.getOperationSign();
            IElementType tokenType = sign.getTokenType();
            if (!tokenType.equals(JavaTokenType.PLUSEQ)) {
                return;
            }
            if (!StringConcatenationInLoopsVisitor.checkExpression(expression)) {
                return;
            }
            PsiExpression lhs = PsiUtil.skipParenthesizedExprDown(expression.getLExpression());
            if (!(lhs instanceof PsiReferenceExpression)) {
                return;
            }
            this.registerError((PsiElement)sign, expression);
        }

        private static boolean checkExpression(PsiExpression expression) {
            PsiVariable variable;
            if (!TypeUtils.isJavaLangString(expression.getType()) || ControlFlowUtils.isInExitStatement(expression) || !ControlFlowUtils.isInLoop(expression)) {
                return false;
            }
            PsiElement parent = expression;
            while (parent instanceof PsiParenthesizedExpression || parent instanceof PsiPolyadicExpression) {
                parent = parent.getParent();
            }
            if (parent != expression && parent instanceof PsiAssignmentExpression && ((PsiAssignmentExpression)parent).getOperationTokenType().equals(JavaTokenType.PLUSEQ)) {
                return false;
            }
            if (parent instanceof PsiAssignmentExpression && (variable = StringConcatenationInLoopsInspection.getAppendedVariable(expression = parent)) != null) {
                PsiLoopStatement commonLoop = StringConcatenationInLoopsInspection.getOutermostCommonLoop(expression, variable);
                return commonLoop != null && !ControlFlowUtils.isExecutedOnceInLoop(PsiTreeUtil.getParentOfType((PsiElement)expression, PsiStatement.class), commonLoop) && !StringConcatenationInLoopsVisitor.isUsedCompletely(variable, commonLoop);
            }
            return false;
        }

        private static boolean isUsedCompletely(PsiVariable variable, PsiLoopStatement loop) {
            boolean notUsedCompletely = ReferencesSearch.search(variable, new LocalSearchScope(loop)).forEach(ref -> {
                PsiExpression expression = ObjectUtils.tryCast(ref.getElement(), PsiExpression.class);
                if (expression == null) {
                    return true;
                }
                PsiElement parent = PsiUtil.skipParenthesizedExprUp(expression.getParent());
                while (parent instanceof PsiTypeCastExpression || parent instanceof PsiConditionalExpression) {
                    parent = PsiUtil.skipParenthesizedExprUp(expression.getParent());
                }
                if (parent instanceof PsiExpressionList || parent instanceof PsiAssignmentExpression && PsiTreeUtil.isAncestor(((PsiAssignmentExpression)parent).getRExpression(), expression, false)) {
                    PsiStatement statement = PsiTreeUtil.getParentOfType(parent, PsiStatement.class);
                    return ControlFlowUtils.isExecutedOnceInLoop(statement, loop) || ControlFlowUtils.isVariableReassigned(statement, variable);
                }
                return true;
            });
            return !notUsedCompletely;
        }

        @Nullable
        private static PsiCodeBlock getSurroundingBlock(PsiElement expression) {
            PsiElement body;
            Object parent = PsiTreeUtil.getParentOfType(expression, PsiMethod.class, PsiClassInitializer.class, PsiLambdaExpression.class);
            if (parent instanceof PsiMethod) {
                return ((PsiMethod)parent).getBody();
            }
            if (parent instanceof PsiClassInitializer) {
                return ((PsiClassInitializer)parent).getBody();
            }
            if (parent instanceof PsiLambdaExpression && (body = ((PsiLambdaExpression)parent).getBody()) instanceof PsiCodeBlock) {
                return (PsiCodeBlock)body;
            }
            return null;
        }

        private static boolean isAppendedRepeatedly(PsiExpression expression) {
            PsiElement parent = expression.getParent();
            while (parent instanceof PsiParenthesizedExpression || parent instanceof PsiPolyadicExpression) {
                parent = parent.getParent();
            }
            if (!(parent instanceof PsiAssignmentExpression)) {
                return false;
            }
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
            PsiExpression lhs = PsiUtil.skipParenthesizedExprDown(assignmentExpression.getLExpression());
            if (!(lhs instanceof PsiReferenceExpression)) {
                return false;
            }
            if (assignmentExpression.getOperationTokenType() == JavaTokenType.PLUSEQ) {
                return true;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lhs;
            PsiElement element = referenceExpression.resolve();
            if (!(element instanceof PsiVariable)) {
                return false;
            }
            PsiExpression rhs = assignmentExpression.getRExpression();
            return StringConcatenationInLoopsVisitor.isAppended(referenceExpression, rhs);
        }

        private static boolean isAppended(PsiReferenceExpression otherRef, PsiExpression expression) {
            PsiPolyadicExpression polyadicExpression;
            if ((expression = PsiUtil.skipParenthesizedExprDown(expression)) instanceof PsiPolyadicExpression && (polyadicExpression = (PsiPolyadicExpression)expression).getOperationTokenType().equals(JavaTokenType.PLUS)) {
                for (PsiExpression operand : polyadicExpression.getOperands()) {
                    if (!StringConcatenationInLoopsVisitor.isSameReference(operand, otherRef) && !StringConcatenationInLoopsVisitor.isAppended(otherRef, operand)) continue;
                    return true;
                }
            }
            return false;
        }

        private static boolean isSameReference(PsiExpression operand, PsiReferenceExpression ref) {
            PsiReferenceExpression other = ObjectUtils.tryCast(PsiUtil.skipParenthesizedExprDown(operand), PsiReferenceExpression.class);
            if (other == null) {
                return false;
            }
            String name = other.getReferenceName();
            if (name == null || !name.equals(ref.getReferenceName())) {
                return false;
            }
            PsiExpression qualifier = ref.getQualifierExpression();
            PsiExpression otherQualifier = other.getQualifierExpression();
            if (qualifier == null && otherQualifier == null) {
                return true;
            }
            if (qualifier == null && ref.resolve() instanceof PsiField) {
                qualifier = ExpressionUtils.getQualifierOrThis(ref);
            }
            if (otherQualifier == null && other.resolve() instanceof PsiField) {
                otherQualifier = ExpressionUtils.getQualifierOrThis(other);
            }
            if (qualifier == null || otherQualifier == null) {
                return false;
            }
            if (qualifier instanceof PsiReferenceExpression) {
                return StringConcatenationInLoopsVisitor.isSameReference(otherQualifier, (PsiReferenceExpression)qualifier);
            }
            return PsiEquivalenceUtil.areElementsEquivalent(qualifier, otherQualifier);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/performance/StringConcatenationInLoopsInspection$StringConcatenationInLoopsVisitor", "visitAssignmentExpression"));
        }
    }
}

