/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Function;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BoolUtils {
    private BoolUtils() {
    }

    public static boolean isNegation(@NotNull PsiExpression expression) {
        if (expression == null) {
            BoolUtils.$$$reportNull$$$0(0);
        }
        if (!(expression instanceof PsiPrefixExpression)) {
            return false;
        }
        PsiPrefixExpression prefixExp = (PsiPrefixExpression)expression;
        IElementType tokenType = prefixExp.getOperationTokenType();
        return JavaTokenType.EXCL.equals(tokenType);
    }

    public static boolean isNegated(PsiExpression exp) {
        PsiExpression ancestor = exp;
        PsiElement parent = ancestor.getParent();
        while (parent instanceof PsiParenthesizedExpression) {
            ancestor = (PsiExpression)parent;
            parent = ancestor.getParent();
        }
        return parent instanceof PsiExpression && BoolUtils.isNegation((PsiExpression)parent);
    }

    @Nullable
    public static PsiExpression getNegated(PsiExpression expression) {
        if (!(expression instanceof PsiPrefixExpression)) {
            return null;
        }
        PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression;
        IElementType tokenType = prefixExpression.getOperationTokenType();
        if (!JavaTokenType.EXCL.equals(tokenType)) {
            return null;
        }
        PsiExpression operand = prefixExpression.getOperand();
        return ParenthesesUtils.stripParentheses(operand);
    }

    @NotNull
    public static String getNegatedExpressionText(@Nullable PsiExpression condition) {
        String string = BoolUtils.getNegatedExpressionText(condition, 17);
        if (string == null) {
            BoolUtils.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static String getNegatedExpressionText(@Nullable PsiExpression expression, int precedence) {
        if (expression == null) {
            if ("" == null) {
                BoolUtils.$$$reportNull$$$0(2);
            }
            return "";
        }
        if (expression instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression;
            String string = '(' + BoolUtils.getNegatedExpressionText(parenthesizedExpression.getExpression()) + ')';
            if (string == null) {
                BoolUtils.$$$reportNull$$$0(3);
            }
            return string;
        }
        if (expression instanceof PsiConditionalExpression) {
            PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)expression;
            boolean needParenthesis = ParenthesesUtils.getPrecedence(conditionalExpression) >= precedence;
            String text2 = conditionalExpression.getCondition().getText() + '?' + BoolUtils.getNegatedExpressionText(conditionalExpression.getThenExpression()) + ':' + BoolUtils.getNegatedExpressionText(conditionalExpression.getElseExpression());
            String string = needParenthesis ? "(" + text2 + ")" : text2;
            if (string == null) {
                BoolUtils.$$$reportNull$$$0(4);
            }
            return string;
        }
        if (BoolUtils.isNegation(expression)) {
            PsiExpression negated = BoolUtils.getNegated(expression);
            if (negated == null) {
                if ("" == null) {
                    BoolUtils.$$$reportNull$$$0(5);
                }
                return "";
            }
            String string = ParenthesesUtils.getText(negated, precedence);
            if (string == null) {
                BoolUtils.$$$reportNull$$$0(6);
            }
            return string;
        }
        if (expression instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression;
            IElementType tokenType = polyadicExpression.getOperationTokenType();
            PsiExpression[] operands = polyadicExpression.getOperands();
            if (ComparisonUtils.isComparison(polyadicExpression)) {
                String negatedComparison = ComparisonUtils.getNegatedComparison(tokenType);
                StringBuilder result = new StringBuilder();
                boolean isEven = (operands.length & 1) != 1;
                int length = operands.length;
                for (int i2 = 0; i2 < length; ++i2) {
                    PsiExpression operand = operands[i2];
                    if (TypeUtils.hasFloatingPointType(operand)) {
                        String string = "!(" + polyadicExpression.getText() + ')';
                        if (string == null) {
                            BoolUtils.$$$reportNull$$$0(7);
                        }
                        return string;
                    }
                    if (i2 > 0) {
                        if (isEven && (i2 & 1) != 1) {
                            PsiJavaToken token = polyadicExpression.getTokenBeforeOperand(operand);
                            if (token != null) {
                                result.append(token.getText());
                            }
                        } else {
                            result.append(negatedComparison);
                        }
                    }
                    result.append(operand.getText());
                }
                String string = result.toString();
                if (string == null) {
                    BoolUtils.$$$reportNull$$$0(8);
                }
                return string;
            }
            if (tokenType.equals(JavaTokenType.ANDAND) || tokenType.equals(JavaTokenType.OROR)) {
                boolean needParenthesis;
                String targetToken;
                if (tokenType.equals(JavaTokenType.ANDAND)) {
                    targetToken = "||";
                    needParenthesis = 14 > precedence;
                } else {
                    targetToken = "&&";
                    needParenthesis = 13 > precedence;
                }
                Function<PsiElement, String> replacer = child -> {
                    if (child instanceof PsiExpression) {
                        return BoolUtils.getNegatedExpressionText((PsiExpression)child);
                    }
                    return child instanceof PsiJavaToken ? targetToken : child.getText();
                };
                String join = StringUtil.join(polyadicExpression.getChildren(), replacer, "");
                String string = needParenthesis ? '(' + join + ')' : join;
                if (string == null) {
                    BoolUtils.$$$reportNull$$$0(9);
                }
                return string;
            }
        }
        String string = '!' + ParenthesesUtils.getText(expression, 3);
        if (string == null) {
            BoolUtils.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Nullable
    public static PsiExpression findNegation(PsiExpression expression) {
        PsiPrefixExpression prefixAncestor;
        PsiExpression ancestor = expression;
        PsiElement parent = ancestor.getParent();
        while (parent instanceof PsiParenthesizedExpression) {
            ancestor = (PsiExpression)parent;
            parent = ancestor.getParent();
        }
        if (parent instanceof PsiPrefixExpression && JavaTokenType.EXCL.equals((prefixAncestor = (PsiPrefixExpression)parent).getOperationTokenType())) {
            return prefixAncestor;
        }
        return null;
    }

    public static boolean isBooleanLiteral(PsiExpression expression) {
        if (!((expression = ParenthesesUtils.stripParentheses(expression)) instanceof PsiLiteralExpression)) {
            return false;
        }
        PsiLiteralExpression literalExpression = (PsiLiteralExpression)expression;
        String text2 = literalExpression.getText();
        return "true".equals(text2) || "false".equals(text2);
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isTrue(@Nullable PsiExpression expression) {
        if ((expression = ParenthesesUtils.stripParentheses(expression)) == null) {
            return false;
        }
        return "true".equals(expression.getText());
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isFalse(@Nullable PsiExpression expression) {
        if ((expression = ParenthesesUtils.stripParentheses(expression)) == null) {
            return false;
        }
        return "false".equals(expression.getText());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/psiutils/BoolUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/psiutils/BoolUtils";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getNegatedExpressionText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isNegation";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

