/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.SerializationUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class SerializableStoresNonSerializableInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("serializable.stores.non.serializable.display.name", new Object[0]);
        if (string == null) {
            SerializableStoresNonSerializableInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiElement classOrLambda = (PsiElement)infos[0];
        PsiType type = (PsiType)infos[1];
        if (classOrLambda instanceof PsiClass) {
            PsiClass aClass = (PsiClass)classOrLambda;
            if (aClass instanceof PsiAnonymousClass) {
                String string = InspectionGadgetsBundle.message("serializable.anonymous.class.stores.non.serializable.problem.descriptor", type.getPresentableText());
                if (string == null) {
                    SerializableStoresNonSerializableInspection.$$$reportNull$$$0(1);
                }
                return string;
            }
            String string = InspectionGadgetsBundle.message("serializable.local.class.stores.non.serializable.problem.descriptor", type.getPresentableText(), aClass.getName());
            if (string == null) {
                SerializableStoresNonSerializableInspection.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("serializable.lambda.stores.non.serializable.problem.descriptor", type.getPresentableText());
        if (string == null) {
            SerializableStoresNonSerializableInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SerializableStoresNonSerializableVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/serialization/SerializableStoresNonSerializableInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class SerializableStoresNonSerializableVisitor
    extends BaseInspectionVisitor {
        private SerializableStoresNonSerializableVisitor() {
        }

        @Override
        public void visitClass(PsiClass aClass) {
            super.visitClass(aClass);
            PsiElement parent = aClass.getParent();
            if (!(parent instanceof PsiDeclarationStatement) && !(aClass instanceof PsiAnonymousClass)) {
                return;
            }
            if (!SerializationUtils.isSerializable(aClass)) {
                return;
            }
            LocalVariableReferenceFinder visitor = new LocalVariableReferenceFinder(aClass);
            for (PsiElement child = aClass.getLBrace(); child != null; child = child.getNextSibling()) {
                child.accept(visitor);
            }
        }

        @Override
        public void visitLambdaExpression(PsiLambdaExpression lambda2) {
            super.visitLambdaExpression(lambda2);
            PsiType type = lambda2.getFunctionalInterfaceType();
            if (!(type instanceof PsiClassType)) {
                return;
            }
            PsiClassType classType = (PsiClassType)type;
            PsiClass aClass = classType.resolve();
            if (!SerializationUtils.isSerializable(aClass)) {
                return;
            }
            lambda2.accept(new LocalVariableReferenceFinder(lambda2));
        }

        private class LocalVariableReferenceFinder
        extends JavaRecursiveElementWalkingVisitor {
            @NotNull
            private final PsiElement myClassOrLambda;

            public LocalVariableReferenceFinder(PsiElement classOrLambda) {
                if (classOrLambda == null) {
                    LocalVariableReferenceFinder.$$$reportNull$$$0(0);
                }
                this.myClassOrLambda = classOrLambda;
            }

            @Override
            public void visitReferenceExpression(PsiReferenceExpression expression) {
                super.visitReferenceExpression(expression);
                if (expression.getQualifierExpression() != null) {
                    return;
                }
                PsiType type = expression.getType();
                if (SerializationUtils.isProbablySerializable(type)) {
                    return;
                }
                PsiElement target = expression.resolve();
                if (!(target instanceof PsiLocalVariable) && !(target instanceof PsiParameter)) {
                    return;
                }
                PsiVariable variable = (PsiVariable)target;
                if (!(variable.hasModifierProperty("final") || PsiUtil.isLanguageLevel8OrHigher(variable) && HighlightControlFlowUtil.isEffectivelyFinal(variable, this.myClassOrLambda, expression))) {
                    return;
                }
                if (PsiTreeUtil.isAncestor(this.myClassOrLambda, variable, true)) {
                    return;
                }
                SerializableStoresNonSerializableVisitor.this.registerError(expression, new Object[]{this.myClassOrLambda, type});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrLambda", "com/siyeh/ig/serialization/SerializableStoresNonSerializableInspection$SerializableStoresNonSerializableVisitor$LocalVariableReferenceFinder", "<init>"));
            }
        }
    }
}

