/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.testFrameworks;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ImportUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.testFrameworks.AssertHint;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class SimplifiableAssertionInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("simplifiable.junit.assertion.problem.descriptor", infos[0]);
        if (string == null) {
            SimplifiableAssertionInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new SimplifyAssertFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SimplifiableJUnitAssertionVisitor();
    }

    protected abstract boolean checkTestNG();

    static boolean isAssertThatCouldBeFail(PsiExpression position, boolean checkTrue) {
        return (checkTrue ? "true" : "false").equals(position.getText());
    }

    boolean isAssertEqualsThatCouldBeAssertLiteral(PsiMethodCallExpression expression) {
        AssertHint assertHint = AssertHint.createAssertEqualsHint(expression, this.checkTestNG());
        if (assertHint == null) {
            return false;
        }
        PsiExpressionList argumentList = expression.getArgumentList();
        PsiExpression[] arguments = argumentList.getExpressions();
        int argIndex = assertHint.getArgIndex();
        PsiExpression firstTestArgument = arguments[argIndex];
        PsiExpression secondTestArgument = arguments[argIndex + 1];
        if (firstTestArgument == null || secondTestArgument == null) {
            return false;
        }
        return SimplifiableAssertionInspection.isSimpleLiteral(firstTestArgument, secondTestArgument) || SimplifiableAssertionInspection.isSimpleLiteral(secondTestArgument, firstTestArgument);
    }

    static boolean isSimpleLiteral(PsiExpression expression1, PsiExpression expression2) {
        if (!(expression1 instanceof PsiLiteralExpression)) {
            return false;
        }
        String text2 = expression1.getText();
        if ("null".equals(text2)) {
            return true;
        }
        if (!"true".equals(text2) && !"false".equals(text2)) {
            return false;
        }
        PsiType type = expression2.getType();
        return PsiType.BOOLEAN.equals(type);
    }

    private static boolean isEqualityComparison(PsiExpression expression) {
        if (expression instanceof PsiBinaryExpression) {
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
            IElementType tokenType = binaryExpression.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.EQEQ)) {
                return false;
            }
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiExpression rhs = binaryExpression.getROperand();
            if (rhs == null) {
                return false;
            }
            PsiType type = lhs.getType();
            return type != null && TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(type);
        }
        if (expression instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)expression;
            if (!MethodCallUtils.isEqualsCall(call)) {
                return false;
            }
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            return methodExpression.getQualifierExpression() != null;
        }
        return false;
    }

    private static boolean isIdentityComparison(PsiExpression expression) {
        if (!(expression instanceof PsiBinaryExpression)) {
            return false;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
        if (!ComparisonUtils.isEqualityComparison(binaryExpression)) {
            return false;
        }
        PsiExpression rhs = binaryExpression.getROperand();
        if (rhs == null) {
            return false;
        }
        PsiExpression lhs = binaryExpression.getLOperand();
        PsiType lhsType = lhs.getType();
        if (lhsType instanceof PsiPrimitiveType) {
            return false;
        }
        PsiType rhsType = rhs.getType();
        return !(rhsType instanceof PsiPrimitiveType);
    }

    private static boolean isAssertTrue(AssertHint assertTrueFalseHint) {
        return "assertTrue".equals(assertTrueFalseHint.getMethod().getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/testFrameworks/SimplifiableAssertionInspection", "buildErrorString"));
    }

    private class SimplifiableJUnitAssertionVisitor
    extends BaseInspectionVisitor {
        private SimplifiableJUnitAssertionVisitor() {
        }

        @Override
        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                SimplifiableJUnitAssertionVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression);
            if (SimplifiableAssertionInspection.this.isAssertEqualsThatCouldBeAssertLiteral(expression)) {
                this.registerMethodCallError(expression, this.getReplacementMethodName(expression));
            } else {
                AssertHint assertTrueFalseHint = AssertHint.createAssertTrueFalseHint(expression, SimplifiableAssertionInspection.this.checkTestNG());
                if (assertTrueFalseHint == null) {
                    return;
                }
                boolean assertTrue = SimplifiableAssertionInspection.isAssertTrue(assertTrueFalseHint);
                PsiExpression position = assertTrueFalseHint.getPosition(expression.getArgumentList().getExpressions());
                if (ComparisonUtils.isNullComparison(position)) {
                    this.registerMethodCallError(expression, this.hasEqEqExpressionArgument(position) ? "assertNull()" : "assertNotNull()");
                } else if (SimplifiableAssertionInspection.isIdentityComparison(position)) {
                    this.registerMethodCallError(expression, this.hasEqEqExpressionArgument(position) ? "assertSame()" : "assertNotSame()");
                } else if (assertTrue && SimplifiableAssertionInspection.isEqualityComparison(position)) {
                    this.registerMethodCallError(expression, "assertEquals()");
                } else if (SimplifiableAssertionInspection.isAssertThatCouldBeFail(position, !assertTrue)) {
                    this.registerMethodCallError(expression, "fail()");
                }
            }
        }

        @NonNls
        private String getReplacementMethodName(PsiMethodCallExpression expression) {
            PsiLiteralExpression literalExpression;
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            PsiExpression firstArgument = arguments[0];
            PsiExpression secondArgument = arguments[1];
            if (firstArgument instanceof PsiLiteralExpression) {
                literalExpression = (PsiLiteralExpression)firstArgument;
            } else if (secondArgument instanceof PsiLiteralExpression) {
                literalExpression = (PsiLiteralExpression)secondArgument;
            } else {
                return "";
            }
            Object value = literalExpression.getValue();
            if (value == Boolean.TRUE) {
                return "assertTrue()";
            }
            if (value == Boolean.FALSE) {
                return "assertFalse()";
            }
            if (value == null) {
                return "assertNull()";
            }
            return "";
        }

        private boolean hasEqEqExpressionArgument(PsiExpression argument) {
            if (!(argument instanceof PsiBinaryExpression)) {
                return false;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)argument;
            IElementType tokenType = binaryExpression.getOperationTokenType();
            return JavaTokenType.EQEQ.equals(tokenType);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/testFrameworks/SimplifiableAssertionInspection$SimplifiableJUnitAssertionVisitor", "visitMethodCallExpression"));
        }
    }

    private class SimplifyAssertFix
    extends InspectionGadgetsFix {
        private SimplifyAssertFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("simplify.junit.assertion.simplify.quickfix", new Object[0]);
            if (string == null) {
                SimplifyAssertFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement methodNameIdentifier = descriptor.getPsiElement();
            PsiElement parent = methodNameIdentifier.getParent();
            if (parent == null) {
                return;
            }
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)parent.getParent();
            if (SimplifiableAssertionInspection.this.isAssertEqualsThatCouldBeAssertLiteral(callExpression)) {
                this.replaceAssertEqualsWithAssertLiteral(callExpression);
            } else {
                AssertHint assertTrueFalseHint = AssertHint.createAssertTrueFalseHint(callExpression, SimplifiableAssertionInspection.this.checkTestNG());
                if (assertTrueFalseHint == null) {
                    return;
                }
                boolean assertTrue = SimplifiableAssertionInspection.isAssertTrue(assertTrueFalseHint);
                PsiExpression position = assertTrueFalseHint.getPosition(callExpression.getArgumentList().getExpressions());
                if (ComparisonUtils.isNullComparison(position)) {
                    this.replaceAssertWithAssertNull(callExpression, (PsiBinaryExpression)position, assertTrueFalseHint.getMessage(), assertTrueFalseHint.getArgIndex());
                } else if (SimplifiableAssertionInspection.isIdentityComparison(position)) {
                    this.replaceAssertWithAssertSame(callExpression, (PsiBinaryExpression)position, assertTrueFalseHint.getMessage(), assertTrueFalseHint.getArgIndex());
                } else if (assertTrue && SimplifiableAssertionInspection.isEqualityComparison(position)) {
                    this.replaceAssertTrueWithAssertEquals(callExpression, position, assertTrueFalseHint.getMessage(), assertTrueFalseHint.getArgIndex());
                } else if (SimplifiableAssertionInspection.isAssertThatCouldBeFail(position, !assertTrue)) {
                    this.replaceAssertWithFail(callExpression, assertTrueFalseHint.getMessage());
                }
            }
        }

        private void addStaticImportOrQualifier(String methodName, PsiMethodCallExpression originalMethodCall, StringBuilder out) {
            PsiReferenceExpression methodExpression = originalMethodCall.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                PsiMethod method = originalMethodCall.resolveMethod();
                if (method == null) {
                    return;
                }
                PsiClass containingClass = method.getContainingClass();
                if (containingClass == null) {
                    return;
                }
                String className = containingClass.getQualifiedName();
                if (className == null) {
                    return;
                }
                if (!ImportUtils.addStaticImport(className, methodName, originalMethodCall)) {
                    out.append(className).append(".");
                }
            } else {
                out.append(qualifier.getText()).append('.');
            }
        }

        private void replaceAssertWithFail(PsiMethodCallExpression callExpression, PsiExpression message) {
            StringBuilder newExpression = new StringBuilder();
            this.addStaticImportOrQualifier("fail", callExpression, newExpression);
            newExpression.append("fail(");
            if (message != null) {
                newExpression.append(message.getText());
            }
            newExpression.append(')');
            PsiReplacementUtil.replaceExpressionAndShorten(callExpression, newExpression.toString());
        }

        private void replaceAssertTrueWithAssertEquals(PsiMethodCallExpression callExpression, PsiExpression position, PsiExpression message, int positionIndex) {
            PsiExpression lhs = null;
            PsiExpression rhs = null;
            if (position instanceof PsiBinaryExpression) {
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)position;
                lhs = binaryExpression.getLOperand();
                rhs = binaryExpression.getROperand();
            } else if (position instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression call = (PsiMethodCallExpression)position;
                PsiReferenceExpression equalityMethodExpression = call.getMethodExpression();
                PsiExpressionList equalityArgumentList = call.getArgumentList();
                PsiExpression[] equalityArgs = equalityArgumentList.getExpressions();
                rhs = equalityArgs[0];
                lhs = equalityMethodExpression.getQualifierExpression();
            }
            if (!(lhs instanceof PsiLiteralExpression) && rhs instanceof PsiLiteralExpression) {
                PsiExpression temp = lhs;
                lhs = rhs;
                rhs = temp;
            }
            if (lhs == null || rhs == null) {
                return;
            }
            StringBuilder newExpression = new StringBuilder();
            String methodName = "assertEquals";
            StringBuilder buf = new StringBuilder();
            PsiType lhsType = lhs.getType();
            PsiType rhsType = rhs.getType();
            if (lhsType != null && rhsType != null && PsiUtil.isLanguageLevel5OrHigher(lhs)) {
                if (this.isPrimitiveAndBoxedInteger(lhsType, rhsType)) {
                    PsiPrimitiveType unboxedType = PsiPrimitiveType.getUnboxedType(rhsType);
                    assert (unboxedType != null);
                    buf.append(lhs.getText()).append(",(").append(unboxedType.getCanonicalText()).append(')').append(rhs.getText());
                } else if (this.isPrimitiveAndBoxedInteger(rhsType, lhsType)) {
                    PsiPrimitiveType unboxedType = PsiPrimitiveType.getUnboxedType(lhsType);
                    assert (unboxedType != null);
                    buf.append('(').append(unboxedType.getCanonicalText()).append(')').append(lhs.getText()).append(',').append(rhs.getText());
                } else {
                    buf.append(lhs.getText()).append(',').append(rhs.getText());
                }
            } else {
                buf.append(lhs.getText()).append(',').append(rhs.getText());
            }
            if (TypeUtils.hasFloatingPointType(lhs) || TypeUtils.hasFloatingPointType(rhs) || this.isPrimitiveAndBoxedFloat(lhsType, rhsType) || this.isPrimitiveAndBoxedFloat(rhsType, lhsType)) {
                buf.append(",0.0");
            }
            this.compoundMethodCall(callExpression, "assertEquals", message, positionIndex, buf.toString(), newExpression);
            PsiReplacementUtil.replaceExpressionAndShorten(callExpression, newExpression.toString());
        }

        private boolean isPrimitiveAndBoxedInteger(PsiType lhsType, PsiType rhsType) {
            return lhsType instanceof PsiPrimitiveType && rhsType instanceof PsiClassType && PsiType.LONG.isAssignableFrom(rhsType);
        }

        private boolean isPrimitiveAndBoxedFloat(PsiType lhsType, PsiType rhsType) {
            return lhsType instanceof PsiPrimitiveType && rhsType instanceof PsiClassType && PsiType.DOUBLE.equals(rhsType) && PsiType.FLOAT.equals(rhsType);
        }

        private void replaceAssertWithAssertNull(PsiMethodCallExpression callExpression, PsiBinaryExpression binaryExpression, PsiExpression message, int positionIndex) {
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiExpression rhs = binaryExpression.getROperand();
            if (rhs == null) {
                return;
            }
            IElementType tokenType = binaryExpression.getOperationTokenType();
            if (!(lhs instanceof PsiLiteralExpression) && rhs instanceof PsiLiteralExpression) {
                rhs = lhs;
            }
            StringBuilder newExpression = new StringBuilder();
            PsiReferenceExpression methodExpression = callExpression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            String memberName = "assertFalse".equals(methodName) ^ tokenType.equals(JavaTokenType.NE) ? "assertNotNull" : "assertNull";
            this.compoundMethodCall(callExpression, memberName, message, positionIndex, rhs.getText(), newExpression);
            PsiReplacementUtil.replaceExpressionAndShorten(callExpression, newExpression.toString());
        }

        private void compoundMethodCall(PsiMethodCallExpression callExpression, String methodName, PsiExpression message, int positionIndex, String args, StringBuilder newExpression) {
            this.addStaticImportOrQualifier(methodName, callExpression, newExpression);
            newExpression.append(methodName).append('(');
            if (message != null && positionIndex != 0) {
                newExpression.append(message.getText()).append(',');
            }
            newExpression.append(args);
            if (message != null && positionIndex == 0) {
                newExpression.append(',').append(message.getText());
            }
            newExpression.append(')');
        }

        private void replaceAssertWithAssertSame(PsiMethodCallExpression callExpression, PsiBinaryExpression position, PsiExpression message, int positionIndex) {
            PsiExpression lhs = position.getLOperand();
            PsiExpression rhs = position.getROperand();
            IElementType tokenType = position.getOperationTokenType();
            if (!(lhs instanceof PsiLiteralExpression) && rhs instanceof PsiLiteralExpression) {
                PsiExpression temp = lhs;
                lhs = rhs;
                rhs = temp;
            }
            if (rhs == null) {
                return;
            }
            StringBuilder newExpression = new StringBuilder();
            PsiReferenceExpression methodExpression = callExpression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            String memberName = "assertFalse".equals(methodName) ^ tokenType.equals(JavaTokenType.NE) ? "assertNotSame" : "assertSame";
            this.compoundMethodCall(callExpression, memberName, message, positionIndex, lhs.getText() + "," + rhs.getText(), newExpression);
            PsiReplacementUtil.replaceExpressionAndShorten(callExpression, newExpression.toString());
        }

        private void replaceAssertEqualsWithAssertLiteral(PsiMethodCallExpression callExpression) {
            String compareValue;
            String literalValue;
            PsiExpression secondTestArgument;
            int argIndex;
            AssertHint assertHint = AssertHint.createAssertEqualsHint(callExpression, SimplifiableAssertionInspection.this.checkTestNG());
            if (assertHint == null) {
                return;
            }
            PsiExpressionList argumentList = callExpression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            PsiExpression firstTestArgument = arguments[argIndex = assertHint.getArgIndex()];
            if (SimplifiableAssertionInspection.isSimpleLiteral(firstTestArgument, secondTestArgument = arguments[argIndex + 1])) {
                literalValue = firstTestArgument.getText();
                compareValue = secondTestArgument.getText();
            } else {
                literalValue = secondTestArgument.getText();
                compareValue = firstTestArgument.getText();
            }
            String uppercaseLiteralValue = Character.toUpperCase(literalValue.charAt(0)) + literalValue.substring(1);
            StringBuilder newExpression = new StringBuilder();
            String methodName = "assert" + uppercaseLiteralValue;
            this.compoundMethodCall(callExpression, methodName, assertHint.getMessage(), argIndex, compareValue, newExpression);
            PsiReplacementUtil.replaceExpressionAndShorten(callExpression, newExpression.toString());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/testFrameworks/SimplifiableAssertionInspection$SimplifyAssertFix", "getFamilyName"));
        }
    }
}

