/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWildcardType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.threading.ThreadingUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SynchronizeOnThisInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("synchronize.on.this.display.name", new Object[0]);
        if (string == null) {
            SynchronizeOnThisInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        boolean syncOnClass = (Boolean)infos[0];
        String string = InspectionGadgetsBundle.message(syncOnClass ? "synchronize.on.class.problem.descriptor" : "synchronize.on.this.problem.descriptor", new Object[0]);
        if (string == null) {
            SynchronizeOnThisInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SynchronizeOnThisVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/threading/SynchronizeOnThisInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class SynchronizeOnThisVisitor
    extends BaseInspectionVisitor {
        private SynchronizeOnThisVisitor() {
        }

        @Override
        public void visitSynchronizedStatement(@NotNull PsiSynchronizedStatement statement) {
            if (statement == null) {
                SynchronizeOnThisVisitor.$$$reportNull$$$0(0);
            }
            super.visitSynchronizedStatement(statement);
            PsiExpression lockExpression = ParenthesesUtils.stripParentheses(statement.getLockExpression());
            if (lockExpression instanceof PsiThisExpression) {
                this.registerError((PsiElement)lockExpression, Boolean.FALSE);
            } else if (SynchronizeOnThisVisitor.hasJavaLangClassType(lockExpression)) {
                this.registerError((PsiElement)lockExpression, Boolean.TRUE);
            }
        }

        @Override
        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                SynchronizeOnThisVisitor.$$$reportNull$$$0(1);
            }
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            if (!ThreadingUtils.isNotifyOrNotifyAllCall(expression) && !ThreadingUtils.isWaitCall(expression)) {
                return;
            }
            PsiExpression qualifier = ParenthesesUtils.stripParentheses(methodExpression.getQualifierExpression());
            if (qualifier == null || qualifier instanceof PsiThisExpression) {
                this.registerMethodCallError(expression, Boolean.FALSE);
            } else if (SynchronizeOnThisVisitor.hasJavaLangClassType(qualifier)) {
                this.registerMethodCallError(expression, Boolean.TRUE);
            }
        }

        private static boolean hasJavaLangClassType(@Nullable PsiExpression expression) {
            if (expression == null) {
                return false;
            }
            PsiType type = expression.getType();
            if (!(type instanceof PsiClassType)) {
                return false;
            }
            PsiClassType classType = (PsiClassType)type;
            PsiClassType javaLangClassType = TypeUtils.getType("java.lang.Class", expression);
            if (!javaLangClassType.isAssignableFrom(classType)) {
                return false;
            }
            PsiType[] parameters = classType.getParameters();
            if (parameters.length == 0) {
                return true;
            }
            if (parameters.length > 1) {
                return false;
            }
            PsiType parameterType = parameters[0];
            if (SynchronizeOnThisVisitor.isPrivateClassType(parameterType)) {
                return true;
            }
            if (!(parameterType instanceof PsiCapturedWildcardType)) {
                return false;
            }
            PsiCapturedWildcardType capturedWildcardType = (PsiCapturedWildcardType)parameterType;
            PsiWildcardType wildcardType = capturedWildcardType.getWildcard();
            PsiType extendsBoundType = wildcardType.getExtendsBound();
            return SynchronizeOnThisVisitor.isPrivateClassType(extendsBoundType);
        }

        private static boolean isPrivateClassType(PsiType type) {
            if (!(type instanceof PsiClassType)) {
                return false;
            }
            PsiClassType extendsBoundClassType = (PsiClassType)type;
            PsiClass aClass = extendsBoundClassType.resolve();
            return aClass == null || !aClass.hasModifierProperty("private");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/threading/SynchronizeOnThisInspection$SynchronizeOnThisVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSynchronizedStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

