/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.impl.file.PsiBinaryFileImpl;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;

public class ClassFileViewProvider
extends SingleRootFileViewProvider {
    private static final Key<Boolean> IS_INNER_CLASS = Key.create("java.is.inner.class.key");

    public ClassFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile file) {
        if (manager == null) {
            ClassFileViewProvider.$$$reportNull$$$0(0);
        }
        if (file == null) {
            ClassFileViewProvider.$$$reportNull$$$0(1);
        }
        this(manager, file, true);
    }

    public ClassFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile file, boolean eventSystemEnabled) {
        if (manager == null) {
            ClassFileViewProvider.$$$reportNull$$$0(2);
        }
        if (file == null) {
            ClassFileViewProvider.$$$reportNull$$$0(3);
        }
        super(manager, file, eventSystemEnabled, JavaLanguage.INSTANCE, JavaClassFileType.INSTANCE);
    }

    @Override
    protected PsiFile createFile(@NotNull Project project, @NotNull VirtualFile file, @NotNull FileType fileType) {
        FileIndexFacade fileIndex;
        if (project == null) {
            ClassFileViewProvider.$$$reportNull$$$0(4);
        }
        if (file == null) {
            ClassFileViewProvider.$$$reportNull$$$0(5);
        }
        if (fileType == null) {
            ClassFileViewProvider.$$$reportNull$$$0(6);
        }
        if (!(fileIndex = ServiceManager.getService(project, FileIndexFacade.class)).isInLibraryClasses(file) && fileIndex.isInSource(file)) {
            return new PsiBinaryFileImpl((PsiManagerImpl)this.getManager(), this);
        }
        try {
            if (!ClassFileViewProvider.isInnerClass(file)) {
                return new ClsFileImpl(this);
            }
        }
        catch (Exception e) {
            Logger.getInstance(ClassFileViewProvider.class).debug(file.getPath(), e);
        }
        return null;
    }

    public static boolean isInnerClass(@NotNull VirtualFile file) {
        if (file == null) {
            ClassFileViewProvider.$$$reportNull$$$0(7);
        }
        return ClassFileViewProvider.detectInnerClass(file, null);
    }

    public static boolean isInnerClass(@NotNull VirtualFile file, @NotNull byte[] content) {
        if (file == null) {
            ClassFileViewProvider.$$$reportNull$$$0(8);
        }
        if (content == null) {
            ClassFileViewProvider.$$$reportNull$$$0(9);
        }
        return ClassFileViewProvider.detectInnerClass(file, content);
    }

    private static boolean detectInnerClass(VirtualFile file, @Nullable byte[] content) {
        String name = file.getNameWithoutExtension();
        int p = name.lastIndexOf(36, name.length() - 2);
        if (p <= 0) {
            return false;
        }
        Boolean isInner = IS_INNER_CLASS.get(file);
        if (isInner != null) {
            return isInner;
        }
        if (content == null) {
            try {
                content = file.contentsToByteArray(false);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        ClassReader reader = new ClassReader(content);
        final Ref<Boolean> ref = Ref.create(Boolean.FALSE);
        final String className = reader.getClassName();
        reader.accept(new ClassVisitor(393216){

            public void visitOuterClass(String owner, String name, String desc) {
                ref.set(Boolean.TRUE);
            }

            public void visitInnerClass(String name, String outer, String inner, int access) {
                if (className.equals(name)) {
                    ref.set(Boolean.TRUE);
                }
            }
        }, ClsFileImpl.EMPTY_ATTRIBUTES, 7);
        isInner = ref.get();
        IS_INNER_CLASS.set(file, isInner);
        return isInner;
    }

    @Override
    @NotNull
    public SingleRootFileViewProvider createCopy(@NotNull VirtualFile copy) {
        if (copy == null) {
            ClassFileViewProvider.$$$reportNull$$$0(10);
        }
        ClassFileViewProvider classFileViewProvider = new ClassFileViewProvider(this.getManager(), copy, false);
        if (classFileViewProvider == null) {
            ClassFileViewProvider.$$$reportNull$$$0(11);
        }
        return classFileViewProvider;
    }

    @Override
    public PsiElement findElementAt(int offset) {
        return this.findElementAt(offset, this.getBaseLanguage());
    }

    @Override
    public PsiElement findElementAt(int offset, @NotNull Language language) {
        PsiFile file;
        if (language == null) {
            ClassFileViewProvider.$$$reportNull$$$0(12);
        }
        if ((file = this.getPsi(language)) instanceof PsiCompiledFile) {
            file = ((PsiCompiledFile)file).getDecompiledPsiFile();
        }
        return ClassFileViewProvider.findElementAt(file, offset);
    }

    @Override
    public PsiReference findReferenceAt(int offset) {
        return this.findReferenceAt(offset, this.getBaseLanguage());
    }

    @Override
    @Nullable
    public PsiReference findReferenceAt(int offset, @NotNull Language language) {
        PsiFile file;
        if (language == null) {
            ClassFileViewProvider.$$$reportNull$$$0(13);
        }
        if ((file = this.getPsi(language)) instanceof PsiCompiledFile) {
            file = ((PsiCompiledFile)file).getDecompiledPsiFile();
        }
        return ClassFileViewProvider.findReferenceAt(file, offset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copy";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/ClassFileViewProvider";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/ClassFileViewProvider";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createCopy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isInnerClass";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createCopy";
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findElementAt";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findReferenceAt";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

