/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.SubstrateRef;
import com.intellij.psi.impl.source.tree.AstPath;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.reference.SoftReference;
import com.intellij.util.containers.ContainerUtil;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AstPathPsiMap {
    private final ConcurrentMap<AstPath, MyReference> myMap;
    private static final Key<MyReferenceQueue> STUB_PSI_REFS = Key.create("STUB_PSI_REFS");
    private final MyReferenceQueue myQueue;

    AstPathPsiMap(@NotNull Project project) {
        if (project == null) {
            AstPathPsiMap.$$$reportNull$$$0(0);
        }
        this.myMap = ContainerUtil.newConcurrentMap();
        MyReferenceQueue queue = project.getUserData(STUB_PSI_REFS);
        this.myQueue = queue != null ? queue : ((UserDataHolderEx)((Object)project)).putUserDataIfAbsent(STUB_PSI_REFS, new MyReferenceQueue(project));
    }

    void invalidatePsi() {
        this.myQueue.cleanupStaleReferences();
        for (MyReference reference : this.myMap.values()) {
            StubBasedPsiElementBase psi = (StubBasedPsiElementBase)SoftReference.dereference(reference);
            if (psi == null) continue;
            DebugUtil.onInvalidated(psi);
            psi.setSubstrateRef(SubstrateRef.createInvalidRef(psi));
        }
        this.myMap.clear();
    }

    void switchToStrongRefs() {
        this.myQueue.cleanupStaleReferences();
        for (MyReference reference : this.myMap.values()) {
            StubBasedPsiElementBase psi = (StubBasedPsiElementBase)SoftReference.dereference(reference);
            if (psi == null) continue;
            CompositeElement node = (CompositeElement)psi.getNode();
            node.setPsi(psi);
            psi.setSubstrateRef(SubstrateRef.createAstStrongRef(node));
        }
        this.myMap.clear();
    }

    @Nullable
    StubBasedPsiElementBase<?> getCachedPsi(@NotNull AstPath ref) {
        if (ref == null) {
            AstPathPsiMap.$$$reportNull$$$0(1);
        }
        return (StubBasedPsiElementBase)SoftReference.dereference((Reference)this.myMap.get(ref));
    }

    @NotNull
    StubBasedPsiElementBase<?> cachePsi(@NotNull AstPath key, @NotNull StubBasedPsiElementBase psi) {
        if (key == null) {
            AstPathPsiMap.$$$reportNull$$$0(2);
        }
        if (psi == null) {
            AstPathPsiMap.$$$reportNull$$$0(3);
        }
        this.myQueue.cleanupStaleReferences();
        psi.setSubstrateRef(key);
        this.myMap.put(key, new MyReference(psi, key, this.myQueue));
        StubBasedPsiElementBase stubBasedPsiElementBase = psi;
        if (stubBasedPsiElementBase == null) {
            AstPathPsiMap.$$$reportNull$$$0(4);
        }
        return stubBasedPsiElementBase;
    }

    List<StubBasedPsiElementBase<?>> getAllCachedPsi() {
        this.myQueue.cleanupStaleReferences();
        if (this.myMap.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<StubBasedPsiElementBase<?>> result = ContainerUtil.newArrayList();
        for (MyReference reference : this.myMap.values()) {
            ContainerUtil.addIfNotNull(result, reference.get());
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/AstPathPsiMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/AstPathPsiMap";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "cachePsi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCachedPsi";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "cachePsi";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyReferenceQueue
    extends ReferenceQueue<StubBasedPsiElementBase<?>> {
        MyReferenceQueue(Project project) {
            LowMemoryWatcher.register(() -> this.cleanupStaleReferences(), project);
        }

        void cleanupStaleReferences() {
            MyReference reference;
            while ((reference = (MyReference)this.poll()) != null) {
                AstPath key = reference.pathRef;
                key.getContainingFile().getRefToPsi().myMap.remove(key, reference);
            }
        }
    }

    private static class MyReference
    extends WeakReference<StubBasedPsiElementBase<?>> {
        final AstPath pathRef;

        MyReference(StubBasedPsiElementBase psi, AstPath ref, ReferenceQueue<StubBasedPsiElementBase<?>> queue) {
            super(psi, queue);
            this.pathRef = ref;
        }
    }
}

