/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.diagnostic.ThreadDumper;
import com.intellij.extapi.psi.ASTDelegatePsiElement;
import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.tree.events.TreeChangeEvent;
import com.intellij.pom.tree.events.impl.ChangeInfoImpl;
import com.intellij.pom.tree.events.impl.ReplaceChangeInfoImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.FreeThreadedFileViewProvider;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.DummyHolderElement;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.AstBufferUtil;
import com.intellij.psi.impl.source.tree.AstPath;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import com.intellij.psi.impl.source.tree.LazyParseableElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeElementVisitor;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.AtomicFieldUpdater;
import com.intellij.util.text.StringFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeElement
extends TreeElement {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.CompositeElement");
    public static final CompositeElement[] EMPTY_ARRAY = new CompositeElement[0];
    private TreeElement firstChild;
    private TreeElement lastChild;
    private volatile int myCachedLength;
    private volatile int myHC;
    private volatile PsiElement myWrapper;
    private static final boolean ASSERT_THREADING = true;
    private static final AtomicFieldUpdater<CompositeElement, PsiElement> ourPsiUpdater = AtomicFieldUpdater.forFieldOfType(CompositeElement.class, PsiElement.class);

    public CompositeElement(@NotNull IElementType type) {
        if (type == null) {
            CompositeElement.$$$reportNull$$$0(0);
        }
        super(type);
        this.myCachedLength = -1;
        this.myHC = -1;
    }

    @Override
    @NotNull
    public CompositeElement clone() {
        CompositeElement clone = (CompositeElement)super.clone();
        clone.firstChild = null;
        clone.lastChild = null;
        clone.myWrapper = null;
        for (ASTNode child = this.rawFirstChild(); child != null; child = child.getTreeNext()) {
            clone.rawAddChildrenWithoutNotifications((TreeElement)child.clone());
        }
        clone.clearCaches();
        CompositeElement compositeElement = clone;
        if (compositeElement == null) {
            CompositeElement.$$$reportNull$$$0(1);
        }
        return compositeElement;
    }

    public void subtreeChanged() {
        for (CompositeElement compositeElement = this; compositeElement != null; compositeElement = compositeElement.getTreeParent()) {
            compositeElement.clearCaches();
            if (compositeElement instanceof PsiElement) continue;
            PsiElement psi = compositeElement.myWrapper;
            if (psi instanceof ASTDelegatePsiElement) {
                ((ASTDelegatePsiElement)psi).subtreeChanged();
                continue;
            }
            if (!(psi instanceof PsiFile)) continue;
            ((PsiFile)psi).subtreeChanged();
        }
    }

    @Override
    public void clearCaches() {
        this.assertThreading();
        this.myCachedLength = -1;
        this.myHC = -1;
        CompositeElement.clearRelativeOffsets(this.rawFirstChild());
    }

    private void assertThreading() {
        boolean ok;
        boolean bl = ok = ApplicationManager.getApplication().isWriteAccessAllowed() || this.isNonPhysicalOrInjected();
        if (!ok) {
            LOG.error("Threading assertion. " + this.getThreadingDiagnostics());
        }
    }

    private String getThreadingDiagnostics() {
        FileElement fileElement = TreeUtil.getFileElement(this);
        PsiFile psiFile = fileElement == null ? null : (PsiFile)fileElement.getPsi();
        return " Under write: " + ApplicationManager.getApplication().isWriteAccessAllowed() + "; wrapper: " + this.myWrapper + "; wrapper.isPhysical(): " + (this.myWrapper != null && this.myWrapper.isPhysical()) + "; fileElement: " + fileElement + "; psiFile: " + psiFile + "; psiFile.getViewProvider(): " + (psiFile == null ? null : psiFile.getViewProvider()) + "; psiFile.isPhysical(): " + (psiFile != null && psiFile.isPhysical()) + "; nonPhysicalOrInjected: " + this.isNonPhysicalOrInjected();
    }

    private boolean isNonPhysicalOrInjected() {
        PsiElement wrapper;
        FileElement fileElement = TreeUtil.getFileElement(this);
        if (fileElement == null || fileElement instanceof DummyHolderElement) {
            return true;
        }
        if (fileElement.getTreeParent() != null) {
            return true;
        }
        PsiElement psiElement = wrapper = this instanceof PsiElement ? (PsiElement)((Object)this) : this.myWrapper;
        if (wrapper == null) {
            return true;
        }
        PsiFile psiFile = wrapper.getContainingFile();
        return psiFile == null || psiFile instanceof DummyHolder || psiFile.getViewProvider() instanceof FreeThreadedFileViewProvider || !psiFile.isPhysical();
    }

    @Override
    public void acceptTree(TreeElementVisitor visitor) {
        visitor.visitComposite(this);
    }

    @Override
    public LeafElement findLeafElementAt(int offset) {
        TreeElement element = this;
        if (element.getTreeParent() == null && offset >= element.getTextLength()) {
            return null;
        }
        block0: while (true) {
            boolean fwd;
            TreeElement child = ((TreeElement)element).getFirstChildNode();
            TreeElement lastChild = ((TreeElement)element).getLastChildNode();
            int elementTextLength = element.getTextLength();
            boolean bl = fwd = lastChild == null || elementTextLength / 2 > offset;
            if (!fwd) {
                child = lastChild;
                offset = elementTextLength - offset;
            }
            while (child != null) {
                int textLength = child.getTextLength();
                if (textLength > offset || !fwd && textLength >= offset) {
                    if (child instanceof LeafElement) {
                        if (child instanceof ForeignLeafPsiElement) {
                            child = fwd ? child.getTreeNext() : child.getTreePrev();
                            continue;
                        }
                        return (LeafElement)child;
                    }
                    offset = fwd ? offset : textLength - offset;
                    element = child;
                    continue block0;
                }
                offset -= textLength;
                child = fwd ? child.getTreeNext() : child.getTreePrev();
            }
            break;
        }
        return null;
    }

    @Nullable
    public PsiElement findPsiChildByType(IElementType type) {
        ASTNode node = this.findChildByType(type);
        return node == null ? null : node.getPsi();
    }

    @Nullable
    public PsiElement findPsiChildByType(TokenSet types) {
        ASTNode node = this.findChildByType(types);
        return node == null ? null : node.getPsi();
    }

    @Override
    public ASTNode findChildByType(IElementType type) {
        if (DebugUtil.CHECK_INSIDE_ATOMIC_ACTION_ENABLED) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
        for (ASTNode element = this.getFirstChildNode(); element != null; element = element.getTreeNext()) {
            if (element.getElementType() != type) continue;
            return element;
        }
        return null;
    }

    @Override
    public ASTNode findChildByType(IElementType type, ASTNode anchor) {
        if (DebugUtil.CHECK_INSIDE_ATOMIC_ACTION_ENABLED) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
        return TreeUtil.findSibling(anchor, type);
    }

    @Override
    @Nullable
    public ASTNode findChildByType(@NotNull TokenSet types) {
        if (types == null) {
            CompositeElement.$$$reportNull$$$0(2);
        }
        if (DebugUtil.CHECK_INSIDE_ATOMIC_ACTION_ENABLED) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
        for (ASTNode element = this.getFirstChildNode(); element != null; element = element.getTreeNext()) {
            if (!types.contains(element.getElementType())) continue;
            return element;
        }
        return null;
    }

    @Override
    @Nullable
    public ASTNode findChildByType(@NotNull TokenSet typesSet, ASTNode anchor) {
        if (typesSet == null) {
            CompositeElement.$$$reportNull$$$0(3);
        }
        if (DebugUtil.CHECK_INSIDE_ATOMIC_ACTION_ENABLED) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
        return TreeUtil.findSibling(anchor, typesSet);
    }

    @Override
    @NotNull
    public String getText() {
        String string = StringFactory.createShared(this.textToCharArray());
        if (string == null) {
            CompositeElement.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @NotNull
    public CharSequence getChars() {
        String string = this.getText();
        if (string == null) {
            CompositeElement.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    public int getNotCachedLength() {
        final int[] result = new int[]{0};
        this.acceptTree(new RecursiveTreeElementWalkingVisitor(false){

            @Override
            protected void visitNode(TreeElement element) {
                if (element instanceof LeafElement || TreeUtil.isCollapsedChameleon(element)) {
                    result[0] = result[0] + element.getNotCachedLength();
                }
                super.visitNode(element);
            }
        });
        return result[0];
    }

    @Override
    @NotNull
    public char[] textToCharArray() {
        int endOffset;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        int len = this.getTextLength();
        char[] buffer = new char[len];
        try {
            endOffset = AstBufferUtil.toBuffer(this, buffer, 0);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            String msg = "Underestimated text length: " + len;
            try {
                int length = AstBufferUtil.toBuffer(this, new char[len], 0);
                msg = msg + ";\n repetition gives success (" + length + ")";
            }
            catch (ArrayIndexOutOfBoundsException e1) {
                msg = msg + ";\n repetition fails as well";
            }
            throw new RuntimeException(msg, e);
        }
        if (endOffset != len) {
            String msg = "len=" + len + ";\n endOffset=" + endOffset;
            msg = msg + this.diagnoseTextInconsistency(new String(buffer, 0, Math.min(len, endOffset)));
            throw new AssertionError((Object)msg);
        }
        if (buffer == null) {
            CompositeElement.$$$reportNull$$$0(6);
        }
        return buffer;
    }

    private String diagnoseTextInconsistency(String text) {
        PsiElement psi;
        String msg = "";
        msg = msg + ";\n nonPhysicalOrInjected=" + this.isNonPhysicalOrInjected();
        msg = msg + ";\n buffer=" + text;
        try {
            msg = msg + ";\n this=" + this;
        }
        catch (StackOverflowError e) {
            msg = msg + ";\n this.toString produces SOE";
        }
        int shitStart = this.textMatches(text, 0);
        msg = msg + ";\n matches until " + shitStart;
        LeafElement leaf = this.findLeafElementAt(Math.abs(shitStart));
        msg = msg + ";\n element there=" + leaf;
        if (leaf != null) {
            psi = leaf.getPsi();
            msg = msg + ";\n leaf.text=" + leaf.getText();
            msg = msg + ";\n leaf.psi=" + psi;
            msg = msg + ";\n leaf.lang=" + (psi == null ? null : psi.getLanguage());
            msg = msg + ";\n leaf.type=" + leaf.getElementType();
        }
        if ((psi = this.getPsi()) != null) {
            PsiFile file;
            boolean valid = psi.isValid();
            msg = msg + ";\n psi.valid=" + valid;
            if (valid && (file = psi.getContainingFile()) != null) {
                msg = msg + ";\n psi.file=" + file;
                msg = msg + ";\n psi.file.tl=" + file.getTextLength();
                msg = msg + ";\n psi.file.lang=" + file.getLanguage();
                msg = msg + ";\n psi.file.vp=" + file.getViewProvider();
                msg = msg + ";\n psi.file.vp.lang=" + file.getViewProvider().getLanguages();
                msg = msg + ";\n psi.file.vp.lang=" + file.getViewProvider().getLanguages();
                PsiElement fileLeaf = file.findElementAt(this.getTextRange().getStartOffset());
                LeafElement myLeaf = this.findLeafElementAt(0);
                msg = msg + ";\n leaves at start=" + fileLeaf + " and " + myLeaf;
            }
        }
        return msg;
    }

    @Override
    public boolean textContains(char c) {
        for (ASTNode child = this.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (!child.textContains(c)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected int textMatches(final @NotNull CharSequence buffer, int start) {
        if (buffer == null) {
            CompositeElement.$$$reportNull$$$0(7);
        }
        final int[] curOffset = new int[]{start};
        this.acceptTree(new RecursiveTreeElementWalkingVisitor(){

            @Override
            public void visitLeaf(LeafElement leaf) {
                this.matchText(leaf);
            }

            private void matchText(TreeElement leaf) {
                curOffset[0] = leaf.textMatches(buffer, curOffset[0]);
                if (curOffset[0] < 0) {
                    this.stopWalking();
                }
            }

            @Override
            public void visitComposite(CompositeElement composite) {
                if (composite instanceof LazyParseableElement && !((LazyParseableElement)composite).isParsed()) {
                    this.matchText(composite);
                } else {
                    super.visitComposite(composite);
                }
            }
        });
        return curOffset[0];
    }

    @Nullable
    public final PsiElement findChildByRoleAsPsiElement(int role) {
        ASTNode element = this.findChildByRole(role);
        if (element == null) {
            return null;
        }
        return SourceTreeToPsiMap.treeElementToPsi(element);
    }

    @Nullable
    public ASTNode findChildByRole(int role) {
        for (ASTNode child = this.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (this.getChildRole(child) != role) continue;
            return child;
        }
        return null;
    }

    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this, child);
        return 0;
    }

    protected final int getChildRole(ASTNode child, int roleCandidate) {
        if (this.findChildByRole(roleCandidate) == child) {
            return roleCandidate;
        }
        return 0;
    }

    @Override
    @NotNull
    public ASTNode[] getChildren(@Nullable TokenSet filter) {
        int count = this.countChildren(filter);
        if (count == 0) {
            if (EMPTY_ARRAY == null) {
                CompositeElement.$$$reportNull$$$0(8);
            }
            return EMPTY_ARRAY;
        }
        ASTNode[] result = new ASTNode[count];
        count = 0;
        for (ASTNode child = this.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (filter != null && !filter.contains(child.getElementType())) continue;
            result[count++] = child;
        }
        if (result == null) {
            CompositeElement.$$$reportNull$$$0(9);
        }
        return result;
    }

    @NotNull
    public <T extends PsiElement> T[] getChildrenAsPsiElements(@Nullable TokenSet filter, ArrayFactory<T> constructor) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        int count = this.countChildren(filter);
        PsiElement[] result = (PsiElement[])constructor.create(count);
        if (count == 0) {
            if (result == null) {
                CompositeElement.$$$reportNull$$$0(10);
            }
            return result;
        }
        int idx = 0;
        for (ASTNode child = this.getFirstChildNode(); child != null && idx < count; child = child.getTreeNext()) {
            if (filter != null && !filter.contains(child.getElementType())) continue;
            PsiElement element = child.getPsi();
            LOG.assertTrue(element != null, child);
            result[idx++] = element;
        }
        if (result == null) {
            CompositeElement.$$$reportNull$$$0(11);
        }
        return result;
    }

    @NotNull
    public <T extends PsiElement> T[] getChildrenAsPsiElements(@NotNull IElementType type, ArrayFactory<T> constructor) {
        if (type == null) {
            CompositeElement.$$$reportNull$$$0(12);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        int count = this.countChildren(type);
        PsiElement[] result = (PsiElement[])constructor.create(count);
        if (count == 0) {
            if (result == null) {
                CompositeElement.$$$reportNull$$$0(13);
            }
            return result;
        }
        int idx = 0;
        for (ASTNode child = this.getFirstChildNode(); child != null && idx < count; child = child.getTreeNext()) {
            if (type != child.getElementType()) continue;
            PsiElement element = child.getPsi();
            LOG.assertTrue(element != null, child);
            result[idx++] = element;
        }
        if (result == null) {
            CompositeElement.$$$reportNull$$$0(14);
        }
        return result;
    }

    public int countChildren(@Nullable TokenSet filter) {
        int count = 0;
        for (ASTNode child = this.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (filter != null && !filter.contains(child.getElementType())) continue;
            ++count;
        }
        return count;
    }

    private int countChildren(@NotNull IElementType type) {
        if (type == null) {
            CompositeElement.$$$reportNull$$$0(15);
        }
        int count = 0;
        for (ASTNode child = this.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (type != child.getElementType()) continue;
            ++count;
        }
        return count;
    }

    public TreeElement addInternal(TreeElement first, ASTNode last, ASTNode anchor, Boolean before) {
        ASTNode anchorBefore = anchor != null ? (before != false ? anchor : anchor.getTreeNext()) : (before == null || before != false ? null : this.getFirstChildNode());
        return (TreeElement)CodeEditUtil.addChildren(this, first, last, anchorBefore);
    }

    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            CompositeElement.$$$reportNull$$$0(16);
        }
        CodeEditUtil.removeChild(this, child);
    }

    public void replaceChildInternal(@NotNull ASTNode child, @NotNull TreeElement newElement) {
        if (child == null) {
            CompositeElement.$$$reportNull$$$0(17);
        }
        if (newElement == null) {
            CompositeElement.$$$reportNull$$$0(18);
        }
        CodeEditUtil.replaceChild(this, child, newElement);
    }

    @Override
    public int getTextLength() {
        int cachedLength = this.myCachedLength;
        if (cachedLength >= 0) {
            return cachedLength;
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        try {
            return this.walkCachingLength();
        }
        catch (AssertionError e) {
            this.myCachedLength = -1;
            String assertion = StringUtil.getThrowableText((Throwable)((Object)e));
            throw new AssertionError((Object)("Walking failure: ===\n" + assertion + "\n=== Thread dump:\n" + ThreadDumper.dumpThreadsToString() + "\n===\n"));
        }
    }

    @Override
    public int hc() {
        int hc = this.myHC;
        if (hc == -1) {
            hc = 0;
            for (TreeElement child = this.firstChild; child != null; child = child.getTreeNext()) {
                hc += child.hc();
            }
            this.myHC = hc;
        }
        return hc;
    }

    @Override
    public int getCachedLength() {
        return this.myCachedLength;
    }

    @NotNull
    private static TreeElement drillDown(@NotNull TreeElement start) {
        TreeElement child;
        if (start == null) {
            CompositeElement.$$$reportNull$$$0(19);
        }
        TreeElement cur = start;
        while (cur.getCachedLength() < 0 && (child = cur.getFirstChildNode()) != null) {
            cur = child;
        }
        TreeElement treeElement = cur;
        if (treeElement == null) {
            CompositeElement.$$$reportNull$$$0(20);
        }
        return treeElement;
    }

    private int walkCachingLength() {
        TreeElement cur = CompositeElement.drillDown(this);
        while (true) {
            int length;
            if ((length = cur.getCachedLength()) < 0) {
                length = 0;
                for (TreeElement child = cur.getFirstChildNode(); child != null; child = child.getTreeNext()) {
                    length += child.getTextLength();
                }
                ((CompositeElement)cur).setCachedLength(length);
            }
            if (cur == this) {
                return length;
            }
            TreeElement next = cur.getTreeNext();
            cur = next != null ? CompositeElement.drillDown(next) : CompositeElement.getNotNullParent(cur);
        }
    }

    private static TreeElement getNotNullParent(TreeElement cur) {
        CompositeElement parent = cur.getTreeParent();
        if (parent == null) {
            CompositeElement.diagnoseNullParent(cur);
        }
        return parent;
    }

    private static void diagnoseNullParent(TreeElement cur) {
        PsiElement psi = cur.getPsi();
        if (psi != null) {
            PsiUtilCore.ensureValid(psi);
        }
        throw new IllegalStateException("Null parent of " + cur + " " + cur.getClass());
    }

    void setCachedLength(int cachedLength) {
        this.myCachedLength = cachedLength;
    }

    @Override
    public TreeElement getFirstChildNode() {
        return this.firstChild;
    }

    @Override
    public TreeElement getLastChildNode() {
        return this.lastChild;
    }

    void setFirstChildNode(TreeElement firstChild) {
        this.firstChild = firstChild;
        CompositeElement.clearRelativeOffsets(firstChild);
    }

    void setLastChildNode(TreeElement lastChild) {
        this.lastChild = lastChild;
    }

    @Override
    public void addChild(@NotNull ASTNode child, final @Nullable ASTNode anchorBefore) {
        if (child == null) {
            CompositeElement.$$$reportNull$$$0(21);
        }
        LOG.assertTrue(anchorBefore == null || ((TreeElement)anchorBefore).getTreeParent() == this, "anchorBefore == null || anchorBefore.getTreeParent() == parent");
        TreeUtil.ensureParsed(this.getFirstChildNode());
        TreeUtil.ensureParsed(child);
        TreeElement last = ((TreeElement)child).getTreeNext();
        final TreeElement first = (TreeElement)child;
        CompositeElement.removeChildrenInner(first, last);
        ChangeUtil.prepareAndRunChangeAction(new ChangeUtil.ChangeAction(){

            @Override
            public void makeChange(TreeChangeEvent destinationTreeChange) {
                if (anchorBefore != null) {
                    CompositeElement.insertBefore(destinationTreeChange, (TreeElement)anchorBefore, first);
                } else {
                    CompositeElement.add(destinationTreeChange, CompositeElement.this, first);
                }
            }
        }, this);
    }

    @Override
    public void addLeaf(@NotNull IElementType leafType, CharSequence leafText, ASTNode anchorBefore) {
        if (leafType == null) {
            CompositeElement.$$$reportNull$$$0(22);
        }
        FileElement holder = new DummyHolder(this.getManager(), null).getTreeElement();
        LeafElement leaf = ASTFactory.leaf(leafType, holder.getCharTable().intern(leafText));
        CodeEditUtil.setNodeGenerated(leaf, true);
        holder.rawAddChildren(leaf);
        this.addChild(leaf, anchorBefore);
    }

    @Override
    public void addChild(@NotNull ASTNode child) {
        if (child == null) {
            CompositeElement.$$$reportNull$$$0(23);
        }
        this.addChild(child, null);
    }

    @Override
    public void removeChild(@NotNull ASTNode child) {
        if (child == null) {
            CompositeElement.$$$reportNull$$$0(24);
        }
        CompositeElement.removeChildInner((TreeElement)child);
    }

    @Override
    public void removeRange(@NotNull ASTNode first, ASTNode firstWhichStayInTree) {
        if (first == null) {
            CompositeElement.$$$reportNull$$$0(25);
        }
        CompositeElement.removeChildrenInner((TreeElement)first, (TreeElement)firstWhichStayInTree);
    }

    @Override
    public void replaceChild(@NotNull ASTNode oldChild, @NotNull ASTNode newChild) {
        if (oldChild == null) {
            CompositeElement.$$$reportNull$$$0(26);
        }
        if (newChild == null) {
            CompositeElement.$$$reportNull$$$0(27);
        }
        LOG.assertTrue(((TreeElement)oldChild).getTreeParent() == this);
        final TreeElement oldChild1 = (TreeElement)oldChild;
        TreeElement newChildNext = ((TreeElement)newChild).getTreeNext();
        final TreeElement newChild1 = (TreeElement)newChild;
        if (oldChild1 == newChild1) {
            return;
        }
        CompositeElement.removeChildrenInner(newChild1, newChildNext);
        ChangeUtil.prepareAndRunChangeAction(new ChangeUtil.ChangeAction(){

            @Override
            public void makeChange(TreeChangeEvent destinationTreeChange) {
                CompositeElement.replace(destinationTreeChange, oldChild1, newChild1);
                CompositeElement.repairRemovedElement(CompositeElement.this, oldChild1);
            }
        }, this);
    }

    @Override
    public void replaceAllChildrenToChildrenOf(final ASTNode anotherParent) {
        TreeUtil.ensureParsed(this.getFirstChildNode());
        TreeUtil.ensureParsed(anotherParent.getFirstChildNode());
        final ASTNode firstChild = anotherParent.getFirstChildNode();
        ChangeUtil.prepareAndRunChangeAction(new ChangeUtil.ChangeAction(){

            @Override
            public void makeChange(TreeChangeEvent destinationTreeChange) {
                destinationTreeChange.addElementaryChange(anotherParent, ChangeInfoImpl.create((short)3, anotherParent));
                ((CompositeElement)anotherParent).rawRemoveAllChildren();
            }
        }, (TreeElement)anotherParent);
        if (firstChild != null) {
            ChangeUtil.prepareAndRunChangeAction(new ChangeUtil.ChangeAction(){

                @Override
                public void makeChange(TreeChangeEvent destinationTreeChange) {
                    if (CompositeElement.this.getTreeParent() != null) {
                        ChangeInfoImpl changeInfo = ChangeInfoImpl.create((short)3, CompositeElement.this);
                        changeInfo.setOldLength(CompositeElement.this.getTextLength());
                        destinationTreeChange.addElementaryChange(CompositeElement.this, changeInfo);
                        CompositeElement.this.rawRemoveAllChildren();
                        CompositeElement.this.rawAddChildren((TreeElement)firstChild);
                    } else {
                        TreeElement first = CompositeElement.this.getFirstChildNode();
                        CompositeElement.remove(destinationTreeChange, first, null);
                        CompositeElement.add(destinationTreeChange, CompositeElement.this, (TreeElement)firstChild);
                        CompositeElement.repairRemovedElement(CompositeElement.this, first);
                    }
                }
            }, this);
        } else {
            this.removeAllChildren();
        }
    }

    public void removeAllChildren() {
        TreeElement child = this.getFirstChildNode();
        if (child != null) {
            this.removeRange(child, null);
        }
    }

    @Override
    public void addChildren(ASTNode firstChild, ASTNode lastChild, ASTNode anchorBefore) {
        while (firstChild != lastChild) {
            ASTNode next1 = firstChild.getTreeNext();
            this.addChild(firstChild, anchorBefore);
            firstChild = next1;
        }
    }

    @Nullable
    public final PsiElement getCachedPsi() {
        return this.myWrapper;
    }

    @Override
    public final PsiElement getPsi() {
        ProgressIndicatorProvider.checkCanceled();
        PsiElement wrapper = this.myWrapper;
        if (wrapper != null) {
            return wrapper;
        }
        wrapper = this.obtainStubBasedPsi();
        if (wrapper == null) {
            wrapper = this.createPsiNoLock();
        }
        return ourPsiUpdater.compareAndSet(this, null, wrapper) ? wrapper : ObjectUtils.assertNotNull(this.myWrapper);
    }

    @Nullable
    private PsiElement obtainStubBasedPsi() {
        AstPath path = this.getElementType() instanceof IStubElementType ? AstPath.getNodePath(this) : null;
        return path == null ? null : path.getContainingFile().obtainPsi(path, () -> (StubBasedPsiElementBase)this.createPsiNoLock());
    }

    @Override
    public <T extends PsiElement> T getPsi(@NotNull Class<T> clazz) {
        if (clazz == null) {
            CompositeElement.$$$reportNull$$$0(28);
        }
        return LeafElement.getPsi(clazz, this.getPsi(), LOG);
    }

    protected PsiElement createPsiNoLock() {
        Language lang = this.getElementType().getLanguage();
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
        if (parserDefinition != null) {
            return parserDefinition.createElement(this);
        }
        return null;
    }

    public void setPsi(@NotNull PsiElement psi) {
        if (psi == null) {
            CompositeElement.$$$reportNull$$$0(29);
        }
        this.myWrapper = psi;
    }

    protected void clearPsi() {
        this.myWrapper = null;
    }

    public final void rawAddChildren(@NotNull TreeElement first) {
        if (first == null) {
            CompositeElement.$$$reportNull$$$0(30);
        }
        this.rawAddChildrenWithoutNotifications(first);
        this.subtreeChanged();
    }

    public void rawAddChildrenWithoutNotifications(@NotNull TreeElement first) {
        PsiFileImpl file;
        if (first == null) {
            CompositeElement.$$$reportNull$$$0(31);
        }
        if (DebugUtil.DO_EXPENSIVE_CHECKS && !(this instanceof LazyParseableElement) && (file = CompositeElement.getCachedFile(this)) != null && !file.useStrongRefs()) {
            throw new AssertionError((Object)"Attempt to modify PSI in a file with weakly-referenced AST. Possible cause: missing PomTransaction.");
        }
        TreeElement last = this.getLastChildNode();
        if (last == null) {
            first.rawRemoveUpToWithoutNotifications(null, false);
            this.setFirstChildNode(first);
            while (true) {
                TreeElement treeNext = first.getTreeNext();
                first.setTreeParent(this);
                if (treeNext == null) break;
                first = treeNext;
            }
            this.setLastChildNode(first);
            first.setTreeParent(this);
        } else {
            last.rawInsertAfterMeWithoutNotifications(first);
        }
        DebugUtil.checkTreeStructure(this);
    }

    public void rawRemoveAllChildren() {
        TreeElement first = this.getFirstChildNode();
        if (first != null) {
            first.rawRemoveUpToLast();
        }
    }

    private static void repairRemovedElement(CompositeElement oldParent, TreeElement oldChild) {
        if (oldChild == null) {
            return;
        }
        FileElement treeElement = DummyHolderFactory.createHolder((PsiManager)oldParent.getManager(), null, false).getTreeElement();
        treeElement.rawAddChildren(oldChild);
    }

    private static void add(TreeChangeEvent destinationTreeChange, CompositeElement parent, TreeElement first) {
        parent.rawAddChildren(first);
        for (TreeElement child = first; child != null; child = child.getTreeNext()) {
            destinationTreeChange.addElementaryChange(child, ChangeInfoImpl.create((short)0, child));
        }
    }

    private static void remove(TreeChangeEvent destinationTreeChange, TreeElement first, TreeElement last) {
        if (first != null) {
            for (TreeElement child = first; child != last && child != null; child = child.getTreeNext()) {
                destinationTreeChange.addElementaryChange(child, ChangeInfoImpl.create((short)1, child));
            }
            first.rawRemoveUpTo(last);
        }
    }

    private static void insertBefore(TreeChangeEvent destinationTreeChange, TreeElement anchorBefore, TreeElement first) {
        anchorBefore.rawInsertBeforeMe(first);
        for (TreeElement child = first; child != anchorBefore; child = child.getTreeNext()) {
            destinationTreeChange.addElementaryChange(child, ChangeInfoImpl.create((short)0, child));
        }
    }

    private static void replace(TreeChangeEvent sourceTreeChange, TreeElement oldChild, TreeElement newChild) {
        oldChild.rawReplaceWithList(newChild);
        ReplaceChangeInfoImpl change = new ReplaceChangeInfoImpl(newChild);
        sourceTreeChange.addElementaryChange(newChild, change);
        change.setReplaced(oldChild);
    }

    private static void removeChildInner(TreeElement child) {
        CompositeElement.removeChildrenInner(child, child.getTreeNext());
    }

    private static void removeChildrenInner(final TreeElement first, final TreeElement last) {
        final FileElement fileElement = TreeUtil.getFileElement(first);
        if (fileElement != null) {
            ChangeUtil.prepareAndRunChangeAction(new ChangeUtil.ChangeAction(){

                @Override
                public void makeChange(TreeChangeEvent destinationTreeChange) {
                    CompositeElement.remove(destinationTreeChange, first, last);
                    CompositeElement.repairRemovedElement((CompositeElement)fileElement, first);
                }
            }, first.getTreeParent());
        } else {
            first.rawRemoveUpTo(last);
        }
    }

    public TreeElement rawFirstChild() {
        return this.firstChild;
    }

    public TreeElement rawLastChild() {
        return this.lastChild;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/CompositeElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typesSet";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 16: 
            case 17: 
            case 21: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leafType";
                break;
            }
            case 25: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldChild";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newChild";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/CompositeElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "clone";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getChars";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "textToCharArray";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenAsPsiElements";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "drillDown";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 20: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findChildByType";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "textMatches";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenAsPsiElements";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "countChildren";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "deleteChildInternal";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "replaceChildInternal";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "drillDown";
                break;
            }
            case 21: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addChild";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addLeaf";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "removeChild";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "removeRange";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "replaceChild";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getPsi";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "setPsi";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "rawAddChildren";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "rawAddChildrenWithoutNotifications";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

