/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.guess.impl;

import com.intellij.codeInsight.guess.GuessManager;
import com.intellij.codeInsight.guess.impl.ExpressionTypeMemoryState;
import com.intellij.codeInsight.guess.impl.MethodPattern;
import com.intellij.codeInsight.guess.impl.MethodPatternMap;
import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.RunnerResult;
import com.intellij.codeInspection.dataFlow.instructions.InstanceofInstruction;
import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.codeInspection.dataFlow.instructions.PushInstruction;
import com.intellij.codeInspection.dataFlow.instructions.TypeCastInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaInstanceofValue;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiElementProcessorAdapter;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuessManagerImpl
extends GuessManager {
    private final MethodPatternMap myMethodPatternMap = new MethodPatternMap();
    private final Project myProject;
    private static final int CHECK_USAGE = 1;
    private static final int CHECK_UP = 2;
    private static final int CHECK_DOWN = 4;

    private void initMethodPatterns() {
        this.myMethodPatternMap.addPattern(new MethodPattern("add", 1, 0));
        this.myMethodPatternMap.addPattern(new MethodPattern("contains", 1, 0));
        this.myMethodPatternMap.addPattern(new MethodPattern("remove", 1, 0));
        this.myMethodPatternMap.addPattern(new MethodPattern("add", 2, 1));
        this.myMethodPatternMap.addPattern(new MethodPattern("addElement", 1, 0));
        this.myMethodPatternMap.addPattern(new MethodPattern("elementAt", 1, -1));
        this.myMethodPatternMap.addPattern(new MethodPattern("firstElement", 0, -1));
        this.myMethodPatternMap.addPattern(new MethodPattern("lastElement", 0, -1));
        this.myMethodPatternMap.addPattern(new MethodPattern("get", 1, -1));
        this.myMethodPatternMap.addPattern(new MethodPattern("indexOf", 1, 0));
        this.myMethodPatternMap.addPattern(new MethodPattern("indexOf", 2, 0));
        this.myMethodPatternMap.addPattern(new MethodPattern("lastIndexOf", 1, 0));
        this.myMethodPatternMap.addPattern(new MethodPattern("lastIndexOf", 2, 0));
        this.myMethodPatternMap.addPattern(new MethodPattern("insertElementAt", 2, 0));
        this.myMethodPatternMap.addPattern(new MethodPattern("removeElement", 1, 0));
        this.myMethodPatternMap.addPattern(new MethodPattern("set", 2, 1));
        this.myMethodPatternMap.addPattern(new MethodPattern("setElementAt", 2, 0));
    }

    public GuessManagerImpl(Project project) {
        this.initMethodPatterns();
        this.myProject = project;
    }

    @Override
    @NotNull
    public PsiType[] guessContainerElementType(PsiExpression containerExpr, TextRange rangeToIgnore) {
        PsiElement refElement;
        HashSet<PsiType> typesSet = new HashSet<PsiType>();
        PsiType type = containerExpr.getType();
        PsiType elemType = GuessManagerImpl.getGenericElementType(type);
        if (elemType != null) {
            PsiType[] psiTypeArray = new PsiType[]{elemType};
            if (psiTypeArray == null) {
                GuessManagerImpl.$$$reportNull$$$0(0);
            }
            return psiTypeArray;
        }
        if (containerExpr instanceof PsiReferenceExpression && (refElement = ((PsiReferenceExpression)containerExpr).resolve()) instanceof PsiVariable) {
            PsiFile file = refElement.getContainingFile();
            if (file == null) {
                file = containerExpr.getContainingFile();
            }
            HashSet<PsiVariable> checkedVariables = new HashSet<PsiVariable>();
            this.addTypesByVariable(typesSet, (PsiVariable)refElement, file, checkedVariables, 5, rangeToIgnore);
            checkedVariables.clear();
            this.addTypesByVariable(typesSet, (PsiVariable)refElement, file, checkedVariables, 2, rangeToIgnore);
        }
        PsiType[] psiTypeArray = typesSet.toArray(PsiType.createArray(typesSet.size()));
        if (psiTypeArray == null) {
            GuessManagerImpl.$$$reportNull$$$0(1);
        }
        return psiTypeArray;
    }

    @Nullable
    private static PsiType getGenericElementType(PsiType collectionType) {
        PsiClassType classType;
        PsiType[] parameters;
        if (collectionType instanceof PsiClassType && (parameters = (classType = (PsiClassType)collectionType).getParameters()).length == 1) {
            return parameters[0];
        }
        return null;
    }

    @Override
    @NotNull
    public PsiType[] guessTypeToCast(PsiExpression expr) {
        LinkedHashSet<PsiType> types = new LinkedHashSet<PsiType>();
        ContainerUtil.addIfNotNull(types, this.getControlFlowExpressionType(expr));
        this.addExprTypesWhenContainerElement(types, expr);
        this.addExprTypesByDerivedClasses(types, expr);
        PsiType[] psiTypeArray = types.toArray(PsiType.createArray(types.size()));
        if (psiTypeArray == null) {
            GuessManagerImpl.$$$reportNull$$$0(2);
        }
        return psiTypeArray;
    }

    @Override
    @NotNull
    public Map<PsiExpression, PsiType> getControlFlowExpressionTypes(@NotNull PsiExpression forPlace) {
        Map<PsiExpression, PsiType> typeMap;
        if (forPlace == null) {
            GuessManagerImpl.$$$reportNull$$$0(3);
        }
        if ((typeMap = GuessManagerImpl.buildDataflowTypeMap(forPlace)) != null) {
            Map<PsiExpression, PsiType> map = typeMap;
            if (map == null) {
                GuessManagerImpl.$$$reportNull$$$0(4);
            }
            return map;
        }
        Map<PsiExpression, PsiType> map = Collections.emptyMap();
        if (map == null) {
            GuessManagerImpl.$$$reportNull$$$0(5);
        }
        return map;
    }

    @Nullable
    private static Map<PsiExpression, PsiType> buildDataflowTypeMap(PsiExpression forPlace) {
        ExpressionTypeInstructionVisitor visitor;
        DataFlowRunner runner;
        PsiElement scope = DfaPsiUtil.getTopmostBlockInSameClass(forPlace);
        if (scope == null) {
            PsiFile file = forPlace.getContainingFile();
            if (!(file instanceof PsiCodeFragment)) {
                return Collections.emptyMap();
            }
            scope = file;
        }
        if ((runner = new DataFlowRunner(){

            @Override
            @NotNull
            protected DfaMemoryState createMemoryState() {
                ExpressionTypeMemoryState expressionTypeMemoryState = new ExpressionTypeMemoryState(this.getFactory());
                if (expressionTypeMemoryState == null) {
                    1.$$$reportNull$$$0(0);
                }
                return expressionTypeMemoryState;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/guess/impl/GuessManagerImpl$1", "createMemoryState"));
            }
        }).analyzeMethod(scope, visitor = new ExpressionTypeInstructionVisitor(forPlace)) == RunnerResult.OK) {
            return visitor.getResult();
        }
        return null;
    }

    private static Map<PsiExpression, PsiType> getAllTypeCasts(PsiExpression forPlace) {
        assert (forPlace.isValid());
        int start = forPlace.getTextRange().getStartOffset();
        THashMap allCasts = new THashMap(ExpressionTypeMemoryState.EXPRESSION_HASHING_STRATEGY);
        GuessManagerImpl.getTopmostBlock(forPlace).accept(new JavaRecursiveElementWalkingVisitor((Map)allCasts, start){
            final /* synthetic */ Map val$allCasts;
            final /* synthetic */ int val$start;
            {
                this.val$allCasts = map;
                this.val$start = n;
            }

            @Override
            public void visitTypeCastExpression(PsiTypeCastExpression expression) {
                PsiType castType = expression.getType();
                PsiExpression operand = expression.getOperand();
                if (operand != null && castType != null) {
                    this.val$allCasts.put(operand, castType);
                }
                super.visitTypeCastExpression(expression);
            }

            @Override
            public void visitInstanceOfExpression(PsiInstanceOfExpression expression) {
                PsiTypeElement castType = expression.getCheckType();
                PsiExpression operand = expression.getOperand();
                if (castType != null) {
                    this.val$allCasts.put(operand, castType.getType());
                }
                super.visitInstanceOfExpression(expression);
            }

            @Override
            public void visitElement(PsiElement element) {
                if (element.getTextRange().getStartOffset() > this.val$start) {
                    return;
                }
                super.visitElement(element);
            }
        });
        return allCasts;
    }

    private static PsiElement getTopmostBlock(PsiElement scope) {
        PsiFile file;
        PsiCodeBlock lastCodeBlock;
        assert (scope.isValid());
        PsiElement lastScope = scope;
        while ((lastCodeBlock = PsiTreeUtil.getParentOfType(lastScope, PsiCodeBlock.class, true)) != null) {
            lastScope = lastCodeBlock;
        }
        if (lastScope == scope && (file = scope.getContainingFile()) instanceof PsiCodeFragment) {
            return file;
        }
        return lastScope;
    }

    private void addExprTypesByDerivedClasses(LinkedHashSet<PsiType> set, PsiExpression expr) {
        PsiType type = expr.getType();
        if (!(type instanceof PsiClassType)) {
            return;
        }
        PsiClass refClass = PsiUtil.resolveClassInType(type);
        if (refClass == null) {
            return;
        }
        PsiManager manager = PsiManager.getInstance(this.myProject);
        PsiElementProcessor.CollectElementsWithLimit processor = new PsiElementProcessor.CollectElementsWithLimit(5);
        ClassInheritorsSearch.search(refClass).forEach(new PsiElementProcessorAdapter(processor));
        if (processor.isOverflow()) {
            return;
        }
        for (PsiClass derivedClass : processor.getCollection()) {
            if (derivedClass instanceof PsiAnonymousClass) continue;
            PsiClassType derivedType = JavaPsiFacade.getInstance(manager.getProject()).getElementFactory().createType(derivedClass);
            set.add(derivedType);
        }
    }

    private void addExprTypesWhenContainerElement(LinkedHashSet<PsiType> set, PsiExpression expr) {
        PsiExpression qualifier;
        PsiMethodCallExpression callExpr;
        PsiReferenceExpression methodExpr;
        String methodName;
        MethodPattern pattern;
        if (expr instanceof PsiMethodCallExpression && (pattern = this.myMethodPatternMap.findPattern(methodName = (methodExpr = (callExpr = (PsiMethodCallExpression)expr).getMethodExpression()).getReferenceName(), callExpr.getArgumentList().getExpressions().length)) != null && pattern.parameterIndex < 0 && (qualifier = methodExpr.getQualifierExpression()) != null) {
            PsiType[] types;
            for (PsiType type : types = this.guessContainerElementType(qualifier, null)) {
                if (type instanceof PsiClassType && ((PsiClassType)type).resolve() instanceof PsiAnonymousClass) continue;
                set.add(type);
            }
        }
    }

    private void addTypesByVariable(HashSet<PsiType> typesSet, PsiVariable var, PsiFile scopeFile, HashSet<PsiVariable> checkedVariables, int flags, TextRange rangeToIgnore) {
        if (!checkedVariables.add(var)) {
            return;
        }
        LocalSearchScope searchScope = new LocalSearchScope(scopeFile);
        if (BitUtil.isSet(flags, 1) || BitUtil.isSet(flags, 4)) {
            for (PsiReference varRef : ReferencesSearch.search(var, searchScope, false)) {
                PsiParameter[] parameters;
                PsiMethodCallExpression methodCall;
                PsiMethod method;
                PsiType type;
                PsiElement ref = varRef.getElement();
                if (BitUtil.isSet(flags, 1) && (type = GuessManagerImpl.guessElementTypeFromReference(this.myMethodPatternMap, ref, rangeToIgnore)) != null && !(type instanceof PsiPrimitiveType)) {
                    typesSet.add(type);
                }
                if (!BitUtil.isSet(flags, 4) || !(ref.getParent() instanceof PsiExpressionList) || !(ref.getParent().getParent() instanceof PsiMethodCallExpression)) continue;
                PsiExpressionList list = (PsiExpressionList)ref.getParent();
                PsiExpression[] args = list.getExpressions();
                int argIndex = -1;
                for (int j = 0; j < args.length; ++j) {
                    PsiExpression arg = args[j];
                    if (!arg.equals(ref)) continue;
                    argIndex = j;
                    break;
                }
                if ((method = (PsiMethod)(methodCall = (PsiMethodCallExpression)list.getParent()).getMethodExpression().resolve()) == null || argIndex >= (parameters = method.getParameterList().getParameters()).length) continue;
                this.addTypesByVariable(typesSet, parameters[argIndex], method.getContainingFile(), checkedVariables, flags | 1, rangeToIgnore);
            }
        }
        if (BitUtil.isSet(flags, 2) && var instanceof PsiParameter && var.getParent() instanceof PsiParameterList && var.getParent().getParent() instanceof PsiMethod) {
            PsiParameterList list = (PsiParameterList)var.getParent();
            PsiParameter[] parameters = list.getParameters();
            int argIndex = -1;
            for (int i2 = 0; i2 < parameters.length; ++i2) {
                PsiParameter parameter = parameters[i2];
                if (!parameter.equals(var)) continue;
                argIndex = i2;
                break;
            }
            PsiMethod method = (PsiMethod)var.getParent().getParent();
            for (PsiReference methodRef : ReferencesSearch.search(method, searchScope, false)) {
                PsiElement refElement;
                PsiExpression arg;
                PsiMethodCallExpression methodCall;
                PsiExpression[] args;
                PsiElement ref = methodRef.getElement();
                if (!(ref.getParent() instanceof PsiMethodCallExpression) || (args = (methodCall = (PsiMethodCallExpression)ref.getParent()).getArgumentList().getExpressions()).length <= argIndex || !((arg = args[argIndex]) instanceof PsiReferenceExpression) || !((refElement = ((PsiReferenceExpression)arg).resolve()) instanceof PsiVariable)) continue;
                this.addTypesByVariable(typesSet, (PsiVariable)refElement, scopeFile, checkedVariables, flags | 1, rangeToIgnore);
            }
        }
    }

    @Nullable
    private static PsiType guessElementTypeFromReference(MethodPatternMap methodPatternMap, PsiElement ref, TextRange rangeToIgnore) {
        PsiMethodCallExpression methodCall;
        PsiExpression[] args;
        String methodName;
        MethodPattern pattern;
        PsiReferenceExpression parentExpr;
        PsiElement refParent = ref.getParent();
        if (refParent instanceof PsiReferenceExpression && ref.equals((parentExpr = (PsiReferenceExpression)refParent).getQualifierExpression()) && parentExpr.getParent() instanceof PsiMethodCallExpression && (pattern = methodPatternMap.findPattern(methodName = parentExpr.getReferenceName(), (args = (methodCall = (PsiMethodCallExpression)parentExpr.getParent()).getArgumentList().getExpressions()).length)) != null) {
            if (pattern.parameterIndex < 0) {
                if (methodCall.getParent() instanceof PsiTypeCastExpression && (rangeToIgnore == null || !rangeToIgnore.contains(methodCall.getTextRange()))) {
                    return ((PsiTypeCastExpression)methodCall.getParent()).getType();
                }
            } else {
                return args[pattern.parameterIndex].getType();
            }
        }
        return null;
    }

    @Override
    @Nullable
    public PsiType getControlFlowExpressionType(@NotNull PsiExpression expr) {
        Map<PsiExpression, PsiType> allCasts;
        if (expr == null) {
            GuessManagerImpl.$$$reportNull$$$0(6);
        }
        if (!(allCasts = GuessManagerImpl.getAllTypeCasts(expr)).containsKey(expr)) {
            return null;
        }
        Map<PsiExpression, PsiType> fromDfa = GuessManagerImpl.buildDataflowTypeMap(expr);
        if (fromDfa != null) {
            return fromDfa.get(expr);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/guess/impl/GuessManagerImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forPlace";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "guessContainerElementType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "guessTypeToCast";
                break;
            }
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/guess/impl/GuessManagerImpl";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getControlFlowExpressionTypes";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getControlFlowExpressionTypes";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getControlFlowExpressionType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ExpressionTypeInstructionVisitor
    extends InstructionVisitor {
        private Map<PsiExpression, PsiType> myResult;
        private final PsiElement myForPlace;

        private ExpressionTypeInstructionVisitor(@NotNull PsiElement forPlace) {
            if (forPlace == null) {
                ExpressionTypeInstructionVisitor.$$$reportNull$$$0(0);
            }
            PsiElement parent = PsiUtil.skipParenthesizedExprUp(forPlace.getParent());
            this.myForPlace = forPlace instanceof PsiThisExpression && parent instanceof PsiReferenceExpression ? (parent.getParent() instanceof PsiMethodCallExpression ? parent.getParent() : parent) : forPlace;
        }

        public Map<PsiExpression, PsiType> getResult() {
            return this.myResult;
        }

        @Override
        public DfaInstructionState[] visitInstanceof(InstanceofInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
            memState.pop();
            memState.pop();
            memState.push(new DfaInstanceofValue(runner.getFactory(), instruction.getLeft(), instruction.getCastType()));
            return new DfaInstructionState[]{new DfaInstructionState(runner.getInstruction(instruction.getIndex() + 1), memState)};
        }

        @Override
        public DfaInstructionState[] visitTypeCast(TypeCastInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
            ((ExpressionTypeMemoryState)memState).setExpressionType(instruction.getCasted(), instruction.getCastTo());
            return super.visitTypeCast(instruction, runner, memState);
        }

        @Override
        public DfaInstructionState[] visitMethodCall(MethodCallInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
            if (this.myForPlace == instruction.getCallExpression()) {
                this.addToResult(((ExpressionTypeMemoryState)memState).getStates());
            }
            return super.visitMethodCall(instruction, runner, memState);
        }

        @Override
        public DfaInstructionState[] visitPush(PushInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
            if (this.myForPlace == instruction.getPlace()) {
                this.addToResult(((ExpressionTypeMemoryState)memState).getStates());
            }
            return super.visitPush(instruction, runner, memState);
        }

        private void addToResult(Map<PsiExpression, PsiType> map) {
            if (this.myResult == null) {
                this.myResult = new THashMap(map, ExpressionTypeMemoryState.EXPRESSION_HASHING_STRATEGY);
            } else {
                Iterator<PsiExpression> iterator = this.myResult.keySet().iterator();
                while (iterator.hasNext()) {
                    PsiExpression psiExpression = iterator.next();
                    if (this.myResult.get(psiExpression).equals(map.get(psiExpression))) continue;
                    iterator.remove();
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forPlace", "com/intellij/codeInsight/guess/impl/GuessManagerImpl$ExpressionTypeInstructionVisitor", "<init>"));
        }
    }
}

