/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SuspiciousArrayMethodCallInspection
extends BaseJavaBatchLocalInspectionTool {
    private static final Set<String> INTERESTING_NAMES = ContainerUtil.set("fill", "binarySearch", "equals", "mismatch");

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            SuspiciousArrayMethodCallInspection.$$$reportNull$$$0(0);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            @Override
            public void visitMethodCallExpression(PsiMethodCallExpression call) {
                PsiElement nameElement = call.getMethodExpression().getReferenceNameElement();
                if (nameElement == null) {
                    return;
                }
                String name = nameElement.getText();
                if (!INTERESTING_NAMES.contains(name)) {
                    return;
                }
                PsiMethod method = call.resolveMethod();
                if (method == null) {
                    return;
                }
                PsiClass aClass = method.getContainingClass();
                if (aClass == null || !"java.util.Arrays".equals(aClass.getQualifiedName())) {
                    return;
                }
                PsiExpression[] args = call.getArgumentList().getExpressions();
                switch (name) {
                    case "fill": 
                    case "binarySearch": {
                        if (args.length == 2) {
                            this.handleArrayElement(args[0], args[1]);
                            break;
                        }
                        if (args.length != 4) break;
                        this.handleArrayElement(args[0], args[3]);
                        break;
                    }
                    case "equals": 
                    case "mismatch": {
                        if (args.length == 2) {
                            this.handleArrays(nameElement, args[0], args[1]);
                            break;
                        }
                        if (args.length != 6) break;
                        this.handleArrays(nameElement, args[0], args[3]);
                    }
                }
            }

            private void handleArrayElement(PsiExpression array, PsiExpression element) {
                PsiType arrayType = array.getType();
                PsiType elementType = element.getType();
                if (elementType == null || !(arrayType instanceof PsiArrayType)) {
                    return;
                }
                PsiType arrayElementType = ((PsiArrayType)arrayType).getComponentType();
                if (arrayElementType instanceof PsiPrimitiveType) {
                    return;
                }
                if (!TypeConversionUtil.areTypesConvertible(elementType = TypeConversionUtil.erasure(elementType), arrayElementType = TypeConversionUtil.erasure(arrayElementType))) {
                    holder.registerProblem((PsiElement)element, InspectionsBundle.message("inspection.suspicious.array.method.call.problem.element", new Object[0]), new LocalQuickFix[0]);
                }
            }

            private void handleArrays(PsiElement context, PsiExpression array1, PsiExpression array2) {
                PsiType array1Type = array1.getType();
                PsiType array2Type = array2.getType();
                if (!(array1Type instanceof PsiArrayType) || !(array2Type instanceof PsiArrayType)) {
                    return;
                }
                PsiType array1ElementType = ((PsiArrayType)array1Type).getComponentType();
                PsiType array2ElementType = ((PsiArrayType)array2Type).getComponentType();
                if (array1ElementType instanceof PsiPrimitiveType || array2ElementType instanceof PsiPrimitiveType) {
                    return;
                }
                if (!TypeConversionUtil.areTypesConvertible(array1ElementType = TypeConversionUtil.erasure(array1ElementType), array2ElementType = TypeConversionUtil.erasure(array2ElementType)) || !TypeConversionUtil.areTypesConvertible(array2ElementType, array1ElementType)) {
                    holder.registerProblem(context, InspectionsBundle.message("inspection.suspicious.array.method.call.problem.arrays", new Object[0]), new LocalQuickFix[0]);
                }
            }
        };
        if (javaElementVisitor == null) {
            SuspiciousArrayMethodCallInspection.$$$reportNull$$$0(1);
        }
        return javaElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/SuspiciousArrayMethodCallInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/SuspiciousArrayMethodCallInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

