/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.util.Key;
import com.intellij.util.keyFMap.KeyFMap;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DfaFactMap {
    public static final DfaFactMap EMPTY = new DfaFactMap(KeyFMap.EMPTY_MAP);
    @NotNull
    private final KeyFMap myMap;

    private DfaFactMap(@NotNull KeyFMap map) {
        if (map == null) {
            DfaFactMap.$$$reportNull$$$0(0);
        }
        this.myMap = map;
    }

    @Nullable
    public <T> T get(@NotNull DfaFactType<T> type) {
        if (type == null) {
            DfaFactMap.$$$reportNull$$$0(1);
        }
        return this.myMap.get(type);
    }

    @NotNull
    public <T> DfaFactMap with(@NotNull DfaFactType<T> type, @Nullable T value) {
        if (type == null) {
            DfaFactMap.$$$reportNull$$$0(2);
        }
        KeyFMap newMap = value == null ? this.myMap.minus(type) : this.myMap.plus(type, value);
        DfaFactMap dfaFactMap = newMap == this.myMap ? this : new DfaFactMap(newMap);
        if (dfaFactMap == null) {
            DfaFactMap.$$$reportNull$$$0(3);
        }
        return dfaFactMap;
    }

    public boolean isSuperStateOf(DfaFactMap subMap) {
        for (Key key : this.myMap.getKeys()) {
            DfaFactType type = (DfaFactType)key;
            Object other = subMap.get(type);
            if (other == null) {
                return false;
            }
            Object thisValue = this.myMap.get(type);
            Objects.requireNonNull(thisValue);
            if (type.isSuper(thisValue, other)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public <T> DfaFactMap intersect(@NotNull DfaFactType<T> type, @Nullable T value) {
        if (type == null) {
            DfaFactMap.$$$reportNull$$$0(4);
        }
        if (value == null) {
            return this;
        }
        T curFact = this.get(type);
        if (curFact == null) {
            return this.with(type, value);
        }
        T newFact = type.intersectFacts(curFact, value);
        return newFact == null ? null : this.with(type, newFact);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof DfaFactMap && this.myMap.equals(((DfaFactMap)o).myMap);
    }

    public int hashCode() {
        return this.myMap.hashCode();
    }

    public String toString() {
        return StreamEx.of((Object[])this.myMap.getKeys()).map(key -> ((DfaFactType)key).toString(this.myMap.get(key))).joining((CharSequence)", ");
    }

    public static DfaFactMap calcFromVariable(@NotNull DfaVariableValue value) {
        if (value == null) {
            DfaFactMap.$$$reportNull$$$0(5);
        }
        return (DfaFactMap)StreamEx.of(DfaFactType.getTypes()).foldLeft((Object)EMPTY, (factMap, type) -> {
            if (value == null) {
                DfaFactMap.$$$reportNull$$$0(6);
            }
            return DfaFactMap.updateMap(factMap, type, value);
        });
    }

    private static <T> DfaFactMap updateMap(DfaFactMap map, DfaFactType<T> factType, DfaVariableValue value) {
        return map.with(factType, factType.calcFromVariable(value));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/DfaFactMap";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/DfaFactMap";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "with";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "with";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "intersect";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "calcFromVariable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$calcFromVariable$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

