/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.ContractInferenceIndexKt;
import com.intellij.codeInspection.dataFlow.ExpressionRange;
import com.intellij.codeInspection.dataFlow.InferenceFromSourceUtil;
import com.intellij.codeInspection.dataFlow.MethodData;
import com.intellij.codeInspection.dataFlow.PurityInferenceResult;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.JavaLightTreeUtil;
import com.intellij.psi.impl.source.PsiMethodImpl;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PurityInference {
    public static boolean inferPurity(@NotNull PsiMethodImpl method) {
        if (method == null) {
            PurityInference.$$$reportNull$$$0(0);
        }
        if (!InferenceFromSourceUtil.shouldInferFromSource(method) || PsiType.VOID.equals(method.getReturnType()) || method.isConstructor()) {
            return false;
        }
        return (Boolean)CachedValuesManager.getCachedValue(method, () -> {
            MethodData data;
            if (method == null) {
                PurityInference.$$$reportNull$$$0(1);
            }
            PurityInferenceResult result = (data = ContractInferenceIndexKt.getIndexedData(method)) == null ? null : data.getPurity();
            Boolean pure = RecursionManager.doPreventingRecursion(method, true, () -> {
                if (method == null) {
                    PurityInference.$$$reportNull$$$0(2);
                }
                return result != null && result.isPure(method, data.methodBody(method));
            });
            return CachedValueProvider.Result.create(Boolean.valueOf(pure == Boolean.TRUE), method);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "method";
        objectArray2[1] = "com/intellij/codeInspection/dataFlow/PurityInference";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "inferPurity";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$inferPurity$1";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class PurityInferenceVisitor {
        private final LighterAST tree;
        private final LighterASTNode body;
        private List<LighterASTNode> mutatedRefs = new ArrayList<LighterASTNode>();
        private boolean hasReturns;
        private List<LighterASTNode> calls = new ArrayList<LighterASTNode>();

        PurityInferenceVisitor(LighterAST tree, LighterASTNode body) {
            this.tree = tree;
            this.body = body;
        }

        void visitNode(LighterASTNode element) {
            IElementType type = element.getTokenType();
            if (type == JavaElementType.ASSIGNMENT_EXPRESSION) {
                this.mutatedRefs.add(this.tree.getChildren(element).get(0));
            } else if (type == JavaElementType.RETURN_STATEMENT && JavaLightTreeUtil.findExpressionChild(this.tree, element) != null) {
                this.hasReturns = true;
            } else if ((type == JavaElementType.PREFIX_EXPRESSION || type == JavaElementType.POSTFIX_EXPRESSION) && this.isMutatingOperation(element)) {
                ContainerUtil.addIfNotNull(this.mutatedRefs, JavaLightTreeUtil.findExpressionChild(this.tree, element));
            } else if (this.isCall(element, type)) {
                this.calls.add(element);
            }
        }

        private boolean isCall(@NotNull LighterASTNode element, IElementType type) {
            if (element == null) {
                PurityInferenceVisitor.$$$reportNull$$$0(0);
            }
            return type == JavaElementType.NEW_EXPRESSION && LightTreeUtil.firstChildOfType(this.tree, element, JavaElementType.EXPRESSION_LIST) != null || type == JavaElementType.METHOD_CALL_EXPRESSION;
        }

        private boolean isMutatingOperation(@NotNull LighterASTNode element) {
            if (element == null) {
                PurityInferenceVisitor.$$$reportNull$$$0(1);
            }
            return LightTreeUtil.firstChildOfType(this.tree, element, JavaTokenType.PLUSPLUS) != null || LightTreeUtil.firstChildOfType(this.tree, element, JavaTokenType.MINUSMINUS) != null;
        }

        @Nullable
        PurityInferenceResult getResult() {
            if (this.calls.size() > 1 || !this.hasReturns) {
                return null;
            }
            int bodyStart = this.body.getStartOffset();
            return new PurityInferenceResult(ContainerUtil.map(this.mutatedRefs, node -> ExpressionRange.create(node, bodyStart)), this.calls.isEmpty() ? null : ExpressionRange.create(this.calls.get(0), bodyStart));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "element";
            objectArray2[1] = "com/intellij/codeInspection/dataFlow/PurityInference$PurityInferenceVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isCall";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isMutatingOperation";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

