/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.impl.light.LightVariableBuilder;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaExpressionFactory {
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInspection.dataFlow.value.DfaExpressionFactory");
    private static final Condition<String> FALSE_GETTERS = DfaExpressionFactory.parseFalseGetters();
    private final DfaValueFactory myFactory;
    private final Map<Integer, PsiVariable> myMockIndices = ContainerUtil.newHashMap();

    private static Condition<String> parseFalseGetters() {
        try {
            String regex = Registry.stringValue("ide.dfa.getters.with.side.effects").trim();
            if (!StringUtil.isEmpty(regex)) {
                Pattern pattern = Pattern.compile(regex);
                return s -> pattern.matcher((CharSequence)s).matches();
            }
        }
        catch (Exception e) {
            LOG.error(e);
        }
        return Conditions.alwaysFalse();
    }

    public DfaExpressionFactory(DfaValueFactory factory) {
        this.myFactory = factory;
    }

    @Nullable
    public DfaValue getExpressionDfaValue(@Nullable PsiExpression expression) {
        PsiType type;
        Object qualifier;
        if (expression == null) {
            return null;
        }
        if (expression instanceof PsiParenthesizedExpression) {
            return this.getExpressionDfaValue(((PsiParenthesizedExpression)expression).getExpression());
        }
        if (expression instanceof PsiArrayAccessExpression) {
            PsiVariable indexVar;
            PsiExpression arrayExpression = ((PsiArrayAccessExpression)expression).getArrayExpression();
            qualifier = this.getQualifierVariable(arrayExpression);
            if (qualifier != null && (indexVar = this.getArrayIndexVariable(((PsiArrayAccessExpression)expression).getIndexExpression())) != null) {
                return this.myFactory.getVarFactory().createVariableValue(indexVar, expression.getType(), false, (DfaVariableValue)qualifier);
            }
            PsiType type2 = expression.getType();
            if (type2 != null) {
                return this.myFactory.createTypeValue(type2, DfaPsiUtil.getElementNullability(type2, null));
            }
        }
        if (expression instanceof PsiMethodCallExpression) {
            return this.createReferenceValue(((PsiMethodCallExpression)expression).getMethodExpression());
        }
        if (expression instanceof PsiReferenceExpression) {
            return this.createReferenceValue((PsiReferenceExpression)expression);
        }
        if (expression instanceof PsiLiteralExpression) {
            return this.myFactory.createLiteralValue((PsiLiteralExpression)expression);
        }
        if (expression instanceof PsiNewExpression || expression instanceof PsiLambdaExpression) {
            return this.myFactory.createTypeValue(expression.getType(), Nullness.NOT_NULL);
        }
        Object value = JavaConstantExpressionEvaluator.computeConstantExpression(expression, false);
        if (value != null && (type = expression.getType()) != null) {
            return this.myFactory.getConstFactory().createFromValue(value, type, null);
        }
        if (expression instanceof PsiThisExpression) {
            PsiElement target;
            qualifier = ((PsiThisExpression)expression).getQualifier();
            PsiElement psiElement = target = qualifier == null ? null : qualifier.resolve();
            if (target instanceof PsiClass) {
                return this.myFactory.getVarFactory().createVariableValue((PsiModifierListOwner)target, null, false, null);
            }
        }
        return null;
    }

    private DfaValue createReferenceValue(@NotNull PsiReferenceExpression refExpr) {
        PsiModifierListOwner var;
        if (refExpr == null) {
            DfaExpressionFactory.$$$reportNull$$$0(0);
        }
        if ((var = DfaExpressionFactory.getAccessedVariableOrGetter(refExpr.resolve())) == null) {
            return null;
        }
        if (!var.hasModifierProperty("volatile")) {
            DfaValue constValue;
            if (var instanceof PsiVariable && var.hasModifierProperty("final") && !PsiUtil.isAccessedForWriting(refExpr) && (constValue = this.myFactory.getConstFactory().create((PsiVariable)var)) != null && !DfaExpressionFactory.maybeUninitializedConstant(constValue, refExpr, var)) {
                return constValue;
            }
            if (DfaValueFactory.isEffectivelyUnqualified(refExpr) || DfaExpressionFactory.isStaticFinalConstantWithoutInitializationHacks(var)) {
                return this.myFactory.getVarFactory().createVariableValue(var, refExpr.getType(), false, null);
            }
            DfaVariableValue qualifier = this.getQualifierVariable(refExpr.getQualifierExpression());
            if (qualifier != null) {
                return this.myFactory.getVarFactory().createVariableValue(var, refExpr.getType(), false, qualifier);
            }
        }
        PsiType type = refExpr.getType();
        return this.myFactory.createTypeValue(type, DfaPsiUtil.getElementNullability(type, var));
    }

    private DfaVariableValue getQualifierVariable(PsiExpression qualifierExpression) {
        Object constValue;
        DfaValue qualifierValue = this.getExpressionDfaValue(qualifierExpression);
        DfaVariableValue qualifier = null;
        if (qualifierValue instanceof DfaVariableValue) {
            qualifier = (DfaVariableValue)qualifierValue;
        } else if (qualifierValue instanceof DfaConstValue && (constValue = ((DfaConstValue)qualifierValue).getValue()) instanceof PsiVariable) {
            qualifier = this.myFactory.getVarFactory().createVariableValue((PsiVariable)constValue, false);
        }
        return qualifier;
    }

    private static boolean maybeUninitializedConstant(DfaValue constValue, @NotNull PsiReferenceExpression refExpr, PsiModifierListOwner var) {
        if (refExpr == null) {
            DfaExpressionFactory.$$$reportNull$$$0(1);
        }
        if (!(constValue instanceof DfaConstValue) || ((DfaConstValue)constValue).getValue() != var) {
            return false;
        }
        if (!(var instanceof PsiField) || var instanceof PsiEnumConstant) {
            return false;
        }
        return PsiTreeUtil.getTopmostParentOfType(refExpr, PsiClass.class) == PsiTreeUtil.getTopmostParentOfType(var, PsiClass.class);
    }

    private static boolean isStaticFinalConstantWithoutInitializationHacks(PsiModifierListOwner var) {
        return var instanceof PsiField && var.hasModifierProperty("final") && var.hasModifierProperty("static") && !DfaUtil.hasInitializationHacks((PsiField)var);
    }

    @Nullable
    private static PsiModifierListOwner getAccessedVariableOrGetter(PsiElement target) {
        if (target instanceof PsiVariable) {
            return (PsiVariable)target;
        }
        if (target instanceof PsiMethod) {
            String qName;
            PsiMethod method = (PsiMethod)target;
            if (!(!PropertyUtil.isSimplePropertyGetter(method) || method.getReturnType() instanceof PsiPrimitiveType || (qName = PsiUtil.getMemberQualifiedName(method)) != null && FALSE_GETTERS.value(qName))) {
                return method;
            }
            for (SpecialField sf : SpecialField.values()) {
                if (!sf.isMyAccessor(method)) continue;
                return sf.getCanonicalOwner(null, ((PsiMethod)target).getContainingClass());
            }
            if (AnnotationUtil.findAnnotation((PsiModifierListOwner)method.getContainingClass(), "javax.annotation.concurrent.Immutable") != null) {
                return method;
            }
        }
        return null;
    }

    @Nullable
    private PsiVariable getArrayIndexVariable(@Nullable PsiExpression indexExpression) {
        Object constant = JavaConstantExpressionEvaluator.computeConstantExpression(indexExpression, false);
        if (constant instanceof Integer && (Integer)constant >= 0) {
            return this.myMockIndices.computeIfAbsent((Integer)constant, k -> new LightVariableBuilder("$array$index$" + k, PsiType.INT, (PsiElement)indexExpression));
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "refExpr";
        objectArray2[1] = "com/intellij/codeInspection/dataFlow/value/DfaExpressionFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createReferenceValue";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "maybeUninitializedConstant";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

