/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.javaDoc;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.javaDoc.JavadocHighlightUtil;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiSyntheticClass;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.javadoc.JavadocManager;
import com.intellij.psi.javadoc.JavadocTagInfo;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiInlineDocTag;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaDocLocalInspectionBase
extends BaseJavaBatchLocalInspectionTool {
    public static final String SHORT_NAME = "JavaDoc";
    protected static final String NONE = "none";
    protected static final String PACKAGE_LOCAL = "package";
    protected static final String PUBLIC = "public";
    protected static final String PROTECTED = "protected";
    protected static final String PRIVATE = "private";
    private static final String IGNORE_ACCESSORS_ATTR_NAME = "IGNORE_ACCESSORS";
    private static final String IGNORE_DUPLICATED_THROWS_TAGS_ATTR_NAME = "IGNORE_DUPLICATED_THROWS_TAGS";
    protected final Options PACKAGE_OPTIONS = new Options("none", "");
    public Options TOP_LEVEL_CLASS_OPTIONS = new Options("none", "");
    public Options INNER_CLASS_OPTIONS = new Options("none", "");
    public Options METHOD_OPTIONS = new Options("none", "@return@param@throws or @exception");
    public Options FIELD_OPTIONS = new Options("none", "");
    public boolean IGNORE_DEPRECATED;
    public boolean IGNORE_JAVADOC_PERIOD = true;
    @Deprecated
    public boolean IGNORE_DUPLICATED_THROWS;
    public boolean IGNORE_POINT_TO_ITSELF;
    public String myAdditionalJavadocTags = "";
    private boolean myIgnoreDuplicatedThrows = true;
    private boolean myIgnoreEmptyDescriptions;
    private boolean myIgnoreSimpleAccessors;

    public void setPackageOption(String modifier, String tags) {
        this.PACKAGE_OPTIONS.ACCESS_JAVADOC_REQUIRED_FOR = modifier;
        this.PACKAGE_OPTIONS.REQUIRED_TAGS = tags;
    }

    public void registerAdditionalTag(@NotNull String tag) {
        if (tag == null) {
            JavaDocLocalInspectionBase.$$$reportNull$$$0(0);
        }
        this.myAdditionalJavadocTags = !this.myAdditionalJavadocTags.isEmpty() ? this.myAdditionalJavadocTags + "," + tag : tag;
    }

    public boolean isIgnoreDuplicatedThrows() {
        return this.myIgnoreDuplicatedThrows;
    }

    public void setIgnoreDuplicatedThrows(boolean ignoreDuplicatedThrows) {
        this.myIgnoreDuplicatedThrows = ignoreDuplicatedThrows;
    }

    public void setIgnoreEmptyDescriptions(boolean ignoreEmptyDescriptions) {
        this.myIgnoreEmptyDescriptions = ignoreEmptyDescriptions;
    }

    public boolean isIgnoreSimpleAccessors() {
        return this.myIgnoreSimpleAccessors;
    }

    public void setIgnoreSimpleAccessors(boolean ignoreSimpleAccessors) {
        this.myIgnoreSimpleAccessors = ignoreSimpleAccessors;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            JavaDocLocalInspectionBase.$$$reportNull$$$0(1);
        }
        super.writeSettings(node);
        if (this.myIgnoreSimpleAccessors) {
            node.addContent(new Element(IGNORE_ACCESSORS_ATTR_NAME).setAttribute("value", String.valueOf(true)));
        }
        if (!this.myIgnoreDuplicatedThrows) {
            node.addContent(new Element(IGNORE_DUPLICATED_THROWS_TAGS_ATTR_NAME).setAttribute("value", String.valueOf(false)));
        }
        if (!this.PACKAGE_OPTIONS.ACCESS_JAVADOC_REQUIRED_FOR.equals(NONE) || !this.PACKAGE_OPTIONS.REQUIRED_TAGS.isEmpty()) {
            this.PACKAGE_OPTIONS.writeExternal(node);
        }
    }

    @Override
    public void readSettings(@NotNull Element node) throws InvalidDataException {
        Element ignoreDupThrowsTag;
        if (node == null) {
            JavaDocLocalInspectionBase.$$$reportNull$$$0(2);
        }
        super.readSettings(node);
        Element ignoreAccessorsTag = node.getChild(IGNORE_ACCESSORS_ATTR_NAME);
        if (ignoreAccessorsTag != null) {
            this.myIgnoreSimpleAccessors = Boolean.parseBoolean(ignoreAccessorsTag.getAttributeValue("value"));
        }
        if ((ignoreDupThrowsTag = node.getChild(IGNORE_DUPLICATED_THROWS_TAGS_ATTR_NAME)) != null) {
            this.myIgnoreDuplicatedThrows = Boolean.parseBoolean(ignoreDupThrowsTag.getAttributeValue("value"));
        }
        this.PACKAGE_OPTIONS.readExternal(node);
    }

    @Override
    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            JavaDocLocalInspectionBase.$$$reportNull$$$0(3);
        }
        if (manager == null) {
            JavaDocLocalInspectionBase.$$$reportNull$$$0(4);
        }
        if (!"package-info.java".equals(file.getName()) || !(file instanceof PsiJavaFile)) {
            return null;
        }
        PsiDocComment docComment = PsiTreeUtil.getChildOfType(file, PsiDocComment.class);
        PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(file.getContainingDirectory());
        boolean required = aPackage != null && JavadocHighlightUtil.isJavaDocRequired(this, aPackage);
        ProblemHolderImpl holder = new ProblemHolderImpl(manager, isOnTheFly);
        if (this.IGNORE_DEPRECATED && (AnnotationUtil.findAnnotation((PsiModifierListOwner)aPackage, "java.lang.Deprecated") != null || docComment != null && docComment.findTagByName("deprecated") != null)) {
            return null;
        }
        if (docComment == null) {
            if (required) {
                PsiElement toHighlight = ObjectUtils.notNull(((PsiJavaFile)file).getPackageStatement(), file);
                JavadocHighlightUtil.reportMissingTag(toHighlight, holder);
            }
        } else {
            PsiDocTag[] tags = docComment.getTags();
            if (required) {
                Predicate<String> tagChecker = tag -> this.isTagRequired(aPackage, (String)tag);
                JavadocHighlightUtil.checkRequiredTags(tags, tagChecker, docComment.getFirstChild(), holder);
            }
            JavadocHighlightUtil.checkRequiredTagDescriptions(tags, holder);
            JavadocHighlightUtil.checkTagValues(tags, aPackage, holder);
            JavadocHighlightUtil.checkInlineTags(docComment.getDescriptionElements(), holder);
            if (!this.IGNORE_JAVADOC_PERIOD) {
                JavadocHighlightUtil.checkForPeriod(docComment, aPackage, holder);
            }
            JavadocHighlightUtil.checkForBadCharacters(docComment, holder);
        }
        return holder.problems();
    }

    @Override
    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull PsiClass psiClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (psiClass == null) {
            JavaDocLocalInspectionBase.$$$reportNull$$$0(5);
        }
        if (manager == null) {
            JavaDocLocalInspectionBase.$$$reportNull$$$0(6);
        }
        if (psiClass instanceof PsiAnonymousClass || psiClass instanceof PsiSyntheticClass || psiClass instanceof PsiTypeParameter) {
            return null;
        }
        if (this.IGNORE_DEPRECATED && psiClass.isDeprecated()) {
            return null;
        }
        PsiDocComment docComment = psiClass.getDocComment();
        boolean required = JavadocHighlightUtil.isJavaDocRequired(this, psiClass);
        ProblemHolderImpl holder = new ProblemHolderImpl(manager, isOnTheFly);
        if (docComment == null) {
            if (required) {
                PsiElement toHighlight = ObjectUtils.notNull(psiClass.getNameIdentifier(), psiClass);
                JavadocHighlightUtil.reportMissingTag(toHighlight, holder);
            }
        } else {
            PsiDocTag[] tags = docComment.getTags();
            if (required) {
                Predicate<String> tagChecker = tag -> {
                    if (psiClass == null) {
                        JavaDocLocalInspectionBase.$$$reportNull$$$0(20);
                    }
                    return this.isTagRequired(psiClass, (String)tag);
                };
                JavadocHighlightUtil.checkRequiredTags(tags, tagChecker, docComment.getFirstChild(), holder);
            }
            JavadocHighlightUtil.checkRequiredTagDescriptions(tags, holder);
            JavadocHighlightUtil.checkTagValues(tags, psiClass, holder);
            if (!this.IGNORE_JAVADOC_PERIOD) {
                JavadocHighlightUtil.checkForPeriod(docComment, psiClass, holder);
            }
            JavadocHighlightUtil.checkInlineTags(docComment.getDescriptionElements(), holder);
            JavadocHighlightUtil.checkForBadCharacters(docComment, holder);
            JavadocHighlightUtil.checkDuplicateTags(tags, holder);
            if (required && this.isTagRequired(psiClass, "param")) {
                JavadocHighlightUtil.checkMissingTypeParamTags(psiClass, tags, docComment.getFirstChild(), holder);
            }
        }
        return holder.problems();
    }

    @Override
    @Nullable
    public ProblemDescriptor[] checkField(@NotNull PsiField psiField, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (psiField == null) {
            JavaDocLocalInspectionBase.$$$reportNull$$$0(7);
        }
        if (manager == null) {
            JavaDocLocalInspectionBase.$$$reportNull$$$0(8);
        }
        if (this.IGNORE_DEPRECATED && JavaDocLocalInspectionBase.isDeprecated(psiField)) {
            return null;
        }
        PsiDocComment docComment = psiField.getDocComment();
        boolean required = JavadocHighlightUtil.isJavaDocRequired(this, psiField);
        ProblemHolderImpl holder = new ProblemHolderImpl(manager, isOnTheFly);
        if (docComment == null) {
            if (required) {
                JavadocHighlightUtil.reportMissingTag(psiField.getNameIdentifier(), holder);
            }
        } else {
            JavadocHighlightUtil.checkTagValues(docComment.getTags(), psiField, holder);
            JavadocHighlightUtil.checkInlineTags(docComment.getDescriptionElements(), holder);
            if (!this.IGNORE_JAVADOC_PERIOD) {
                JavadocHighlightUtil.checkForPeriod(docComment, psiField, holder);
            }
            JavadocHighlightUtil.checkDuplicateTags(docComment.getTags(), holder);
            JavadocHighlightUtil.checkForBadCharacters(docComment, holder);
        }
        return holder.problems();
    }

    @Override
    @Nullable
    public ProblemDescriptor[] checkMethod(@NotNull PsiMethod psiMethod, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (psiMethod == null) {
            JavaDocLocalInspectionBase.$$$reportNull$$$0(9);
        }
        if (manager == null) {
            JavaDocLocalInspectionBase.$$$reportNull$$$0(10);
        }
        if (psiMethod instanceof SyntheticElement) {
            return null;
        }
        if (this.IGNORE_DEPRECATED && JavaDocLocalInspectionBase.isDeprecated(psiMethod)) {
            return null;
        }
        if (this.myIgnoreSimpleAccessors && PropertyUtil.isSimplePropertyAccessor(psiMethod)) {
            return null;
        }
        PsiDocComment docComment = psiMethod.getDocComment();
        boolean hasSupers = psiMethod.findSuperMethods().length > 0;
        boolean required = JavadocHighlightUtil.isJavaDocRequired(this, psiMethod);
        ProblemHolderImpl holder = new ProblemHolderImpl(manager, isOnTheFly);
        if (docComment == null) {
            if (!required || hasSupers) {
                return null;
            }
            PsiIdentifier nameIdentifier = psiMethod.getNameIdentifier();
            if (nameIdentifier == null) {
                return null;
            }
            ExtensionPoint ep = Extensions.getRootArea().getExtensionPoint("com.intellij.javaDocNotNecessary");
            if (Stream.of(ep.getExtensions()).anyMatch(condition -> {
                if (psiMethod == null) {
                    JavaDocLocalInspectionBase.$$$reportNull$$$0(19);
                }
                return condition.value(psiMethod);
            })) {
                return null;
            }
            JavadocHighlightUtil.reportMissingTag(nameIdentifier, holder);
        } else {
            PsiElement[] descriptionElements = docComment.getDescriptionElements();
            if (JavaDocLocalInspectionBase.isInherited(docComment, descriptionElements, psiMethod)) {
                return null;
            }
            JavadocHighlightUtil.checkInlineTags(descriptionElements, holder);
            PsiDocTag[] tags = docComment.getTags();
            if (required && !hasSupers) {
                if (this.isTagRequired(psiMethod, "return")) {
                    JavadocHighlightUtil.checkMissingReturnTag(tags, psiMethod, docComment.getFirstChild(), holder);
                }
                if (this.isTagRequired(psiMethod, "param")) {
                    JavadocHighlightUtil.checkMissingParamTags(tags, psiMethod, docComment.getFirstChild(), holder);
                }
                if (this.isTagRequired(psiMethod, "throws")) {
                    JavadocHighlightUtil.checkMissingThrowsTags(tags, psiMethod, docComment.getFirstChild(), holder);
                }
            }
            if (!this.myIgnoreEmptyDescriptions) {
                JavadocHighlightUtil.checkEmptyMethodTagsDescription(tags, holder);
            }
            JavadocHighlightUtil.checkTagValues(tags, psiMethod, holder);
            if (!this.IGNORE_JAVADOC_PERIOD) {
                JavadocHighlightUtil.checkForPeriod(docComment, psiMethod, holder);
            }
            JavadocHighlightUtil.checkForBadCharacters(docComment, holder);
            JavadocHighlightUtil.checkDuplicateTags(tags, holder);
        }
        return holder.problems();
    }

    private boolean isTagRequired(PsiElement context, String tag) {
        if (context instanceof PsiPackage) {
            return JavaDocLocalInspectionBase.isTagRequired(this.PACKAGE_OPTIONS, tag);
        }
        if (context instanceof PsiClass) {
            boolean isInner = PsiTreeUtil.getParentOfType(context, PsiClass.class) != null;
            return JavaDocLocalInspectionBase.isTagRequired(isInner ? this.INNER_CLASS_OPTIONS : this.TOP_LEVEL_CLASS_OPTIONS, tag);
        }
        if (context instanceof PsiMethod) {
            return JavaDocLocalInspectionBase.isTagRequired(this.METHOD_OPTIONS, tag);
        }
        if (context instanceof PsiField) {
            return JavaDocLocalInspectionBase.isTagRequired(this.FIELD_OPTIONS, tag);
        }
        return false;
    }

    protected static boolean isTagRequired(Options options, String tag) {
        return options.REQUIRED_TAGS.contains(tag);
    }

    private static boolean isDeprecated(PsiDocCommentOwner element) {
        return element.isDeprecated() || element.getContainingClass() != null && element.getContainingClass().isDeprecated();
    }

    private static boolean isInherited(PsiDocComment docComment, PsiElement[] descriptionElements, PsiMethod psiMethod) {
        JavadocTagInfo tagInfo;
        for (PsiElement descriptionElement : descriptionElements) {
            if (!(descriptionElement instanceof PsiInlineDocTag) || !"inheritDoc".equals(((PsiInlineDocTag)descriptionElement).getName())) continue;
            return true;
        }
        return docComment.findTagByName("inheritDoc") != null && (tagInfo = JavadocManager.SERVICE.getInstance(psiMethod.getProject()).getTagInfo("inheritDoc")) != null && tagInfo.isValidInContext(psiMethod);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message("inspection.javadoc.display.name", new Object[0]);
        if (string == null) {
            JavaDocLocalInspectionBase.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Override
    @NotNull
    public String getGroupDisplayName() {
        String string = InspectionsBundle.message("group.names.javadoc.issues", new Object[0]);
        if (string == null) {
            JavaDocLocalInspectionBase.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Override
    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            JavaDocLocalInspectionBase.$$$reportNull$$$0(13);
        }
        return SHORT_NAME;
    }

    @Override
    @Nullable
    public String getAlternativeID() {
        return "javadoc";
    }

    protected LocalQuickFix createAddJavadocFix(@NotNull PsiElement nameIdentifier, boolean isOnTheFly) {
        if (nameIdentifier == null) {
            JavaDocLocalInspectionBase.$$$reportNull$$$0(14);
        }
        return null;
    }

    protected LocalQuickFix createAddMissingTagFix(@NotNull String tag, @NotNull String value, boolean isOnTheFly) {
        if (tag == null) {
            JavaDocLocalInspectionBase.$$$reportNull$$$0(15);
        }
        if (value == null) {
            JavaDocLocalInspectionBase.$$$reportNull$$$0(16);
        }
        return null;
    }

    protected LocalQuickFix createAddMissingParamTagFix(@NotNull String name, boolean isOnTheFly) {
        if (name == null) {
            JavaDocLocalInspectionBase.$$$reportNull$$$0(17);
        }
        return null;
    }

    protected LocalQuickFix createRegisterTagFix(@NotNull String tag, boolean isOnTheFly) {
        if (tag == null) {
            JavaDocLocalInspectionBase.$$$reportNull$$$0(18);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 5: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
            case 9: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameIdentifier";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerAdditionalTag";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkField";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkMethod";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createAddJavadocFix";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createAddMissingTagFix";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createAddMissingParamTagFix";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createRegisterTagFix";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$checkMethod$2";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$checkClass$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ProblemHolderImpl
    implements JavadocHighlightUtil.ProblemHolder {
        private final InspectionManager myManager;
        private final boolean myOnTheFly;
        private List<ProblemDescriptor> myProblems;

        private ProblemHolderImpl(InspectionManager manager, boolean onTheFly) {
            this.myManager = manager;
            this.myOnTheFly = onTheFly;
        }

        public ProblemDescriptor[] problems() {
            return this.myProblems == null || this.myProblems.isEmpty() ? null : this.myProblems.toArray(new ProblemDescriptor[this.myProblems.size()]);
        }

        @Override
        public Project project() {
            return this.myManager.getProject();
        }

        @Override
        public JavaDocLocalInspectionBase inspection() {
            return JavaDocLocalInspectionBase.this;
        }

        @Override
        public void problem(@NotNull PsiElement toHighlight, @NotNull @Nls String message, @Nullable LocalQuickFix fix) {
            if (toHighlight == null) {
                ProblemHolderImpl.$$$reportNull$$$0(0);
            }
            if (message == null) {
                ProblemHolderImpl.$$$reportNull$$$0(1);
            }
            if (this.myProblems == null) {
                this.myProblems = ContainerUtil.newSmartList();
            }
            this.myProblems.add(this.myManager.createProblemDescriptor(toHighlight, message, fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.myOnTheFly));
        }

        @Override
        public void eolProblem(@NotNull PsiElement toHighlight, @NotNull @Nls String message, @Nullable LocalQuickFix fix) {
            LocalQuickFix[] localQuickFixArray;
            if (toHighlight == null) {
                ProblemHolderImpl.$$$reportNull$$$0(2);
            }
            if (message == null) {
                ProblemHolderImpl.$$$reportNull$$$0(3);
            }
            if (this.myProblems == null) {
                this.myProblems = ContainerUtil.newSmartList();
            }
            if (fix != null) {
                LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                localQuickFixArray = localQuickFixArray2;
                localQuickFixArray2[0] = fix;
            } else {
                localQuickFixArray = null;
            }
            LocalQuickFix[] fixes = localQuickFixArray;
            this.myProblems.add(this.myManager.createProblemDescriptor(toHighlight, message, fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.myOnTheFly, true));
        }

        @Override
        public LocalQuickFix addJavadocFix(@NotNull PsiElement nameIdentifier) {
            if (nameIdentifier == null) {
                ProblemHolderImpl.$$$reportNull$$$0(4);
            }
            return JavaDocLocalInspectionBase.this.createAddJavadocFix(nameIdentifier, this.myOnTheFly);
        }

        @Override
        public LocalQuickFix addMissingTagFix(@NotNull String tag, @NotNull String value) {
            if (tag == null) {
                ProblemHolderImpl.$$$reportNull$$$0(5);
            }
            if (value == null) {
                ProblemHolderImpl.$$$reportNull$$$0(6);
            }
            return JavaDocLocalInspectionBase.this.createAddMissingTagFix(tag, value, this.myOnTheFly);
        }

        @Override
        public LocalQuickFix addMissingParamTagFix(@NotNull String name) {
            if (name == null) {
                ProblemHolderImpl.$$$reportNull$$$0(7);
            }
            return JavaDocLocalInspectionBase.this.createAddMissingParamTagFix(name, this.myOnTheFly);
        }

        @Override
        public LocalQuickFix registerTagFix(@NotNull String tag) {
            if (tag == null) {
                ProblemHolderImpl.$$$reportNull$$$0(8);
            }
            return JavaDocLocalInspectionBase.this.createRegisterTagFix(tag, this.myOnTheFly);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toHighlight";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nameIdentifier";
                    break;
                }
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tag";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase$ProblemHolderImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "problem";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "eolProblem";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addJavadocFix";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addMissingTagFix";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addMissingParamTagFix";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerTagFix";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Options
    implements JDOMExternalizable {
        public String ACCESS_JAVADOC_REQUIRED_FOR = "none";
        public String REQUIRED_TAGS = "";

        public Options() {
        }

        public Options(String accessJavadocRequiredFor, String requiredTags) {
            this.ACCESS_JAVADOC_REQUIRED_FOR = accessJavadocRequiredFor;
            this.REQUIRED_TAGS = requiredTags;
        }

        @Override
        public void readExternal(Element element) throws InvalidDataException {
            DefaultJDOMExternalizer.readExternal(this, element);
        }

        @Override
        public void writeExternal(Element element) throws WriteExternalException {
            DefaultJDOMExternalizer.writeExternal(this, element);
        }
    }
}

