/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl.java;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.ide.structureView.impl.java.AccessLevelProvider;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ClassInitializerTreeElement
extends PsiTreeElementBase<PsiClassInitializer>
implements AccessLevelProvider {
    public ClassInitializerTreeElement(PsiClassInitializer initializer) {
        super(initializer);
    }

    @Override
    public String getPresentableText() {
        PsiClassInitializer initializer = (PsiClassInitializer)this.getElement();
        assert (initializer != null);
        String isStatic = initializer.hasModifierProperty("static") ? "static " : "";
        return CodeInsightBundle.message("static.class.initializer", isStatic);
    }

    @Override
    public String getLocationString() {
        PsiClassInitializer initializer = (PsiClassInitializer)this.getElement();
        assert (initializer != null);
        PsiCodeBlock body = initializer.getBody();
        PsiElement first = body.getFirstBodyElement();
        if (first instanceof PsiWhiteSpace) {
            first = first.getNextSibling();
        }
        if (first == body.getRBrace()) {
            first = null;
        }
        if (first != null) {
            return StringUtil.first(first.getText(), 20, true);
        }
        return null;
    }

    @Override
    @NotNull
    public Collection<StructureViewTreeElement> getChildrenBase() {
        List<StructureViewTreeElement> list = Collections.emptyList();
        if (list == null) {
            ClassInitializerTreeElement.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Override
    public int getAccessLevel() {
        return 1;
    }

    @Override
    public int getSubLevel() {
        return 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/impl/java/ClassInitializerTreeElement", "getChildrenBase"));
    }
}

