/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.html.structureView;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.navigation.LocationPresentation;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.HtmlUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class HtmlTagTreeElement
extends PsiTreeElementBase<XmlTag>
implements LocationPresentation {
    static final int MAX_TEXT_LENGTH = 50;

    public HtmlTagTreeElement(XmlTag tag) {
        super(tag);
    }

    @Override
    @NotNull
    public Collection<StructureViewTreeElement> getChildrenBase() {
        XmlTag tag = (XmlTag)this.getElement();
        if (tag == null || !tag.isValid()) {
            List<StructureViewTreeElement> list = Collections.emptyList();
            if (list == null) {
                HtmlTagTreeElement.$$$reportNull$$$0(0);
            }
            return list;
        }
        List<StructureViewTreeElement> list = ContainerUtil.map2List(tag.getSubTags(), HtmlTagTreeElement::new);
        if (list == null) {
            HtmlTagTreeElement.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    public String getPresentableText() {
        XmlTag tag = (XmlTag)this.getElement();
        if (tag == null) {
            return IdeBundle.message("node.structureview.invalid", new Object[0]);
        }
        return HtmlUtil.getTagPresentation(tag);
    }

    @Override
    @Nullable
    public String getLocationString() {
        XmlTag tag = (XmlTag)this.getElement();
        if (tag == null) {
            return null;
        }
        if (tag.getName().equalsIgnoreCase("img") || HtmlUtil.isScriptTag(tag)) {
            return HtmlTagTreeElement.getPathDescription(tag.getAttributeValue("src"));
        }
        if (tag.getName().equalsIgnoreCase("link")) {
            return HtmlTagTreeElement.getPathDescription(tag.getAttributeValue("href"));
        }
        return StringUtil.nullize(HtmlTagTreeElement.normalizeSpacesAndShortenIfLong(tag.getValue().getTrimmedText()));
    }

    private static String getPathDescription(String src) {
        if (StringUtil.isEmpty(src)) {
            return null;
        }
        return StringUtil.shortenPathWithEllipsis(src, 50, true);
    }

    @Override
    public boolean isSearchInLocationString() {
        return true;
    }

    @Nullable
    public static String normalizeSpacesAndShortenIfLong(@NotNull String text2) {
        StringBuilder builder;
        if (text2 == null) {
            HtmlTagTreeElement.$$$reportNull$$$0(2);
        }
        return (builder = HtmlTagTreeElement.normalizeSpaces(text2)) == null ? null : HtmlTagTreeElement.shortenTextIfLong(builder);
    }

    @Nullable
    private static StringBuilder normalizeSpaces(@NotNull String text2) {
        if (text2 == null) {
            HtmlTagTreeElement.$$$reportNull$$$0(3);
        }
        if (text2.isEmpty()) {
            return null;
        }
        StringBuilder buf = new StringBuilder(text2.length());
        int length = text2.length();
        for (int i2 = 0; i2 < length; ++i2) {
            char c = text2.charAt(i2);
            if (c <= ' ' || Character.isSpaceChar(c)) {
                if (buf.length() != 0 && buf.charAt(buf.length() - 1) == ' ') continue;
                buf.append(' ');
                continue;
            }
            buf.append(c);
        }
        return buf;
    }

    @Nullable
    private static String shortenTextIfLong(@NotNull StringBuilder text2) {
        int index;
        if (text2 == null) {
            HtmlTagTreeElement.$$$reportNull$$$0(4);
        }
        if (text2.length() <= 50) {
            return text2.toString();
        }
        for (index = 50; index > 30 && Character.isLetter(text2.charAt(index)); --index) {
        }
        text2.setLength(Character.isLetter(index) ? 50 : index);
        return text2.append("\u2026").toString();
    }

    @Override
    public String getLocationPrefix() {
        return "  ";
    }

    @Override
    public String getLocationSuffix() {
        return "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/html/structureView/HtmlTagTreeElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenBase";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/html/structureView/HtmlTagTreeElement";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "normalizeSpacesAndShortenIfLong";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "normalizeSpaces";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "shortenTextIfLong";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

