/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.projectRoots.ex.ProjectRoot;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SimpleProjectRoot
implements ProjectRoot {
    @NotNull
    private final String myUrl;
    private VirtualFile myFile;
    private final VirtualFile[] myFileArray;
    private boolean myInitialized;
    @NonNls
    private static final String ATTRIBUTE_URL = "url";

    public SimpleProjectRoot(@NotNull VirtualFile file) {
        if (file == null) {
            SimpleProjectRoot.$$$reportNull$$$0(0);
        }
        this.myFileArray = new VirtualFile[1];
        this.myFile = file;
        this.myUrl = this.myFile.getUrl();
    }

    public SimpleProjectRoot(@NotNull String url) {
        if (url == null) {
            SimpleProjectRoot.$$$reportNull$$$0(1);
        }
        this.myFileArray = new VirtualFile[1];
        this.myUrl = url;
    }

    SimpleProjectRoot(@NotNull Element element) {
        if (element == null) {
            SimpleProjectRoot.$$$reportNull$$$0(2);
        }
        this.myFileArray = new VirtualFile[1];
        this.myUrl = SimpleProjectRoot.readUrl(element);
    }

    public VirtualFile getFile() {
        return this.myFile;
    }

    @Override
    @NotNull
    public String getPresentableString() {
        String path = VirtualFileManager.extractPath(this.myUrl);
        path = StringUtil.trimEnd(path, "!/");
        String string = path.replace('/', File.separatorChar);
        if (string == null) {
            SimpleProjectRoot.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    public VirtualFile[] getVirtualFiles() {
        if (!this.myInitialized) {
            this.initialize();
        }
        if (this.myFile == null) {
            if (VirtualFile.EMPTY_ARRAY == null) {
                SimpleProjectRoot.$$$reportNull$$$0(4);
            }
            return VirtualFile.EMPTY_ARRAY;
        }
        this.myFileArray[0] = this.myFile;
        if (this.myFileArray == null) {
            SimpleProjectRoot.$$$reportNull$$$0(5);
        }
        return this.myFileArray;
    }

    @Override
    @NotNull
    public String[] getUrls() {
        String[] stringArray = new String[]{this.getUrl()};
        if (stringArray == null) {
            SimpleProjectRoot.$$$reportNull$$$0(6);
        }
        return stringArray;
    }

    @Override
    public boolean isValid() {
        if (!this.myInitialized) {
            this.initialize();
        }
        return this.myFile != null && this.myFile.isValid();
    }

    @Override
    public void update() {
        this.initialize();
    }

    private void initialize() {
        this.myInitialized = true;
        if (this.myFile == null || !this.myFile.isValid()) {
            this.myFile = VirtualFileManager.getInstance().findFileByUrl(this.myUrl);
            if (this.myFile != null && !this.canHaveChildren()) {
                this.myFile = null;
            }
        }
    }

    private boolean canHaveChildren() {
        return this.myFile.getFileSystem().getProtocol().equals("http") || this.myFile.isDirectory();
    }

    @NotNull
    public String getUrl() {
        String string = this.myUrl;
        if (string == null) {
            SimpleProjectRoot.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    private static String readUrl(Element element) {
        String string = element.getAttributeValue(ATTRIBUTE_URL);
        if (string == null) {
            SimpleProjectRoot.$$$reportNull$$$0(8);
        }
        return string;
    }

    public void writeExternal(Element element) {
        if (!this.myInitialized) {
            this.initialize();
        }
        element.setAttribute(ATTRIBUTE_URL, this.getUrl());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = ATTRIBUTE_URL;
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/projectRoots/impl/SimpleProjectRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/projectRoots/impl/SimpleProjectRoot";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableString";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFiles";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrls";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "readUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

