/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JDOMExternalizerUtil {
    private static final String VALUE_ATTR_NAME = "value";

    public static void writeField(@NotNull Element root, @NotNull @NonNls String fieldName, String value) {
        if (root == null) {
            JDOMExternalizerUtil.$$$reportNull$$$0(0);
        }
        if (fieldName == null) {
            JDOMExternalizerUtil.$$$reportNull$$$0(1);
        }
        Element element = new Element("option");
        element.setAttribute("name", fieldName);
        element.setAttribute(VALUE_ATTR_NAME, value == null ? "" : value);
        root.addContent(element);
    }

    public static void writeField(@NotNull Element root, @NotNull String fieldName, @Nullable String value, @NotNull String defaultValue) {
        if (root == null) {
            JDOMExternalizerUtil.$$$reportNull$$$0(2);
        }
        if (fieldName == null) {
            JDOMExternalizerUtil.$$$reportNull$$$0(3);
        }
        if (defaultValue == null) {
            JDOMExternalizerUtil.$$$reportNull$$$0(4);
        }
        if (!defaultValue.equals(value)) {
            JDOMExternalizerUtil.writeField(root, fieldName, value);
        }
    }

    @NotNull
    public static String readField(@NotNull Element parent, @NotNull @NonNls String fieldName, @NotNull String defaultValue) {
        String val;
        if (parent == null) {
            JDOMExternalizerUtil.$$$reportNull$$$0(5);
        }
        if (fieldName == null) {
            JDOMExternalizerUtil.$$$reportNull$$$0(6);
        }
        if (defaultValue == null) {
            JDOMExternalizerUtil.$$$reportNull$$$0(7);
        }
        String string = (val = JDOMExternalizerUtil.readField(parent, fieldName)) == null ? defaultValue : val;
        if (string == null) {
            JDOMExternalizerUtil.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Nullable
    public static String readField(@NotNull Element parent, @NotNull @NonNls String fieldName) {
        if (parent == null) {
            JDOMExternalizerUtil.$$$reportNull$$$0(9);
        }
        if (fieldName == null) {
            JDOMExternalizerUtil.$$$reportNull$$$0(10);
        }
        for (Element element : parent.getChildren("option")) {
            String childName = element.getAttributeValue("name");
            if (!Comparing.strEqual(childName, fieldName)) continue;
            return element.getAttributeValue(VALUE_ATTR_NAME);
        }
        return null;
    }

    public static Element getOption(@NotNull Element parent, @NotNull @NonNls String fieldName) {
        if (parent == null) {
            JDOMExternalizerUtil.$$$reportNull$$$0(11);
        }
        if (fieldName == null) {
            JDOMExternalizerUtil.$$$reportNull$$$0(12);
        }
        for (Element element : parent.getChildren("option")) {
            String childName = element.getAttributeValue("name");
            if (!Comparing.strEqual(childName, fieldName)) continue;
            return element;
        }
        return null;
    }

    @NotNull
    public static Element writeOption(@NotNull Element root, @NotNull @NonNls String fieldName) {
        if (root == null) {
            JDOMExternalizerUtil.$$$reportNull$$$0(13);
        }
        if (fieldName == null) {
            JDOMExternalizerUtil.$$$reportNull$$$0(14);
        }
        Element element = new Element("option");
        element.setAttribute("name", fieldName);
        root.addContent(element);
        Element element2 = element;
        if (element2 == null) {
            JDOMExternalizerUtil.$$$reportNull$$$0(15);
        }
        return element2;
    }

    @NotNull
    public static Element addElementWithValueAttribute(@NotNull Element parent, @NotNull String childTagName, @Nullable String attrValue) {
        if (parent == null) {
            JDOMExternalizerUtil.$$$reportNull$$$0(16);
        }
        if (childTagName == null) {
            JDOMExternalizerUtil.$$$reportNull$$$0(17);
        }
        Element element = new Element(childTagName);
        if (attrValue != null) {
            element.setAttribute(VALUE_ATTR_NAME, attrValue);
        }
        parent.addContent(element);
        Element element2 = element;
        if (element2 == null) {
            JDOMExternalizerUtil.$$$reportNull$$$0(18);
        }
        return element2;
    }

    @Nullable
    public static String getFirstChildValueAttribute(@NotNull Element parent, @NotNull String childTagName) {
        Element first;
        if (parent == null) {
            JDOMExternalizerUtil.$$$reportNull$$$0(19);
        }
        if (childTagName == null) {
            JDOMExternalizerUtil.$$$reportNull$$$0(20);
        }
        if ((first = parent.getChild(childTagName)) != null) {
            return first.getAttributeValue(VALUE_ATTR_NAME);
        }
        return null;
    }

    @NotNull
    public static List<String> getChildrenValueAttributes(@NotNull Element parent, @NotNull String childTagName) {
        List children;
        if (parent == null) {
            JDOMExternalizerUtil.$$$reportNull$$$0(21);
        }
        if (childTagName == null) {
            JDOMExternalizerUtil.$$$reportNull$$$0(22);
        }
        if ((children = parent.getChildren(childTagName)).isEmpty()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                JDOMExternalizerUtil.$$$reportNull$$$0(23);
            }
            return list;
        }
        if (children.size() == 1) {
            String value = ((Element)children.iterator().next()).getAttributeValue(VALUE_ATTR_NAME);
            List<Object> list = value == null ? Collections.emptyList() : Collections.singletonList(value);
            if (list == null) {
                JDOMExternalizerUtil.$$$reportNull$$$0(24);
            }
            return list;
        }
        ArrayList<String> values = ContainerUtil.newArrayListWithCapacity(children.size());
        for (Element child : children) {
            String value = child.getAttributeValue(VALUE_ATTR_NAME);
            if (value == null) continue;
            values.add(value);
        }
        ArrayList<String> arrayList = values;
        if (arrayList == null) {
            JDOMExternalizerUtil.$$$reportNull$$$0(25);
        }
        return arrayList;
    }

    public static void addChildrenWithValueAttribute(@NotNull Element parent, @NotNull String childTagName, @NotNull List<String> attrValues) {
        if (parent == null) {
            JDOMExternalizerUtil.$$$reportNull$$$0(26);
        }
        if (childTagName == null) {
            JDOMExternalizerUtil.$$$reportNull$$$0(27);
        }
        if (attrValues == null) {
            JDOMExternalizerUtil.$$$reportNull$$$0(28);
        }
        for (String value : attrValues) {
            if (value == null) continue;
            Element child = new Element(childTagName);
            child.setAttribute(VALUE_ATTR_NAME, value);
            parent.addContent(child);
        }
    }

    public static void addChildren(@NotNull Element parent, @NotNull String childElementName, @NotNull Collection<? extends JDOMExternalizable> children) throws WriteExternalException {
        if (parent == null) {
            JDOMExternalizerUtil.$$$reportNull$$$0(29);
        }
        if (childElementName == null) {
            JDOMExternalizerUtil.$$$reportNull$$$0(30);
        }
        if (children == null) {
            JDOMExternalizerUtil.$$$reportNull$$$0(31);
        }
        for (JDOMExternalizable jDOMExternalizable : children) {
            if (jDOMExternalizable == null) continue;
            Element element = new Element(childElementName);
            jDOMExternalizable.writeExternal(element);
            parent.addContent(element);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 15: 
            case 18: 
            case 23: 
            case 24: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 15: 
            case 18: 
            case 23: 
            case 24: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 5: 
            case 9: 
            case 11: 
            case 16: 
            case 19: 
            case 21: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 8: 
            case 15: 
            case 18: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/JDOMExternalizerUtil";
                break;
            }
            case 17: 
            case 20: 
            case 22: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTagName";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrValues";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childElementName";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/JDOMExternalizerUtil";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "readField";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "writeOption";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "addElementWithValueAttribute";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenValueAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "writeField";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "readField";
                break;
            }
            case 8: 
            case 15: 
            case 18: 
            case 23: 
            case 24: 
            case 25: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getOption";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "writeOption";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addElementWithValueAttribute";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getFirstChildValueAttribute";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenValueAttributes";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "addChildrenWithValueAttribute";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "addChildren";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 15: 
            case 18: 
            case 23: 
            case 24: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

