/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.ArrayUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class ClsRepositoryPsiElement<T extends StubElement>
extends ClsElementImpl
implements StubBasedPsiElement<T> {
    private final T myStub;

    protected ClsRepositoryPsiElement(T stub) {
        this.myStub = stub;
    }

    @Override
    public IStubElementType getElementType() {
        return this.myStub.getStubType();
    }

    @Override
    public PsiElement getParent() {
        return this.myStub.getParentStub().getPsi();
    }

    @Override
    public PsiManager getManager() {
        PsiFile file = this.getContainingFile();
        if (file == null) {
            throw new PsiInvalidElementAccessException(this);
        }
        return file.getManager();
    }

    @Override
    public PsiFile getContainingFile() {
        Object p = this.myStub;
        while (!(p instanceof PsiFileStub)) {
            p = p.getParentStub();
        }
        return (PsiFile)p.getPsi();
    }

    @Override
    public T getStub() {
        return this.myStub;
    }

    @Override
    public boolean isPhysical() {
        PsiFile file = this.getContainingFile();
        return file != null && file.isPhysical();
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        List<StubElement> stubs = this.getStub().getChildrenStubs();
        if (stubs.size() == 0) {
            if (EMPTY_ARRAY == null) {
                ClsRepositoryPsiElement.$$$reportNull$$$0(0);
            }
            return EMPTY_ARRAY;
        }
        PsiElement[] children = new PsiElement[stubs.size()];
        for (int i2 = 0; i2 < stubs.size(); ++i2) {
            children[i2] = stubs.get(i2).getPsi();
        }
        if (children == null) {
            ClsRepositoryPsiElement.$$$reportNull$$$0(1);
        }
        return children;
    }

    @Override
    public PsiElement getFirstChild() {
        List<StubElement> children = this.getStub().getChildrenStubs();
        return children.isEmpty() ? null : (PsiElement)children.get(0).getPsi();
    }

    @Override
    public PsiElement getLastChild() {
        List<StubElement> children = this.getStub().getChildrenStubs();
        return children.isEmpty() ? null : (PsiElement)children.get(children.size() - 1).getPsi();
    }

    @Override
    public PsiElement getNextSibling() {
        Object[] psiElements = this.getParent().getChildren();
        int i2 = ArrayUtil.indexOf(psiElements, this);
        if (i2 < 0 || i2 >= psiElements.length - 1) {
            return null;
        }
        return psiElements[i2 + 1];
    }

    @Override
    public PsiElement getPrevSibling() {
        Object[] psiElements = this.getParent().getChildren();
        int i2 = ArrayUtil.indexOf(psiElements, this);
        if (i2 < 1) {
            return null;
        }
        return psiElements[i2 - 1];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsRepositoryPsiElement", "getChildren"));
    }
}

