/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AllClassesSearch;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.intellij.util.indexing.IdFilter;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class AllClassesSearchExecutor
implements QueryExecutor<PsiClass, AllClassesSearch.SearchParameters> {
    @Override
    public boolean execute(@NotNull AllClassesSearch.SearchParameters queryParameters, @NotNull Processor<PsiClass> consumer) {
        PsiElement[] scopeRoots;
        SearchScope scope;
        if (queryParameters == null) {
            AllClassesSearchExecutor.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            AllClassesSearchExecutor.$$$reportNull$$$0(1);
        }
        if ((scope = queryParameters.getScope()) instanceof GlobalSearchScope) {
            return AllClassesSearchExecutor.processAllClassesInGlobalScope((GlobalSearchScope)scope, queryParameters, consumer);
        }
        for (PsiElement scopeRoot : scopeRoots = ((LocalSearchScope)scope).getScope()) {
            if (AllClassesSearchExecutor.processScopeRootForAllClasses(scopeRoot, consumer)) continue;
            return false;
        }
        return true;
    }

    private static boolean processAllClassesInGlobalScope(@NotNull GlobalSearchScope scope, @NotNull AllClassesSearch.SearchParameters parameters, @NotNull Processor<PsiClass> processor) {
        if (scope == null) {
            AllClassesSearchExecutor.$$$reportNull$$$0(2);
        }
        if (parameters == null) {
            AllClassesSearchExecutor.$$$reportNull$$$0(3);
        }
        if (processor == null) {
            AllClassesSearchExecutor.$$$reportNull$$$0(4);
        }
        THashSet names = new THashSet(10000);
        AllClassesSearchExecutor.processClassNames(parameters.getProject(), scope, arg_0 -> AllClassesSearchExecutor.lambda$processAllClassesInGlobalScope$0(parameters, (Set)names, arg_0));
        ArrayList<String> sorted = new ArrayList<String>((Collection<String>)names);
        Collections.sort(sorted, String.CASE_INSENSITIVE_ORDER);
        return AllClassesSearchExecutor.processClassesByNames(parameters.getProject(), scope, sorted, processor);
    }

    public static boolean processClassesByNames(Project project, GlobalSearchScope scope, Collection<String> names, Processor<PsiClass> processor) {
        PsiShortNamesCache cache = PsiShortNamesCache.getInstance(project);
        for (String name : names) {
            ProgressIndicatorProvider.checkCanceled();
            for (PsiClass psiClass : DumbService.getInstance(project).runReadActionInSmartMode(() -> cache.getClassesByName(name, scope))) {
                ProgressIndicatorProvider.checkCanceled();
                if (processor.process(psiClass)) continue;
                return false;
            }
        }
        return true;
    }

    public static Project processClassNames(Project project, GlobalSearchScope scope, Consumer<String> consumer) {
        DumbService.getInstance(project).runReadActionInSmartMode(() -> {
            PsiShortNamesCache.getInstance(project).processAllClassNames(s -> {
                ProgressManager.checkCanceled();
                consumer.consume((String)s);
                return true;
            }, scope, IdFilter.getProjectIdFilter(project, true));
            return null;
        });
        ProgressManager.checkCanceled();
        return project;
    }

    private static boolean processScopeRootForAllClasses(@NotNull PsiElement scopeRoot, final @NotNull Processor<PsiClass> processor) {
        if (scopeRoot == null) {
            AllClassesSearchExecutor.$$$reportNull$$$0(5);
        }
        if (processor == null) {
            AllClassesSearchExecutor.$$$reportNull$$$0(6);
        }
        final boolean[] stopped = new boolean[]{false};
        JavaElementVisitor visitor = scopeRoot instanceof PsiCompiledElement ? new JavaRecursiveElementVisitor(){

            @Override
            public void visitElement(PsiElement element) {
                if (!stopped[0]) {
                    super.visitElement(element);
                }
            }

            @Override
            public void visitClass(PsiClass aClass) {
                stopped[0] = !processor.process(aClass);
                super.visitClass(aClass);
            }
        } : new JavaRecursiveElementWalkingVisitor(){

            @Override
            public void visitElement(PsiElement element) {
                if (!stopped[0]) {
                    super.visitElement(element);
                }
            }

            @Override
            public void visitClass(PsiClass aClass) {
                stopped[0] = !processor.process(aClass);
                super.visitClass(aClass);
            }
        };
        ApplicationManager.getApplication().runReadAction(() -> {
            if (scopeRoot == null) {
                AllClassesSearchExecutor.$$$reportNull$$$0(7);
            }
            scopeRoot.accept(visitor);
        });
        return !stopped[0];
    }

    private static /* synthetic */ void lambda$processAllClassesInGlobalScope$0(@NotNull AllClassesSearch.SearchParameters parameters, Set names, String s) {
        if (parameters == null) {
            AllClassesSearchExecutor.$$$reportNull$$$0(8);
        }
        if (parameters.nameMatches(s)) {
            names.add(s);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryParameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeRoot";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/search/AllClassesSearchExecutor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processAllClassesInGlobalScope";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "processScopeRootForAllClasses";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$processScopeRootForAllClasses$4";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$processAllClassesInGlobalScope$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

