/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class Queue<T> {
    private Object[] myArray;
    private int myFirst;
    private int myLast;
    private boolean isWrapped;

    public Queue(int initialCapacity) {
        this.myArray = initialCapacity > 0 ? new Object[initialCapacity] : ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public void addLast(T object) {
        int currentSize = this.size();
        if (currentSize == this.myArray.length) {
            this.myArray = this.normalize(Math.max(currentSize * 3 / 2, 10));
            this.myFirst = 0;
            this.myLast = currentSize;
            this.isWrapped = false;
        }
        this.myArray[this.myLast] = object;
        ++this.myLast;
        if (this.myLast == this.myArray.length) {
            this.isWrapped = !this.isWrapped;
            this.myLast = 0;
        }
    }

    public T removeLast() {
        if (this.myLast == 0) {
            this.isWrapped = !this.isWrapped;
            this.myLast = this.myArray.length;
        }
        --this.myLast;
        Object result = this.myArray[this.myLast];
        this.myArray[this.myLast] = null;
        return (T)result;
    }

    public T peekLast() {
        int last = this.myLast;
        if (last == 0) {
            last = this.myArray.length;
        }
        Object result = this.myArray[last - 1];
        return (T)result;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        return this.isWrapped ? this.myArray.length - this.myFirst + this.myLast : this.myLast - this.myFirst;
    }

    @NotNull
    public List<T> toList() {
        List<T> list = Arrays.asList(this.normalize(this.size()));
        if (list == null) {
            Queue.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    public Object[] toArray() {
        Object[] objectArray = this.normalize(this.size());
        if (objectArray == null) {
            Queue.$$$reportNull$$$0(1);
        }
        return objectArray;
    }

    @NotNull
    public T[] toArray(T[] array) {
        if (array.length < this.size()) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), this.size());
        }
        T[] TArray = this.normalize(array);
        if (TArray == null) {
            Queue.$$$reportNull$$$0(2);
        }
        return TArray;
    }

    public T pullFirst() {
        T result = this.peekFirst();
        this.myArray[this.myFirst] = null;
        ++this.myFirst;
        if (this.myFirst == this.myArray.length) {
            this.myFirst = 0;
            this.isWrapped = !this.isWrapped;
        }
        return result;
    }

    public T peekFirst() {
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException("queue is empty");
        }
        Object t = this.myArray[this.myFirst];
        return (T)t;
    }

    private int copyFromTo(int first, int last, Object[] result, int destinationPos) {
        int length = last - first;
        System.arraycopy(this.myArray, first, result, destinationPos, length);
        return length;
    }

    @NotNull
    private T[] normalize(int capacity) {
        Object[] result = new Object[capacity];
        Object[] objectArray = this.normalize(result);
        if (objectArray == null) {
            Queue.$$$reportNull$$$0(3);
        }
        return objectArray;
    }

    @NotNull
    private T[] normalize(T[] result) {
        if (this.isWrapped) {
            int tailLength = this.copyFromTo(this.myFirst, this.myArray.length, result, 0);
            this.copyFromTo(0, this.myLast, result, tailLength);
        } else {
            this.copyFromTo(this.myFirst, this.myLast, result, 0);
        }
        if (result == null) {
            Queue.$$$reportNull$$$0(4);
        }
        return result;
    }

    public void clear() {
        Arrays.fill(this.myArray, null);
        this.myLast = 0;
        this.myFirst = 0;
        this.isWrapped = false;
    }

    public T set(int index, T value) {
        int arrayIndex = this.myFirst + index;
        if (this.isWrapped && arrayIndex >= this.myArray.length) {
            arrayIndex -= this.myArray.length;
        }
        Object old = this.myArray[arrayIndex];
        this.myArray[arrayIndex] = value;
        Object t = old;
        return (T)t;
    }

    public boolean process(@NotNull Processor<T> processor) {
        if (processor == null) {
            Queue.$$$reportNull$$$0(5);
        }
        if (this.isWrapped) {
            Object t;
            int i2;
            for (i2 = this.myFirst; i2 < this.myArray.length; ++i2) {
                t = this.myArray[i2];
                if (processor.process(t)) continue;
                return false;
            }
            for (i2 = 0; i2 < this.myLast; ++i2) {
                t = this.myArray[i2];
                if (processor.process(t)) continue;
                return false;
            }
        } else {
            for (int i3 = this.myFirst; i3 < this.myLast; ++i3) {
                Object t = this.myArray[i3];
                if (processor.process(t)) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "<empty>";
        }
        return this.isWrapped ? "[ " + this.sub(this.myFirst, this.myArray.length) + " ||| " + this.sub(0, this.myLast) + " ]" : "[ " + this.sub(this.myFirst, this.myLast) + " ]";
    }

    private Object sub(int start, int end) {
        if (start == end) {
            return "";
        }
        return Arrays.asList(this.myArray).subList(start, end);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/Queue";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "toList";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "toArray";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "normalize";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/Queue";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

