/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.text.StringTokenizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class VersionComparatorUtil {
    private static final Pattern WORDS_SPLITTER = Pattern.compile("\\d+|[^\\d]+");
    private static final VersionTokenType[] VALUES = VersionTokenType.values();
    public static final Comparator<String> COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String s1, String s2) {
            return VersionComparatorUtil.compare(s1, s2);
        }
    };
    public static final Function<String, Integer> DEFAULT_TOKEN_PRIORITY_PROVIDER = new Function<String, Integer>(){

        @Override
        public Integer fun(String s) {
            return VersionTokenType.lookup(s).getPriority();
        }
    };

    private VersionComparatorUtil() {
    }

    public static String max(String v1, String v2) {
        return VersionComparatorUtil.compare(v1, v2) > 0 ? v1 : v2;
    }

    public static String min(String v1, String v2) {
        return VersionComparatorUtil.compare(v1, v2) < 0 ? v1 : v2;
    }

    static List<String> splitVersionString(String ver) {
        StringTokenizer st = new StringTokenizer(ver.trim(), "()._-;:/, +~");
        ArrayList<String> result = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            Matcher matcher = WORDS_SPLITTER.matcher(st.nextToken());
            while (matcher.find()) {
                result.add(matcher.group());
            }
        }
        return result;
    }

    public static int compare(String ver1, String ver2) {
        return VersionComparatorUtil.compare(ver1, ver2, DEFAULT_TOKEN_PRIORITY_PROVIDER);
    }

    public static int compare(String ver1, String ver2, Function<String, Integer> tokenPriorityProvider) {
        if (ver1 == null) {
            return ver2 == null ? 0 : -1;
        }
        if (ver2 == null) {
            return 1;
        }
        ver1 = ver1.toLowerCase();
        ver2 = ver2.toLowerCase();
        List<String> s1 = VersionComparatorUtil.splitVersionString(ver1);
        List<String> s2 = VersionComparatorUtil.splitVersionString(ver2);
        VersionComparatorUtil.padWithNulls(s1, s2);
        for (int i2 = 0; i2 < s1.size(); ++i2) {
            String e1 = s1.get(i2);
            String e2 = s2.get(i2);
            VersionTokenType t1 = VersionTokenType.lookup(e1);
            int res = VersionComparatorUtil.comparePriorities(e1, e2, tokenPriorityProvider);
            if (res != 0) {
                return res;
            }
            if (t1 == VersionTokenType._WORD) {
                res = e1.compareTo(e2);
            } else if (t1 == VersionTokenType._DIGITS) {
                res = VersionComparatorUtil.compareNumbers(e1, e2);
            }
            if (res == 0) continue;
            return res;
        }
        return 0;
    }

    public static int comparePriorities(String ver1, String ver2, Function<String, Integer> tokenPriorityProvider) {
        int priority1 = tokenPriorityProvider.fun(ver1);
        int priority2 = tokenPriorityProvider.fun(ver2);
        return Integer.signum(priority1 - priority2);
    }

    private static int compareNumbers(String n1, String n2) {
        int n2len;
        while (!n1.isEmpty() && !n2.isEmpty() && n1.charAt(0) == '0' && n2.charAt(0) == '0') {
            n1 = n1.substring(1);
            n2 = n2.substring(1);
        }
        if (!n1.isEmpty() && n1.charAt(0) == '0') {
            return -1;
        }
        if (!n2.isEmpty() && n2.charAt(0) == '0') {
            return 1;
        }
        int n1len = n1.length();
        if (n1len > (n2len = n2.length())) {
            n2 = StringUtil.repeatSymbol('0', n1len - n2len) + n2;
        } else if (n2len > n1len) {
            n1 = StringUtil.repeatSymbol('0', n2len - n1len) + n1;
        }
        return n1.compareTo(n2);
    }

    private static void padWithNulls(Collection<String> s1, Collection<String> s2) {
        if (s1.size() != s2.size()) {
            while (s1.size() < s2.size()) {
                s1.add(null);
            }
            while (s1.size() > s2.size()) {
                s2.add(null);
            }
        }
    }

    public static enum VersionTokenType {
        SNAP(10),
        SNAPSHOT(10),
        M(20),
        EAP(25),
        PRE(25),
        PREVIEW(25),
        ALPHA(30),
        A(30),
        BETA(40),
        BETTA(40),
        B(40),
        RC(50),
        _WS(60),
        SP(70),
        REL(80),
        RELEASE(80),
        R(80),
        FINAL(80),
        _WORD(90),
        _DIGITS(100),
        BUNDLED(666);

        private final int myPriority;

        private VersionTokenType(int priority) {
            this.myPriority = priority;
        }

        @NotNull
        public static VersionTokenType lookup(String str) {
            if (str == null) {
                VersionTokenType versionTokenType = _WS;
                if (versionTokenType == null) {
                    VersionTokenType.$$$reportNull$$$0(0);
                }
                return versionTokenType;
            }
            if ((str = str.trim()).isEmpty()) {
                VersionTokenType versionTokenType = _WS;
                if (versionTokenType == null) {
                    VersionTokenType.$$$reportNull$$$0(1);
                }
                return versionTokenType;
            }
            for (VersionTokenType token : VALUES) {
                String name = token.name();
                if (name.charAt(0) == '_' || !name.equalsIgnoreCase(str)) continue;
                VersionTokenType versionTokenType = token;
                if (versionTokenType == null) {
                    VersionTokenType.$$$reportNull$$$0(2);
                }
                return versionTokenType;
            }
            if (str.matches("0+")) {
                VersionTokenType versionTokenType = _WS;
                if (versionTokenType == null) {
                    VersionTokenType.$$$reportNull$$$0(3);
                }
                return versionTokenType;
            }
            if (str.matches("\\d+")) {
                VersionTokenType versionTokenType = _DIGITS;
                if (versionTokenType == null) {
                    VersionTokenType.$$$reportNull$$$0(4);
                }
                return versionTokenType;
            }
            VersionTokenType versionTokenType = _WORD;
            if (versionTokenType == null) {
                VersionTokenType.$$$reportNull$$$0(5);
            }
            return versionTokenType;
        }

        public int getPriority() {
            return this.myPriority;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/VersionComparatorUtil$VersionTokenType", "lookup"));
        }
    }
}

