/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ArrayContentsAssignedVisitor
extends JavaRecursiveElementWalkingVisitor {
    private boolean assigned;
    private final PsiVariable variable;

    ArrayContentsAssignedVisitor(@NotNull PsiVariable variable) {
        if (variable == null) {
            ArrayContentsAssignedVisitor.$$$reportNull$$$0(0);
        }
        this.variable = variable;
    }

    @Override
    public void visitAssignmentExpression(@NotNull PsiAssignmentExpression assignment) {
        if (assignment == null) {
            ArrayContentsAssignedVisitor.$$$reportNull$$$0(1);
        }
        if (this.assigned) {
            return;
        }
        super.visitAssignmentExpression(assignment);
        PsiExpression lhs = assignment.getLExpression();
        PsiExpression arrayExpression = ArrayContentsAssignedVisitor.getDeepArrayExpression(lhs);
        if (!(arrayExpression instanceof PsiReferenceExpression)) {
            return;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)arrayExpression;
        PsiElement referent = referenceExpression.resolve();
        if (referent == null) {
            return;
        }
        if (referent.equals(this.variable)) {
            this.assigned = true;
        }
    }

    @Override
    public void visitPrefixExpression(@NotNull PsiPrefixExpression expression) {
        if (expression == null) {
            ArrayContentsAssignedVisitor.$$$reportNull$$$0(2);
        }
        if (this.assigned) {
            return;
        }
        super.visitPrefixExpression(expression);
        IElementType tokenType = expression.getOperationTokenType();
        if (!tokenType.equals(JavaTokenType.PLUSPLUS) && !tokenType.equals(JavaTokenType.MINUSMINUS)) {
            return;
        }
        PsiExpression operand = expression.getOperand();
        PsiExpression arrayExpression = ArrayContentsAssignedVisitor.getDeepArrayExpression(operand);
        if (!(arrayExpression instanceof PsiReferenceExpression)) {
            return;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)arrayExpression;
        PsiElement referent = referenceExpression.resolve();
        if (referent == null) {
            return;
        }
        if (referent.equals(this.variable)) {
            this.assigned = true;
        }
    }

    @Override
    public void visitPostfixExpression(@NotNull PsiPostfixExpression expression) {
        if (expression == null) {
            ArrayContentsAssignedVisitor.$$$reportNull$$$0(3);
        }
        if (this.assigned) {
            return;
        }
        super.visitPostfixExpression(expression);
        IElementType tokenType = expression.getOperationTokenType();
        if (!tokenType.equals(JavaTokenType.PLUSPLUS) && !tokenType.equals(JavaTokenType.MINUSMINUS)) {
            return;
        }
        PsiExpression operand = expression.getOperand();
        PsiExpression arrayExpression = ArrayContentsAssignedVisitor.getDeepArrayExpression(operand);
        if (!(arrayExpression instanceof PsiReferenceExpression)) {
            return;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)arrayExpression;
        PsiElement referent = referenceExpression.resolve();
        if (referent == null) {
            return;
        }
        if (referent.equals(this.variable)) {
            this.assigned = true;
        }
    }

    @Nullable
    private static PsiExpression getDeepArrayExpression(PsiExpression expression) {
        if (!(expression instanceof PsiArrayAccessExpression)) {
            return null;
        }
        PsiExpression arrayExpression = ((PsiArrayAccessExpression)expression).getArrayExpression();
        while (arrayExpression instanceof PsiArrayAccessExpression) {
            PsiArrayAccessExpression arrayAccessExpression = (PsiArrayAccessExpression)arrayExpression;
            arrayExpression = arrayAccessExpression.getArrayExpression();
        }
        return arrayExpression;
    }

    public boolean isAssigned() {
        return this.assigned;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/psiutils/ArrayContentsAssignedVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitAssignmentExpression";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPrefixExpression";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPostfixExpression";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

