/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.NotNull;

public class InstanceOfUtils {
    private InstanceOfUtils() {
    }

    public static PsiInstanceOfExpression getConflictingInstanceof(PsiType castType, PsiReferenceExpression operand, PsiElement context) {
        if (!(castType instanceof PsiClassType)) {
            return null;
        }
        PsiClassType classType = (PsiClassType)castType;
        if (((PsiClassType)castType).resolve() instanceof PsiTypeParameter) {
            return null;
        }
        PsiClassType rawType = classType.rawType();
        InstanceofChecker checker = new InstanceofChecker(operand, rawType, false);
        PsiStatement sibling = PsiTreeUtil.getParentOfType(context, PsiStatement.class);
        sibling = PsiTreeUtil.getPrevSiblingOfType(sibling, PsiStatement.class);
        while (sibling != null) {
            PsiExpression condition;
            if (sibling instanceof PsiIfStatement) {
                PsiIfStatement ifStatement = (PsiIfStatement)sibling;
                condition = ifStatement.getCondition();
                if (condition != null) {
                    if (!ControlFlowUtils.statementMayCompleteNormally(ifStatement.getThenBranch())) {
                        checker.negate = true;
                        checker.checkExpression(condition);
                        if (checker.hasAgreeingInstanceof()) {
                            return null;
                        }
                    } else if (!ControlFlowUtils.statementMayCompleteNormally(ifStatement.getElseBranch())) {
                        checker.negate = false;
                        checker.checkExpression(condition);
                        if (checker.hasAgreeingInstanceof()) {
                            return null;
                        }
                    }
                }
            } else if (sibling instanceof PsiAssertStatement) {
                PsiAssertStatement assertStatement = (PsiAssertStatement)sibling;
                condition = assertStatement.getAssertCondition();
                checker.negate = false;
                checker.checkExpression(condition);
                if (checker.hasAgreeingInstanceof()) {
                    return null;
                }
            }
            sibling = PsiTreeUtil.getPrevSiblingOfType(sibling, PsiStatement.class);
        }
        checker.negate = false;
        Object parent = PsiTreeUtil.getParentOfType(context, PsiIfStatement.class, PsiConditionalExpression.class, PsiPolyadicExpression.class);
        while (parent != null) {
            parent.accept(checker);
            if (checker.hasAgreeingInstanceof()) {
                return null;
            }
            parent = PsiTreeUtil.getParentOfType(parent, new Class[]{PsiPolyadicExpression.class, PsiIfStatement.class, PsiConditionalExpression.class});
        }
        if (checker.hasAgreeingInstanceof()) {
            return null;
        }
        return checker.getConflictingInstanceof();
    }

    public static boolean hasAgreeingInstanceof(@NotNull PsiTypeCastExpression expression) {
        if (expression == null) {
            InstanceOfUtils.$$$reportNull$$$0(0);
        }
        PsiType castType = expression.getType();
        PsiExpression operand = expression.getOperand();
        if (!(operand instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)operand;
        InstanceofChecker checker = new InstanceofChecker(referenceExpression, castType, false);
        Object parent = PsiTreeUtil.getParentOfType((PsiElement)expression, PsiIfStatement.class, PsiConditionalExpression.class, PsiPolyadicExpression.class);
        while (parent != null) {
            parent.accept(checker);
            if (checker.hasAgreeingInstanceof()) {
                return true;
            }
            parent = PsiTreeUtil.getParentOfType(parent, new Class[]{PsiIfStatement.class, PsiConditionalExpression.class, PsiPolyadicExpression.class});
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/psiutils/InstanceOfUtils", "hasAgreeingInstanceof"));
    }

    private static class InstanceofChecker
    extends JavaElementVisitor {
        private final PsiReferenceExpression referenceExpression;
        private final PsiType castType;
        private final boolean strict;
        private boolean negate = false;
        private PsiInstanceOfExpression conflictingInstanceof = null;
        private boolean agreeingInstanceof = false;

        InstanceofChecker(PsiReferenceExpression referenceExpression, PsiType castType, boolean strict) {
            this.referenceExpression = referenceExpression;
            this.castType = castType;
            this.strict = strict;
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression) {
            this.visitExpression(expression);
        }

        @Override
        public void visitPolyadicExpression(PsiPolyadicExpression expression) {
            IElementType tokenType = expression.getOperationTokenType();
            if (tokenType == JavaTokenType.ANDAND) {
                for (PsiExpression operand : expression.getOperands()) {
                    this.checkExpression(operand);
                    if (!this.agreeingInstanceof) continue;
                    return;
                }
                if (!this.negate && this.conflictingInstanceof != null) {
                    this.agreeingInstanceof = false;
                }
            } else if (tokenType == JavaTokenType.OROR) {
                for (PsiExpression operand : expression.getOperands()) {
                    if (operand instanceof PsiPrefixExpression && ((PsiPrefixExpression)operand).getOperationTokenType() == JavaTokenType.EXCL) {
                        this.negate = true;
                    }
                    this.checkExpression(operand);
                    if (!this.agreeingInstanceof) continue;
                    return;
                }
                if (this.negate && this.conflictingInstanceof != null) {
                    this.agreeingInstanceof = false;
                }
            }
        }

        @Override
        public void visitIfStatement(PsiIfStatement ifStatement) {
            PsiBlockStatement blockStatement;
            PsiStatement thenBranch;
            PsiBlockStatement blockStatement2;
            PsiStatement branch = ifStatement.getElseBranch();
            boolean bl = this.negate = branch != null && PsiTreeUtil.isAncestor(branch, this.referenceExpression, true);
            if (this.negate ? branch instanceof PsiBlockStatement && VariableAccessUtils.variableIsAssignedBeforeReference(this.referenceExpression, blockStatement2 = (PsiBlockStatement)branch) : (thenBranch = ifStatement.getThenBranch()) instanceof PsiBlockStatement && VariableAccessUtils.variableIsAssignedBeforeReference(this.referenceExpression, blockStatement = (PsiBlockStatement)thenBranch)) {
                return;
            }
            this.checkExpression(ifStatement.getCondition());
        }

        @Override
        public void visitConditionalExpression(PsiConditionalExpression expression) {
            PsiExpression elseExpression = expression.getElseExpression();
            this.negate = elseExpression != null && PsiTreeUtil.isAncestor(elseExpression, this.referenceExpression, true);
            this.checkExpression(expression.getCondition());
        }

        private void checkExpression(PsiExpression expression) {
            expression = PsiUtil.deparenthesizeExpression(expression);
            if (this.negate) {
                if (expression instanceof PsiPrefixExpression) {
                    PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression;
                    IElementType tokenType = prefixExpression.getOperationTokenType();
                    if (tokenType != JavaTokenType.EXCL) {
                        return;
                    }
                    expression = PsiUtil.deparenthesizeExpression(prefixExpression.getOperand());
                    this.checkInstanceOfExpression(expression);
                }
            } else {
                this.checkInstanceOfExpression(expression);
            }
            if (expression instanceof PsiPolyadicExpression) {
                PsiPolyadicExpression binaryExpression = (PsiPolyadicExpression)expression;
                this.visitPolyadicExpression(binaryExpression);
            }
        }

        private void checkInstanceOfExpression(PsiExpression expression) {
            if (!(expression instanceof PsiInstanceOfExpression)) {
                return;
            }
            PsiInstanceOfExpression instanceOfExpression = (PsiInstanceOfExpression)expression;
            if (this.isAgreeing(instanceOfExpression)) {
                this.agreeingInstanceof = true;
                this.conflictingInstanceof = null;
            } else if (this.isConflicting(instanceOfExpression) && this.conflictingInstanceof == null) {
                this.conflictingInstanceof = instanceOfExpression;
            }
        }

        private boolean isConflicting(PsiInstanceOfExpression expression) {
            PsiExpression conditionOperand = expression.getOperand();
            if (!EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(this.referenceExpression, conditionOperand)) {
                return false;
            }
            PsiTypeElement typeElement = expression.getCheckType();
            if (typeElement == null) {
                return false;
            }
            PsiType type = typeElement.getType();
            if (this.strict) {
                return !this.castType.equals(type);
            }
            return !this.castType.isAssignableFrom(type);
        }

        private boolean isAgreeing(PsiInstanceOfExpression expression) {
            PsiExpression conditionOperand = expression.getOperand();
            if (!EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(this.referenceExpression, conditionOperand)) {
                return false;
            }
            PsiTypeElement typeElement = expression.getCheckType();
            if (typeElement == null) {
                return false;
            }
            PsiType type = typeElement.getType();
            if (this.strict) {
                return this.castType.equals(type);
            }
            return this.castType.isAssignableFrom(type);
        }

        public boolean hasAgreeingInstanceof() {
            return this.agreeingInstanceof;
        }

        public PsiInstanceOfExpression getConflictingInstanceof() {
            return this.conflictingInstanceof;
        }
    }
}

